/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.LoggingInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.Value;
import java.util.Enumeration;
import java.util.Stack;

class ProxyPool {
    private int maxProxies;
    private int numberOfProxies;
    private Stack pool;

    ProxyPool(int n) {
        this.maxProxies = n;
        this.numberOfProxies = 0;
        this.initPool();
    }

    synchronized Proxy get(ARServerUser aRServerUser) throws ARException {
        if (!this.pool.empty()) {
            Proxy proxy = (Proxy)this.pool.pop();
            return this.prepareProxy(proxy, aRServerUser);
        }
        if (this.numberOfProxies < this.maxProxies) {
            Proxy proxy = new Proxy();
            Value value = new Value(1);
            proxy.ARSetSessionConfiguration(aRServerUser, 6, value);
            ++this.numberOfProxies;
            return this.prepareProxy(proxy, aRServerUser);
        }
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.pool.empty());
        Proxy proxy = (Proxy)this.pool.pop();
        return this.prepareProxy(proxy, aRServerUser);
    }

    synchronized void put(Proxy proxy) {
        if (this.pool.size() < this.maxProxies) {
            this.pool.push(proxy);
            this.notifyAll();
        } else {
            System.err.println("Proxy pool overflow! Size = " + this.pool.size() + ", max = " + this.maxProxies + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
        }
    }

    public synchronized void clear() {
        Enumeration enumeration = this.pool.elements();
        while (enumeration.hasMoreElements()) {
            Proxy proxy = (Proxy)enumeration.nextElement();
            try {
                proxy.ARTermination(null);
            }
            catch (ARException aRException) {
                aRException.describe();
            }
        }
        this.pool.removeAllElements();
    }

    synchronized ProxyManager.PoolInfo getInfo(String string) {
        return new ProxyManager.PoolInfo(string, this.numberOfProxies - this.pool.size(), this.pool.size(), this.maxProxies - this.numberOfProxies);
    }

    private void initPool() {
        this.pool = new Stack();
    }

    private Proxy prepareProxy(Proxy proxy, ARServerUser aRServerUser) throws ARException {
        LoggingInfo loggingInfo;
        if (aRServerUser != null && (loggingInfo = aRServerUser.getLogging()) != null && loggingInfo.isEnabled()) {
            proxy.ARSetLogging(aRServerUser, loggingInfo.getType(), loggingInfo.getWriteToFileOrStatus(), loggingInfo.getPath());
        }
        return proxy;
    }
}

