/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.Entry;
import com.remedy.arsys.api.EntryCriteria;
import com.remedy.arsys.api.EntryID;
import com.remedy.arsys.api.EntryKey;
import com.remedy.arsys.api.EntryListCriteria;
import com.remedy.arsys.api.EntryListInfo;
import com.remedy.arsys.api.IARObjectFactory;
import com.remedy.arsys.api.IARRowIterator;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;

public class EntryFactory
implements IARObjectFactory {
    private static final EntryFactory entryManager = new EntryFactory();

    protected EntryFactory() {
    }

    public Object newInstance() {
        Entry entry = new Entry();
        return entry;
    }

    public boolean releaseInstance(Object object) {
        return true;
    }

    public static EntryFactory getFactory() {
        return entryManager;
    }

    public static Entry findByKey(ARServerUser aRServerUser, EntryKey entryKey, EntryCriteria entryCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        Entry entry = new Entry();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARGetEntry(aRServerUser, entryKey, entryCriteria, entry);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        entry.setContext(aRServerUser);
        entry.setKey(entryKey);
        return entry;
    }

    public static EntryKey[] find(ARServerUser aRServerUser, EntryListCriteria entryListCriteria, boolean bl, Integer n) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl2 = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl2);
        EntryListInfo[] entryListInfoArray = null;
        try {
            entryListInfoArray = proxy.ARGetListEntry(aRServerUser, entryListCriteria, null, bl, n);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl2);
        }
        if (null == entryListInfoArray) {
            return null;
        }
        EntryKey[] entryKeyArray = new EntryKey[entryListInfoArray.length];
        try {
            for (int i = 0; i < entryListInfoArray.length; ++i) {
                entryKeyArray[i] = new EntryKey((NameID)entryListCriteria.getSchemaID().clone(), (EntryID)entryListInfoArray[i].getEntryID().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone not supported on EntryID or SchemaID");
        }
        return entryKeyArray;
    }

    public static Entry[] findObjects(ARServerUser aRServerUser, EntryListCriteria entryListCriteria, EntryCriteria entryCriteria, boolean bl, Integer n) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        Entry[] entryArray = null;
        boolean bl2 = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl2);
        try {
            entryArray = entryListCriteria.getEntriesToRetrieve() != null ? proxy.ARGetMultipleEntries(aRServerUser, entryListCriteria, entryCriteria) : proxy.ARGetListEntryWithFields(aRServerUser, entryListCriteria, entryCriteria, bl, n);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl2);
        }
        return entryArray;
    }

    public static int findObjectsByBlocks(ARServerUser aRServerUser, EntryListCriteria entryListCriteria, EntryCriteria entryCriteria, int n, boolean bl, Integer n2, Integer n3, Integer n4) throws ARException {
        int n5;
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl2 = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl2);
        try {
            n5 = proxy.ARGetListEntryBlocks(aRServerUser, entryListCriteria, entryCriteria, n, bl, n2, n3, n4);
            System.out.println("NumReturnedBlocks = " + n2);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl2);
        }
        return n5;
    }

    public static Entry[] getBlock(ARServerUser aRServerUser, int n, int n2) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        Entry[] entryArray = null;
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            entryArray = proxy.ARGetEntryBlock(n, n2);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return entryArray;
    }

    public static void freeBlock(ARServerUser aRServerUser, int n) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARFreeEntryBlock(n);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
    }

    public static void findAndIterate(ARServerUser aRServerUser, EntryListCriteria entryListCriteria, EntryCriteria entryCriteria, boolean bl, Integer n, int n2, IARRowIterator iARRowIterator) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl2 = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl2);
        try {
            proxy.FindAndIterate(aRServerUser, entryListCriteria, entryCriteria, bl, n, n2, iARRowIterator);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl2);
        }
    }

    public static EntryListInfo[] findEntryListInfos(ARServerUser aRServerUser, EntryListCriteria entryListCriteria, EntryCriteria entryCriteria, boolean bl, Integer n) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        EntryListInfo[] entryListInfoArray = null;
        boolean bl2 = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl2);
        try {
            entryListInfoArray = proxy.ARGetListEntry(aRServerUser, entryListCriteria, entryCriteria, bl, n);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl2);
        }
        return entryListInfoArray;
    }
}

