/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.ContainerCriteria;
import com.remedy.arsys.api.ContainerKey;
import com.remedy.arsys.api.ContainerOwner;
import com.remedy.arsys.api.ContainerType;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PermissionInfo;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ReferenceBase;
import com.remedy.arsys.api.StringHelper;
import com.remedy.arsys.api.Util;

public class Container
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_session;
    private InternalID[] m_adminGrpList;
    private char[] m_label;
    private char[] m_description;
    private ContainerType m_type;
    private ReferenceBase[] m_references;
    private ContainerOwner[] m_containerOwner;
    private PropInfo[] m_props;
    private boolean m_removeFlag;
    private NameID m_newName;
    private int m_deleteOption;
    private static final int TOTAL_PARAMS = 5;

    Container() {
        this.m_changeFlags = new CriteriaFlags(5);
    }

    Container(NameID nameID) {
        this.m_changeFlags = new CriteriaFlags(5);
        this.setName(nameID);
        this.setKey(new ContainerKey(nameID));
    }

    protected Container(String string, PermissionInfo[] permissionInfoArray, String string2, long l, String string3, String string4, String string5) {
        super(string, null, string2, l, string3, string4, string5);
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            for (int i = 0; i < permissionInfoArray.length; ++i) {
                long l2 = permissionInfoArray[i].getGroupID().getValue();
                int n = new Long(l2).intValue();
                this.m_permissionList[i] = new PermissionInfo(n, permissionInfoArray[i].getPermissionValue());
            }
        }
    }

    public ContainerKey getKey() {
        return new ContainerKey(this.getName());
    }

    public void setKey(ContainerKey containerKey) {
        this.setName(containerKey);
    }

    public void setAdminGroupList(InternalID[] internalIDArray) {
        this.m_adminGrpList = internalIDArray;
        if (this.m_adminGrpList != null) {
            for (int i = 0; i < this.m_adminGrpList.length; ++i) {
                long l = this.m_adminGrpList[i].getValue();
                int n = new Long(l).intValue();
                this.m_adminGrpList[i] = new InternalID(n);
            }
        }
    }

    public void setPermissions(PermissionInfo[] permissionInfoArray) {
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            for (int i = 0; i < permissionInfoArray.length; ++i) {
                long l = permissionInfoArray[i].getGroupID().getValue();
                int n = new Long(l).intValue();
                this.m_permissionList[i] = new PermissionInfo(n, permissionInfoArray[i].getPermissionValue());
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public InternalID[] getAdminGroupList() {
        return this.m_adminGrpList;
    }

    public void setLabel(String string) {
        if (null == this.m_label) {
            this.m_label = new char[255];
        }
        StringHelper.toChars(string, this.m_label, 255);
    }

    public char[] getLabel() {
        return this.m_label;
    }

    public void setDescription(String string) {
        if (null == this.m_description) {
            this.m_description = new char[2000];
        }
        StringHelper.toChars(string, this.m_description, 2000);
    }

    public char[] getDescription() {
        return this.m_description;
    }

    public ContainerType getType() {
        return this.m_type;
    }

    int getContainerTypeInt() {
        return this.m_type.toInt();
    }

    void setContainerTypeInt(int n) {
        this.m_type = ContainerType.toContainerType(n);
    }

    public void setType(ContainerType containerType) {
        this.m_type = containerType;
    }

    public void setReferences(ReferenceBase[] referenceBaseArray) {
        this.m_references = referenceBaseArray;
    }

    public ReferenceBase[] getReferences() {
        return this.m_references;
    }

    public void setContainerOwner(ContainerOwner[] containerOwnerArray) {
        this.m_containerOwner = containerOwnerArray;
    }

    public ContainerOwner[] getContainerOwner() {
        return this.m_containerOwner;
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_props = propInfoArray;
    }

    public PropInfo[] getProperties() {
        return this.m_props;
    }

    public void setRemoveFlag(boolean bl) {
        this.m_removeFlag = bl;
    }

    public boolean getRemoveFlag() {
        return this.m_removeFlag;
    }

    public void setNewname(NameID nameID) {
        this.m_newName = nameID;
    }

    public NameID getNewname() {
        return this.m_newName;
    }

    public void setDeleteOption(int n) {
        this.m_deleteOption = n;
    }

    int getDeleteOption() {
        return this.m_deleteOption;
    }

    public ARServerUser getContext() {
        return this.m_session;
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_session = aRServerUser;
    }

    public void unsetContext() {
        this.m_session = null;
    }

    public void clear() {
        super.clear();
        this.m_adminGrpList = null;
        this.m_label = null;
        this.m_description = null;
        this.m_type = null;
        this.m_references = null;
        this.m_containerOwner = null;
        this.m_props = null;
        this.m_newName = null;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        Container container = (Container)super.clone();
        int n2 = this.m_adminGrpList.length;
        container.m_adminGrpList = new InternalID[n2];
        for (int i = 0; i < n2; ++i) {
            container.m_adminGrpList[i] = (InternalID)this.m_adminGrpList[i].clone();
        }
        n2 = this.m_label.length;
        container.m_label = new char[n2];
        System.arraycopy(this.m_label, 0, container.m_label, 0, n2);
        n2 = this.m_description.length;
        container.m_description = new char[n2];
        System.arraycopy(this.m_description, 0, container.m_description, 0, n2);
        container.m_type = (ContainerType)this.m_type.clone();
        n2 = this.m_references.length;
        container.m_references = new ReferenceBase[n2];
        for (n = 0; n < n2; ++n) {
            container.m_references[n] = (ReferenceBase)this.m_references[n].clone();
        }
        container.m_containerOwner = (ContainerOwner[])this.m_containerOwner.clone();
        n2 = this.m_props.length;
        container.m_props = new PropInfo[n2];
        for (n = 0; n < n2; ++n) {
            container.m_props[n] = (PropInfo)this.m_props[n].clone();
        }
        container.m_newName = (NameID)this.m_newName.clone();
        return container;
    }

    public void create() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARCreateContainer(this.m_session, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
    }

    public void remove() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARDeleteContainer(this.m_session, this.getKey(), this.m_deleteOption);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
    }

    public void load() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        ContainerCriteria containerCriteria = new ContainerCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetContainer(this.m_session, this.getKey(), containerCriteria, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
    }

    public void load(ContainerCriteria containerCriteria) throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetContainer(this.m_session, this.getKey(), containerCriteria, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
    }

    public void store() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARSetContainer(this.m_session, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
    }

    public void activate() {
    }

    public void passivate() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Container)) {
            return false;
        }
        Container container = (Container)object;
        return super.equals(container) && Util.equals(this.m_adminGrpList, container.m_adminGrpList) && (this.m_label == null ? container.m_label == null : new String(this.m_label).equals(new String(container.m_label))) && (this.m_description == null ? container.m_description == null : new String(this.m_description).equals(new String(container.m_description))) && (this.m_type == null ? container.m_type == null : this.m_type.equals(container.m_type)) && Util.equals(this.m_references, container.m_references) && Util.equals(this.m_containerOwner, container.m_containerOwner) && Util.equals(this.m_props, container.m_props) && this.m_removeFlag == container.m_removeFlag && (this.m_newName == null ? container.m_newName == null : this.m_newName.equals(container.m_newName));
    }

    public int hashCode() {
        return super.hashCode();
    }
}

