/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ArithmeticOrRelationalOperand;

public class ArithmeticOperationInfo
implements Cloneable {
    private int m_operation;
    private ArithmeticOrRelationalOperand m_operandLeft;
    private ArithmeticOrRelationalOperand m_operandRight;
    public static final int AR_ARITH_OP_ADD = 1;
    public static final int AR_ARITH_OP_SUBTRACT = 2;
    public static final int AR_ARITH_OP_MULTIPLY = 3;
    public static final int AR_ARITH_OP_DIVIDE = 4;
    public static final int AR_ARITH_OP_MODULO = 5;
    public static final int AR_ARITH_OP_NEGATE = 6;

    public ArithmeticOperationInfo() {
        this.m_operation = 0;
        this.m_operandLeft = null;
        this.m_operandRight = null;
    }

    public ArithmeticOperationInfo(int n, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2) throws IllegalArgumentException {
        if (!this.validate(n)) {
            throw new IllegalArgumentException("invalid operation in ArithmeticOperationInfo constructor");
        }
        this.m_operation = n;
        this.m_operandLeft = arithmeticOrRelationalOperand;
        this.m_operandRight = arithmeticOrRelationalOperand2;
    }

    public ArithmeticOrRelationalOperand getLeftOperand() {
        return this.m_operandLeft;
    }

    public ArithmeticOrRelationalOperand getRightOperand() {
        return this.m_operandRight;
    }

    public int getOperation() {
        return this.m_operation;
    }

    private boolean validate(int n) {
        return n >= 1 && n <= 6;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)super.clone();
        arithmeticOperationInfo.m_operandLeft = (ArithmeticOrRelationalOperand)this.m_operandLeft.clone();
        arithmeticOperationInfo.m_operandRight = (ArithmeticOrRelationalOperand)this.m_operandRight.clone();
        return arithmeticOperationInfo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ArithmeticOperationInfo)) {
            return false;
        }
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)object;
        return this.m_operation == arithmeticOperationInfo.m_operation && (this.m_operandLeft == null ? arithmeticOperationInfo.m_operandLeft == null : this.m_operandLeft.equals(arithmeticOperationInfo.m_operandLeft)) && (this.m_operandRight == null ? arithmeticOperationInfo.m_operandRight == null : this.m_operandRight.equals(arithmeticOperationInfo.m_operandRight));
    }

    public int hashCode() {
        return this.m_operation;
    }
}

