/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.Container;
import com.remedy.arsys.api.ContainerCriteria;
import com.remedy.arsys.api.ContainerKey;
import com.remedy.arsys.api.ContainerListCriteria;
import com.remedy.arsys.api.ContainerListInfo;
import com.remedy.arsys.api.ContainerMultiCriteria;
import com.remedy.arsys.api.IARObjectFactory;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;

public class ContainerFactory
implements IARObjectFactory {
    private static final ContainerFactory containerFactory = new ContainerFactory();

    protected ContainerFactory() {
    }

    public Object newInstance() {
        Container container = new Container();
        return container;
    }

    public boolean releaseInstance(Object object) {
        return true;
    }

    public static ContainerFactory getFactory() {
        return containerFactory;
    }

    public static Container findByKey(ARServerUser aRServerUser, ContainerKey containerKey, ContainerCriteria containerCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (containerCriteria == null) {
            containerCriteria = new ContainerCriteria();
        }
        Container container = new Container();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARGetContainer(aRServerUser, containerKey, containerCriteria, container);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        container.setName(containerKey);
        return container;
    }

    public static ContainerKey[] find(ARServerUser aRServerUser, ContainerListCriteria containerListCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        ContainerListInfo[] containerListInfoArray = null;
        try {
            containerListInfoArray = proxy.ARGetListContainer(aRServerUser, containerListCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        if (null == containerListInfoArray) {
            return null;
        }
        ContainerKey[] containerKeyArray = new ContainerKey[containerListInfoArray.length];
        for (int i = 0; i < containerListInfoArray.length; ++i) {
            containerKeyArray[i] = containerListInfoArray[i].getKey();
        }
        return containerKeyArray;
    }

    public static Container[] findObjects(ARServerUser aRServerUser, ContainerListCriteria containerListCriteria, ContainerCriteria containerCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (null == containerCriteria) {
            containerCriteria = new ContainerCriteria();
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        Container[] containerArray = null;
        try {
            containerArray = proxy.ARGetListContainerObjects(aRServerUser, containerListCriteria, containerCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return containerArray;
    }

    public static Container[] findObjects(ARServerUser aRServerUser, ContainerMultiCriteria containerMultiCriteria, ContainerCriteria containerCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (null == containerCriteria) {
            containerCriteria = new ContainerCriteria();
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        Container[] containerArray = null;
        try {
            containerArray = proxy.ARGetMultipleContainerObjects(aRServerUser, containerMultiCriteria, containerCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return containerArray;
    }
}

