/*  File: arplugin.h  */

#ifndef arplugin_h
#define arplugin_h

#include "ar.h"

#ifndef C_VARIETIES_H
#define C_VARIETIES_H

/* external definition macros extracted from the c_variables.h include file  */
/* Builds the correct external reference for the type of compiler being used */

#if defined(__cplusplus)
    /* Definitions for C++ 2.0 and later */
#   define EXTERN_FUNCTION( rtn, args ) extern "C" { rtn args; }
#   define STRUCT_TAG( tag_name ) /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(c_plusplus)
    /* Definitions for C++ 1.2 */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name )  /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(__STDC__) || defined(_WIN32)
    /* Definitions for ANSI C and Win32 .c files */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT ...
#   define _VOID_ void

#else
    /* Definitions for Sun/K&R C */
#   define EXTERN_FUNCTION( rtn, args ) rtn()
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) enum_type
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT
#   define _VOID_

#endif

#endif

#endif

#endif

/* Types of plug-ins */
#define AR_PLUGIN_TYPE_ARDBC  1
#define AR_PLUGIN_TYPE_FILTER 2
#define AR_PLUGIN_TYPE_AREA   3

/* Log level for plug-in logging */
#define AR_PLUGIN_LOG_OFF       10000
#define AR_PLUGIN_LOG_SEVERE    1000
#define AR_PLUGIN_LOG_WARNING   900
#define AR_PLUGIN_LOG_INFO      800
#define AR_PLUGIN_LOG_CONFIG    700
#define AR_PLUGIN_LOG_FINE      600
#define AR_PLUGIN_LOG_FINER     500
#define AR_PLUGIN_LOG_FINEST    400
#define AR_PLUGIN_LOG_ALL       100

/* Defines the event types received by ARPluginEvent()            */
#define ARPLUGIN_EVENT_CONFIG   1  /* Configuration has changed   */

/* Defines the property tags used in ARPluginSetProperties()      */
#define AR_PLUGIN_PROP_LOG_FUNCTION       1  /* BYTE: function pointer */
#define AR_PLUGIN_PROP_INSTALL_DIR        2  /* CHAR: AR System install*/
                                             /*       directory        */
#define AR_PLUGIN_PROP_CONFIG_FILE        3  /* CHAR: ar.cfg/ar.conf   */
                                             /*       path & file name */
#define AR_PLUGIN_PROP_GETUSER_FUNCTION   4  /* BYTE: function pointer */
#define AR_PLUGIN_PROP_GETAUTHSTRING_FUNCTION 5  /* BYTE: function pointer */

typedef struct {
   unsigned int type;      /* AR_PLUGIN_TYPE_...         */
   ARNameType   name;      /* name of plugin             */
   unsigned int version;   /* version of plugin, one of: */
                           /*        AREA_PLUGIN_VERSION */
                           /*       ARDBC_PLUGIN_VERSION */
                           /* ARFILTERAPI_PLUGIN_VERSION */
} ARPluginIdentification;

typedef int (*AR_PLUGIN_LOG_FUNCTION)(
               ARPluginIdentification* id,
               int debugLevel, /* IN; the level this mesg is for; See above */
                               /*     "Log level for plug-in logging"       */
               char *text      /* IN; text to output */);

typedef int (*AR_PLUGIN_GETUSER_FUNCTION)(
               ARAccessNameType userName  /* OUT; Username invoking current api */);

typedef int (*AR_PLUGIN_GETAUTHSTRING_FUNCTION)(
               ARNameType authString  /* OUT; authstring for user invoking current api */);

#ifdef _WIN32
#define ARPLUGIN_EXPORT __declspec(dllexport)
#else /* UNIX */
#define ARPLUGIN_EXPORT   
#endif

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginIdentify, (
                ARPluginIdentification*  id,       /* OUT; info about plugin */
                ARStatusList*            status    /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginSetProperties, (
                ARPropList*              propList, /* IN; list of properties */
                ARStatusList*            status    /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginInitialization, (
                int                      argc,     /*  IN; argc from main() */
                char**                   argv,     /*  IN; argv from main() */
                ARStatusList*            status    /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginTermination, (
                ARStatusList*            status    /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginCreateInstance, (
                void**                   object,   /* OUT; object created */
                ARStatusList*            status    /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginDeleteInstance, (
                void*                    object,   /* IN; object to delete */
                ARStatusList*            status    /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginEvent, (
                unsigned int             eventID,  /* IN; ARPLUGIN_EVENT_... */
                ARStatusList*            status    /* OUT; status of the operation */));

#endif /* arplugin_h */
