
/*  File:  arstruct.h  */

#ifndef AR_STRUCT_DEFINED
#define AR_STRUCT_DEFINED

#define AR_CORE_VERSION            2L /* version number of core definition */
#define AR_EXPORT_VERSION          8L /* version number of export definition */

                                      /* default version number of internal server defn */
#define AR_INTERNAL_DEFN_DEFAULT_VERSION  0L

#define AR_ENTRY_ID_SEPARATOR      '|'/* join schema entry id separator */

#define AR_CORE_ENTRY_ID           1L /* field-ids of the core fields */
#define AR_CORE_SUBMITTER          2L
#define AR_CORE_CREATE_DATE        3L
#define AR_CORE_ASSIGNED_TO        4L
#define AR_CORE_LAST_MODIFIED_BY   5L
#define AR_CORE_MODIFIED_DATE      6L
#define AR_CORE_STATUS             7L
#define AR_CORE_SHORT_DESCRIPTION  8L
#define AR_CORE_STATUS_HISTORY    15L

#define AR_CORE_DESCRIPTION        9L /* field-ids of obsoleted core fields */
#define AR_CORE_DISPOSITION       10L /* Any existing definitions can       */
#define AR_CORE_RELATED_TO        11L /* remain and will be fully supported.*/
#define AR_CORE_NOTIFY_METHOD     12L /* Any change to the fields will      */
#define AR_CORE_SUBMIT_SEVERITY   13L /* retain the restrictions when these */
#define AR_CORE_ASSIGN_PRIORITY   14L /* were core fields.  They can be     */
                                      /* deleted if desired, but not created*/

#define AR_NUM_CORE_FIELDS         9

#define AR_MAX_CORE_FIELD_ID             99L
#define AR_MAX_RESERVED_FIELD_ID  536870911L  /* 0x1fffffff */

#define AR_RESERV_WEIGHT          99  /* Reserved display only field - weight */
#define AR_LIKE_ID                98  /* Reserved for Push/Set Like Field id */
#define AR_SET_DEFAULTS_ID        97  /* Reserved for Set Field Defaults on  */
                                      /*   OpenWindow action.                */

#define AR_RESERV_USER_NAME      101L /* field-ids of the user/group fields */
#define AR_RESERV_PASSWORD       102L
#define AR_RESERV_EMAIL          103L /* these ids are reserved for defining */
#define AR_RESERV_GROUP_LIST     104L /*  users and groups within the AR     */
#define AR_RESERV_GROUP_NAME     105L /*  system                             */
#define AR_RESERV_GROUP_ID       106L
#define AR_RESERV_GROUP_TYPE     107L
#define AR_RESERV_USER_NOTIFY    108L
#define AR_RESERV_LICENSE_TYPE   109L
#define AR_RESERV_LIC_FULL_TEXT  110L
#define AR_RESERV_LIC_RESERVED1  111L
#define AR_RESERV_ASSIGNED_GROUP 112L
#define AR_RESERV_LIC_ASSET      113L
#define AR_RESERV_LIC_CHANGE     114L
#define AR_RESERV_GROUP_FLOATING_LIC      115L
#define AR_RESERV_GROUP_FLOATING_FTS_LIC  116L
#define AR_RESERV_AUTH_USER_NAME          117L
#define AR_RESERV_AUTH_STRING             118L
#define AR_RESERV_COMPUTED_GROUP_LIST     119L
#define AR_RESERV_GROUP_CATEGORY          120L
#define AR_RESERV_COMPUTED_GROUP_QUAL     121L
#define AR_RESERV_APP_LICENSE             122L
#define AR_RESERV_ENCRYPTED_STRING        123L
#define AR_RESERV_INSTANCE_ID             490000000L
#define AR_RESERV_OBJECT_ID               490000100L


/* Message Catalog reserved fields */

#define ARMC_RESERV_MESSAGE_CAT_STATUS                 7L
#define ARMC_RESERV_MESSAGE_CAT_NAME                   8L
#define ARMC_RESERV_MESSAGE_CAT_MSG_TYPE             150L
#define ARMC_RESERV_MESSAGE_CAT_FLD_ID_OR_MSG_NUM    151L
#define ARMC_RESERV_MESSAGE_CAT_LOCALE               152L

#define ARMC_RESERV_MESSAGE_CAT_RETURN_TYPE          155L
#define ARMC_RESERV_MESSAGE_CAT_MSG_TEXT             156L
#define ARMC_RESERV_MESSAGE_CAT_BIN_ATTACH_POOL      157L
#define ARMC_RESERV_MESSAGE_CAT_BIN_ATTACH_FLD       158L
#define ARMC_RESERV_MESSAGE_CAT_APPL_TAG             159L

#define AR_RESERV_LOCALE_LOCALIZED_SCHEMA            160L
#define AR_RESERV_LOCALE_MSG_TYPE_MENU               161L
#define AR_RESERV_LOCALE_BIN_ATTACH_LABEL            162L
#define AR_RESERV_LOCALE_LOC_SEARCH_CRIT_LABEL       163L
#define AR_RESERV_LOCALE_RETURNED_VALUE_LABEL        164L

                                      /* reserved for SetField action */
#define AR_RESERV_SETFIELD_SCHEMA_NAME    170L

                                      /* Reserved for the GUID (Globally Unique */
                                      /* ID) field of the current schema object.*/
                                      /* The field will be a character field    */
                                      /* with the length of 38 characters.      */
#define AR_RESERV_GUID                    179L

                                      /* reserved for Distributed Server */
/* Generic Fields */
#define AR_RESERV_CHANGE_DIARY            180L
#define AR_RESERV_HELP                    181L
#define AR_RESERV_OPROP                   182L

/* Mapping Schema */
#define ARDS_RESERV_DISTRIB_MAPPING_NAME  AR_CORE_SHORT_DESCRIPTION
#define ARDS_RESERV_DISTRIB_FROM_SCHEMA   200L
#define ARDS_RESERV_DISTRIB_FROM_SERVER   201L
#define ARDS_RESERV_DISTRIB_TO_SCHEMA     202L
#define ARDS_RESERV_DISTRIB_TO_SERVER     203L
#define ARDS_RESERV_DISTRIB_UPDATE_CODE   204L
#define ARDS_RESERV_DISTRIB_TRANS_MODE    205L
#define ARDS_RESERV_DISTRIB_MAP_TYPE      206L
#define ARDS_RESERV_DISTRIB_MAPPING       207L
#define ARDS_RESERV_DISTRIB_RTN_MAP_TYPE  208L
#define ARDS_RESERV_DISTRIB_RTN_MAPPING   209L
#define ARDS_RESERV_DISTRIB_DEFAULT_MAP   210L
#define ARDS_RESERV_DISTRIB_DUP_ACTION    211L
#define ARDS_RESERV_DISTRIB_RETRY_TIME    212L
#define ARDS_RESERV_DISTRIB_PATTERN_MATCH 213L
#define ARDS_RESERV_DISTRIB_REQUIRED_FIELDS 214L
#define ARDS_RESERV_DISTRIB_MATCH_QUAL    215L

/* Pending Schema */
#define ARDS_RESERV_DISTRIB_PENDING_NAME  AR_CORE_SHORT_DESCRIPTION
#define ARDS_RESERV_DISTRIB_SOURCE_ID     250L
#define ARDS_RESERV_DISTRIB_PENDING_TYPE  251L
#define ARDS_RESERV_DISTRIB_PENDING_OTHER 252L
#define ARDS_RESERV_DISTRIB_POOL          253L

/* Pool Schema */
#define ARDS_RESERV_DISTRIB_POOL_NAME     AR_CORE_SHORT_DESCRIPTION
#define ARDS_RESERV_DISTRIB_EXEORDER      230L
#define ARDS_RESERV_DISTRIB_TCOUNT        275L
#define ARDS_RESERV_DISTRIB_CONNECT       276L
#define ARDS_RESERV_DISTRIB_DEFAULT       277L
#define ARDS_RESERV_DISTRIB_OPROP         278L

/* User Schema Extensions */
#define ARDS_RESERV_DISTRIB_TO_MAPPING    300L
#define ARDS_RESERV_DISTRIB_TRANS_STATE   301L
#define ARDS_RESERV_DISTRIB_UPDATE_STATE  302L
#define ARDS_RESERV_DISTRIB_MASTER_FLAG   303L
#define ARDS_RESERV_DISTRIB_CUR_SCHEMA    304L
#define ARDS_RESERV_DISTRIB_CUR_SERVER    305L
#define ARDS_RESERV_DISTRIB_FROM_MAPPING  306L
#define ARDS_RESERV_DISTRIB_FROM_ENTRYID  307L
#define ARDS_RESERV_DISTRIB_TO_ENTRYID    308L
#define ARDS_RESERV_DISTRIB_MAP_HISTORY   309L
#define ARDS_RESERV_DISTRIB_FROM_SCHEMA_2 310L
#define ARDS_RESERV_DISTRIB_FROM_SERVER_2 311L
#define ARDS_RESERV_DISTRIB_TO_SCHEMA_2   312L
#define ARDS_RESERV_DISTRIB_TO_SERVER_2   313L
#define ARDS_RESERV_DISTRIB_UPDATE_CODE_2 314L
#define ARDS_RESERV_DISTRIB_TRANS_MODE_2  315L
#define ARDS_RESERV_DISTRIB_DUP_ACTION_2  316L
#define ARDS_RESERV_DISTRIB_RETRY_TIME_2  317L
#define ARDS_RESERV_DISTRIB_FROM_POOL     318L
#define ARDS_RESERV_DISTRIB_PATTERN_MATCH_2   319L
#define ARDS_RESERV_DISTRIB_REQUIRED_FIELDS_2 320L
#define ARDS_RESERV_DISTRIB_MATCH_QUAL_2  321L

/* Reserved fields for AR System client menu items */
#define AR_RESERV_MENU_MIN                400L

#define AR_RESERV_MENU_MODIFYALL          401L
#define AR_RESERV_MENU_DELETE             402L
#define AR_RESERV_MENU_PREFERENCES        403L
#define AR_RESERV_MENU_MENU               404L
#define AR_RESERV_MENU_TOOLBAR            405L
#define AR_RESERV_MENU_APPLY              406L
#define AR_RESERV_MENU_POLLING            407L
#define AR_RESERV_MENU_REPORTING          408L
#define AR_RESERV_MENU_PRINT              409L
#define AR_RESERV_MENU_CLEARALL           410L
#define AR_RESERV_MENU_SETDEFAULT         411L
#define AR_RESERV_MENU_SEARCH             412L
#define AR_RESERV_MENU_NEW_SEARCH         413L
#define AR_RESERV_MENU_NEW_REQUEST        414L
#define AR_RESERV_MENU_SHOW_STAT_HIST     415L
#define AR_RESERV_MENU_HOME               416L
#define AR_RESERV_MENU_HELP               417L
#define AR_RESERV_MENU_ADVANCED_SEARCH    418L

/* Reserved field ids to identify a shadow form for archive & audit */
#define AR_RESERV_ARCHIVE_AUDIT_ENTRY_ID  450L
#define AR_RESERV_ARCHIVE_CREATE_DATE     451L
#define AR_RESERV_AUDIT_LAST_CHANGED      452L
#define AR_RESERV_AUDIT_ACTION            453L

/* Reserved fields for Application support */
#define ARAPP_RESERV_APPLIC_CATEGORY      AR_CORE_SHORT_DESCRIPTION
#define ARAPP_RESERV_APPLIC_COMMAND       501L
#define ARAPP_RESERV_APPLIC_SCHEMA        502L
#define ARAPP_RESERV_APPLIC_ENTRY_ID      503L
#define ARAPP_RESERV_APPLIC_TAG           504L
#define ARAPP_RESERV_APPLIC_FIELD_1       505L
#define ARAPP_RESERV_APPLIC_FIELD_2       506L
#define ARAPP_RESERV_APPLIC_FIELD_3       507L
#define ARAPP_RESERV_APPLIC_OTHER_SHORT   508L
#define ARAPP_RESERV_APPLIC_OTHER_LONG    509L
                                      /* reserved for Business Time support */
                                      /* Holiday */
#define AR_RESERV_HOLIDAY_LIST            600L
                                      /* Workday */
#define AR_RESERV_WORKDAY_OPEN_SUN_0        620L
#define AR_RESERV_WORKDAY_OPEN_MON_0        621L
#define AR_RESERV_WORKDAY_OPEN_TUES_0       622L
#define AR_RESERV_WORKDAY_OPEN_WED_0        623L
#define AR_RESERV_WORKDAY_OPEN_THURS_0      624L
#define AR_RESERV_WORKDAY_OPEN_FRI_0        625L
#define AR_RESERV_WORKDAY_OPEN_SAT_0        626L
#define AR_RESERV_WORKDAY_CLOSE_SUN_0       630L
#define AR_RESERV_WORKDAY_CLOSE_MON_0       631L
#define AR_RESERV_WORKDAY_CLOSE_TUES_0      632L
#define AR_RESERV_WORKDAY_CLOSE_WED_0       633L
#define AR_RESERV_WORKDAY_CLOSE_THURS_0     634L
#define AR_RESERV_WORKDAY_CLOSE_FRI_0       635L
#define AR_RESERV_WORKDAY_CLOSE_SAT_0       636L
#define AR_RESERV_WORKDAY_OFFSET_HOURS      637L

#define AR_RESERV_WORKDAY_OPEN_SUN_1        639L
#define AR_RESERV_WORKDAY_OPEN_MON_1        640L
#define AR_RESERV_WORKDAY_OPEN_TUES_1       641L
#define AR_RESERV_WORKDAY_OPEN_WED_1        642L
#define AR_RESERV_WORKDAY_OPEN_THURS_1      643L
#define AR_RESERV_WORKDAY_OPEN_FRI_1        644L
#define AR_RESERV_WORKDAY_OPEN_SAT_1        645L
#define AR_RESERV_WORKDAY_CLOSE_SUN_1       646L
#define AR_RESERV_WORKDAY_CLOSE_MON_1       647L
#define AR_RESERV_WORKDAY_CLOSE_TUES_1      648L
#define AR_RESERV_WORKDAY_CLOSE_WED_1       649L
#define AR_RESERV_WORKDAY_CLOSE_THURS_1     652L
#define AR_RESERV_WORKDAY_CLOSE_FRI_1       653L
#define AR_RESERV_WORKDAY_CLOSE_SAT_1       654L

#define AR_RESERV_WORKDAY_OPEN_SUN_2        655L
#define AR_RESERV_WORKDAY_OPEN_MON_2        656L
#define AR_RESERV_WORKDAY_OPEN_TUES_2       657L
#define AR_RESERV_WORKDAY_OPEN_WED_2        658L
#define AR_RESERV_WORKDAY_OPEN_THURS_2      659L
#define AR_RESERV_WORKDAY_OPEN_FRI_2        660L
#define AR_RESERV_WORKDAY_OPEN_SAT_2        661L
#define AR_RESERV_WORKDAY_CLOSE_SUN_2       662L
#define AR_RESERV_WORKDAY_CLOSE_MON_2       663L
#define AR_RESERV_WORKDAY_CLOSE_TUES_2      664L
#define AR_RESERV_WORKDAY_CLOSE_WED_2       665L
#define AR_RESERV_WORKDAY_CLOSE_THURS_2     666L
#define AR_RESERV_WORKDAY_CLOSE_FRI_2       667L
#define AR_RESERV_WORKDAY_CLOSE_SAT_2       668L

/* Field ID's 670-678, 680-682, 695-698 */
/* Reserved by Business time form.      */
/* REMAINING WORKDAY reserved fields in */
/* the range of 820 - 880               */

/* Reserved fields for Alert support */
#define AR_RESERV_ALERT_FORM              701L
#define AR_RESERV_ALERT_REQUEST           702L
#define AR_RESERV_ALERT_SERVER            703L
#define AR_RESERV_ALERT_MESSAGE           704L
#define AR_RESERV_ALERT_PRIORITY          705L
#define AR_RESERV_ALERT_LIST_QLV          706L

#define AR_RESERV_ALERT_COLUMN_READ       711L
#define AR_RESERV_ALERT_COLUMN_PRIORITY   712L
#define AR_RESERV_ALERT_COLUMN_SOURCE     713L
#define AR_RESERV_ALERT_COLUMN_CREATEDATE 714L
#define AR_RESERV_ALERT_COLUMN_MESSAGE    715L
#define AR_RESERV_ALERT_COLUMN_REQUEST    716L
#define AR_RESERV_ALERT_COLUMN_FORM       717L
#define AR_RESERV_ALERT_COLUMN_SERVER     718L

/* Reserved fields for Server Group support */
#define AR_RESERV_SG_OPERATION            731L
#define AR_RESERV_SG_SERVER_NAME          732L
#define AR_RESERV_SG_RANK                 733L
#define AR_RESERV_SG_DELINQ_THRESH        734L

/* Reserved fields for the Server Event Schema */
#define AR_RESERV_SVR_EVENT_TYPE          800L
#define AR_RESERV_SVR_EVENT_CAUSE         801L
#define AR_RESERV_SVR_EVENT_DETAILS_1     802L
#define AR_RESERV_SVR_EVENT_DETAILS_2     803L
#define AR_RESERV_SVR_EVENT_DETAILS_3     804L

/* Reserved fields for Business Time Continued from Above */
#define AR_RESERV_WORKDAY_OPEN_SUN_3        820L
#define AR_RESERV_WORKDAY_OPEN_MON_3        821L
#define AR_RESERV_WORKDAY_OPEN_TUES_3       822L
#define AR_RESERV_WORKDAY_OPEN_WED_3        823L
#define AR_RESERV_WORKDAY_OPEN_THURS_3      824L
#define AR_RESERV_WORKDAY_OPEN_FRI_3        825L
#define AR_RESERV_WORKDAY_OPEN_SAT_3        826L
#define AR_RESERV_WORKDAY_CLOSE_SUN_3       827L
#define AR_RESERV_WORKDAY_CLOSE_MON_3       828L
#define AR_RESERV_WORKDAY_CLOSE_TUES_3      829L
#define AR_RESERV_WORKDAY_CLOSE_WED_3       830L
#define AR_RESERV_WORKDAY_CLOSE_THURS_3     831L
#define AR_RESERV_WORKDAY_CLOSE_FRI_3       832L
#define AR_RESERV_WORKDAY_CLOSE_SAT_3       833L
/* 835 to 840 used for Open and Close texts */

/* Reserved fields for the Server Statistics Schema */
#define AR_RESERV_SVR_STATS_QUEUE                   900L
#define AR_RESERV_SVR_STATS_BAD_PASSWORD            902
#define AR_RESERV_SVR_STATS_NO_WRITE_TOKEN          903
#define AR_RESERV_SVR_STATS_NO_FULL_TOKEN           904
#define AR_RESERV_SVR_STATS_CURRENT_USERS           905
#define AR_RESERV_SVR_STATS_WRITE_FIXED             906
#define AR_RESERV_SVR_STATS_WRITE_FLOATING          907
#define AR_RESERV_SVR_STATS_WRITE_READ              908
#define AR_RESERV_SVR_STATS_FULL_FIXED              909
#define AR_RESERV_SVR_STATS_FULL_FLOATING           910
#define AR_RESERV_SVR_STATS_FULL_NONE               911
#define AR_RESERV_SVR_STATS_API_REQUESTS            912
#define AR_RESERV_SVR_STATS_API_TIME                913
#define AR_RESERV_SVR_STATS_ENTRY_TIME              914
#define AR_RESERV_SVR_STATS_RESTRUCT_TIME           915
#define AR_RESERV_SVR_STATS_OTHER_TIME              916
#define AR_RESERV_SVR_STATS_CACHE_TIME              917
#define AR_RESERV_SVR_STATS_GET_E_COUNT             918
#define AR_RESERV_SVR_STATS_GET_E_TIME              919
#define AR_RESERV_SVR_STATS_SET_E_COUNT             920
#define AR_RESERV_SVR_STATS_SET_E_TIME              921
#define AR_RESERV_SVR_STATS_CREATE_E_COUNT          922
#define AR_RESERV_SVR_STATS_CREATE_E_TIME           923
#define AR_RESERV_SVR_STATS_DELETE_E_COUNT          924
#define AR_RESERV_SVR_STATS_DELETE_E_TIME           925
#define AR_RESERV_SVR_STATS_MERGE_E_COUNT           926
#define AR_RESERV_SVR_STATS_MERGE_E_TIME            927
#define AR_RESERV_SVR_STATS_GETLIST_E_COUNT         928
#define AR_RESERV_SVR_STATS_GETLIST_E_TIME          929
#define AR_RESERV_SVR_STATS_E_STATS_COUNT           930
#define AR_RESERV_SVR_STATS_E_STATS_TIME            931
#define AR_RESERV_SVR_STATS_FILTER_PASSED           932
#define AR_RESERV_SVR_STATS_FILTER_FAILED           933
#define AR_RESERV_SVR_STATS_FILTER_DISABLE          934
#define AR_RESERV_SVR_STATS_FILTER_NOTIFY           935
#define AR_RESERV_SVR_STATS_FILTER_MESSAGE          936
#define AR_RESERV_SVR_STATS_FILTER_LOG              937
#define AR_RESERV_SVR_STATS_FILTER_FIELDS           938
#define AR_RESERV_SVR_STATS_FILTER_PROCESS          939
#define AR_RESERV_SVR_STATS_FILTER_TIME             940
#define AR_RESERV_SVR_STATS_ESCL_PASSED             941
#define AR_RESERV_SVR_STATS_ESCL_FAILED             942
#define AR_RESERV_SVR_STATS_ESCL_DISABLE            943
#define AR_RESERV_SVR_STATS_ESCL_NOTIFY             944
#define AR_RESERV_SVR_STATS_ESCL_LOG                945
#define AR_RESERV_SVR_STATS_ESCL_FIELDS             946
#define AR_RESERV_SVR_STATS_ESCL_PROCESS            947
#define AR_RESERV_SVR_STATS_ESCL_TIME               948
#define AR_RESERV_SVR_STATS_TIMES_BLOCKED           949
#define AR_RESERV_SVR_STATS_NUMBER_BLOCKED          950
#define AR_RESERV_SVR_STATS_CPU                     951
#define AR_RESERV_SVR_STATS_SQL_DB_COUNT            952
#define AR_RESERV_SVR_STATS_SQL_DB_TIME             953
#define AR_RESERV_SVR_STATS_FTS_SRCH_COUNT          954
#define AR_RESERV_SVR_STATS_FTS_SRCH_TIME           955
#define AR_RESERV_SVR_STATS_IDLE_TIME               957
#define AR_RESERV_SVR_STATS_NET_RESP_TIME           958
#define AR_RESERV_SVR_STATS_FILTER_FIELDP           959
#define AR_RESERV_SVR_STATS_ESCL_FIELDP             960
#define AR_RESERV_SVR_STATS_FILTER_SQL              961
#define AR_RESERV_SVR_STATS_ESCL_SQL                962
#define AR_RESERV_SVR_STATS_NUM_THREADS             963
#define AR_RESERV_SVR_STATS_FILTER_GOTO_ACTION      964
#define AR_RESERV_SVR_STATS_FILTER_CALL_GUIDE       965
#define AR_RESERV_SVR_STATS_FILTER_EXIT_GUIDE       966
#define AR_RESERV_SVR_STATS_FILTER_GOTO_GUIDE_LB    967
#define AR_RESERV_SVR_STATS_FILTER_FIELDS_SQL       968
#define AR_RESERV_SVR_STATS_FILTER_FIELDS_PROCESS   969
#define AR_RESERV_SVR_STATS_FILTER_FIELDS_FLTAPI    970
#define AR_RESERV_SVR_STATS_ESCL_FIELDS_SQL         971
#define AR_RESERV_SVR_STATS_ESCL_FIELDS_PROCESS     972
#define AR_RESERV_SVR_STATS_ESCL_FIELDS_FLTAPI      973
#define AR_RESERV_SVR_STATS_SERVER_NAME             974
#define AR_RESERV_SVR_STATS_SERVER_TCP_PORT         975
#define AR_RESERV_SVR_STATS_RESTRICTED_READ         976

/* Reserved fields for Application Statistics Configuration Form */

#define AR_RESERV_APP_STATS_CONFIG_LOGGING_INTERVAL 1101L
#define AR_RESERV_APP_STATS_CONFIG_LOGGING_TYPE     1102L
#define AR_RESERV_APP_STATS_CONFIG_NAME             1103L
#define AR_RESERV_APP_STATS_CONFIG_LOGGING_STATUS   1104L
#define AR_RESERV_APP_STATS_CONFIG_WINDOWS_VUI      1105L
#define AR_RESERV_APP_STATS_CONFIG_WEB_VUI          1106L


/* Reserved fields for Application Statistics Form */
#define AR_RESERV_APP_STATS_LOGGING_TYPE            1102L
#define AR_RESERV_APP_STATS_NAME                    1103L
#define AR_RESERV_APP_STATS_FIXED_LIC               1251L
#define AR_RESERV_APP_STATS_FLOATING_LIC            1252L
#define AR_RESERV_APP_STATS_ESCL_PF                 1254L
#define AR_RESERV_APP_STATS_ESCL_DIRECT_SQL         1255L
#define AR_RESERV_APP_STATS_ESCL_PROC_TIME          1256L
#define AR_RESERV_APP_STATS_SQL_COMMANDS            1257L
#define AR_RESERV_APP_STATS_SQL_PROC_TIME           1258L
#define AR_RESERV_APP_STATS_WINDOWS_VUI             1260L
#define AR_RESERV_APP_STATS_WEB_VUI                 1261L
#define AR_RESERV_APP_STATS_PAGEHOLDER              1262L
#define AR_RESERV_APP_STATS_PAGEFIELD_ENTRY         1263L
#define AR_RESERV_APP_STATS_PAGEFIELD_FILTER        1264L
#define AR_RESERV_APP_STATS_PAGEFIELD_ESCALATION    1265L
#define AR_RESERV_APP_STATS_PAGEFIELD_LICENSES      1266L
#define AR_RESERV_APP_STATS_FILTER_EXECS            1267L
#define AR_RESERV_APP_STATS_FILTER_SKIPPED          1268L
#define AR_RESERV_APP_STATS_DISABLED_FILTERS        1269L
#define AR_RESERV_APP_STATS_FILTER_NOTIFY           1270L
#define AR_RESERV_APP_STATS_FILTER_MSG              1272L
#define AR_RESERV_APP_STATS_FILTER_LOG              1271L
#define AR_RESERV_APP_STATS_FILTER_SF               1273L
#define AR_RESERV_APP_STATS_FILTER_SF_SQL           1274L
#define AR_RESERV_APP_STATS_FILTER_SF_PROC          1275L
#define AR_RESERV_APP_STATS_FILTER_SF_FLTAPI        1276L
#define AR_RESERV_APP_STATS_FILTER_RUN_PROC         1277L
#define AR_RESERV_APP_STATS_FILTER_PF               1278L
#define AR_RESERV_APP_STATS_FILTER_SQL              1279L
#define AR_RESERV_APP_STATS_FILTER_GOTO             1280L
#define AR_RESERV_APP_STATS_FILTER_CALL_GUIDE       1281L
#define AR_RESERV_APP_STATS_FILTER_EXIT_GUIDE       1282L
#define AR_RESERV_APP_STATS_FILTER_GOTO_GUIDE       1283L
#define AR_RESERV_APP_STATS_FILTER_PROC_TIME        1284L
#define AR_RESERV_APP_STATS_ESCL_EXEC               1285L
#define AR_RESERV_APP_STATS_ESCL_SKIPPED            1286L
#define AR_RESERV_APP_STATS_ESCL_DISABLED           1287L
#define AR_RESERV_APP_STATS_ESCL_NOTIFY             1288L
#define AR_RESERV_APP_STATS_ESCL_LOG                1289L
#define AR_RESERV_APP_STATS_ESCL_SF                 1290L
#define AR_RESERV_APP_STATS_ESCL_SF_SQL             1291L
#define AR_RESERV_APP_STATS_ESCL_SF_PROC            1292L
#define AR_RESERV_APP_STATS_ESCL_SF_FLTAPI          1293L
#define AR_RESERV_APP_STATS_ESCL_RUN_PROC           1294L
#define AR_RESERV_APP_STATS_FRM_GE                  1295L
#define AR_RESERV_APP_STATS_FRM_SE                  1296L
#define AR_RESERV_APP_STATS_FRM_GLE                 1297L
#define AR_RESERV_APP_STATS_FRM_CR_ENTRY            1298L
#define AR_RESERV_APP_STATS_FRM_DEL_ENTRY           1299L
#define AR_RESERV_APP_STATS_FRM_MERGE_ENTRY         1300L
#define AR_RESERV_APP_STATS_FRM_ENTRY_API_CALLS     1301L
#define AR_RESERV_APP_STATS_FRM_GLE_TIME            1302L
#define AR_RESERV_APP_STATS_FRM_GE_TIME             1303L
#define AR_RESERV_APP_STATS_FRM_SE_TIME             1304L
#define AR_RESERV_APP_STATS_FRM_CR_ENTRY_TIME       1305L
#define AR_RESERV_APP_STATS_FRM_MERGE_ENTRY_TIME    1306L
#define AR_RESERV_APP_STATS_FRM_DEL_ENTRY_TIME      1307L
#define AR_RESERV_APP_STATS_SERVER_START_TIME       1310L
#define AR_RESERV_APP_STATS_SERVER_NAME              974L
#define AR_RESERV_APP_STATS_SERVER_TCP_PORT          975L
#define AR_RESERV_APP_STATS_FLOATING_LIC_DENIED     1313L

/* Reserved fields for form actions and results */
#define AR_RESERV_FORM_ACTION_SUBMIT         1001L
#define AR_RESERV_FORM_ACTION_QUERY          1002L
#define AR_RESERV_FORM_ACTION_MODIFY         1003L
#define AR_RESERV_FORM_ACTION_MODIFYALL      1004L
#define AR_RESERV_FORM_ACTION_QUERYBAR       1005L
#define AR_RESERV_FORM_ACTION_CLEAR          1006L
#define AR_RESERV_FORM_ACTION_SETDEFAULT     1007L
#define AR_RESERV_FORM_ACTION_HELP           1008L
#define AR_RESERV_FORM_ACTION_NEWSEARCH      1009L
#define AR_RESERV_FORM_ACTION_NEWREQUEST     1010L
#define AR_RESERV_FORM_ACTION_SHOW_STATHST   1011L
#define AR_RESERV_FORM_ACTION_HOMEPAGE       1012L

#define AR_RESERV_FORM_RESULTS_LIST          1020L

/* Reserved fields for Currency forms */
#define AR_RESERV_CURRENCY_DATE              1501L
#define AR_RESERV_CURRENCY_FROM              1502L
#define AR_RESERV_CURRENCY_TO                1503L
#define AR_RESERV_CURRENCY_RATIO             1504L

#define AR_RESERV_CURRENCY_CODE              1521L
#define AR_RESERV_CURRENCY_PRECISION         1522L
#define AR_RESERV_CURRENCY_LOCALE            1523L
#define AR_RESERV_CURRENCY_LABEL             1524L
#define AR_RESERV_CURRENCY_ACTIVE            1525L

/* Reserved fields for Home Page */
#define AR_RESERV_HOMEPAGE_FIELD             1575L
#define AR_RESERV_HOMEPAGE_SUBSET            1576L

/* Reserved fields for Auto-GUID generation */
#define AR_RESERV_AUTO_GUID                  1600L
#define AR_RESERV_AUTO_GUID_MIN              1600L
#define AR_RESERV_AUTO_GUID_MAX              1699L

/* Reserved fields for Role Mapping Schema */
#define AR_RESERV_ROLE_MAPPING_APPLICATION   1700L
#define AR_RESERV_ROLE_MAPPING_ROLE_NAME     1701L
#define AR_RESERV_ROLE_MAPPING_ROLE_ID       1702L

/* Reserved fields for Application States */
#define AR_RESERV_APP_STATE_MIN              2000L
#define AR_RESERV_APP_STATE_MAX              2199L

#define AR_RESERV_APP_STATE_ADMIN_ONLY       2000L
#define AR_RESERV_APP_STATE_TEST             2001L
#define AR_RESERV_APP_STATE_PRODUCTION       2002L

#define AR_RESERV_APP_STATE_APPLICATION      2200L
#define AR_RESERV_APP_STATE_STATE            2201L

                 /* 100 reserved field ids to identify report schema */
#define AR_RESERV_REPORT_MIN                    17000L
#define AR_RESERV_REPORT_MAX                    17399L

#define AR_RESERV_REPORT_CREATOR_SCHEMA         17127L 
#define AR_RESERV_REPORT_SCHEMA                 2010005L 
#define AR_RESERV_REPORT_TYPE_SCHEMA            2010006L
#define AR_RESERV_REPORT_SELECTION_SCHEMA       2010007L
                 /* "Form Name" field on the "Report" schema */
#define AR_RESERV_REPORT_FORM_NAME              2000010L

               /* 2000 reserved field ids to identify email forms */
#define AR_RESERV_EMAIL_MIN                     18000L
#define AR_RESERV_EMAIL_MAX                     19999L
               /* shared among all email forms. */
#define AR_RESERV_EMAIL_GUID                    179L
#define AR_RESERV_EMAIL_HIDDEN                  18213L

/* Reserved fields for the Email Association form */
#define AR_RESERV_EMAIL_ASSOC_DEST_ID           18000L
#define AR_RESERV_EMAIL_ASSOC_SOURCE_TYPE       18001L
#define AR_RESERV_EMAIL_ASSOC_DEST_TYPE         18002L
#define AR_RESERV_EMAIL_ASSOC_SRC_ID            18134L
#define AR_RESERV_EMAIL_ASSOC_FORM_ID           19000L   /* 30007L */
#define AR_RESERV_EMAIL_ASSOC_HDR_LABEL         18182L   /* reused */
#define AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL    18193L   /* reused */
#define AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR    18210L   /* reused */

/* Reserved fields for the Email Attachments form */
#define AR_RESERV_EMAIL_ATTCH_ATTCHMNT_POOL     18003L
#define AR_RESERV_EMAIL_ATTCH_EMAIL_ATTACHMNT   18004L
#define AR_RESERV_EMAIL_ATTCH_TYPE              18005L
#define AR_RESERV_EMAIL_ATTCH_EMAIL_GUID        18051L
#define AR_RESERV_EMAIL_ATTCH_ATTCHMENT_NAME    18133L
#define AR_RESERV_EMAIL_ATTCH_SAVE              18151L   /* reused */
#define AR_RESERV_EMAIL_ATTCH_FORM_ID           19001L   /* 30008L */
#define AR_RESERV_EMAIL_ATTCH_SUB_HDR_LABEL     AR_RESERV_EMAIL_ASSOC_HDR_LABEL /* 18182L */
#define AR_RESERV_EMAIL_ATTCH_FORM_HDR_LABEL    AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL /* 18193L */
#define AR_RESERV_EMAIL_ATTCH_HIDDEN_PG_HLDR    AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */
#define AR_RESERV_EMAIL_ATTCH_COLUMN2           18225L
#define AR_RESERV_EMAIL_ATTCH_COLUMN            18226L
#define AR_RESERV_EMAIL_ATTCH_TEMP_INDEX        18249L
#define AR_RESERV_EMAIL_ATTCH_TEMP_NAME         18248L

/* Reserved fields for the Email Error Logs form */
#define AR_RESERV_EMAIL_ERR_LOG_MSG_TYPE        18019L
#define AR_RESERV_EMAIL_ERR_LOG_MSG_GEN_BY      18020L
#define AR_RESERV_EMAIL_ERR_LOG_MSG_NUM         18021L
#define AR_RESERV_EMAIL_ERR_LOG_MSG_TXT         18022L   /* reused */
#define AR_RESERV_EMAIL_ERR_LOG_EMAIL_ID        18023L
#define AR_RESERV_EMAIL_ERR_LOG_CLASS_NAME      18024L
#define AR_RESERV_EMAIL_ERR_LOG_METHOD_NAME     18025L
#define AR_RESERV_EMAIL_ERR_LOG_CALL_STACK      18026L
#define AR_RESERV_EMAIL_ERR_LOG_MAILBOX_ID      AR_RESERV_EMAIL_MSG_MAILBOX_ID /* 18093L */
#define AR_RESERV_EMAIL_ERR_LOG_FORM_ID         19002L   /* 30010L */
#define AR_RESERV_EMAIL_ERR_LOG_SUB_HDR_LABEL   18192L   /* reused */
#define AR_RESERV_EMAIL_ERR_LOG_FORM_HDR_LABEL  AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL /* 18193L */
#define AR_RESERV_EMAIL_ERR_LOG_HIDDEN_PG_HLDR  AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */
#define AR_RESERV_EMAIL_ERR_LOG_COLUMN2         18227L
#define AR_RESERV_EMAIL_ERR_LOG_COLUMN3         18228L
#define AR_RESERV_EMAIL_ERR_LOG_COLUMN4         18229L
#define AR_RESERV_EMAIL_ERR_LOG_COLUMN5         18230L

/* Reserved fields for the Email Instruction Parameters form */
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_NAME             18028L
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_ID               18029L
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_VALUE            18030L
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_ATTACHMNT        18031L
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_FORM_ID          19003L   /* 30011L */
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_SUB_HDR_LABEL    AR_RESERV_EMAIL_ERR_LOG_SUB_HDR_LABEL    /* 18192L */
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_FORM_HDR_LABEL   AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL /* 18193L */
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_HIDDEN_PG_HLDR   AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */
#define AR_RESERV_EMAIL_INSTRCTNS_PARMS_ATTCHMNT_POOL    18198L   /* reused */

/* Reserved fields for the Email Instructions form */
#define AR_RESERV_EMAIL_INSTRCTNS_EMAIL_ID         18032L
#define AR_RESERV_EMAIL_INSTRCTNS_MAILBOX_ID       18033L
#define AR_RESERV_EMAIL_INSTRCTNS_INSTRCTN         18034L
#define AR_RESERV_EMAIL_INSTRCTNS_AR_SVR           18035L
#define AR_RESERV_EMAIL_INSTRCTNS_FORM_ID          19004L   /* 30012L*/
#define AR_RESERV_EMAIL_INSTRCTNS_SUB_HDR_LABEL    AR_RESERV_EMAIL_ERR_LOG_SUB_HDR_LABEL    /* 18192L */
#define AR_RESERV_EMAIL_INSTRCTNS_FORM_HDR_LABEL   AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL /* 18193L */
#define AR_RESERV_EMAIL_INSTRCTNS_HIDDEN_PG_HLDR   AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */

/* Reserved fields for the Email Mailbox Configuration form */
#define AR_RESERV_EMAIL_CONFIG_MAILBOX_NAME              18037L
#define AR_RESERV_EMAIL_CONFIG_IN_MAILSVR_PORT           18038L
#define AR_RESERV_EMAIL_CONFIG_IN_MAILSVR_USER           18039L
#define AR_RESERV_EMAIL_CONFIG_IN_MAILSVR_TYPE           18041L
#define AR_RESERV_EMAIL_CONFIG_OUT_MAILSVR_TYPE          18045L
#define AR_RESERV_EMAIL_CONFIG_IN_MAILSVR_SSL            18046L
#define AR_RESERV_EMAIL_CONFIG_MAILBOX_FUNC              18049L
#define AR_RESERV_EMAIL_CONFIG_IN_POLL_INTVL             18050L
#define AR_RESERV_EMAIL_CONFIG_EMAIL_ACTION              18052L
#define AR_RESERV_EMAIL_CONFIG_DFLT_WKFLW_FORM           18053L
#define AR_RESERV_EMAIL_CONFIG_DFLT_FORM_ONLY            18054L
#define AR_RESERV_EMAIL_CONFIG_REPLY_W_RSLT              18055L
#define AR_RESERV_EMAIL_CONFIG_USER_NAME                 18056L
#define AR_RESERV_EMAIL_CONFIG_EMAIL_ADDRESS             18057L
#define AR_RESERV_EMAIL_CONFIG_REPLY_TO_ADDRESS          18058L
#define AR_RESERV_EMAIL_CONFIG_ORGANIZATION              18059L
#define AR_RESERV_EMAIL_CONFIG_DFLT_TO                   18069L
#define AR_RESERV_EMAIL_CONFIG_DFLT_CC                   18070L
#define AR_RESERV_EMAIL_CONFIG_DFLT_BCC                  18071L
#define AR_RESERV_EMAIL_CONFIG_HEADER_TMP                18074L
#define AR_RESERV_EMAIL_CONFIG_USE_SECURITY_IN           18076L
#define AR_RESERV_EMAIL_CONFIG_USE_EMAIL_ADDR_FRM_IN     18077L
#define AR_RESERV_EMAIL_CONFIG_USE_SUPPLIED_USER_INFO_IN 18078L
#define AR_RESERV_EMAIL_CONFIG_FOOTER_TMP                18079L
#define AR_RESERV_EMAIL_CONFIG_STATUS_TMP                18080L
#define AR_RESERV_EMAIL_CONFIG_RESULT_TMP                18081L
#define AR_RESERV_EMAIL_CONFIG_IN_MAIL_SVR_IP            18130L
#define AR_RESERV_EMAIL_CONFIG_HDR_TMP_NAME        18143L
#define AR_RESERV_EMAIL_CONFIG_FTR_TMP_NAME        18144L
#define AR_RESERV_EMAIL_CONFIG_STAT_TMP_NAME       18145L
#define AR_RESERV_EMAIL_CONFIG_RSLT_TMP_NAME       18146L
#define AR_RESERV_EMAIL_CONFIG_DFLT_MAILBOX        18147L   /* out going */
#define AR_RESERV_EMAIL_CONFIG_ENABLE_MODIFICATION 18148L
#define AR_RESERV_EMAIL_CONFIG_SAVE                AR_RESERV_EMAIL_ATTCH_SAVE /* 18151L */
#define AR_RESERV_EMAIL_CONFIG_SUB_HDR_LABEL       AR_RESERV_EMAIL_ASSOC_HDR_LABEL /* 18182L */
#define AR_RESERV_EMAIL_CONFIG_FORM_HDR_LABEL      18183L   /* reused */
#define AR_RESERV_EMAIL_CONFIG_PG_HLDR             18184L
#define AR_RESERV_EMAIL_CONFIG_MAILBOX_CNFG_TAB    18185L
#define AR_RESERV_EMAIL_CONFIG_ACTION_CNFG_TAB     18186L
#define AR_RESERV_EMAIL_CONFIG_ACTION_CNFG_LABEL   AR_RESERV_EMAIL_ERR_LOG_SUB_HDR_LABEL /* 18192L */
#define AR_RESERV_EMAIL_CONFIG_ACTION_CNFG_BOX     AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL  /* 18193L */
#define AR_RESERV_EMAIL_CONFIG_IN_SCRTY_CNFG_LABEL 18194L
#define AR_RESERV_EMAIL_CONFIG_IN_SCRTY_CNFG_BOX   18195L
#define AR_RESERV_EMAIL_CONFIG_DFLT_ADDR_LABEL     AR_RESERV_EMAIL_INSTRCTNS_PARMS_ATTCHMNT_POOL /* 18198L */
#define AR_RESERV_EMAIL_CONFIG_DFLT_ADDR_BOX       18199L
#define AR_RESERV_EMAIL_CONFIG_DFLT_TMP_LABEL      18200L
#define AR_RESERV_EMAIL_CONFIG_DFLT_TMP_BOX        18201L
#define AR_RESERV_EMAIL_CONFIG_REPLY_WITH_ENTRY    18205L
#define AR_RESERV_EMAIL_CONFIG_INBOX_PATH          18206L
#define AR_RESERV_EMAIL_CONFIG_PROFILE_NAME        18208L
#define AR_RESERV_EMAIL_CONFIG_HIDDEN_PG_HLDR      AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */
#define AR_RESERV_EMAIL_CONFIG_FORM_ID             19005L   /* 30013L*/
#define AR_RESERV_EMAIL_CONFIG_PASSWORD            AR_RESERV_ENCRYPTED_STRING /* 123L */
#define AR_RESERV_EMAIL_CONFIG_ASSOCIATED_GUID     18216L
#define AR_RESERV_EMAIL_CONFIG_MAILBOX_ID          18217L
#define AR_RESERV_EMAIL_CONFIG_ASSOC_MAILBOX_NAME  18218L
#define AR_RESERV_EMAIL_CONFIG_DELETE_OUTGOING     18221L
#define AR_RESERV_EMAIL_CONFIG_DEFLT_OUTGOING2     18222L
#define AR_RESERV_EMAIL_CONFIG_SET_DEFAULT_PORT    18223L
#define AR_RESERV_EMAIL_CONFIG_COLUMN              18231L
#define AR_RESERV_EMAIL_CONFIG_COLUMN2             18232L
#define AR_RESERV_EMAIL_CONFIG_COLUMN3             18233L
#define AR_RESERV_EMAIL_CONFIG_DEFAULT_MAILBOX     18252L

/* Reserved fields for the Email Message form */
#define AR_RESERV_EMAIL_MSG_CNTNT_ATTCHMNT_ENCODING      18065L
#define AR_RESERV_EMAIL_MSG_VALUES_ATTCHMNT_ENCODING     18066L
#define AR_RESERV_EMAIL_MSG_MSG_ID                       18082L
#define AR_RESERV_EMAIL_MSG_DATE_SENT                    18083L
#define AR_RESERV_EMAIL_MSG_DATE_RECEIVED                18084L
#define AR_RESERV_EMAIL_MSG_TO                           18085L
#define AR_RESERV_EMAIL_MSG_FROM                         18086L
#define AR_RESERV_EMAIL_MSG_REPLY_TO                     18087L
#define AR_RESERV_EMAIL_MSG_CC                           18088L
#define AR_RESERV_EMAIL_MSG_BCC                          18089L
#define AR_RESERV_EMAIL_MSG_SUBJECT                      18090L
#define AR_RESERV_EMAIL_MSG_MSG_BODY                     18091L
#define AR_RESERV_EMAIL_MSG_MSG_TYPE                     18092L
#define AR_RESERV_EMAIL_MSG_MAILBOX_ID                   18093L   /* reused */
#define AR_RESERV_EMAIL_MSG_ARSYS_SVR                    18094L
#define AR_RESERV_EMAIL_MSG_ATTCHMNT_POOL                18095L
#define AR_RESERV_EMAIL_MSG_PRIORITY                     18096L
#define AR_RESERV_EMAIL_MSG_SENT_AT                      18097L
#define AR_RESERV_EMAIL_MSG_PARSE_MSG                    18098L
#define AR_RESERV_EMAIL_MSG_SEND_MSG                     18099L   /* reused */
#define AR_RESERV_EMAIL_MSG_EMAIL                        18100L
#define AR_RESERV_EMAIL_MSG_ARSYS_FORM                   18101L
#define AR_RESERV_EMAIL_MSG_CONTENT_TMP                  18102L
#define AR_RESERV_EMAIL_MSG_ORGANIZATION                 18103L
#define AR_RESERV_EMAIL_MSG_CONTENT                      18104L
#define AR_RESERV_EMAIL_MSG_FIELD_VALUE                  18106L
#define AR_RESERV_EMAIL_MSG_VALUES                       18107L
#define AR_RESERV_EMAIL_MSG_HEADER_TMP_ID                18108L
#define AR_RESERV_EMAIL_MSG_FOOTER_TEMPLATE              18109L
#define AR_RESERV_EMAIL_MSG_QUALIFICATION                18110L
#define AR_RESERV_EMAIL_MSG_ARSYS_TCP_PORT               18111L
#define AR_RESERV_EMAIL_MSG_ARSYS_RPC                    18112L
#define AR_RESERV_EMAIL_MSG_FORM_ID                      19006L   /* 30014L */
#define AR_RESERV_EMAIL_MSG_LOG_MSG_TXT                  AR_RESERV_EMAIL_ERR_LOG_MSG_TXT /* 18022L */
#define AR_RESERV_EMAIL_MSG_HDR_TMP_NAME                 18135L
#define AR_RESERV_EMAIL_MSG_CNTNT_TMP_NAME               18136L
#define AR_RESERV_EMAIL_MSG_FTR_TMP_NAME                 18137L
#define AR_RESERV_EMAIL_MSG_MAILBOX_NAME                 18139L   /* reused */
#define AR_RESERV_EMAIL_MSG_HTML_CNTNT                   18140L
#define AR_RESERV_EMAIL_MSG_HTML_CNTNT_ATTCHMNT_ENCODE   18141L
#define AR_RESERV_EMAIL_MSG_REPLY                        18149L
#define AR_RESERV_EMAIL_MSG_SEND_EMAIL                   18150L
#define AR_RESERV_EMAIL_MSG_SAVE                         AR_RESERV_EMAIL_ATTCH_SAVE /* 18151L */
#define AR_RESERV_EMAIL_MSG_ATTCH_TBL_FLD                18152L   /* reused */
#define AR_RESERV_EMAIL_MSG_ATTCH_ID_CLMN                18153L   /* reused */
#define AR_RESERV_EMAIL_MSG_ATTCH_NAME_CLMN              18154L   /* reused */
#define AR_RESERV_EMAIL_MSG_ATTCH_TYPE_CLMN              18155L   /* reused */
#define AR_RESERV_EMAIL_MSG_ERR_TABLE                    18157L
#define AR_RESERV_EMAIL_MSG_CLMN3                        18158L
#define AR_RESERV_EMAIL_MSG_CLMN7                        18159L
#define AR_RESERV_EMAIL_MSG_CLMN8                        18160L
#define AR_RESERV_EMAIL_MSG_LOG_MSG_ID                   18161L
#define AR_RESERV_EMAIL_MSG_MSG_PG_HLDR                  18162L
#define AR_RESERV_EMAIL_MSG_MSG_TAB                      18163L
#define AR_RESERV_EMAIL_MSG_ATTCH_TAB                    18164L
#define AR_RESERV_EMAIL_MSG_ADVANCE_OPT_TAB              18165L
#define AR_RESERV_EMAIL_MSG_MSG_INFO_TAB                 18166L
#define AR_RESERV_EMAIL_MSG_ERROR_TAB                    18167L
#define AR_RESERV_EMAIL_MSG_CRM_SUPPORT                  18168L
#define AR_RESERV_EMAIL_MSG_BODY_PG_HLDR                 18169L
#define AR_RESERV_EMAIL_MSG_HTML_BODY_PG                 18170L
#define AR_RESERV_EMAIL_MSG_ADD_ATTCH                    18171L   /* reused */
#define AR_RESERV_EMAIL_MSG_MOD_ATTCH                    18172L   /* reused */
#define AR_RESERV_EMAIL_MSG_DEL_ATTCH                    18173L   /* reused */
#define AR_RESERV_EMAIL_MSG_EXISTING_ATTCH               18174L   /* reused */
#define AR_RESERV_EMAIL_MSG_EXISTING_ATTCH_ID            18175L   /* reused */
#define AR_RESERV_EMAIL_MSG_ADD_EXISTING                 18176L   /* reused */
#define AR_RESERV_EMAIL_MSG_REFRESH_TBL                  18177L   /* reused */
#define AR_RESERV_EMAIL_MSG_PG_HLDR2                     18178L
#define AR_RESERV_EMAIL_MSG_TMP_TAB                      18179L
#define AR_RESERV_EMAIL_MSG_VAR_REPLACE_TAB              18180L
#define AR_RESERV_EMAIL_MSG_ATTCH_ALTERNATIVE            18181L
#define AR_RESERV_EMAIL_MSG_PLAIN_TXT_BODY_PG            18191L
#define AR_RESERV_EMAIL_MSG_FORM_HDR_LABEL               AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL /* 18193L */
#define AR_RESERV_EMAIL_MSG_SUB_HDR_LABEL                18224L
#define AR_RESERV_EMAIL_MSG_RTF_CONTENT                  18209L
#define AR_RESERV_EMAIL_MSG_HIDDEN_PG_HLDR               AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */
#define AR_RESERV_EMAIL_MSG_ATTACHMENT_GUID_COLUMN       18212L
#define AR_RESERV_EMAIL_MSG_RTF_CONTENT_ENCODE           18215L
#define AR_RESERV_EMAIL_MSG_INCOMING_MAILBOX_ID          18220L
#define AR_RESERV_EMAIL_MSG_HTML_BODY                    18290L
#define AR_RESERV_EMAIL_MSG_CRM_READ_STAT                18291L
#define AR_RESERV_EMAIL_MSG_CRM_MAX_RETRIES              18292L
#define AR_RESERV_EMAIL_MSG_CRM_RETRY_COUNT              18293L
#define AR_RESERV_EMAIL_MSG_CRM_SMTP_SVR_RET_CODE        18294L
#define AR_RESERV_EMAIL_MSG_CRM_LAST_LOG_ENTRY           18295L
#define AR_RESERV_EMAIL_MSG_CRM_EMAIL_LOG                18296L
#define AR_RESERV_EMAIL_MSG_ATTCH                        18297L
#define AR_RESERV_EMAIL_MSG_CRM_SUBMITTED_FORM           18298L   /* reused */
#define AR_RESERV_EMAIL_MSG_IN_REPLY_TO                  18299L
#define AR_RESERV_EMAIL_MSG_DISPLAY_ADVANCED_OPT         18304L
#define AR_RESERV_EMAIL_MSG_COLUMN                       18235L
#define AR_RESERV_EMAIL_MSG_COLUMN2                      18236L
#define AR_RESERV_EMAIL_MSG_COLUMN4                      18237L

/* Reserved fields for the Email Security form */
#define AR_RESERV_EMAIL_SEC_USER_NAME                 18113L
#define AR_RESERV_EMAIL_SEC_KEY                       18115L
#define AR_RESERV_EMAIL_SEC_FOR_MAILBOX_ONLY          18116L
#define AR_RESERV_EMAIL_SEC_EMAIL_ADDRESSES           18117L
#define AR_RESERV_EMAIL_SEC_USE_EMAIL_FROM_ADDRESSES  18118L
#define AR_RESERV_EMAIL_SEC_KEY_EXPIRE                18119L
#define AR_RESERV_EMAIL_SEC_EXPIRE_DATE_TIME          18120L
#define AR_RESERV_EMAIL_SEC_DESCRIPTION               18129L
#define AR_RESERV_EMAIL_SEC_SAVE                      AR_RESERV_EMAIL_ATTCH_SAVE /* 18151L */
#define AR_RESERV_EMAIL_SEC_FORM_ID                   19007L   /* 30009L */
#define AR_RESERV_EMAIL_SEC_MAILBOX_ID                AR_RESERV_EMAIL_MSG_MAILBOX_ID /* 18093L */
#define AR_RESERV_EMAIL_SEC_MAILBOX_NAME              AR_RESERV_EMAIL_MSG_MAILBOX_NAME /* 18139L */
#define AR_RESERV_EMAIL_SEC_FORM_HDR_LABEL            AR_RESERV_EMAIL_CONFIG_FORM_HDR_LABEL /* 18183L */
#define AR_RESERV_EMAIL_SEC_SUB_HDR_LABEL             AR_RESERV_EMAIL_ERR_LOG_SUB_HDR_LABEL /* 18192L */
#define AR_RESERV_EMAIL_SEC_HIDDEN_PG_HLDR            AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR  /* 18210L */
#define AR_RESERV_EMAIL_SEC_COLUMN                    18238L
#define AR_RESERV_EMAIL_SEC_COLUMN2                   18239L
#define AR_RESERV_EMAIL_SEC_COLUMN3                   18240L
#define AR_RESERV_EMAIL_SEC_COLUMN4                   18241L
#define AR_RESERV_EMAIL_SEC_COLUMN5                   18242L

/* Reserved fields for the Email Templates form */
#define AR_RESERV_EMAIL_TMP_TMP_NAME            18121L
#define AR_RESERV_EMAIL_TMP_DESCRIPTION         18122L
#define AR_RESERV_EMAIL_TMP_ATTCHMNT_POOL       18123L
#define AR_RESERV_EMAIL_TMP_TMP_FORMAT          18125L
#define AR_RESERV_EMAIL_TMP_ENCODING            18132L
#define AR_RESERV_EMAIL_TMP_FORM_ID             19008L   /* 30015L */
#define AR_RESERV_EMAIL_TMP_TMP_ATTCH           18124L
#define AR_RESERV_EMAIL_TMP_SAVE                AR_RESERV_EMAIL_ATTCH_SAVE /* 18151L */
#define AR_RESERV_EMAIL_TMP_ATTCH_TBL_FID       AR_RESERV_EMAIL_MSG_ATTCH_TBL_FLD /* 18152L */
#define AR_RESERV_EMAIL_TMP_ATTCH_ID_CLMN       AR_RESERV_EMAIL_MSG_ATTCH_ID_CLMN /* 18153L */
#define AR_RESERV_EMAIL_TMP_ATTCH_NAME_CLMN     AR_RESERV_EMAIL_MSG_ATTCH_NAME_CLMN/* 18154L */
#define AR_RESERV_EMAIL_TMP_ATTCH_TYP_CLMN      AR_RESERV_EMAIL_MSG_ATTCH_TYPE_CLMN/* 18155L */
#define AR_RESERV_EMAIL_TMP_ADD_ATTCH           AR_RESERV_EMAIL_MSG_ADD_ATTCH/* 18171L */
#define AR_RESERV_EMAIL_TMP_MOD_ATTCH           AR_RESERV_EMAIL_MSG_MOD_ATTCH/* 18172L */
#define AR_RESERV_EMAIL_TMP_DEL_ATTCH           AR_RESERV_EMAIL_MSG_DEL_ATTCH/* 18173L */
#define AR_RESERV_EMAIL_TMP_EXISTING_ATTCH      AR_RESERV_EMAIL_MSG_EXISTING_ATTCH/* 18174L */
#define AR_RESERV_EMAIL_TMP_EXISTING_ATTCH_ID   AR_RESERV_EMAIL_MSG_EXISTING_ATTCH_ID/* 18175L */
#define AR_RESERV_EMAIL_TMP_ADD_EXISTING        AR_RESERV_EMAIL_MSG_ADD_EXISTING/* 18176L */
#define AR_RESERV_EMAIL_TMP_REFRESH_TBL         AR_RESERV_EMAIL_MSG_REFRESH_TBL/* 18177L */
#define AR_RESERV_EMAIL_TMP_HDR_LABEL           AR_RESERV_EMAIL_ASSOC_HDR_LABEL/* 18182L */
#define AR_RESERV_EMAIL_TMP_SUB_HDR_LABEL       AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL/* 18193L */
#define AR_RESERV_EMAIL_TMP_PG_HLDR             18202L
#define AR_RESERV_EMAIL_TMP_TMP_INFO            18203L
#define AR_RESERV_EMAIL_TMP_TMP_ATTCHs          18204L
#define AR_RESERV_EMAIL_TMP_HIDDEN_PG_HLDR      AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR /* 18210L */
#define AR_RESERV_EMAIL_TMP_ATTACHMENT_GUID_COL AR_RESERV_EMAIL_MSG_ATTACHMENT_GUID_COLUMN /* 18212 */
#define AR_RESERV_EMAIL_TMP_COLUMN              18243L
#define AR_RESERV_EMAIL_TMP_COLUMN2             18244L
#define AR_RESERV_EMAIL_TMP_COLUMN3             18245L
#define AR_RESERV_EMAIL_TMP_COLUMN4             18246L
#define AR_RESERV_EMAIL_TMP_TEMP_INDEX          18250L
#define AR_RESERV_EMAIL_TMP_TEMP_NAME           18251L

/* Reserved fields for the Email User Instruction Template form */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_INSTRUCTION      18126L
#define AR_RESERV_EMAIL_INSTRCTN_TMP_TMP_ID           18127L
#define AR_RESERV_EMAIL_INSTRCTN_TMP_SAVE             AR_RESERV_EMAIL_ATTCH_SAVE /* 18151L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_FORM_ID          19009L   /* 30016L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_MAILBOX_ID       AR_RESERV_EMAIL_MSG_MAILBOX_ID /* 18093L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_MAILBOX_NAME     AR_RESERV_EMAIL_MSG_MAILBOX_NAME/* 18139L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_TMP_NAME         18142L
#define AR_RESERV_EMAIL_INSTRCTN_TMP_SUB_HDR_LABEL    AR_RESERV_EMAIL_ERR_LOG_SUB_HDR_LABEL/* 18192L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_FORM_HDR_LABEL   AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL/* 18193L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_HIDDEN_PG_HLDR   AR_RESERV_EMAIL_ASSOC_HIDDEN_PG_HLDR/* 18210L */
#define AR_RESERV_EMAIL_INSTRCTN_TMP_COLUMN           18247L

/* Reserved fields for the Email Attachment join form */
#define AR_RESERV_EMAIL_ATTCHMNT_JOIN_TYPE            AR_RESERV_EMAIL_ATTCH_TYPE    /* 18005L */
#define AR_RESERV_EMAIL_ATTCHMNT_JOIN_ATTCHMENT_NAME  AR_RESERV_EMAIL_ATTCH_ATTCHMENT_NAME  /* 18133L */
#define AR_RESERV_EMAIL_ATTCHMNT_JOIN_SRC_ID          AR_RESERV_EMAIL_ASSOC_SRC_ID  /* 18134L */
#define AR_RESERV_EMAIL_ATTCHMNT_JOIN_HDR_LABEL       AR_RESERV_EMAIL_ASSOC_HDR_LABEL /* 18182L */
#define AR_RESERV_EMAIL_ATTCHMNT_JOIN_SUB_HDR_LABEL   AR_RESERV_EMAIL_CONFIG_FORM_HDR_LABEL /* 18183L */
#define AR_RESERV_EMAIL_ATTCHMNT_JOIN_ATTCH_ID        AR_RESERV_EMAIL_ASSOC_FORM_HDR_LABEL/* 18193L */

                 /* reserved field ids unique within a schema */
                 /* but not across schemas */
#define AR_RESERV_SCHEMA_SPECIFIC_FIELD_MIN       20000L
#define AR_RESERV_SCHEMA_SPECIFIC_FIELD_MAX       29999L

                 /* reserved field ids to identify preference schemas */
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_MIN       30000L  /* 10,000 for AR System client  */
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_MAX       39999L  /* preference schema  */

#define AR_RESERV_PREFERENCE_ARS_SCHEMA_COMMON    30000L
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_ADMIN     30001L
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_USER      30002L
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_WEBTIER   30003L
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_ALERT     30004L
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_MIGRATOR  30005L
#define AR_RESERV_PREFERENCE_ARS_SCHEMA_FILES     30006L    /* Reserved field IDs to identify */
                                                            /* pref schema holding pref files */
                                                            /* (i.e. report, macro and etc.)  */

                 /* reserved field ids used to identify various flashboard schemas       */
                 /* The actual id values are available in the Flashboard server/midtier  */
                 /* and admin tool components. This define here is to reserve the range  */
                 /* so that no other module uses it                                      */
#define AR_RESERV_FLASHBOARD_FIELDS_MIN         40000L
#define AR_RESERV_FLASHBOARD_FIELDS_MAX         42000L

                  /* unique field ids used to identify flashboard forms */
#define AR_RESERV_FB_ALARM_EVENTS               40280L
#define AR_RESERV_FB_ALARM_MONITOR              40262L
#define AR_RESERV_FB_DATA_SOURCE                40056L
#define AR_RESERV_FB_DATA_SOURCE_VARIABLES      40250L
#define AR_RESERV_FB_FLASHBOARDS                40164L
#define AR_RESERV_FB_HISTORY                    40100L
#define AR_RESERV_FB_HISTORY_SUMMARY            40306L
#define AR_RESERV_FB_VARIABLE                   40075L
#define AR_RESERV_FB_VARIABLE_ATTRIBUTES        40201L

                  /* reserved flashboard fields */
#define AR_RESERV_FB_VARIABLE_ID                40000L   /* Variable System ID */
#define AR_RESERV_FB_DATA_SOURCE_ID             40001L   /* Data Source System ID */
#define AR_RESERV_FB_ALARM_SOURCE_ID            40260L   /* Alarm System ID */
#define AR_RESERV_FB_NAME                       AR_CORE_SHORT_DESCRIPTION   /* Flashboard Name */

                 /* reserved field ids for wireless forms */
#define AR_RESERV_SCHEMA_SPECIFIC_WIRELESS_FIELD_MIN   50000L
#define AR_RESERV_SCHEMA_SPECIFIC_WIRELESS_FIELD_MAX   50999L

                 /* Reserved range for dynamic group ids and field ids */
                 /* Group ids below 14000 are for general use by customers */
#define AR_RESERV_GROUP_DYNAMIC_MIN          60000L
#define AR_RESERV_GROUP_DYNAMIC_MAX          60999L

                 /* Range of reserved field Ids for */
                 /* global fields.                  */
#define AR_RESERV_GLOBAL_FIELDS_MIN          1000000
#define AR_RESERV_GLOBAL_FIELDS_MAX          1999999

                 /* Range of reserved field Ids for */
                 /* workflow variables.             */
#define AR_RESERV_WORKFLOW_VARS_MIN          2000000
#define AR_RESERV_WORKFLOW_VARS_MAX          2999999

#define   inWFVariableRange(_l) ( (_l <= AR_RESERV_WORKFLOW_VARS_MAX) && (_l >= AR_RESERV_WORKFLOW_VARS_MIN) )
#define   getWFVariableType(_l)  ((_l % AR_RESERV_WORKFLOW_VARS_MIN) / 10000)
#define   getWFVariableScope(_l)  ((_l % 10000) / 1000)
/* Note that the following macros only check the guide or filter bit */
/* you need to make sure the ID is in range and of a correct type */
/* before using them */
#define   isGuideVar(_l) ((_l / 1000) & 1)
#define   isFilterVar(_l) (!(_l / 1000) & 1)

                /* Per API/Execute On condition scope */
#define AR_RESERV_WF_EOC_INTEGER_VAR_MIN   2020000
#define AR_RESERV_WF_EOC_INTEGER_VAR_MAX   2020999
#define AR_RESERV_WF_EOC_REAL_VAR_MIN      2030000
#define AR_RESERV_WF_EOC_REAL_VAR_MAX      2030999
#define AR_RESERV_WF_EOC_CHAR_VAR_MIN      2040000
#define AR_RESERV_WF_EOC_CHAR_VAR_MAX      2040999
#define AR_RESERV_WF_EOC_ENUM_VAR_MIN      2060000
#define AR_RESERV_WF_EOC_ENUM_VAR_MAX      2060999
#define AR_RESERV_WF_EOC_TIMEOFDAY_VAR_MIN 2070000
#define AR_RESERV_WF_EOC_TIMEOFDAY_VAR_MAX 2070999
#define AR_RESERV_WF_EOC_DECIMAL_VAR_MIN   2100000
#define AR_RESERV_WF_EOC_DECIMAL_VAR_MAX   2100999
#define AR_RESERV_WF_EOC_CURRENCY_VAR_MIN  2120000
#define AR_RESERV_WF_EOC_CURRENCY_VAR_MAX  2120999
#define AR_RESERV_WF_EOC_DATE_VAR_MIN      2130000
#define AR_RESERV_WF_EOC_DATE_VAR_MAX      2130999
#define AR_RESERV_WF_EOC_TIME_VAR_MIN      2140000
#define AR_RESERV_WF_EOC_TIME_VAR_MAX      2140999

                /* Per Guide/Workflow Component scope */
#define AR_RESERV_WF_GUIDE_INTEGER_VAR_MIN   2021000
#define AR_RESERV_WF_GUIDE_INTEGER_VAR_MAX   2021999
#define AR_RESERV_WF_GUIDE_REAL_VAR_MIN      2031000
#define AR_RESERV_WF_GUIDE_REAL_VAR_MAX      2031999
#define AR_RESERV_WF_GUIDE_CHAR_VAR_MIN      2041000
#define AR_RESERV_WF_GUIDE_CHAR_VAR_MAX      2041999
#define AR_RESERV_WF_GUIDE_ENUM_VAR_MIN      2061000
#define AR_RESERV_WF_GUIDE_ENUM_VAR_MAX      2061999
#define AR_RESERV_WF_GUIDE_TIMEOFDAY_VAR_MIN 2071000
#define AR_RESERV_WF_GUIDE_TIMEOFDAY_VAR_MAX 2071999
#define AR_RESERV_WF_GUIDE_DECIMAL_VAR_MIN   2101000
#define AR_RESERV_WF_GUIDE_DECIMAL_VAR_MAX   2101999
#define AR_RESERV_WF_GUIDE_CURRENCY_VAR_MIN  2121000
#define AR_RESERV_WF_GUIDE_CURRENCY_VAR_MAX  2121999
#define AR_RESERV_WF_GUIDE_DATE_VAR_MIN      2131000
#define AR_RESERV_WF_GUIDE_DATE_VAR_MAX      2131999
#define AR_RESERV_WF_GUIDE_TIME_VAR_MIN      2141000
#define AR_RESERV_WF_GUIDE_TIME_VAR_MAX      2141999

                 /* Range of reserved field Ids for */
                 /* window global fields            */
#define AR_RESERV_WINDOW_GLOBAL_FIELDS_MIN   3000000
#define AR_RESERV_WINDOW_GLOBAL_FIELDS_MAX   3999999


#define AR_GROUP_ID_PUBLIC            0L /* group-ids of the 'key' groups */
#define AR_GROUP_ID_ADMINISTRATOR     1L
#define AR_GROUP_ID_CUSTOMIZE         2L
#define AR_GROUP_ID_SUBMITTER         3L
#define AR_GROUP_ID_ASSIGNEE          4L
#define AR_GROUP_ID_SUB_ADMINISTRATOR 5L
#define AR_GROUP_ID_FLASH_ADMIN       6L
#define AR_GROUP_ID_ASSIGNEE_GROUP    7L

/* Constants used for items in values returned from the server */

#define AR_DEFN_DIARY_SEP        '\03'     /* diary items separator */
#define AR_DEFN_DIARY_COMMA      '\04'     /* char between date/user/text */
                                           /*  within a diary item        */
#define AR_DEFN_STAT_HIST_SEP    '\03'     /* status history items separator */
#define AR_DEFN_STAT_HIST_COMMA  '\04'     /* char between user and time in a */
                                           /*  status history item            */
#define AR_DEFN_VUI_EXT_SEP      '\01'     /* vui extension separator  */
                                           /* within a vui label       */
#define AR_DEFN_LABEL_SIZE     20 /* length of the label portion of lines   */
                                  /*   in the export definition format file */
#define AR_DEFN_LABEL_ENCR_SIZE 20 /* length of the label portion of encrypted */
                                  /* lines in the export definition format file */
#define AR_MAX_DEFN_LINE_SIZE 325 /* maximum length of a line in a defn file */
                                  /*   (excl "\n\0" at end of each line)     */

#define AR_NOTIFICATION_VUI      "ARNotification"
                                  /* VUI name used to identify the view to */
                                  /*  use for order of fields in an email  */
                                  /*  or other style notification          */

/* Constants holding label definitions for the fields in a definition file */

#define AR_DEFN_FILE_ALL_FIELDS    '*'     /* character to indicate ALL fields*/
#define AR_DEFN_FILE_CHNG_FIELDS   '@'     /* character to indicate CHNG field*/
#define AR_DEFN_FILE_COMMENT       '#'     /* character introducing a comment */
#define AR_DEFN_FILE_SEPARATOR     '\\'    /* character used to separate two */
                                           /*  or more values on one line    */
#define AR_DEFN_GROUP_ID_SEPARATOR ';'     /* character used to separate two */
                                           /*  or more group ids in a list   */
#define AR_DEFN_KEYWORD_PARM_TAG   '$'     /* character surrounding keywords */
                                           /*  and parameters in values      */
#define AR_DEFN_ATTACH_SEPARATOR   ';'     /* character used to separate     */
                                           /*  attributes of a stringified   */
                                           /*  attachment value              */

#define AR_DEFN_SINGLE_USER_GROUP_QUOTE   '\''  /* character that surrounds  */
                                                /* a single user group */

   /* There are some characters that can occur in labels and/or character */
   /* strings that conflict with the formatting characters that allow the */
   /* definition and processing of records.  When these characters are    */
   /* encountered, they are translated into a control character when the  */
   /* data is stored in the DB and then back into the "real" character on */
   /* retrieval.  The "EMBEDDED" definitions define these mappings.       */
#define AR_DEFN_EMBEDDED_RETURN  '\01'     /* character substituting for '\n' */
                                           /*  (record separator) in the DB   */
#define AR_DEFN_EMBEDDED_SEP     '\02'     /* character substituting for an */
                                           /*  embedded separator in the DB */
#define AR_DEFN_ALT_EMBEDDED_SEP '\04'     /* character subs for embedded     */
                                           /*  char if has meaning other than */
                                           /*  a mapping for something        */
#define AR_DEFN_EXPLICIT_NEWLINE '\05'     /* character substituting for '\n' */
                                           /*  while encrypting multiline     */
                                           /*  definition content */
#define AR_DEFN_EXPLICIT_RETURN  '\06'     /* character substituting for '\r' */
                                           /*  while encrypting multiline     */
                                           /*  definition content */
#define AR_DEFN_CONT_CHAR          '&'     /* line continuation character */

#define AR_DEFN_STRUCT_ACTIVE_LINK      "begin active link\n"
#define AR_DEFN_STRUCT_ADMIN_EXT        "begin admin ext\n"
#define AR_DEFN_STRUCT_CHAR_MENU        "begin char menu\n"
#define AR_DEFN_STRUCT_CONTAINER        "begin container\n"
#define AR_DEFN_STRUCT_DIST_MAPPING     "begin distributed mapping\n"
#define AR_DEFN_STRUCT_FILTER           "begin filter\n"
#define AR_DEFN_STRUCT_ESCALATION       "begin escalation\n"
#define AR_DEFN_STRUCT_GROUP            "begin group\n"
#define AR_DEFN_STRUCT_SCHEMA           "begin schema\n"
#define AR_DEFN_STRUCT_SCHEMA_DATA      "begin schema data\n"
#define AR_DEFN_STRUCT_DIST_POOL        "begin distributed pool\n"
#define AR_DEFN_STRUCT_VUI              "begin vui\n"
#define AR_DEFN_STRUCT_LOCK_BLOCK       "begin lock block\n"
#define AR_DEFN_STRUCT_APP              "begin application\n"

#define AR_DEFN_END_STRUCT              "end\n"

#define AR_DEFN_CLAUSE_FIELD            "field {\n"
#define AR_DEFN_CLAUSE_REFERENCE        "reference {\n"
#define AR_DEFN_CLAUSE_VUI              "vui  {\n"
#define AR_DEFN_END_CLAUSE              "}\n"
#define AR_DEFN_CLAUSE_ACTION           "   action {\n"
#define AR_DEFN_END_ACTION              "   }\n"
#define AR_DEFN_CLAUSE_ELSE             "   else {\n"
#define AR_DEFN_END_ELSE                "   }\n"
#define AR_DEFN_CLAUSE_FILE             "   support file {\n"
#define AR_DEFN_END_FILE                "   }\n"

/* above definitions without newline */
#define AR_DEFN_STRUCT_ACTIVE_LINK_NO_NL  "begin active link"
#define AR_DEFN_STRUCT_ADMIN_EXT_NO_NL    "begin admin ext"
#define AR_DEFN_STRUCT_CHAR_MENU_NO_NL    "begin char menu"
#define AR_DEFN_STRUCT_CONTAINER_NO_NL    "begin container"
#define AR_DEFN_STRUCT_DIST_MAPPING_NO_NL "begin distributed mapping"
#define AR_DEFN_STRUCT_FILTER_NO_NL       "begin filter"
#define AR_DEFN_STRUCT_ESCALATION_NO_NL   "begin escalation"
#define AR_DEFN_STRUCT_GROUP_NO_NL        "begin group"
#define AR_DEFN_STRUCT_SCHEMA_NO_NL       "begin schema"
#define AR_DEFN_STRUCT_SCHEMA_DATA_NO_NL  "begin schema data"
#define AR_DEFN_STRUCT_DIST_POOL_NO_NL    "begin distributed pool"
#define AR_DEFN_STRUCT_VUI_NO_NL          "begin vui"
#define AR_DEFN_STRUCT_LOCK_BLOCK_NO_NL   "begin lock block"
#define AR_DEFN_STRUCT_APP_NO_NL          "begin application"

#define AR_DEFN_END_STRUCT_NO_NL          "end"

#define AR_DEFN_CLAUSE_FIELD_NO_NL      "field {"
#define AR_DEFN_CLAUSE_REFERENCE_NO_NL  "reference {"
#define AR_DEFN_CLAUSE_VUI_NO_NL        "vui  {"
#define AR_DEFN_CLAUSE_VUI_NO_NL_ALT    "vui {"
#define AR_DEFN_END_CLAUSE_NO_NL        "}"
#define AR_DEFN_CLAUSE_ACTION_NO_NL     "   action {"
#define AR_DEFN_END_ACTION_NO_NL        "   }"
#define AR_DEFN_CLAUSE_ELSE_NO_NL       "   else {"
#define AR_DEFN_END_ELSE_NO_NL          "   }"
#define AR_DEFN_CLAUSE_FILE_NO_NL       "   support file {"
#define AR_DEFN_END_FILE_NO_NL          "   }"

#define AR_DEFN_LABEL_ACCESS_OPTION     "      access-opt  : "
#define AR_DEFN_LABEL_FIELD_CHAR_OPTION "      option      : "
#define AR_DEFN_LABEL_ACTLINK_FIELD     "   actlink-field  : "
#define AR_DEFN_LABEL_ACTLINK_FOCUS     "   actlink-focus  : "
#define AR_DEFN_LABEL_ACTLINK_CONTROL   "   actlink-control: "
#define AR_DEFN_LABEL_ACTLINK_MASK      "   actlink-mask   : "
#define AR_DEFN_LABEL_ACTLINK_QRY       "   actlink-query  : "
#define AR_DEFN_LABEL_ACTLINK_ORD       "   actlink-order  : "
#define AR_DEFN_LABEL_ALLOW_CODES       "   allow-codes    : "
#define AR_DEFN_LABEL_ADMIN_SUB_PERM    "   admin-sub-perm : "
#define AR_DEFN_LABEL_AD_COMMAND        "   command        : "
#define AR_DEFN_LABEL_CALLGUIDE         " call guide :"
#define AR_DEFN_LABEL_CHANGE_DIARY      "   change-diary   : "
#define AR_DEFN_LABEL_CHAR_MENU         "   char-menu      : "
#define AR_DEFN_LABEL_ENCR_CHAR_MENU    " encrypt-char-menu: "
#define AR_DEFN_LABEL_CHAR_MENU_2       "      char-menu   : "
#define AR_DEFN_LABEL_CLOSE_WND         "      close-wnd   : "
#define AR_DEFN_LABEL_CLOSE_WND_ALL     "      close-all   : "
#define AR_DEFN_LABEL_COMMAND           "      command     : "
#define AR_DEFN_LABEL_ENCR_COMMAND      "    encrypt-cmd   : "
#define AR_DEFN_LABEL_COMMIT_CHANGES    "    commit_changes: "
#define AR_DEFN_LABEL_CONTENT           "      content     : "
#define AR_DEFN_LABEL_CONTAINER_SUBADM  "   container-admin: "
#define AR_DEFN_LABEL_CORE_VERS         "   core-version   : "
#define AR_DEFN_LABEL_UPGRD_VERS        "   upgrade-version: "
#define AR_DEFN_LABEL_CREATE_MODE       "   create-mode    : "
#define AR_DEFN_LABEL_DATA              "   data           : "
#define AR_DEFN_LABEL_DATA_MAPPING      "   data-mapping   : "
#define AR_DEFN_LABEL_DATA_TYPE         "   datatype       : "
#define AR_DEFN_LABEL_DDE_ACTION        "      dde-action  : "
#define AR_DEFN_LABEL_DDE_COMMAND       "      dde-command : "
#define AR_DEFN_LABEL_DDE_FILE          "      dde-file    : "
#define AR_DEFN_LABEL_DDE_ITEM          "      dde-item    : "
#define AR_DEFN_LABEL_DDE_SERVICE       "      dde-service : "
#define AR_DEFN_LABEL_DDE_TOPIC         "      dde-topic   : "
#define AR_DEFN_LABEL_AUTO_SERVER       "      auto-server : "
#define AR_DEFN_LABEL_AUTO_CLSID        "      auto-clsId  : "
#define AR_DEFN_LABEL_AUTO_ACTION       "      auto-action : "
#define AR_DEFN_LABEL_AUTO_VISIBLE      "      auto-visible: "
#define AR_DEFN_LABEL_AUTO_COM          "      auto-COM    : "
#define AR_DEFN_LABEL_DIRECT_SQL        "      direct-sql  : "
#define AR_DEFN_LABEL_ENCR_AL_SQL       "      encrypt-sql : "
#define AR_DEFN_LABEL_DEFAULT           "   default        : "
#define AR_DEFN_LABEL_DEFAULT_VUI       "   default-vui    : "
#define AR_DEFN_LABEL_DESCRIPTION       "   description    : "
#define AR_DEFN_LABEL_DISPLAY           "   display        : "
#define AR_DEFN_LABEL_DISPLAY_2         "      display     : "
#define AR_DEFN_LABEL_DISPLAY_PROPLIST  "   display-prop   : "
#define AR_DEFN_LABEL_DISPLAY_INSTANCE  " display-instance : "
#define AR_DEFN_LABEL_DUP_ACTION        "   dup-action     : "
#define AR_DEFN_LABEL_PATTERN_MATCH     "   pat-match      : "
#define AR_DEFN_LABEL_REQUIRED_FIELDS   "   req-fields     : "
#define AR_DEFN_LABEL_ENABLE            "   enable         : "
#define AR_DEFN_LABEL_ENUM_VALUE        "   enum-value     : "
#define AR_DEFN_LABEL_ENUM_VALUE_NUM    "   enum-value-num : "
#define AR_DEFN_LABEL_ENUM_QRY_SCHEMA   "   enum-qry-schema: "
#define AR_DEFN_LABEL_ENUM_QRY_SERVER   "   enum-qry-server: "
#define AR_DEFN_LABEL_ENUM_QRY_QUERY    "   enum-qry-query : "
#define AR_DEFN_LABEL_ENUM_QRY_NAME     "   enum-qry-name  : "
#define AR_DEFN_LABEL_ENUM_QRY_NUM      "   enum-qry-num   : "
#define AR_DEFN_LABEL_TBLFLD_SCHEMA     "tablefield-schema : "
#define AR_DEFN_LABEL_TBLFLD_SERVER     "tablefield-server : "
#define AR_DEFN_LABEL_TBLFLD_QUERY      "tablefield-query  : "
#define AR_DEFN_LABEL_TBLFLD_NUMCOLS    "tablefield-numcols: "
#define AR_DEFN_LABEL_TBLFLD_MAXRET     "tablefield-maxret : "
#define AR_DEFN_LABEL_COLFLD_PARENT     "colfield-parent   : "
#define AR_DEFN_LABEL_COLFLD_DATAFIELD  "colfield-datafield: "
#define AR_DEFN_LABEL_COLFLD_DATATYPE   "colfield-datatype : "
#define AR_DEFN_LABEL_COLFLD_DATASOURCE "colfield-datasrc  : "
#define AR_DEFN_LABEL_COLFLD_COLLENGTH  "colfield-collength: "
#define AR_DEFN_LABEL_ESCALATION_HOUR   "   escl-hourmask  : "
#define AR_DEFN_LABEL_ESCALATION_INT    "   escl-interval  : "
#define AR_DEFN_LABEL_ESCALATION_MIN    "   escl-minute    : "
#define AR_DEFN_LABEL_ESCALATION_MON    "   escl-monthday  : "
#define AR_DEFN_LABEL_ESCALATION_QRY    "   escl-query     : "
#define AR_DEFN_LABEL_ESCALATION_TMTYPE "   escl-tmType    : "
#define AR_DEFN_LABEL_ESCALATION_WEEK   "   escl-weekday   : "
#define AR_DEFN_LABEL_EXPORT_VERS       "   export-version : "

#define AR_DEFN_LABEL_EXT_NAME          "   ext-name       : "
#define AR_DEFN_LABEL_EXT_FIELD         "   ext-field      : "
#define AR_DEFN_LABEL_EXT_TABLE         "   ext-table      : "
#define AR_DEFN_LABEL_FIELD_TYPE        "   fieldtype      : "
#define AR_DEFN_LABEL_FIELD_REF         "      field-ref   : "
#define AR_DEFN_LABEL_FILE_TYPE         "      file-type   : "
#define AR_DEFN_LABEL_FILTER_OP         "   filter-op      : "
#define AR_DEFN_LABEL_FILTER_ORD        "   filter-order   : "
#define AR_DEFN_LABEL_FILTER_QRY        "   filter-query   : "
#define AR_DEFN_LABEL_FOCUS             "      focus       : "
#define AR_DEFN_LABEL_FROM_SCHEMA       "   from-schema    : "
#define AR_DEFN_LABEL_FROM_SERVER       "   from-server    : "
#define AR_DEFN_LABEL_FULLTEXTOPTNS     "   fulltext-optns : "
#define AR_DEFN_LABEL_FUNC_CODES        "   func-codes     : "
#define AR_DEFN_LABEL_GET_LIST_FLDS     "   get-list-flds  : "
#define AR_DEFN_LABEL_HELP              "   help-text      : "
#define AR_DEFN_LABEL_ID                "   id             : "
#define AR_DEFN_LABEL_ID_2              "      id          : "
#define AR_DEFN_LABEL_INDEX             "   index          : "
#define AR_DEFN_LABEL_JOIN_OPTION       "      join-option : "
#define AR_DEFN_LABEL_JOIN_PRIMARY      "      primary     : "
#define AR_DEFN_LABEL_JOIN_QRY          "      join-query  : "
#define AR_DEFN_LABEL_JOIN_SECONDARY    "      secondary   : "
#define AR_DEFN_LABEL_LABEL             "   label          : "
#define AR_DEFN_LABEL_LAST_CHANGED      "   last-changed   : "
#define AR_DEFN_LABEL_LOG_FILE          "      log-file    : "
#define AR_DEFN_LABEL_MACRO_NAME        "      macro-name  : "
#define AR_DEFN_LABEL_MACRO_PARMS       "      macro-parms : "
#define AR_DEFN_LABEL_MACRO_TEXT        "      macro-text  : "
#define AR_DEFN_LABEL_MAP_FIELDID       "      mapfield    : "
#define AR_DEFN_LABEL_MAP_SCHEMA        "      mapschema   : "
#define AR_DEFN_LABEL_MAP_TYPE          "   map-type       : "
#define AR_DEFN_LABEL_MAPPING           "   mapping        : "
#define AR_DEFN_LABEL_MATCH_QUAL        "   match-qual     : "
#define AR_DEFN_LABEL_MAX_DATE          "   maxDate        : "
#define AR_DEFN_LABEL_MAX_LENGTH        "   maxlength      : "
#define AR_DEFN_LABEL_MAXSIZE           "   maxsize        : "
#define AR_DEFN_LABEL_MIN_DATE          "   minDate        : "
#define AR_DEFN_LABEL_ATTACH_TYPE       "   attachtype     : "
#define AR_DEFN_LABEL_MENU_STYLE        "   menu-style     : "
#define AR_DEFN_LABEL_MSG_NUM           "      message-num : "
#define AR_DEFN_LABEL_MSG_TEXT          "      message-text: "
#define AR_DEFN_LABEL_MSG_TYPE          "      message-type: "
#define AR_DEFN_LABEL_MSG_PANE          "      message-pane: "
#define AR_DEFN_LABEL_NAME              "   name           : "
#define AR_DEFN_LABEL_NOT_FIELDS        "      notify-field: "
#define AR_DEFN_LABEL_NOT_MECH          "      notify-mech : "
#define AR_DEFN_LABEL_NOT_PRIORITY      "      notify-pri  : "
#define AR_DEFN_LABEL_NOT_SUBJECT       "      notify-subj : "
#define AR_DEFN_LABEL_NOT_TEXT          "      notify-text : "
#define AR_DEFN_LABEL_NOT_USER          "      notify-user : "
#define AR_DEFN_LABEL_NOT_XREF          "      notify-xref : "
#define AR_DEFN_LABEL_NOT_BEHAVIOR      "      notify-behvr: "
#define AR_DEFN_LABEL_NOT_PERMISSION    "      notify-perm : "
#define AR_DEFN_LABEL_NOT_ADV_REPLY_TO  "      notify-reply: "
#define AR_DEFN_LABEL_NOT_ADV_FROM      "      notify-from : "
#define AR_DEFN_LABEL_NOT_ADV_CC        "      notify-cc   : "
#define AR_DEFN_LABEL_NOT_ADV_BCC       "      notify-bcc  : "
#define AR_DEFN_LABEL_NOT_ADV_ORG       "      notify-org  : "
#define AR_DEFN_LABEL_NOT_ADV_MAILBOX   "      notify-mlbox: "
#define AR_DEFN_LABEL_NOT_ADV_HDR_TMP   "      notify-hdrtm: "
#define AR_DEFN_LABEL_NOT_ADV_FTR_TMP   "      notify-ftrtm: "
#define AR_DEFN_LABEL_NOT_ADV_CNT_TMP   "      notify-cnttm: "
#define AR_DEFN_LABEL_NUM_FIELDS        "   num-fields     : "
#define AR_DEFN_LABEL_NUM_REFERENCES    "   num-references : "
#define AR_DEFN_LABEL_NUM_VUIS          "   num-vuis       : "
#define AR_DEFN_LABEL_STRUCTITEM_LIST   "  struct-item-list: "
#define AR_DEFN_LABEL_ENCR_TEXT         "  encrypt-text    : "
#define AR_DEFN_LABEL_CHECKSUM          "  checksum        : "
#define AR_DEFN_LABEL_OBJECT            "   object         : "
#define AR_DEFN_LABEL_OBJECT_PROP       "   object-prop    : "
#define AR_DEFN_LABEL_ENCR_OBJECT_PROP  "  encrypt-obj-prop: "
#define AR_DEFN_LABEL_OBJECT_PROP_INTERVAL "   interval       : "

#define AR_DEFN_LABEL_OPEN_DLG          "   open-dialog    : "
#define AR_DEFN_LABEL_OPEN_DLG_SERVER   "      open-server : "
#define AR_DEFN_LABEL_OPEN_DLG_SCHEMA   "      open-schema : "
#define AR_DEFN_LABEL_OPEN_DLG_VUI      "      open-vui    : "
#define AR_DEFN_LABEL_OPEN_DLG_BOX      "      open-close  : "
#define AR_DEFN_LABEL_OPEN_DLG_INPUT    "      open-input  : "
#define AR_DEFN_LABEL_OPEN_DLG_OUTPUT   "      open-output : "
#define AR_DEFN_LABEL_OPEN_DLG_WINMODE  "      open-winmod : "
#define AR_DEFN_LABEL_OPEN_DLG_TARGET   "      open-target : "
#define AR_DEFN_LABEL_OPEN_DLG_QUERY    "      open-query  : "
#define AR_DEFN_LABEL_OPEN_DLG_CONTINU  "      open-continu: "
#define AR_DEFN_LABEL_OPEN_DLG_SUPPRESS "      open-suppres: "
#define AR_DEFN_LABEL_OPEN_DLG_MSG_TYPE "      open-msgtype: "
#define AR_DEFN_LABEL_OPEN_DLG_MSG_NUM  "      open-msgnum : "
#define AR_DEFN_LABEL_OPEN_DLG_MSG_PANE "      open-msgpane: "
#define AR_DEFN_LABEL_OPEN_DLG_MSG_TEXT "      open-msgtext: "
#define AR_DEFN_LABEL_OPEN_DLG_POLLINT  "      open-pollint: "
#define AR_DEFN_LABEL_OPEN_DLG_RPTSTR   "      open-rptstr : "
#define AR_DEFN_LABEL_OPEN_DLG_SORTORD  "      open-sortord: "

#define AR_DEFN_LABEL_CALLGUIDE_SERVER  "      call-server : "
#define AR_DEFN_LABEL_CALLGUIDE_GUIDE   "      call-guide  : "
#define AR_DEFN_LABEL_CALLGUIDE_MODE    "      call-mode   : "
#define AR_DEFN_LABEL_CALLGUIDE_TABLEID "      call-tableid: "
#define AR_DEFN_LABEL_CALLGUIDE_INPUT   "      call-input  : "
#define AR_DEFN_LABEL_CALLGUIDE_OUTPUT  "      call-output : "

#define AR_DEFN_LABEL_EXITGUIDE         "      exit guide  : "
#define AR_DEFN_LABEL_GOTOGUIDE         "      goto guide  : "
#define AR_DEFN_LABEL_WAIT              "      wait        : "
#define AR_DEFN_LABEL_GOTOACTION        "      goto action : "

#define AR_DEFN_LABEL_OPTION            "   option         : "
#define AR_DEFN_LABEL_OWNER             "   owner          : "
#define AR_DEFN_LABEL_CONTAINER_OWNER      "   owning-obj     : "
#define AR_DEFN_LABEL_CONTAINER_OWNER_NAME "   owning-obj-name: "
#define AR_DEFN_LABEL_CONTAINER_OWNER_TYPE "   owning-obj-type: "
#define AR_DEFN_LABEL_CONTAINER_NUM_OWNER "   num-owning-obj : "
#define AR_DEFN_LABEL_PATTERN           "   pattern        : "
#define AR_DEFN_LABEL_PERMISSION        "   permission     : "
#define AR_DEFN_LABEL_PRECISION         "   precision      : "
#define AR_DEFN_LABEL_REFERENCE_GROUPS  "   ref-groups     : "
#define AR_DEFN_LABEL_QBE_MATCH_OP      "   qbe-match-op   : "
#define AR_DEFN_LABEL_PUSH_FIELD        "      push-field  : "
#define AR_DEFN_LABEL_SAMPLE_SERVER     "      samp-server : "
#define AR_DEFN_LABEL_SAMPLE_SCHEMA     "      samp-schema : "
#define AR_DEFN_LABEL_SAMPLE_GUIDE      "      samp-guide  : "
#define AR_DEFN_LABEL_ENCR_FIELDP       "encrypt-push-field: "
#define AR_DEFN_LABEL_RANGE_HIGH        "   range-high     : "
#define AR_DEFN_LABEL_RANGE_LOW         "   range-low      : "
#define AR_DEFN_LABEL_REFRESH_CODE      "   refresh-code   : "
#define AR_DEFN_LABEL_RETRY_TIME        "   retry-time     : "
#define AR_DEFN_LABEL_RTN_MAP_TYPE      "   rtn-map-type   : "
#define AR_DEFN_LABEL_RTN_MAPPING       "   rtn-mapping    : "
#define AR_DEFN_LABEL_WK_CONN_TYPE      "   wk-conn-type   : "
#define AR_DEFN_LABEL_NEXT_FIELD_ID     "   next-field-id  : "
#define AR_DEFN_LABEL_SCHEMA_NAME       "   schema-name    : "
#define AR_DEFN_LABEL_SCHEMA_TYPE       "   schema-type    : "
#define AR_DEFN_LABEL_SCHEMA_SUBADM     "   schema-admin   : "
#define AR_DEFN_LABEL_SET_FIELD         "      set-field   : "
#define AR_DEFN_LABEL_ENCR_SET_FIELD    " encrypt-set-field: "
#define AR_DEFN_LABEL_SMOPROP_LIST      "   obj-props      : "
#define AR_DEFN_LABEL_SORT_LIST         "   sort-list      : "
#define AR_DEFN_LABEL_TIMESTAMP         "   timestamp      : "
#define AR_DEFN_LABEL_TIMESTAMP_2       "      timestamp   : "
#define AR_DEFN_LABEL_TO_SCHEMA         "   to-schema      : "
#define AR_DEFN_LABEL_TO_SERVER         "   to-server      : "
#define AR_DEFN_LABEL_TRANSFER_MODE     "   transfer-mode  : "
#define AR_DEFN_LABEL_TYPE              "   type           : "
#define AR_DEFN_LABEL_UPDATE_CODE       "   update-code    : "
#define AR_DEFN_LABEL_VIEW_KEYFIELD     "      key-field   : "
#define AR_DEFN_LABEL_VIEW_NAME         "      ext-table   : "
#define AR_DEFN_LABEL_VIEW_QRY          "      view-query  : "
#define AR_DEFN_LABEL_VALUE             "   value          : "
#define AR_DEFN_LABEL_DISTRIB_TCOUNT    "   thread-count   : "
#define AR_DEFN_LABEL_DISTRIB_CONNECT   "   connection     : "
#define AR_DEFN_LABEL_VUI_LOCALE        "   vui-locale     : "
#define AR_DEFN_LABEL_VUI_TYPE          "   vui-type       : "


#define AR_DEFN_LABEL_ARCHIVEINFO       "   archive        : "
#define AR_DEFN_LABEL_ARCHIVEINFO_TIME  "      arch-time   : "
#define AR_DEFN_LABEL_ARCHIVEINFO_QRY   "      arch-query  : "
#define AR_DEFN_LABEL_ARCHIVEINFO_FROM  "      arch-from   : "


/* Constants used for processing the directory files */
#define AR_DIR_LABEL_ACTLINK_DIR             "Active-Link-Dir:"
#define AR_DIR_LABEL_ACTLINK_SHELL           "Active-Link-Shell:"
#define AR_DIR_LABEL_ADMIN_ONLY              "Admin-Only-Mode:"
#define AR_DIR_LABEL_ARF_JAVA_CLASS_PATH     "ARF-Java-Class-Path:"
#define AR_DIR_LABEL_ARF_JAVA_VM_OPTIONS     "ARF-Java-VM-Options:"
#define AR_DIR_LABEL_ARFORK_LOG_FILE         "Arfork-Log-File:"
#define AR_DIR_LABEL_AS_SPEC_PORT            "Admin-Specific-Port:"
#define AR_DIR_LABEL_ALERT_CHECK_USERS       "Alert-Check-Users:"
#define AR_DIR_LABEL_ALERT_LOG_FILE          "Alert-Log-File:"
#define AR_DIR_LABEL_ALERT_OUTBOUND_PORT     "Alert-Outbound-Port:"
#define AR_DIR_LABEL_ALERT_SEND_TIMEOUT      "Alert-Send-Timeout:"
#define AR_DIR_LABEL_ALERT_IGNORE_ACTUAL_IP  "Alert-Ignore-Actual-Client-IP:"
#define AR_DIR_LABEL_ALLOW_GUEST             "Allow-Guest-Users:"
#define AR_DIR_LABEL_ALLOW_BACKQUOTE_IN_PROCESS "Allow-Backquote-In-Process-String:"
#define AR_DIR_LABEL_UNQUAL_QUERIES          "Allow-Unqual-Queries:"
#define AR_DIR_LABEL_API_LOG_FILE            "API-Log-File:"
#define AR_DIR_LABEL_APPLICATION_AUDIT       "Application-Audit-Info:"
#define AR_DIR_LABEL_APPLICATION_ENABLE      "Application-Enable:"
#define AR_DIR_LABEL_APPLICATION_TAG         "Application-Tag:"
#define AR_DIR_LABEL_AP_DEFN_CHECK_INT       "Approval-Defn-Check-Interval:"
#define AR_DIR_LABEL_APPROVAL_LOG_FILE       "Approval-Log-File:"
#define AR_DIR_LABEL_APPROVAL_NOTIFY         "Approval-Notify:"
#define AR_DIR_LABEL_AP_RPC_SOCKET           "Approval-RPC-Socket:"
#define AR_DIR_LABEL_AP_SPEC_PORT            "Approval-Specific-Port:"
#define AR_DIR_LABEL_AP_WEB_DOC_DIR          "Approval-Web-Doc-Dir:"
#define AR_DIR_LABEL_AUTH_CHAINING_MODE      "Authentication-Chaining-Mode:"
#define AR_DIR_LABEL_CACHE_MODE              "Cache-Mode:"
#define AR_DIR_LABEL_CANCEL_QUERY            "Cancel-Query-Option:"
#define AR_DIR_LABEL_CE_DEADLOCK_RETRIES     "Create-Entry-DeadLock-Retries:"
#define AR_DIR_LABEL_CE_DEADLOCK_RETRY_DELAY "Create-Entry-DeadLock-Retry-Delay:"
#define AR_DIR_LABEL_FTCASESEARCH            "Case-Insensitive-Search:"
#define AR_DIR_LABEL_NO_CHANGED_CHECK        "Changed-By-Another-Check:"
#define AR_DIR_LABEL_CLUSTERED_INDEX         "Clustered-Index:"
#define AR_DIR_LABEL_FTCOLLECTION            "Collection-directory:"
#define AR_DIR_LABEL_COMPUTED_GROUP_LOGGING  "Computed-Group-Logging:"
#define AR_DIR_LABEL_XREF_PASSWD             "Crossref-Blank-Password:"
#define AR_DIR_LABEL_CURRENCY_INTERVAL       "Currency-Ratio-Client-Refresh-Interval:"
#define AR_DIR_LABEL_DB_CASE_INSENSITIVE     "Db-Case-Insensitive:"
#define AR_DIR_LABEL_DB_CHAR_SET             "Db-Character-Set:"
#define AR_DIR_LABEL_DB_CONNECTION_RETRIES   "Db-Connection-Retries:"
#define AR_DIR_LABEL_DB_DIR                  "Dbhome-directory:"
#define AR_DIR_LABEL_DB_MAX_TEXT_SIZE        "Db-Max-Text-Size:"
#define AR_DIR_LABEL_DB_MAX_ATTACH_SIZE      "Db-Max-Attach-Size:"
#define AR_DIR_LABEL_DB_NAME                 "Db-name:"
#define AR_DIR_LABEL_DB_PASSWORD             "Db-password:"
#define AR_DIR_LABEL_DB_USER                 "Db-user:"
#define AR_DIR_LABEL_DEBUG_GROUPID           "Debug-GroupId:"
#define AR_DIR_LABEL_DEBUG_MODE              "Debug-mode:"
#define AR_DIR_LABEL_DB2_DATABASE_ALIAS      "DB2-Database-Alias:"
#define AR_DIR_LABEL_DB2_SERVER              "DB2-Server-Name:"
#define AR_DIR_LABEL_DB2_FREE_LOB_FREQ       "DB2-Free-Lob-Locator-Frequency:"
#define AR_DIR_LABEL_DFLT_ALLOW_CURRENCIES   "Default-Allowable-Currencies:"
#define AR_DIR_LABEL_DFLT_FUNC_CURRENCIES    "Default-Functional-Currencies:"
#define AR_DIR_LABEL_DEFAULT_ORDER_BY        "Default-Order-By:"
#define AR_DIR_LABEL_DEFAULT_WEB_PATH        "Default-Web-Path:"
#define AR_DIR_LABEL_DELAY_RECACHE_TIME      "Delay-Recache-Time:"
#define AR_DIR_LABEL_DISABLE_ADMIN_OPS       "Disable-Admin-Ops:"
#define AR_DIR_LABEL_DISABLE_ALERTS          "Disable-Alerts:"
#define AR_DIR_LABEL_DISABLE_ARCHIVE         "Disable-Archive:"
#define AR_DIR_LABEL_DISABLE_CLIENT_OP       "Disable-Client-Operation:"
#define AR_DIR_LABEL_DISABLE_ESCALATIONS     "Disable-Escalations:"
#define AR_DIR_LABEL_DELAYED_CACHE           "Disable-Shared-Cache-Delay:"
#define AR_DIR_LABEL_SHARED_MEM              "Disable-Shared-Memory:"
#define AR_DIR_LABEL_USER_CACHE_UTILS        "Disable-User-Cache-Utilities:"
#define AR_DIR_LABEL_DISTRIB_LOG_FILE        "Distrib-Log-File:"
#define AR_DIR_LABEL_DS_RPC_SOCKET           "Distributed-RPC-Socket:"
#define AR_DIR_LABEL_DSO_HOST_NAME           "DSO-Host-Name:"
#define AR_DIR_LABEL_DSO_MERGE_STYLE         "DSO-Merge-DupId-Overwrite:"
#define AR_DIR_LABEL_DSO_TIMEOUT_NORMAL      "DSO-Timeout-Normal:"
#define AR_DIR_LABEL_DSO_PLACEHOLDER         "DSO-Placeholder-Mode:"
#define AR_DIR_LABEL_DSO_POLL_INTERVAL       "DSO-Polling-Interval:"
#define AR_DIR_LABEL_DSO_DEST_PORT           "DSO-private-dest-port:"
#define AR_DIR_LABEL_DSO_REDIRECTOR_MODE     "DSO-Redirector-Mode:"
#define AR_DIR_LABEL_DSO_SOURCE_SERVER       "DSO-Source-Server:"
#define AR_DIR_LABEL_DSO_PEND_RETRY_FL       "DSO-Mark-Pending-Retry-Flag:"
#define AR_DIR_LABEL_DSO_TARGET_CONNECT      "DSO-Target-Connection:"
#define AR_DIR_LABEL_DSO_USER_PASSWD         "DSO-User-Password:"
#define AR_DIR_LABEL_DSO_TARGET_PASSWD       "DSO-Target-Password:"
#define AR_DIR_LABEL_DSO_CACHE_CHK_INTERVAL  "DSO-Cache-Check-Interval:"
#define AR_DIR_LABEL_DSO_RPC_SOCKET          "DSO-Local-RPC-Socket:"
#define AR_DIR_LABEL_DSO_LOGICAL_SERVER      "DSO-Logical-Server:"
#define AR_DIR_LABEL_DSO_ERROR_RETRY_OPTION  "DSO-Error-Retry-Option:"
#define AR_DIR_LABEL_EMAIL_SYSTEM            "Email-Delivery-System:"
#define AR_DIR_LABEL_EMAIL_FROM              "Email-Notify-From:"
#define AR_DIR_LABEL_EMAIL_TIMEOUT           "Email-Timeout:"
#define AR_DIR_LABEL_EMAIL_NOTIFY_MAILBOX_ID "Email-Notification-MailboxID:"
#define AR_DIR_LABEL_EMAIL_IMPORT_BY_DEFAULT "Email-Import-Form-By-Default:"
#define AR_DIR_LABEL_EMAIL_AIX_USE_OLD_EMAIL "Email-AIX-Use-Old-System:"
#define AR_DIR_LABEL_SHARED_CACHE            "Enable-Shared-Cache:"
#define AR_DIR_LABEL_ENCR_AL_SQL             "Encrypt-AL-Direct-SQL:"
#define AR_DIR_LABEL_ENC_DATA_ENCR_ALG       "Encrypt-Data-Encryption-Algorithm:"
#define AR_DIR_LABEL_ENC_DATA_KEY_EXP        "Encrypt-Symmetric-Data-Key-Expire:"
#define AR_DIR_LABEL_ENC_PUB_KEY_ALG         "Encrypt-Public-Key-Algorithm:"
#define AR_DIR_LABEL_ENC_PUB_KEY_EXP         "Encrypt-Public-Key-Expire:"
#define AR_DIR_LABEL_ENC_SEC_POLICY          "Encrypt-Security-Policy:"
#define AR_DIR_LABEL_ENC_SESS_H_ENTRIES      "Encrypt-Session-Hash-Entries:"
#define AR_DIR_LABEL_ENV_VARIABLE            "Environment-variable:"
#define AR_DIR_LABEL_ESCALATION_DAEMON       "Escalation-Daemon:"
#define AR_DIR_LABEL_ESCALATION_LOG_FILE     "Escalation-Log-File:"
#define AR_DIR_LABEL_ES_SPEC_PORT            "Escalation-Specific-Port:"
#define AR_DIR_LABEL_EXPORT_SVR_OPS          "Export-Server-Operations:"
#define AR_DIR_LABEL_EA_RETURN_DATA          "External-Authentication-Return-Data-Capabilities:"
#define AR_DIR_LABEL_EA_RPC_SOCKET           "External-Authentication-RPC-Socket:"
#define AR_DIR_LABEL_EA_RPC_TIMEOUT          "External-Authentication-RPC-Timeout:"
#define AR_DIR_LABEL_EA_SYNC_TIMEOUT         "External-Authentication-Sync-Timeout:"
#define AR_DIR_LABEL_FS_SPEC_PORT            "Fast-Specific-Port:"
#define AR_DIR_LABEL_APPLICATION_FIELDID     "Field-Id:"
#define AR_DIR_LABEL_FILTER_API_RPC_TIMEOUT  "Filter-Api-Timeout:"
#define AR_DIR_LABEL_FILT_MAX_STACK          "Filter-Max-Stack:"
#define AR_DIR_LABEL_FILT_MAX_TOTAL          "Filter-Max-Total:"
#define AR_DIR_LABEL_FILTER_LOG_FILE         "Filter-Log-File:"
#define AR_DIR_LABEL_FLASH_DAEMON            "Flashboards-Daemon:"
#define AR_DIR_LABEL_FLASH_SPEC_PORT         "Flashboards-Specific-Port:"
#define AR_DIR_LABEL_FLUSH_LOG_LINES         "Flush-Log-Lines:"
#define AR_DIR_LABEL_FTS_DEBUG               "FTS-Debug-mode:"
#define AR_DIR_LABEL_FTS_DISABLE_INDEXER     "FTS-Disable-Indexer:"
#define AR_DIR_LABEL_FTHOMEDIR               "FullText-home:"
#define AR_DIR_LABEL_FULL_LIC_TIMEOUT        "FullText-License-Timeout:"
#define AR_DIR_LABEL_FTSMATCHOP              "FullText-matchop:"
#define AR_DIR_LABEL_FTS_PENDING_DIR         "FullText-Pending-Dir:"
#define AR_DIR_LABEL_FTOPSSTATE              "FullText-state:"
#define AR_DIR_LABEL_FTSTHRESHOLDHIGH        "FullText-threshold-high:"
#define AR_DIR_LABEL_FTSTHRESHOLDLOW         "FullText-threshold-low:"
#define AR_DIR_LABEL_DATE_FORMAT             "GetListEntry-Server-Date-Format:"
#define AR_DIR_LABEL_GUID_PREFIX             "GUID-Prefix:"
#define AR_DIR_LABEL_HOMEPAGE_FORM           "Homepage-Form:"
#define AR_DIR_LABEL_INIT_FORM               "Init-Form:"
#define AR_DIR_LABEL_INFORMIX_DBN            "Informix-DBServer-Name:"
#define AR_DIR_LABEL_INFORMIX_RELAY_MOD      "Informix-Relay-Module:"
#define AR_DIR_LABEL_INFORMIX_TBC            "Informix-TBConfig:"
#define AR_DIR_LABEL_IP_NAME                 "IP-Name:"
#define AR_DIR_LABEL_USER_INFO_LISTS         "Internal-User-Info-Hash-Lists:"
#define AR_DIR_LABEL_USER_INST_TIMEOUT       "Internal-User-Instance-Timeout:"
#define AR_DIR_LABEL_LIC_TIMEOUT             "License-Timeout:"
#define AR_DIR_LABEL_LICENSE_TAG             "License-Tag:"
#define AR_DIR_LABEL_LS_SPEC_PORT            "List-Specific-Port:"
#define AR_DIR_LABEL_LOCALIZED_SERVER        "Localized-Server:"
#define AR_DIR_LABEL_LOCKED_WFLW_LOG_MODE    "Locked-Workflow-Log-Mode:"
#define AR_DIR_LABEL_LOGFILE_APPEND          "Log-File-Append:"
#define AR_DIR_LABEL_EMAIL_NOTIFY_DIR        "MailNotifyDir:"
#define AR_DIR_LABEL_MAP_IP_ADDR             "Map-IP-Address:"
#define AR_DIR_LABEL_MAX_AUDIT_LOG_FILE_SIZE "Max-Audit-Log-File-Size:"
#define AR_DIR_LABEL_MAX_ENTRIES             "Max-Entries-Per-Query:"
#define AR_DIR_LABEL_MAX_F_DAEMONS           "Max-Fast-Daemons:"
#define AR_DIR_LABEL_MAX_L_DAEMONS           "Max-List-Daemons:"
#define AR_DIR_LABEL_MAX_LOG_FILE_SIZE       "Max-Log-File-Size:"
#define AR_DIR_LABEL_EMAIL_LINE_LEN          "Max-Notify-Mail-Line-Len:"
#define AR_DIR_LABEL_MID_TIER_PASSWD         "Mid-Tier-Service-Password:"
#define AR_DIR_LABEL_MINIMUM_API_VERSION     "Minimum-API-Version:"
#define AR_DIR_LABEL_MONITOR_DIR             "Monitor-directory:"
#define AR_DIR_LABEL_MULTIPLE_ARSERVER       "Multiple-ARSystem-Servers:"
#define AR_DIR_LABEL_MULT_ASSIGN_GROUPS      "Multiple-Assign-Groups:"
#define AR_DIR_LABEL_NEXT_ID_COMMIT          "Next-ID-Commit:"
#define AR_DIR_LABEL_ORACLE_CURSOR_SHARING   "Oracle-Cursor-Sharing:"
#define AR_DIR_LABEL_ORACLE_DBLINK_CHARSET   "Oracle-Dblink-Character-Set:"
#define AR_DIR_LABEL_ORACLE_SID              "Oracle-SID:"
#define AR_DIR_LABEL_ORACLE_TWO_T            "Oracle-Two-Task:"
#define AR_DIR_LABEL_ORACLE_QUERY_CLOB       "Oracle-Search-On-Clob:"
#define AR_DIR_LABEL_ORACLE_FETCH_COUNT      "Oracle-Bulk-Fetch-Count:"
#define AR_DIR_LABEL_PER_THREAD_LOGS         "Per-Thread-Logging:"
#define AR_DIR_LABEL_PLUGIN_ARDBC_THREAD     "Plugin-ARDBC-Threads:"
#define AR_DIR_LABEL_PLUGIN_AREA_THREAD      "Plugin-AREA-Threads:"
#define AR_DIR_LABEL_PLUGIN_FILTERAPI_THREAD "Plugin-Filter-API-Threads:"
#define AR_DIR_LABEL_PLUGIN_DISABLE_REM      "Plugin-Disable-Remote:"
#define AR_DIR_LABEL_PLUGIN_LOAD             "Plugin:"
#define AR_DIR_LABEL_PLUGIN_LOG_FILE         "Plugin-Log-File:"
#define AR_DIR_LABEL_PLUGIN_LOG_LEVEL        "Plugin-Log-Level:"
#define AR_DIR_LABEL_PLUGIN_LOOPBACK_SOCKET  "Plugin-Loopback-RPC-Socket:"
#define AR_DIR_LABEL_PLUGIN_PASSWD           "Plugin-Password:"
#define AR_DIR_LABEL_PLUGIN_PATH             "Plugin-Path:"
#define AR_DIR_LABEL_PLUGIN_PORT             "Plugin-Port:"
#define AR_DIR_LABEL_PREFERENCE_PRIORITY     "Preference-Priority:"
#define AR_DIR_LABEL_PS_RPC_SOCKET           "Private-RPC-Socket:"
#define AR_DIR_LABEL_PS_SPEC_PORT            "Private-Specific-Port:"
#define AR_DIR_LABEL_PR_CATALOG_DIR          "PurchReq-Catalog-Dir:"
#define AR_DIR_LABEL_READ_ONLY_TRAN_OFF      "Read-Only-Tran-Off:"
#define AR_DIR_LABEL_SVR_EVENT_LIST          "Record-Server-Events:"
#define AR_DIR_LABEL_REDUCE_CHCKPNT_UPD      "Reduce-Checkpoint-Updates:"
#define AR_DIR_LABEL_REGISTER_PORTMAPPER     "Register-With-Portmapper:"
#define AR_DIR_LABEL_REM_WKFLW_PASSWD        "Remote-Workflow-Password:"
#define AR_DIR_LABEL_REM_WKFLW_TARGET_PASSWD "Remote-Workflow-Target-Password:"
#define AR_DIR_LABEL_APP_SERVICE_PASSWD      "Remedy-App-Service-Password:"
#define AR_DIR_LABEL_RPC_NON_BLOCKING_IO     "RPC-Non-Blocking-IO:"
#define AR_DIR_LABEL_SAVE_LOGIN              "Save-Login:"
#define AR_DIR_LABEL_SCC_CMNT_CHECKIN        "SCC-Comment-Checkin:"
#define AR_DIR_LABEL_SCC_CMNT_CHECKOUT       "SCC-Comment-Checkout:"
#define AR_DIR_LABEL_SCC_ENABLED             "SCC-Enabled:"
#define AR_DIR_LABEL_SCC_INT_MODE            "SCC-Integration-Mode:"
#define AR_DIR_LABEL_SCC_PROVIDER_NAME       "SCC-Provider-Name:"
#define AR_DIR_LABEL_SCC_TARGET_DIR          "SCC-Target-Dir:"
#define AR_DIR_LABEL_SELECT_QUERY_HINT       "Select-Query-Hint:"
#define AR_DIR_LABEL_SERVER_CONNECT_NAME     "Server-Connect-Name:"
#define AR_DIR_LABEL_SERVER_DIR              "Server-directory:"
#define AR_DIR_LABEL_SERVERGROUP_EMAIL_PORT  "Server-Group-Email-Admin-Port:"
#define AR_DIR_LABEL_SERVERGROUP_FLASH_PORT  "Server-Group-Flashboards-Admin-Port:"
#define AR_DIR_LABEL_SERVERGROUP_LOG_FILE    "Server-Group-Log-File:"
#define AR_DIR_LABEL_SERVERGROUP_MEMBER      "Server-Group-Member:"
#define AR_DIR_LABEL_SERVERGROUP_SIGNAL_OPT  "Server-Group-Signal-Option:"
#define AR_DIR_LABEL_SERVER_NAME             "Server-Name:"
#define AR_DIR_LABEL_SERVER_PLUGIN_ALIAS     "Server-Plugin-Alias:"
#define AR_DIR_LABEL_SERVER_PLUGIN_PASSWD    "Server-Plugin-Target-Password:"
#define AR_DIR_LABEL_SERVER_PLUGIN_TO        "Server-Plugin-Default-Timeout:"
#define AR_DIR_LABEL_SQL_SECURE_CONNECT      "SQL-Secure-Connection:"
#define AR_DIR_LABEL_SVR_STATS_REC_MODE      "Server-Stats-Rec-Mode:"
#define AR_DIR_LABEL_SVR_STATS_REC_INTERVAL  "Server-Stats-Rec-Interval:"
#define AR_DIR_LABEL_SET_PROC_TIME           "Set-Process-Timeout:"
#define AR_DIR_LABEL_CACHE_SEG_SIZE          "Shared-Cache-Segment-Size:"
#define AR_DIR_LABEL_SNMP_AGENT_ENABLED      "SNMP-agent-enabled:"
#define AR_DIR_LABEL_SQL_LOG_FILE            "SQL-Log-File:"
#define AR_DIR_LABEL_SQL_SERVER_SET_ANSI     "SQL-Server-Set-ANSI-Defaults:"
#define AR_DIR_LABEL_SSTABLE_CHUNK_SIZE      "Server-Side-Table-Chunk-Size:"
#define AR_DIR_LABEL_SUBMITTER_MODE          "Submitter-Mode:"
#define AR_DIR_LABEL_SUPPRESS_WARNINGS       "Suppress-warnings:"
#define AR_DIR_LABEL_SVR_SECURITY_CACHE      "Server-Security-Cache:"
#define AR_DIR_LABEL_SYBASE_CHARSET          "Sybase-Character-Set:"
#define AR_DIR_LABEL_SYBASE_SERV             "Sybase-Server-Name:"
#define AR_DIR_LABEL_SYSTEM_LOGGING_OPTIONS  "System-Logging-Options:"
#define AR_DIR_LABEL_TS_SPEC_PORT            "TCD-Specific-Port:"
#define AR_DIR_LABEL_TWO_DIGIT_YEAR_CUTOFF   "Two-Digit-Year-Cutoff:"
#define AR_DIR_LABEL_THREAD_DEBUG_MODE       "Thread-Debug-mode:"
#define AR_DIR_LABEL_THREAD_LOG_FILE         "Thread-Log-File:"
#define AR_DIR_LABEL_USE_PASSWD              "Use-Password-File:"
#define AR_DIR_LABEL_USER_LOG_FILE           "User-Log-File:"
#define AR_DIR_LABEL_XML_VUI_EXP_LOCALIZED   "XML-VUI-Export-Default-Is-Localized:"
#define AR_DIR_LABEL_GENERAL_AUTH_ERR        "Display-General-Auth-Message:"


/* Constants holding definitions for the database structure clause extensions */
#define AR_DIR_LABEL_CLAUSE              "Clause:"
#define AR_DIR_LABEL_FIELD               "Field {"
#define AR_DIR_LABEL_ID                  "Id:"
#define AR_DIR_LABEL_INDEX               "Index {"
#define AR_DIR_LABEL_SCHEMA              "Schema:"
#define AR_DIR_LABEL_FORM                "Form:"
#define AR_DIR_LABEL_INDEX_UPPER         "Oracle-Upper-Index:"
#define AR_DIR_LABEL_INDEX_FUPPER        "Oracle-All-Upper-Index"

/* Constants holding definitions for the database options */
#define AR_DIR_LABEL_DB_OPTION            "DB-Options:"
#define AR_DIR_LABEL_DB_OPTION_NAME       "name:"
#define AR_DIR_LABEL_DB_OPTION_VALUE      "value:"
#define AR_DIR_LABEL_BEGIN_CLAUSE_NO_NL   "{"
#define AR_DIR_LABEL_END_CLAUSE_NO_NL     "}"

#define AR_TAG_TRUE               "T"
#define AR_TAG_FALSE              "F"

                           /* default value for AR_DIR_LABEL_FTSTHRESHOLDLOW */
#define AR_DEFAULT_THRESHOLDLOW  200
                           /* default value for AR_DIR_LABEL_FTSTHRESHOLDHIGH */
#define AR_DEFAULT_THRESHOLDHIGH 1000000

/* Constants holding definitions for alert message items */

#define AR_ALERT_MSG_TOTAL_LEN            1
#define AR_ALERT_MSG_SERVER_VERSION       2
#define AR_ALERT_MSG_TIMESTAMP            3
#define AR_ALERT_MSG_TYPE_CODE            4
#define AR_ALERT_MSG_PRIORITY             5
#define AR_ALERT_MSG_TEXT_LEN             6
#define AR_ALERT_MSG_TEXT                 7
#define AR_ALERT_MSG_SOURCE_LEN           8
#define AR_ALERT_MSG_SOURCE               9
#define AR_ALERT_MSG_SOURCE_SERVER_LEN   10
#define AR_ALERT_MSG_SOURCE_SERVER       11
#define AR_ALERT_MSG_SOURCE_FORM_LEN     12
#define AR_ALERT_MSG_SOURCE_FORM         13
#define AR_ALERT_MSG_SOURCE_OBJECT_LEN   14
#define AR_ALERT_MSG_SOURCE_OBJECT       15
#define AR_ALERT_MSG_SOURCE_SVR_ADDR_LEN 16
#define AR_ALERT_MSG_SOURCE_SVR_ADDR     17

#define AR_ALERT_MSG_ITEM_COUNT          17
#define AR_ALERT_MSG_ITEM_COUNT_V1       15

#define AR_ALERT_MSG_PROTOCOL_VERSION    2

/* Constants holding definitions for the contents of a mail template/message */

#define AR_MAIL_LABEL_SCHEMA   "Schema:"
#define AR_MAIL_LABEL_SERVER   "Server:"
#define AR_MAIL_LABEL_LOGIN    "Login:"
#define AR_MAIL_LABEL_PASSWORD "Password:"
#define AR_MAIL_LABEL_ACTION   "Action:"
#define AR_MAIL_LABEL_FORMAT   "Format:"

#define AR_MAIL_ACTION_SUBMIT  "Submit"
#define AR_MAIL_ACTION_QUERY   "Query"

#define AR_MAIL_FORMAT_SHORT   "Short"
#define AR_MAIL_FORMAT_FULL    "Full"

#define AR_MAIL_BEGIN          "AR-Message-Begin"
#define AR_MAIL_END            "AR-Message-End"

#define AR_MAIL_ID_DELIMITER   '!'

#define AR_MAIL_MAX_LINE_SIZE  1024 /* max size of mail message lines */

/* license format defines */
#define AR_LICENSE_FORMAT_REGULAR      1
#define AR_LICENSE_FORMAT_VENDOR       4
#define AR_LICENSE_FORMAT_APPLICATION  5

#define AR_APP_LICENSE_LABEL_DELIMITER ':'
#define AR_APP_LICENSE_SEPARATOR       ';'

#define AR_LICENSE_TYPE_USER_FIXED     "User Fixed"
#define AR_LICENSE_TYPE_USER_FLOATING  "User Floating"
#define AR_LICENSE_APPLICATION         "Application"

/* vendor application license types */
#define AR_APP_LICENSE_TYPE_APPLICATION   0   /* application license */
#define AR_APP_LICENSE_TYPE_USER_FIXED    1   /* application user fixed */
#define AR_APP_LICENSE_TYPE_USER_FLOATING 2   /* application user floating */

/* Constants holding license names */
#define AR_SERVER_LICENSE_TYPE          "AR Server"
#define AR_SERVER_LITE_LICENSE_TYPE     "AR System - Dedicated Server"
#define AR_USER_LICENSE_TYPE            "AR User"
#define AR_USER_FIXED_LICENSE_TYPE      "AR User Fixed"
#define AR_USER_FLOATING_LICENSE_TYPE   "AR User Floating"
#define AR_FULLTEXT_FIXED_LICENSE_TYPE  "AR Full Text Fixed"
#define AR_FULLTEXT_FLOAT_LICENSE_TYPE  "AR Full Text Floating"
#define AR_DISTRIBUTED_SERVER_TYPE      "AR Distributed Server"
#define AR_APPROVAL_SERVER_TYPE         "AR Approval Server"
#define AR_MIDTIER_LICENSE_TYPE         "AR Mid-Tier"
#define AR_ENCRYPT_STANDARD_TYPE        "AR Encryption - Standard Security"
#define AR_ENCRYPT_PERFORMANCE_TYPE     "AR Encryption - Performance Security"
#define AR_ENCRYPT_PREMIUM_TYPE         "AR Encryption - Premium Security"
#define AR_RESERVED1_SERVER_TYPE        "AR Reserved1 Server"
#define AR_RESERVED1_FIXED_TYPE         "AR Reserved1 Fixed"
#define AR_RESERVED1_FLOATING_TYPE      "AR Reserved1 Floating"
#define AR_RESERVED1_BUILDER_TYPE       "AR Reserved1 Builder"
#define FLASHBOARD_WEB_SERVER           "Flashboards Web Server"
#define AR_PAGER_LICENSE_TYPE           "AR Pager"
#define AR_WWW_LICENSE_TYPE             "AR Web Server"
#define AR_WIRELESS_LICENSE_TYPE        "AR Wireless Server"
#define AR_DISCOVERY_SMS                "Discovery Service for SMS"
#define AR_DISCOVERY_NETCENSUS          "Discovery Service for NetCensus"
#define AR_DISCOVERY_ORACLE             "Remedy Link for Oracle"
#define AR_DISCOVERY_SQL_SERVER         "Remedy Link for SQL Server"
#define AR_DISCOVERY_SAP                "Remedy Link for SAP R/3"
#define AR_DISCOVERY_LANDESK            "Discovery Service for LANDesk"
#define AR_SLA_FIXED_TYPE               "SLA User Fixed"
#define AR_ASSET_FIXED_TYPE             "Asset User Fixed"
#define AR_CHANGE_FIXED_TYPE            "Change User Fixed"
#define AR_HELPDESK_FIXED_TYPE          "Help Desk User Fixed"
#define AR_HELPDESK_FLOATING_TYPE       "Help Desk User Floating"
#define AR_PURCHASING_LICENSE_TYPE      "Purchasing@Work User"
#define AR_EXPENSABLE_LICENSE_TYPE      "ExpensAble@Work User"
#define AR_SETUPWORK_LICENSE_TYPE       "SetUp@Work User"
#define AR_SUPPORT_LICENSE_TYPE         "Support"
#define AR_QUALITY_LICENSE_TYPE         "Quality"
#define AR_CRMSERVER_LICENSE_TYPE       "CRM Server"
#define AR_CRMUSER_FIXED_TYPE           "CRM User Fixed"
#define AR_CRMUSER_FLOATING_TYPE        "CRM User Floating"
#define AR_CS_FIXED_TYPE                "Customer Support Fixed"
#define AR_CS_FLOATING_TYPE             "Customer Support Floating"
#define AR_ASSET_FLOATING_TYPE          "Asset User Floating"
#define AR_CHANGE_FLOATING_TYPE         "Change User Floating"
#define AR_ENTERPRISE_FLOATING_TYPE     "Enterprise Integration Engine"
#define AR_SALES_CONTINUUM_FIXED_TYPE   "Sales Continuum User Fixed"
#define AR_MIGRATOR_LICENSE_TYPE        "AR Migrator"
#define AR_PALM_LICENSE_TYPE            "AR Link for Palm User"
#define AR_PERSONALIZATION              "Remedy Personalization"
#define AR_APPLICATION_EXPLORER         "Remedy Application Explorer"
#define PROFILER_SERVER_TYPE            "Profiler Server"
#define PROFILER_USER_TYPE              "Profiler User"
#define DEMO_LICENSE_TYPE               "Demo"
#define PURGE_LICENSE_TYPE              "Purge"
#define LITE_LICENSE_TYPE               "Lite"
#define VENDOR_LICENSE                  "Vendor License"
#define AR_LOG_DECRYPTION_UTILITY_TYPE  "AR Log Decryption Utility"
#define AR_QUALITY_MGMT                 "Quality Management"
#define AR_QUALITY_MGMT_FIXED_TYPE      "Quality Management User Fixed"
#define AR_QUALITY_MGMT_FLOATING_TYPE   "Quality Management User Floating"
#define AR_RAD_SERVER                   "RAD/RCCS Server/integration license"
#define AR_ITSP_SUITE_FIXED_TYPE                "ITSP Suite Fixed"
#define AR_ITSP_SUITE_FLOATING_TYPE             "ITSP Suite Floating"
#define AR_ITSP_INCIDENT_USER_FIXED_TYPE        "ITSP Incident User Fixed"
#define AR_ITSP_INCIDENT_USER_FLOATING_TYPE     "ITSP Incident User Floating"
#define AR_ITSP_PROBLEM_USER_FIXED_TYPE         "ITSP Problem User Fixed"
#define AR_ITSP_PROBLEM_USER_FLOATING_TYPE      "ITSP Problem User Floating"
#define AR_ITSP_CHANGE_USER_FIXED_TYPE          "ITSP Change User Fixed"
#define AR_ITSP_CHANGE_USER_FLOATING_TYPE       "ITSP Change User Floating"
#define AR_ITSP_ASSET_USER_FIXED_TYPE           "ITSP Asset User Fixed"
#define AR_ITSP_ASSET_USER_FLOATING_TYPE        "ITSP Asset User Floating"
#define AR_ITSP_REQUEST_USER_FIXED_TYPE         "ITSP Request User Fixed"
#define AR_ITSP_REQUEST_USER_FLOATING_TYPE      "ITSP Request User Floating"
#define AR_ITSP_SLM_USER_FIXED_TYPE             "ITSP SLM User Fixed"
#define AR_ITSP_SLM_USER_FLOATING_TYPE          "ITSP SLM User Floating"
#define AR_ITSP_FOUNDATION_USER_FIXED_TYPE      "ITSP Foundation User Fixed"
#define AR_ITSP_FOUNDATION_USER_FLOATING_TYPE   "ITSP Foundation User Floating"
#define AR_ITSP_MASTER_ADMIN_FIXED_TYPE         "ITSP Master Admin Fixed"
#define AR_ITSP_MOBILITY_FIXED_TYPE             "ITSP Mobility Fixed"

/* Deprecated definitions for AR System client menu items */
/* that did not conform to established naming style       */
#define AR_RESERVE_MENU_MODIFYALL         AR_RESERV_MENU_MODIFYALL
#define AR_RESERVE_MENU_DELETE            AR_RESERV_MENU_DELETE
#define AR_RESERVE_MENU_PREFERENCES       AR_RESERV_MENU_PREFERENCES
#define AR_RESERVE_MENU_MENU              AR_RESERV_MENU_MENU
#define AR_RESERVE_MENU_TOOLBAR           AR_RESERV_MENU_TOOLBAR
#define AR_RESERVE_MENU_APPLY             AR_RESERV_MENU_APPLY
#define AR_RESERVE_MENU_POLLING           AR_RESERV_MENU_POLLING
#define AR_RESERVE_MENU_REPORTING         AR_RESERV_MENU_REPORTING
#define AR_RESERVE_MENU_PRINT             AR_RESERV_MENU_PRINT
#define AR_RESERVE_MENU_CLEARALL          AR_RESERV_MENU_CLEARALL
#define AR_RESERVE_MENU_SETDEFAULT        AR_RESERV_MENU_SETDEFAULT
#define AR_RESERVE_MENU_SEARCH            AR_RESERV_MENU_SEARCH
#define AR_RESERVE_MENU_NEW_SEARCH        AR_RESERV_MENU_NEW_SEARCH
#define AR_RESERVE_MENU_NEW_REQUEST       AR_RESERV_MENU_NEW_REQUEST
#define AR_RESERVE_MENU_SHOW_STAT_HIST    AR_RESERV_MENU_SHOW_STAT_HIST
#define AR_RESERVE_MENU_HOME              AR_RESERV_MENU_HOME
#define AR_RESERVE_MENU_HELP              AR_RESERV_MENU_HELP
#define AR_RESERVE_MENU_ADVANCED_SEARCH   AR_RESERV_MENU_ADVANCED_SEARCH

/* Deprecated definitions for archive & audit shadow form */
/* that did not conform to established naming style       */
#define AR_RESERVE_ARCHIVE_AUDIT_ENTRY_ID AR_RESERV_ARCHIVE_AUDIT_ENTRY_ID
#define AR_RESERVE_ARCHIVE_CREATE_DATE    AR_RESERV_ARCHIVE_CREATE_DATE
#define AR_RESERVE_AUDIT_LAST_CHANGED     AR_RESERV_AUDIT_LAST_CHANGED
#define AR_RESERVE_AUDIT_ACTION           AR_RESERV_AUDIT_ACTION

#endif
