/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.DataType;
import com.remedy.arsys.api.DisplayInstanceList;
import com.remedy.arsys.api.FieldCriteria;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.FieldKey;
import com.remedy.arsys.api.FieldLimitInfo;
import com.remedy.arsys.api.FieldMappingInfo;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PermissionInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.Value;

public class Field
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_session;
    private boolean m_reservedIDOK;
    private FieldMappingInfo m_fieldMap;
    private DataType m_dataType;
    private int m_option;
    private int m_createMode;
    private Value m_defaultValue;
    private FieldLimitInfo m_limit;
    private DisplayInstanceList m_dInstanceList;
    private int m_deleteOption;
    private FieldKey m_key;
    private boolean m_exist;
    private static final int TOTAL_PARAMS = 11;
    final int NEW_OPTION = 5;
    final int NEW_CREATE_MODE = 6;
    final int NEW_DEFAULT_VALUE = 7;
    final int NEW_LIMIT = 8;
    final int NEW_DISPLAY_INSTANCE = 9;
    final int NEW_MAPPING = 10;

    Field() {
        this.m_changeFlags = new CriteriaFlags(11);
        this.m_key = new FieldKey(null, null);
        this.m_exist = true;
    }

    Field(NameID nameID, long l) {
        this.m_changeFlags = new CriteriaFlags(11);
        this.m_key = new FieldKey(nameID, new FieldID(l));
        this.m_exist = true;
    }

    protected Field(String string, PermissionInfo[] permissionInfoArray, String string2, long l, String string3, String string4, String string5) {
        super(string, null, string2, l, string3, string4, string5);
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            int n = 0;
            while (n < permissionInfoArray.length) {
                long l2 = permissionInfoArray[n].getGroupID().getValue();
                int n2 = new Long(l2).intValue();
                this.m_permissionList[n] = new PermissionInfo(n2, permissionInfoArray[n].getPermissionValue());
                ++n;
            }
        }
    }

    public void setPermissions(PermissionInfo[] permissionInfoArray) {
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            int n = 0;
            while (n < permissionInfoArray.length) {
                long l = permissionInfoArray[n].getGroupID().getValue();
                int n2 = new Long(l).intValue();
                this.m_permissionList[n] = new PermissionInfo(n2, permissionInfoArray[n].getPermissionValue());
                ++n;
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public boolean isPresent() {
        return this.m_exist;
    }

    void setPresent(boolean bl) {
        this.m_exist = bl;
    }

    public void setDataType(DataType dataType) {
        this.m_dataType = dataType;
    }

    void setIntDataType(int n) {
        this.m_dataType = DataType.toDataType(n);
    }

    public DataType getDataType() {
        return this.m_dataType;
    }

    int getDataTypeAsInt() {
        return this.m_dataType.toInt();
    }

    public int getFieldType() {
        switch (this.getDataTypeAsInt()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return 1;
            }
            case 11: {
                return 128;
            }
            case 12: 
            case 13: 
            case 14: {
                return 1;
            }
            case 31: {
                return 2;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 32;
            }
            case 34: {
                return 64;
            }
            case 35: {
                return 8;
            }
            case 36: {
                return 16;
            }
            case 37: {
                return 256;
            }
        }
        return 0;
    }

    public void setFieldID(FieldID fieldID) {
        this.m_key.setFieldID(fieldID);
    }

    void setLongFieldID(long l) {
        this.m_key.setFieldID(new FieldID(l));
    }

    public FieldID getFieldID() {
        return this.m_key.getFieldID();
    }

    public void setSchema(NameID nameID) {
        this.m_key.setSchemaName(nameID);
    }

    public NameID getSchema() {
        return this.m_key.getSchemaName();
    }

    public void setFieldOption(int n) {
        this.m_option = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    public int getFieldOption() {
        return this.m_option;
    }

    public void setReservedIDOK(boolean bl) {
        this.m_reservedIDOK = bl;
    }

    public boolean getReservedIDOK() {
        return this.m_reservedIDOK;
    }

    public void setCreateMode(int n) {
        this.m_createMode = n;
        this.m_changeFlags.setParameter(6L, true);
    }

    public int getCreateMode() {
        return this.m_createMode;
    }

    public void setDefaultValue(Value value) {
        this.m_defaultValue = value;
        this.m_changeFlags.setParameter(7L, true);
    }

    public Value getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setFieldLimit(FieldLimitInfo fieldLimitInfo) {
        this.m_limit = fieldLimitInfo;
        this.m_changeFlags.setParameter(8L, true);
    }

    public FieldLimitInfo getFieldLimit() {
        return this.m_limit;
    }

    public void setDeleteOption(int n) {
        this.m_deleteOption = n;
    }

    public FieldMappingInfo getFieldMap() {
        return this.m_fieldMap;
    }

    public void setFieldMap(FieldMappingInfo fieldMappingInfo) {
        this.m_fieldMap = fieldMappingInfo;
        this.m_changeFlags.setParameter(10L, true);
    }

    public void setDisplayInstance(DisplayInstanceList displayInstanceList) {
        this.m_dInstanceList = displayInstanceList;
        this.m_changeFlags.setParameter(9L, true);
    }

    public DisplayInstanceList getDisplayInstance() {
        return this.m_dInstanceList;
    }

    public Object clone() throws CloneNotSupportedException {
        Field field = (Field)super.clone();
        field.setKey((FieldKey)this.m_key.clone());
        field.setFieldMap((FieldMappingInfo)this.m_fieldMap.clone());
        field.setDataType((DataType)this.m_dataType.clone());
        field.setDefaultValue((Value)this.m_defaultValue.clone());
        if (this.m_limit != null) {
            field.setFieldLimit((FieldLimitInfo)this.m_limit.clone());
        }
        field.setDisplayInstance((DisplayInstanceList)this.m_dInstanceList.clone());
        return field;
    }

    public FieldKey getKey() {
        return this.m_key;
    }

    public void setKey(FieldKey fieldKey) {
        this.setSchema(fieldKey.getSchemaName());
        this.setFieldID(fieldKey.getFieldID());
    }

    public void create() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARCreateField(this.m_session, this);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void remove() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARDeleteField(this.m_session, this.getSchema(), this.getFieldID().toLong(), this.m_deleteOption);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void load() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        FieldCriteria fieldCriteria = new FieldCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetField(this.m_session, this.m_key, fieldCriteria, this);
            Object var6_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void load(FieldCriteria fieldCriteria) throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetField(this.m_session, this.m_key, fieldCriteria, this);
            Object var6_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void store() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARSetField(this.m_session, this, this.m_changeFlags.getParameters());
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void activate() {
    }

    public void passivate() {
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_session = aRServerUser;
    }

    public void unsetContext() {
        this.m_session = null;
    }

    public void clear() {
        super.clear();
        this.m_key = null;
        this.m_fieldMap = null;
        this.m_dataType = null;
        this.m_defaultValue = null;
        this.m_limit = null;
        this.m_dInstanceList = null;
    }

    int getDeleteOption() {
        return this.m_deleteOption;
    }
}

