/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ArithmeticOperationInfo;
import com.remedy.arsys.api.CurrencyPartInfo;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.OperandType;
import com.remedy.arsys.api.QueryInfo;
import com.remedy.arsys.api.StatusHistoryValue;
import com.remedy.arsys.api.Util;
import com.remedy.arsys.api.Value;

public class ArithmeticOrRelationalOperand
implements Cloneable {
    private OperandType m_operandType;
    private Object m_operand;

    ArithmeticOrRelationalOperand() {
        this.m_operandType = null;
        this.m_operand = null;
    }

    public ArithmeticOrRelationalOperand(OperandType operandType, FieldID fieldID) {
        if (operandType != OperandType.FIELDID) {
            throw new IllegalArgumentException("datatype not supported by this method");
        }
        this.m_operandType = operandType;
        this.m_operand = fieldID;
    }

    public ArithmeticOrRelationalOperand(FieldID fieldID) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = fieldID;
    }

    ArithmeticOrRelationalOperand(int n, long l) {
        this.m_operandType = this.toOperandType(n);
        this.m_operand = new FieldID(l);
    }

    public ArithmeticOrRelationalOperand(Value value) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = value;
    }

    public ArithmeticOrRelationalOperand(ArithmeticOperationInfo arithmeticOperationInfo) {
        this.m_operandType = OperandType.ARITHMETIC_OP;
        this.m_operand = arithmeticOperationInfo;
    }

    public ArithmeticOrRelationalOperand(StatusHistoryValue statusHistoryValue) {
        this.m_operandType = OperandType.STATUS_HISTORY;
        this.m_operand = statusHistoryValue;
    }

    public ArithmeticOrRelationalOperand(Value[] valueArray) {
        this.m_operandType = OperandType.VALUE_SET;
        this.m_operand = valueArray;
    }

    public ArithmeticOrRelationalOperand(CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = OperandType.CURRENCY_FLD;
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(OperandType operandType, CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = operandType;
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(int n, CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = this.toOperandType(n);
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(int n) {
        this.m_operandType = OperandType.LOCAL_VARIABLE;
        this.m_operand = new Integer(n);
    }

    public ArithmeticOrRelationalOperand(QueryInfo queryInfo) {
        this.m_operandType = OperandType.QUERY_INFO;
        this.m_operand = queryInfo;
    }

    OperandType toOperandType(int n) {
        switch (n) {
            case 1: {
                return OperandType.FIELDID;
            }
            case 2: {
                return OperandType.VALUE;
            }
            case 3: {
                return OperandType.ARITHMETIC_OP;
            }
            case 4: {
                return OperandType.STATUS_HISTORY;
            }
            case 5: {
                return OperandType.VALUE_SET;
            }
            case 6: {
                return OperandType.CURRENCY_FLD;
            }
            case 50: {
                return OperandType.FIELDID_TRANSACTION;
            }
            case 51: {
                return OperandType.FIELDID_DB;
            }
            case 99: {
                return OperandType.FIELDID_CURRENT;
            }
            case 52: {
                return OperandType.LOCAL_VARIABLE;
            }
            case 53: {
                return OperandType.QUERY_INFO;
            }
            case 54: {
                return OperandType.CURRENCY_FLD_TRAN;
            }
            case 55: {
                return OperandType.CURRENCY_FLD_DB;
            }
            case 56: {
                return OperandType.CURRENCY_FLD_CURRENT;
            }
        }
        return null;
    }

    public OperandType getType() {
        return this.m_operandType;
    }

    public Object getValue() {
        return this.m_operand;
    }

    int getTypeInt() {
        return this.m_operandType.toInt();
    }

    int getIntValue() {
        return (Integer)this.m_operand;
    }

    long getFieldIDValue() {
        return ((FieldID)this.m_operand).toLong();
    }

    public void setValue(Value value) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = value;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = (ArithmeticOrRelationalOperand)super.clone();
        arithmeticOrRelationalOperand.m_operandType = (OperandType)this.m_operandType.clone();
        switch (this.getTypeInt()) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                arithmeticOrRelationalOperand.m_operand = new FieldID(((FieldID)this.m_operand).toLong());
                break;
            }
            case 2: {
                arithmeticOrRelationalOperand.m_operand = ((Value)this.m_operand).clone();
                break;
            }
            case 3: {
                arithmeticOrRelationalOperand.m_operand = ((ArithmeticOperationInfo)this.m_operand).clone();
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                arithmeticOrRelationalOperand.m_operand = ((CurrencyPartInfo)this.m_operand).clone();
                break;
            }
            case 4: {
                arithmeticOrRelationalOperand.m_operand = ((StatusHistoryValue)this.m_operand).clone();
                break;
            }
            case 5: {
                Value[] valueArray = (Value[])this.m_operand;
                int n = valueArray.length;
                Value[] valueArray2 = new Value[n];
                int n2 = 0;
                while (n2 < n) {
                    valueArray2[n2] = (Value)valueArray[n2].clone();
                    ++n2;
                }
                arithmeticOrRelationalOperand.m_operand = valueArray2;
                break;
            }
            case 52: {
                arithmeticOrRelationalOperand.m_operand = new Integer(this.getIntValue());
                break;
            }
            case 53: {
                arithmeticOrRelationalOperand.m_operand = ((QueryInfo)this.m_operand).clone();
                break;
            }
            default: {
                arithmeticOrRelationalOperand.m_operand = null;
            }
        }
        return arithmeticOrRelationalOperand;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ArithmeticOrRelationalOperand)) {
            return false;
        }
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = (ArithmeticOrRelationalOperand)object;
        boolean bl2 = this.m_operandType == null ? arithmeticOrRelationalOperand.m_operandType == null : (bl = this.m_operandType.equals(arithmeticOrRelationalOperand.m_operandType));
        if (bl) {
            if (this.m_operand == null) {
                bl = arithmeticOrRelationalOperand.m_operand == null;
            } else {
                switch (this.getTypeInt()) {
                    case 5: {
                        Object[] objectArray = (Value[])this.m_operand;
                        Object[] objectArray2 = (Value[])arithmeticOrRelationalOperand.m_operand;
                        bl = Util.equals(objectArray, objectArray2);
                        break;
                    }
                    default: {
                        bl = this.m_operand == null ? arithmeticOrRelationalOperand.m_operand == null : this.m_operand.equals(arithmeticOrRelationalOperand.m_operand);
                    }
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.m_operandType.hashCode();
    }
}

