/*  File:  util.h  */

#ifndef UTIL_H
#define UTIL_H

#define RELEASE_ONE              1
#define RELEASE_ALL              2

#ifdef _WIN32
#define OS_CRITICAL_SECTION      CRITICAL_SECTION
#define OS_CRITICAL_SECTION_PTR  LPCRITICAL_SECTION
#define OS_TLS_OBJECT            unsigned long
#define OS_TLS_OBJECT_PTR        unsigned long *

typedef struct
{
   unsigned int  releaseType;
   HANDLE        eventHandle;
} OS_EVENT_OBJECT;

#else
#define OS_CRITICAL_SECTION      pthread_mutex_t
#define OS_CRITICAL_SECTION_PTR  pthread_mutex_t *
#define OS_TLS_OBJECT            pthread_key_t
#define OS_TLS_OBJECT_PTR        pthread_key_t *

typedef struct
{
   unsigned int     releaseType;
   pthread_mutex_t  eventMutex;
   pthread_cond_t   eventCondVar;
} OS_EVENT_OBJECT;
#endif /* _WIN32 */


/* External declarations of the Utility procedures */

void  GetInputLine();
void  OpenInputFile();
void  OpenOutputFile();
void  CloseOutputFile();
void  StartRecording();
void  StopRecording();
void  DriverSleep();
void  DriverSleepMsec();
void  DriverInitializeCriticalSection();
void  DriverEnterCriticalSection();
void  DriverLeaveCriticalSection();
void  DriverDeleteCriticalSection();
void  DriverTLSAlloc();
void *DriverTLSGetValue();
void  DriverTLSSetValue();
void  DriverTLSFree();
void  DriverCreateEvent();
void  DriverLockEvent();
void  DriverSetEvent();
void  DriverWaitForEvent();
void  DriverUnlockEvent();
void  DriverDeleteEvent();
void  ReleaseWaitingThreads();
void  SleepTimer();
void  RandomSleep();
void  RandomSleepTimer();
void  MillisecondSleepTimer();
void  BeginLoop();
void  EndLoop();
void *CreateThreadControlBlock();
void *GetThreadControlBlockPtr();
void  DestroyThreadControlBlock();
ARControlStruct * GetControlStructPtr();
void  SaveEntryListEntryIds();
void  SaveEntryListFieldValueEntryIds();
void  SaveFirstSchemaListName();
int   GetDateString(int jd, char *dateStr);
int   GetJDValue(char *, int *jd);

#endif /* UTIL_H */
