/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ProxyPool;
import com.remedy.arsys.api.StatusInfo;
import java.util.Enumeration;
import java.util.Hashtable;

public class PoolingProxyManager
extends ProxyManager {
    private int maxProxiesPerServer;
    private int maxTotalProxies;
    private Hashtable serverProxyPools = new Hashtable();
    public static final int INITIAL_PROXIES_PER_SERVER = 1;

    PoolingProxyManager(int n, int n2) {
        this.maxProxiesPerServer = n;
        this.maxTotalProxies = n2;
    }

    public Proxy getProxy(ARServerUser aRServerUser, boolean bl) throws ARException {
        String string = aRServerUser.getServer();
        ProxyPool proxyPool = this.getServerPool(string);
        Proxy proxy = proxyPool.get(aRServerUser);
        return proxy;
    }

    private synchronized ProxyPool getServerPool(String string) throws ARException {
        ProxyPool proxyPool = (ProxyPool)this.serverProxyPools.get(string);
        if (proxyPool == null) {
            int n = this.maxProxiesPerServer * this.serverProxyPools.size();
            if (n + this.maxProxiesPerServer <= this.maxTotalProxies) {
                proxyPool = new ProxyPool(this.maxProxiesPerServer);
                this.serverProxyPools.put(string, proxyPool);
            } else {
                StatusInfo[] statusInfoArray = new StatusInfo[]{new StatusInfo(2, 0L, "Maximum number of connections requested exceeded", null)};
                throw new ARException(statusInfoArray);
            }
        }
        return proxyPool;
    }

    public void releaseProxy(Proxy proxy, ARServerUser aRServerUser, boolean bl) {
        String string = aRServerUser.getServer();
        try {
            ProxyPool proxyPool = this.getServerPool(string);
            proxyPool.put(proxy);
        }
        catch (ARException aRException) {
            // empty catch block
        }
    }

    synchronized void clear() {
        Enumeration enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ProxyPool proxyPool = (ProxyPool)this.serverProxyPools.get(string);
            proxyPool.clear();
        }
        this.serverProxyPools.clear();
    }

    protected void finalize() {
        this.clear();
    }
}

