/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.CharMenuInfo;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.QualifierInfo;
import com.remedy.arsys.api.ServerNameID;
import com.remedy.arsys.api.Util;

public class CharMenuQueryInfo
extends CharMenuInfo
implements Cloneable {
    private NameID m_schema;
    private ServerNameID m_server;
    private QualifierInfo m_qualifier;
    private FieldID[] m_labelField;
    private FieldID m_valueField;
    private boolean m_sortOnLabel;

    protected CharMenuQueryInfo() {
    }

    public CharMenuQueryInfo(NameID nameID, ServerNameID serverNameID, QualifierInfo qualifierInfo, FieldID fieldID, FieldID fieldID2, boolean bl) {
        this.m_schema = nameID;
        this.m_server = serverNameID;
        this.m_qualifier = qualifierInfo;
        this.m_labelField = new FieldID[5];
        this.m_labelField[0] = fieldID;
        int n = 1;
        while (n < this.m_labelField.length) {
            this.m_labelField[n] = new FieldID(0L);
            ++n;
        }
        this.m_valueField = fieldID2;
        this.m_sortOnLabel = bl;
        this.m_type = 2;
    }

    public CharMenuQueryInfo(NameID nameID, ServerNameID serverNameID, QualifierInfo qualifierInfo, FieldID[] fieldIDArray, FieldID fieldID, boolean bl) {
        this.m_schema = nameID;
        this.m_server = serverNameID;
        this.m_qualifier = qualifierInfo;
        this.m_labelField = fieldIDArray;
        this.m_valueField = fieldID;
        this.m_sortOnLabel = bl;
        this.m_type = 2;
    }

    public Object clone() throws CloneNotSupportedException {
        CharMenuQueryInfo charMenuQueryInfo = (CharMenuQueryInfo)super.clone();
        charMenuQueryInfo.m_schema = (NameID)this.m_schema.clone();
        charMenuQueryInfo.m_server = (ServerNameID)this.m_server.clone();
        charMenuQueryInfo.m_qualifier = (QualifierInfo)this.m_qualifier.clone();
        charMenuQueryInfo.m_labelField = (FieldID[])this.m_labelField.clone();
        charMenuQueryInfo.m_valueField = (FieldID)this.m_valueField.clone();
        return charMenuQueryInfo;
    }

    public NameID getSchema() {
        return this.m_schema;
    }

    public ServerNameID getServer() {
        return this.m_server;
    }

    public QualifierInfo getQualification() {
        return this.m_qualifier;
    }

    public FieldID[] getLabelField() {
        return this.m_labelField;
    }

    private long[] getLabelFieldAsLong() {
        long[] lArray = new long[5];
        int n = 0;
        while (n < lArray.length) {
            lArray[n] = this.m_labelField[n].toLong();
            ++n;
        }
        return lArray;
    }

    public FieldID getValueField() {
        return this.m_valueField;
    }

    private long getValueFieldAsLong() {
        return this.m_valueField.toLong();
    }

    public boolean getSortOnLabel() {
        return this.m_sortOnLabel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof CharMenuQueryInfo)) {
            return false;
        }
        CharMenuQueryInfo charMenuQueryInfo = (CharMenuQueryInfo)object;
        if (!super.equals(charMenuQueryInfo)) return false;
        if (this.m_schema == null) {
            if (charMenuQueryInfo.m_schema != null) return false;
            bl4 = true;
        } else {
            bl4 = this.m_schema.equals(charMenuQueryInfo.m_schema);
        }
        if (!bl4) return false;
        if (this.m_server == null) {
            if (charMenuQueryInfo.m_server != null) return false;
            bl3 = true;
        } else {
            bl3 = this.m_server.equals(charMenuQueryInfo.m_server);
        }
        if (!bl3) return false;
        if (this.m_qualifier == null) {
            if (charMenuQueryInfo.m_qualifier != null) return false;
            bl2 = true;
        } else {
            bl2 = this.m_qualifier.equals(charMenuQueryInfo.m_qualifier);
        }
        if (!bl2) return false;
        if (!Util.equals(this.m_labelField, charMenuQueryInfo.m_labelField)) return false;
        if (this.m_valueField == null) {
            if (charMenuQueryInfo.m_valueField != null) return false;
            bl = true;
        } else {
            bl = this.m_valueField.equals(charMenuQueryInfo.m_valueField);
        }
        if (!bl) return false;
        if (this.m_sortOnLabel != charMenuQueryInfo.m_sortOnLabel) return false;
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

