/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.AccessNameID;
import com.remedy.arsys.api.LoggingInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ServerInfo;
import com.remedy.arsys.api.StatusInfo;
import com.remedy.arsys.api.Timestamp;
import com.remedy.arsys.api.Util;
import com.remedy.arsys.api.VerifyUserCriteria;

public class ARServerUser {
    private long m_cacheId;
    private Timestamp m_operationTime;
    private AccessNameID m_user;
    private AccessNameID m_password;
    private String m_authentication;
    private String m_language;
    private String m_server;
    private StatusInfo[] m_lastStatus;
    private boolean m_adminFlag;
    private boolean m_subAdminFlag;
    private boolean m_customFlag;
    private LoggingInfo m_loggingInfo;
    private boolean m_isGetMultipleFieldSupported = false;
    private boolean m_isGetMultipleActlinkSupported = false;
    private boolean m_isPooledSessionSupported = false;
    private String m_versionString = null;
    private Proxy m_proxy = null;

    public ARServerUser() {
        this.init();
    }

    public ARServerUser(String string, String string2, String string3, String string4) {
        this.init();
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication("");
        this.setLanguage(string3);
        this.setServer(string4);
        this.setLastStatus(null);
    }

    public ARServerUser(String string, String string2, String string3, String string4, long l) {
        this.init();
        this.setCacheId(l);
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication("");
        this.setLanguage(string3);
        this.setServer(string4);
        this.setLastStatus(null);
    }

    public ARServerUser(String string, String string2, String string3, String string4, String string5, long l) {
        this.init();
        this.setCacheId(l);
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication(string3);
        this.setLanguage(string4);
        this.setServer(string5);
        this.setLastStatus(null);
    }

    public void login() throws ARException {
        this.verifyUser(new VerifyUserCriteria());
    }

    public void logout() {
        this.clear();
    }

    private void init() {
        this.m_proxy = null;
    }

    public void clear() {
        if (this.m_cacheId != 0L) {
            Proxy proxy = null;
            boolean bl = this.isProxyInContext();
            try {
                try {
                    proxy = ProxyManager.getProxyManager().getProxy(this, bl);
                    proxy.releaseARServerUser(this);
                }
                catch (ARException aRException) {
                    Object var5_4 = null;
                    ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
                }
                Object var5_3 = null;
                ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
                throw throwable;
            }
        }
        this.m_cacheId = 0L;
        this.m_operationTime = null;
        this.m_user = null;
        this.m_password = null;
        this.m_language = null;
        this.m_authentication = null;
        this.m_server = null;
        this.m_lastStatus = null;
        this.m_proxy = null;
    }

    public long getCacheId() {
        return this.m_cacheId;
    }

    void setCacheId(long l) {
        this.m_cacheId = l;
    }

    public Timestamp getOperationTime() {
        return this.m_operationTime;
    }

    void setOperationTime(Timestamp timestamp) {
        this.m_operationTime.setValue(timestamp);
    }

    public AccessNameID getUser() {
        return this.m_user;
    }

    public void setUser(AccessNameID accessNameID) {
        this.m_user = accessNameID;
    }

    public AccessNameID getPassword() {
        return this.m_password;
    }

    public void setPassword(AccessNameID accessNameID) {
        this.m_password = accessNameID;
    }

    public String getAuthentication() {
        return this.m_authentication;
    }

    public void setAuthentication(String string) {
        this.m_authentication = string;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String string) {
        this.m_language = string;
    }

    public String getServer() {
        return this.m_server;
    }

    public void setServer(String string) {
        this.m_server = string;
        this.m_versionString = null;
        this.m_isGetMultipleFieldSupported = false;
        this.m_isGetMultipleActlinkSupported = false;
        this.m_isPooledSessionSupported = false;
    }

    public StatusInfo[] getLastStatus() {
        return this.m_lastStatus;
    }

    void setLastStatus(StatusInfo[] statusInfoArray) {
        this.m_lastStatus = statusInfoArray;
    }

    public boolean getAdminFlag() {
        return this.m_adminFlag;
    }

    void setAdminFlag(boolean bl) {
        this.m_adminFlag = bl;
    }

    public boolean getSubAdminFlag() {
        return this.m_subAdminFlag;
    }

    void setSubAdminFlag(boolean bl) {
        this.m_subAdminFlag = bl;
    }

    public boolean getCustomFlag() {
        return this.m_customFlag;
    }

    void setCustomFlag(boolean bl) {
        this.m_customFlag = bl;
    }

    public LoggingInfo getLogging() {
        return this.m_loggingInfo;
    }

    public void setLogging(LoggingInfo loggingInfo) {
        this.m_loggingInfo = loggingInfo;
    }

    private boolean isGetMultipleFieldSupported() {
        if (this.m_versionString == null) {
            this.getVersionString();
        }
        if (this.m_isGetMultipleFieldSupported) {
            return this.m_isGetMultipleFieldSupported;
        }
        if (this.m_versionString != null) {
            int n = new Integer(this.m_versionString.substring(0, 1));
            int n2 = new Integer(this.m_versionString.substring(2, 4));
            if (n > 4 || n == 4 && n2 > 5) {
                this.m_isGetMultipleFieldSupported = true;
            }
        }
        return this.m_isGetMultipleFieldSupported;
    }

    private boolean isGetMultipleActlinkSupported() {
        int n;
        if (this.m_versionString == null) {
            this.getVersionString();
        }
        if (this.m_isGetMultipleActlinkSupported) {
            return this.m_isGetMultipleActlinkSupported;
        }
        if (this.m_versionString != null && (n = new Integer(this.m_versionString.substring(0, 1)).intValue()) >= 5) {
            this.m_isGetMultipleActlinkSupported = true;
        }
        return this.m_isGetMultipleActlinkSupported;
    }

    public Proxy getProxy() {
        return this.m_proxy;
    }

    public void setProxy(Proxy proxy) {
        this.m_proxy = proxy;
    }

    public boolean isProxyInContext() {
        return this.m_proxy != null;
    }

    private boolean isPooledSessionSupported() {
        if (this.m_versionString == null) {
            this.getVersionString();
        }
        if (this.m_isPooledSessionSupported) {
            return this.m_isPooledSessionSupported;
        }
        int n = new Integer(this.m_versionString.substring(0, 1));
        int n2 = new Integer(this.m_versionString.substring(2, 4));
        if (n > 4 || n == 4 && n2 > 5) {
            this.m_isPooledSessionSupported = true;
        }
        return this.m_isPooledSessionSupported;
    }

    public String getVersionString() {
        if (this.m_versionString == null) {
            int[] nArray = new int[]{4};
            ServerInfo[] serverInfoArray = null;
            try {
                serverInfoArray = Util.ARGetServerInfo(this, nArray);
            }
            catch (ARException aRException) {
                // empty catch block
            }
            if (serverInfoArray != null) {
                this.m_versionString = serverInfoArray[0].getValue().toString();
            }
        }
        return this.m_versionString;
    }

    public void verifyUser(VerifyUserCriteria verifyUserCriteria) throws ARException {
        boolean bl = this.isProxyInContext();
        boolean[] blArray = verifyUserCriteria.getParameters();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this, bl);
        try {
            proxy.ARVerifyUser(this, blArray);
            Object var7_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
            throw throwable;
        }
    }
}

