import java.io.*;
import java.math.*;
import JavaDriver.*;
import com.remedy.arsys.api.*;

public class OutputWriter 
{
   static PrintWriter resultFile = null;
   static      String        tab = "    ";

   public static void RecordOutput( )
   {
      String fileName = null;
      try
      {
         fileName = InputReader.GetString( "File name of Output file:", "" );
         if( fileName == null || fileName.length( ) == 0 )
         {
            PrintString( "No file name specified. So no change to output...\n" );
         }
         else
         {    
            if( resultFile != null )
            {
               resultFile.close( );
               resultFile = null;
            }
            resultFile = new PrintWriter( new FileOutputStream( new File( fileName ) ) );     
         }
      }
      catch( Exception e ){
         PrintString( "Problem in opening the file " + fileName + "\n" );
      }
   }
        
   public static void StopRecordingOutput( )
   {
      if( resultFile != null )
      {
         resultFile.close( );
         resultFile = null;
      }
   }

   public static void PrintHelp( )
   {
      System.out.print( "         AR System Java API Driver\n" );

      System.out.println( );
         /* columns       0xxxxxxxx1xxxxxxxxx2xxxxxxxxx3xxxxxxxxx4xxxxxxxxx5xxxxxxxxx6xxxxxxxxx7xxxxxxxxx8 */
         /*               1        0         0         0         0         0         0         0         0 */

      System.out.print( "Container      Schema         Char Menu       Field              <mult>\n" );
      System.out.print( "---------      -------        ----------      -------------      ------\n" );
      System.out.print( "get    (gco)   get    (gs)    get    (gc)     get        (gsf)\n" );
      System.out.print( "set    (sco)   set    (ss)    set    (sc)     set        (ssf)\n" );
      System.out.print( "create (cco)   create (cs)    create (cc)     create     (csf)\n" );
      System.out.print( "delete (dco)   delete (ds)    delete (dc)     delete     (dsf)   (dmsf)\n" );
      System.out.print( "getlist(glco)  getList(gls)   getlist(glc)    getlist    (glsf)\n" );
      System.out.print( "                              expand (ec)     get mult   (gmsf)\n");
      System.out.print( "                              expand (ec)     gls w/alias(glsa)\n");

      System.out.println( );

      System.out.print( "Active Link    Filter         Escalation      Entry              <mult>\n" );
      System.out.print( "-----------    ------         ----------      -----              ------\n" );
      System.out.print( "get    (gal)   get    (gf)    get    (ges)    get       (ge)     (gme)\n" );
      System.out.print( "set    (sal)   set    (sf)    set    (ses)    set       (se) \n" );
      System.out.print( "create (cal)   create (cf)    create (ces)    create    (ce) \n");
      System.out.print( "delete (dal)   delete (df)    delete (des)    delete    (de) \n" );
      System.out.print( "getlist(glal)  getlist(glf)   getlist(gles)   getlist   (gle) \n" );
      System.out.print( "execute(epal)                                 getlistw/f(glewf) \n" );
      System.out.print( "listsql(sqlal)                                merge     (me) \n" );
      System.out.print( "                                              stats     (stat) \n" );

      System.out.println( );

      System.out.print( "VUI            Misc Lists    Alerts           Localized Value   \n" );
      System.out.print( "---            ----------    --------------   ---------------   \n" );
      System.out.print( "get    (gv)    server(svr)   create   (cae)   get     (glt)     \n" );
      System.out.print( "set    (sv)    group (glg)   register (rfa)   getmult (gmlt)    \n" );
      System.out.print( "create (cv)    user  (glu)   deregistr(dfa)                     \n" );
      System.out.print( "delete (dv)    sql   (glsql) gla user (glau)                    \n" );
      System.out.print( "               ext sc(glxsc) get count(gac)                     \n" );
         System.out.print( "               fields(gmxfc) decode  (dcam)                     \n" );
      System.out.println( );        

         /* columns       0xxxxxxxx1xxxxxxxxx2xxxxxxxxx3xxxxxxxxx4xxxxxxxxx5xxxxxxxxx6xxxxxxxxx7xxxxxxxxx8 */
         /*               1        0         0         0         0         0         0         0         0 */

      System.out.print( "Init/Term     Control/Logging       Misc             Misc\n" );
      System.out.print( "---------     ---------------       ----             ----\n" );
      System.out.print( "login (log)   record    (rec)       ver user (ver)   get file   (gfl) \n" );
      System.out.print( "exit  (q)     stop rec  (srec)      export   (exp)   set file   (sfl) \n" );
      System.out.print( "help  (h, ?)  open out  (oout)      import   (imp)   get BLOB   (geb) \n" );
      System.out.print( "              close out (cout)      exec proc(proc)  get errmsg (gem) \n" );
      System.out.print( "              rcrd pmpt(recPrompt)  load qual(lqs)   set logging(slog) \n" );
      System.out.print( "              stp recpmt(srecPrompt)set port (ssp)   close conn (cnc) \n" );
      System.out.println( );

      System.out.print( "Info          License        Session Config \n");
      System.out.print( "----          -------        -------------- \n");
      System.out.print( "get svr (gsi) val    (vl)    get conf(gsc)  \n");
      System.out.print( "set svr (ssi) valmult(vml)   get conf(ssc)  \n");
      System.out.print( "get FT  (gft) getlist(gll)                  \n");
      System.out.print( "set FT  (sft) create (cl)                   \n");
      System.out.print( "get stat(gss) delete (dl)                   \n");
      System.out.println( );
       	
   }

   public static void PrintString( String prompt )
   {
      if( resultFile != null )
      {
         resultFile.print( prompt );
         resultFile.flush( );
      }
      else
      {
         System.out.print( prompt );
      }          
   }

   public static void PrintARException( ARException e )
   {
      StatusInfo[] statusList = e.getLastStatus();

      if (statusList != null)
      {
         PrintStatusInfoList( "", "   Results", statusList );
         return;
      }

      String message = e.toString( );

      if( message != null && message.length( ) > 0 )
      {
         PrintString( message );
      }
      else
      {
         PrintString( "No Error Message..." );
      }
      PrintNewLine( );
   }
           
   public static void DriverPrintInt( int value )
   {
      if( resultFile != null )
      {
         resultFile.print( value );
         resultFile.flush( );
      }
      else
      {
         System.out.print( value );
      }
   }

   public static void PrintLong( long value )
   {

      if( resultFile != null )
      {
         resultFile.print( value );
         resultFile.flush( );
      }
      else
      {
         System.out.print( value );
      }
   }
   public static void PrintByte( byte value )
   {

      if( resultFile != null )
      {
         resultFile.print( value );
         resultFile.flush( );
      }
      else
      {
         System.out.print( value );
      }
   }
   public static void PrintFloat( float value )
   {
      if( resultFile != null )
      {
         resultFile.print( value );
         resultFile.flush( );
      }
      else
      {
         System.out.print( value );
      }
   }

   public static void PrintNewLine( )
   {
      if( resultFile != null )
      {
         resultFile.println( );
         resultFile.flush( );
      }
      else
      {
         System.out.println( );
      }
   }

   public static void PrintHeader( String indent, String header, String newLine )
   {
      if( header == null ) 
      {
         return;
      }
      if( resultFile != null )
      {
         if( newLine != null )
         {
            resultFile.println( indent + header );
         }
         else
         {
            resultFile.print( indent + header );
         }
         resultFile.flush( );
      }
      else
      {
         if( newLine != null )
         {
            System.out.println( indent + header );
         }
         else
         {
            System.out.print( indent + header );
         }
      }             
   }

   public static void PrintInt( String indent, String header, int value, String newLine )
   {
      if( resultFile != null )
      {
         if( newLine != null )
         {
            resultFile.println( indent + header + value );
         }
         else
         {
            resultFile.print( indent + header + value );
         }
         resultFile.flush( );
      }
      else
      {
         if( newLine != null )
         {
            System.out.println( indent + header + value );      
         }
         else
         {
            System.out.print( indent + header + value );
         }
      }
   }

   public static void PrintBoolean( String indent, String header, boolean val, String newLine )
   {
      if( resultFile != null )
      {
         if( val )
         {
            resultFile.print( indent + header + "  TRUE" );
         }
         else
         {
            resultFile.print( indent + header + "  FALSE" );
         }
         if( newLine != null )
         {
            resultFile.println( );
         }
         resultFile.flush( );
      }
      else
      {
         if( val )
         {
            System.out.print( indent + header + "  TRUE" );
         }
         else
         {
            System.out.print( indent + header + "  FALSE" );
         }
         if( newLine != null )
         {
            System.out.println( );
         }
      }
   }

   public static void PrintFloat( String indent, String header, float value, String newLine )
   {
      if( resultFile != null )
      {
         if( newLine != null )
         {
            resultFile.println( indent + header + value );
         }
         else
         {
            resultFile.print( indent + header + value );   
         }
         resultFile.flush( );
      }
      else
      {
         if( newLine != null )
         {
            System.out.println( indent + header + value );
         }
         else
         {
            System.out.print( indent + header + value );   
         }
      }
   }

   public static void PrintByte( String indent, String header, byte value, String newLine )
   {
      if( resultFile != null )
      {
         if( newLine != null )
         {
            resultFile.println( indent + header + value );
         }
         else
         {
            resultFile.print( indent + header + value );   
         }
         resultFile.flush( );
      }
      else
      {
         if( newLine != null )
         {
            System.out.println( indent + header + value );
         }
         else
         {
            System.out.print( indent + header + value );   
         }
      }
   }
   public static void PrintLong( String indent, String header, long value, String newLine  )
   {
      if( resultFile != null )
      {
         if( newLine != null )
         {
            resultFile.println( indent + header + value );
         }
         else
         {
            resultFile.println( indent + header + value );
         }
         resultFile.flush( );
      } 
      else
      {
         if( newLine != null )
         {
            System.out.println( indent + header + value );
         }
         else
         {
            System.out.print( indent + header + value );
         }
      }
   }

   public static void PrintULong( String indent, String header, String value, String newLine )
   {
      if( resultFile != null )
      {
         if( newLine != null )
         {
            resultFile.println( indent + header + value );
         } 
         else
         {
            resultFile.print( indent + header + value );
         }
         resultFile.flush( );
      }   
      else
      {
         if( newLine != null )
         {
            System.out.println( indent + header + value );
         }
         else
         {
            System.out.print( indent + header + value );
         }
      }
   }          

   public static void PrintDecimal( String indent, String header, BigDecimal value )
   {
      PrintString( indent + header + "\n" );

      if( value == null )
      {
         PrintString( " Null Decimal value....\n" );
         return;
      }        
      else
      {
         PrintString( value.toString( ) + "\n" );
      }

      PrintNewLine( );
   }

   public static void PrintInteger( String indent, String header, Integer value )
   {
      PrintString( indent + header + "\n" );

      if( value == null )
      {
         PrintString( " Null Integer value....\n" );
         return;
      }        
      else
      {
         DriverPrintInt( value.intValue( ) );
      }

      PrintNewLine( );
   }

   public static void PrintDouble( String indent, String header, Double value )
   {
      PrintString( indent + header + "\n" );

      if( value == null )
      {
         PrintString( " Null Double value....\n" );
         return;
      }        
      else
      {
         PrintString( value.toString( ) + "\n" );
      }

      PrintNewLine( );
   }

   public static void PrintEnum( String indent, String header, Long value )
   {
      PrintString( indent + header + "\n" );

      if( value == null )
      {
         PrintString( " Null Enum value....\n" );
         return;
      }        
      else
      {
         PrintString( value.toString( ) + "\n" );
      }

      PrintNewLine( );
   }    

   public static void PrintString( String indent, String header, String value, String newLine )
   {
      if( resultFile != null )
      {
         if( value != null )
         {
            resultFile.println( indent + header + value );
         }
         else
         {
            resultFile.print( indent + header + "< NULL >" );
         }
         resultFile.flush( );
      }
      else
      {
         if( value != null )
         {
            System.out.println( indent + header + value );
         }
         else
         {
            System.out.print( indent + header + "< NULL >" );
         }
      }              
   }          

   public static void PrintTimestamp( String indent, String header, Timestamp value )
   {
      PrintHeader( indent, header, "\n" );
      if( value != null )
      {
         PrintLong( indent, "Value: ", value.getValue( ), "\n" );
      }
      else
      {
         PrintHeader( indent, "    Null TimeStamp value", "\n" );
      }
   }          

   public static void PrintTimestampList( String indent, String header, Timestamp[] value )
   {

      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent,  "    Null Timestamp list", "\n" );
         return;
      }
                             
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        
      for( int i = 0; i < value.length; i++ )
      {
         if( i/4 * 4 == i )
         {
            PrintNewLine( );
            PrintHeader( indent, tab, null );
         }
         PrintLong( "", " ", value[i].getValue( ), "\n" );
      }

      PrintNewLine( );
   }


   public static void PrintFieldKeyList( String indent, String header, FieldKey[] keyList )
   {
      PrintHeader( indent, header, "\n" );
               
      if( keyList == null )
      {
         PrintHeader( indent + tab,  " Null FieldKey list", "\n" );
         return;
      }
              
               
      PrintInt( indent + tab, "Number of FieldKeys: ", keyList.length, "\n" );
        
      for( int i = 0; i < keyList.length; i++ )
      {
         PrintString( indent + tab, "Schema Name: ", keyList[i].getSchemaName( ).toString( ), "\n" );
         PrintLong( indent + tab, "Field ID: ", keyList[i].getFieldID( ).getValue( ), "\n" );
      }

      PrintNewLine( );
   }


   public static void PrintEntryIdList( String indent, String header,  EntryID[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null EntryID list", "\n" );
         return;
      }
                             
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintString( indent + tab, "Entry ID: ", value[i].toString( ), "\n" );
      }
      PrintNewLine( );
   }

   public static void PrintEntryItem( String indent, String header, EntryItem eItem )
   {
      PrintHeader( indent, header, "\n" );
               
      if( eItem == null )
      {
         PrintHeader( indent + tab, " Null EntryItem", "\n" );
         return;
      }

      PrintHeader( indent + tab, "Field Id: " + eItem.getFieldID(), "\n");
      PrintValue( indent + tab, "Value: ", eItem.getValue() );

      PrintNewLine( );
   }    
               

   public static void PrintEntryItemList( String indent, String header, EntryItem[] entryItemList )
   {
      PrintHeader( indent, header, "\n" );
               
      if( entryItemList  == null )
      {
         PrintHeader( indent + tab,  " Null EntryItem List", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", entryItemList.length, "\n" );
        
      for( int i = 0; i < entryItemList.length; i++ )
      {
         PrintEntryItem( indent + tab, "Entry Item " + i + " : ", entryItemList[i] );
      }
      PrintNewLine( );
   }  
            
   public static void PrintEntry( String indent, String header, Entry entry )
   {
      PrintHeader( indent, header, "\n" );
               
      if( entry == null )
      {
         PrintHeader( indent + tab,  " Entry does not exist....", "\n" );
         return;
      }

      EntryItem[] entryItemList  =  entry.getEntryItems( );  

      PrintEntryItemList( indent + tab, "Entry items List: ", entryItemList );

      PrintNewLine( );
   }    
           
   public static void PrintInternalID( String indent, String header, InternalID value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null InternalID value", "\n" );
         return;
      }

      PrintLong( indent + tab, "Value: ", value.getValue( ), "\n" );

      PrintNewLine( );
   }          


   public static void PrintInternalIDList( String indent, String header, InternalID[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null InternalID list", "\n" );
         return;
      }
              
               
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        
      for( int i = 0; i < value.length; i++ )
      {
         if( i/4 * 4 == i )
         {
            PrintNewLine( );
            PrintHeader( indent, tab, null );
         }
         PrintLong( "", "  ", value[i].getValue( ), null );
      }
              
      PrintNewLine( );
   }



   public static void PrintNameIDList( String indent, String header,  NameID[] value ) 
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null NameID list", "\n" );
         return;
      }
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
      for( int i = 0; i < value.length; i++ )
      {
         if( value[i] != null )
         {
            PrintString( indent + tab, "Name ID: ", value[i].toString( ), "\n" );
         }
         else
         {
            PrintString( indent + tab, "Name ID: ", "null", "\n" );
         }
      }

      PrintNewLine( );
   }

   public static void PrintAccessNameIDList( String indent, String header,  AccessNameID[] value ) 
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null AccessNameID list", "\n" );
         return;
      }
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
      for( int i = 0; i < value.length; i++ )
      {
         if( value[i] != null )
         {
            PrintString( indent + tab, "AccessName ID: ", value[i].toString( ), "\n" );
         }
         else
         {
            PrintString( indent + tab, "AccessName ID: ", "null", "\n" );
         }
      }

      PrintNewLine( );
   }

   public static void PrintFieldIDList( String indent, String header, FieldID[] value ) 
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null FieldID list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 

      for( int i = 0; i < value.length; i++ )
      {
         if( value[i] != null )
         {
            PrintLong( indent + tab, "Field ID: ", value[i].getValue( ), "\n" );
         }
         else{
            PrintString( indent + tab, "Field ID: ", "null", "\n" );
         }
      }

      PrintNewLine( );
   }


   public static void PrintServerNameIDList( String indent, String header, ServerNameID[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Server NameID list", "\n" );
         return;
      }
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
      for( int i = 0; i < value.length; i++ )
      {
         if( value[i] != null )
         {
            PrintString( indent + tab, "Server Name ID: ", value[i].toString( ), "\n" );
         }
         else
         {
            PrintString( indent + tab, "Server Name ID for entry ",  i + " is null", "\n" );
         }
      }

      PrintNewLine( );
   }


   public static void PrintStatusInfo( String indent, String header, StatusInfo value )
   {
      PrintHeader( indent, header, "\n" );

      PrintHeader( indent + tab, "Message type : ", null );

      switch( value.getMessageType( ) )
      {
         case Constants.AR_RETURN_OK:
            PrintHeader( "", "NOTE", "\n" );
            break;
         case Constants.AR_RETURN_WARNING:
            PrintHeader( "", "WARNING", "\n" );
            break;
         case Constants.AR_RETURN_ERROR:
            PrintHeader( "", "ERROR", "\n" );
            break;

         case Constants.AR_RETURN_FATAL:
            PrintHeader( "", "FATAL", "\n");
            break;

         default :
            PrintInt( "", "<Unknown Type>: ", value.getMessageType( ), "\n" );
            break;
      }
      PrintLong( indent + tab, "Message number : ", value.getMessageNum( ), "\n" );

      PrintString( indent + tab, "Message:  ", value.getMessageText( ), "\n" );
         
      PrintString( indent + tab, "Appended: ", value.getAppendedText( ), "\n" );
   }


   public static void PrintStatusInfoList( String indent, String header, StatusInfo[] value )
   {
      PrintNewLine();
      PrintHeader( indent, header, "\n" );
               
      if( value == null || value.length == 0)
      {
         PrintHeader( "", "ReturnCode:  OK", "\n");
         PrintHeader( "", "Status List : 0 items", "\n" );
         return;
      }

      PrintHeader( indent, "ReturnCode:  ", null);
      switch( value[0].getMessageType( ) )
      {
         case 0         :
            PrintHeader( "", "OK", "\n" );
            break;
         case 1     :
            PrintHeader( "", "WARNING", "\n" );
            break;
         case 2      :
            PrintHeader( "", "ERROR", "\n" );
            break;

         case 3     :
            PrintHeader( "", "FATAL", "\n");
            break;

         default :
            PrintInt( "", "<Unknown Type>: ", value[0].getMessageType( ), "\n" );
            break;
      }

      PrintHeader( indent, "Status List : " + value.length + " items", "\n" ); 

      for( int i = 0; i < value.length; i++ )
      {
         PrintStatusInfo( indent, "Status Struct :", value[i] );
      }

      PrintNewLine( );
   }

   public static void PrintByteListInfo( String indent, String header, ByteListInfo value)
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null ByteListInfo list", "\n" );
         return;
      }

      byte[] byteList = value.getValue( );

      if( byteList == null )
      {
         PrintHeader( indent + tab, "Null byte list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", byteList.length, "\n" );

      for( int i = 0; i < value.getValue( ).length; i++ )
      {
         if( i/8 * 8 == i )
         {
            if( i != 0 )
            {
               PrintNewLine( );
            }
            PrintHeader( indent, tab, null );                
         }
         PrintByte( "", "    ", byteList[i], null );
      }

      PrintNewLine( );
   }

   public static void PrintCoordinateInfoList( String indent, String header,  CoordinateInfo[] value)
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Coordinate Info list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 

      for( int i = 0; i < value.length; i++ )
      {
         PrintLong( indent + tab, "Coordiante x: ", value[i].getXCoordinate( ), "\n" );
         PrintLong( indent + tab, "Coordinate y: ", value[i].getYCoordinate( ), "\n" );           
      }

      PrintNewLine( );
   }



   public static void PrintAttachmentInfo( String indent, String header, AttachmentInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null AttachementInfo....", "\n" );
         return;
      }

      if( value.getName( ) != null )
      {
         PrintHeader( indent + tab, " Name: " + value.getName( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Name: <null>", "\n" );
      }

      PrintLong( indent + tab, "Original size: ", value.getOriginalSize( ), "\n" );
        
      PrintLong( indent + tab, "Compressed size : ", value.getCompressedSize( ), "\n" );

   // PrintAttachLocInfo("Locator", &value->loc);

      PrintNewLine( );
   }


   public static void PrintDataType( String indent, String header,  DataType value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null DataType ....", "\n" );
         return;
      } 

      switch( value.toInt( ) )
      {
         case 1:    
            PrintHeader( indent + tab, "KEYWORD", "\n" );
            break;

         case 2:                
            PrintHeader( indent + tab, "INTEGER", "\n" );
            break;

         case 3: 
            PrintHeader( indent + tab,"REAL", "\n" );
            break;

         case 4:   
            PrintHeader( indent + tab, "CHAR", "\n" );
            break;

         case 5:   
            PrintHeader( indent + tab, "DIARY", "\n" );
            break;

         case 6:    
            PrintHeader( indent + tab, "ENUM", "\n" );
            break;

         case 7:    
            PrintHeader( indent + tab, "TIME", "\n" );
            break;

         case 8:    
            PrintHeader( indent + tab, "BITMASK", "\n" );
            break;

         case 9:  
            PrintHeader( indent + tab, "BYTES", "\n" );
            break;

         case 10:   
            PrintHeader( indent + tab, "DECIMAL", "\n" );
            break;

         case 11:   
            PrintHeader( indent + tab, "ATTACHMENT", "\n" );
            break;

         case 30:  
            PrintHeader( indent + tab, "JOIN", "\n" );
            break;

         case 31:   
            PrintHeader( indent + tab, "TRIM", "\n" );
            break;

         case 32:   
            PrintHeader( indent + tab, "CONTROL", "\n" );
            break;

         case 33:  
            PrintHeader( indent + tab, "TABLE", "\n" );
            break;

         case 34:   
            PrintHeader( indent + tab, "COLUMN", "\n" );
            break;

         case 35:  
            PrintHeader( indent + tab, "PAGE", "\n" );
            break;

         case 36: 
            PrintHeader( indent + tab,"PAGE_HOLDER", "\n" );
            break;

         case 40:    
            PrintHeader( indent + tab,"ULONG", "\n" );
            break;

         case 41:   
            PrintHeader( indent + tab,"COORDS", "\n" );
            break;

         default:   
            PrintInt( indent + tab, "UnKnown Type: ", value.toInt( ), "\n" );
            break;
      }

      PrintNewLine( );
   }
        
   public static void PrintKeyword( String indent, String header, Keyword value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Keyword....", "\n" );
         return;
      }        

      PrintInt( indent + tab, "Value: ", value.toInt( ), "\n" );

      PrintNewLine( );
   }



   public static void PrintBitMask( String indent, String header, Long value )
   {
      PrintString( indent + header + "\n" );

      if( value == null )
      {
         PrintString( " Null BitMask value....\n" );
         return;
      }        
      else
      {
         PrintString( value.toString( ) + "\n" );
      }

      PrintNewLine( );
   }
   public static void PrintDiary( String indent, String header, Diary value )
   {
      PrintString( indent + header + "\n" );

      if( value == null )
      {
         PrintString( " Null Diary value....\n" );
         return;
      }        
      else
      {
         PrintString( value.getValue( ) + "\n" );
      }

      PrintNewLine( );
   }
   
   public static void PrintValue( String indent, String header, Value value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Value....", "\n" );
         return;
      }

      DataType  type = value.getDataType( );

      if( type == null )
      {
         PrintString( indent + tab, "getDataType method returns null value", " ", "\n" );
         return;
      }
      switch( type.toInt( ) )
      {
      case 1:    
         PrintKeyword( indent + tab, "Type : KEYWORD - ", ( Keyword )value.getValue( ) );
         break;

      case 2: 
         PrintInteger( indent + tab, "Type : INTEGER -", ( Integer )value.getValue( ) );
         break; 

      case 3: 
         PrintDouble( indent + tab, "Type: REAL -", ( Double )value.getValue( ) );
         break;

      case 4:   
         PrintString(  indent + tab, "Type: CHAR - ", ( String )value.getValue( ), "\n" );
         break;

      case 5:   
         PrintString( indent + tab, "Type: DIARY - ", "   ","\n" );
         PrintDiary(  indent + tab, "Type: DIARY - ", ( Diary )value.getValue( ) );
         break;

      case 6: 
         PrintEnum(  indent + tab, "Type: ENUM -", ( Long )value.getValue( ) );
         break;

      case 7:    
         PrintTimestamp(  indent + tab, "Type: TIME - ", ( Timestamp )value.getValue( ) );
         break;

      case 8:                  
         PrintBitMask(  indent + tab, "Type: BITMASK - ", ( Long )value.getValue( ) );
         break;

      case 9:  
         PrintByteListInfo(  indent + tab, "Type: BYTES - ", ( ByteListInfo )value.getValue( ) );
         break;

      case 10:   
         PrintDecimal(  indent + tab, "Type: DECIMAL - ", ( BigDecimal )value.getValue( ) );
         break;

      case 11:   
         PrintAttachmentInfo(  indent + tab, "Type: ATTACHMENT - ", ( AttachmentInfo )value.getValue( ) );
         break;

      case 30:  
         PrintString(  indent + tab, "Type: JOIN - ", "", "\n"  );
         break;

      case 31:   
         PrintString( indent + tab, "Type : TRIM - ", " ", "\n" );
         break;

      case 32:   
         PrintString(  indent + tab, "Type: CONTROL - ", " ", "\n" );
         break;

      case 33:  
         PrintString(  indent + tab, "Type: TABLE - ", " ", "\n" );
         //   PrintString(  indent + tab, "Type: TABLE - ", value.getValue( ), "\n" );
         break;

      case 34:   
         PrintString(   indent + tab, "Type: COLUMN - ", " ", "\n" );
         //  PrintString(   indent + tab, "Type: COLUMN - ", value.getValue( ), "\n" );
         break;

      case 35:  
         PrintString(  indent + tab, "Type: PAGE - ", " ", "\n" );
         //  PrintString(  indent + tab, "Type: PAGE - ", value.getValue( ), "\n" );
         break;

      case 36: 
         PrintString(  indent + tab, "Type: PAGE_HOLDER - ", " ", "\n" );
   //    PrintString(  indent + tab, "Type: PAGE_HOLDER - ", value.getValue( ) );
         break;

      case 40:   
         PrintLong(  indent + tab, "Type: ULONG -", ( ( Long )value.getValue( ) ).longValue( ), "\n" );
         break;

      case 41:   
         PrintCoordinateInfoList(  indent + tab, "Type: COORDS -", ( CoordinateInfo[] ) value.getValue( ) );
         break;

      default:   
         PrintInt(  indent + tab, "Type : Undefined : ", type.toInt( ), "\n");
         break;
      }

   }

   public static void PrintValueList( String indent, String header, Value[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Value list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintValue( indent, "Value: ", value[i] );
      }

      PrintNewLine( );
   }

   public static void PrintIndexInfo(  String indent, String header, IndexInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + "     ", " Null IndexInfo....", "\n" );
         return;
      }
   /*
      if( value.getName( ) != null )
      {
         PrintString( indent + tab, "Name : ", value.getName( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "Name : ", "<null NameID>", "\n" );
      }

      PrintBoolean( indent + tab, "Unique: ", value.getUnique( ), "\n" );

      PrintInternalIDlist( indent + tab, "Index Field List: ", value.getIndexFields( ) );
   */
      PrintNewLine( );
   }

   public static void PrintIndexInfoList(  String indent, String header, IndexInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Index Info List", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintIndexInfo( indent + tab, "", value[i] );
      }

      PrintNewLine( );

   }
   public static void PrintEntryListFieldInfo(  String indent, String header, EntryListFieldInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + "     ", " Null EntryListFieldInfo....", "\n" );
         return;
      }

      PrintLong( indent + tab, "Field Id : ", value.getFieldID( ).getValue( ), "\n" );

      PrintInt( indent + tab, "Column Width: ", value.getColumnWidth( ), "\n" );

      PrintString( indent + tab, "Separator: ", new String( value.getSeparator( ) ), "\n" );

      PrintNewLine( );
   }


   public static void PrintEntryListFieldInfoList( String indent, String header, EntryListFieldInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null EntryListFieldInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintEntryListFieldInfo( indent, "EntryListFieldInfo: ", value[i] );
      }

      PrintNewLine( );
   }


   public static void PrintSortInfo( String indent, String header, SortInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + "     ", " Null SortInfo....", "\n" );
         return;
      }

      PrintLong( indent + tab, "Field Id :", value.getFieldID( ).getValue( ), "\n" );

      switch( value.getSortOrder( ) )
      {
         case 1  :
            PrintHeader( indent + tab, "Sort Order: ASCENDING", "\n" );
            break;

         case 2 :
            PrintHeader( indent + tab, "Sort Order: DESCENDING", "\n" );
            break;

         default              :
            PrintInt( indent + tab, "Sort Order: undefined  value = ", value.getSortOrder( ), "\n" );
            break;
      }
      PrintNewLine( );
   }


   public static void PrintSortInfoList( String indent, String header, SortInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null SortInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintSortInfo( indent, "SortInfo: ", value[i] );
      }

      PrintNewLine( );
   }



   public static void PrintEntryListInfo( String indent, String header, EntryListInfo  value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + "     ", " Null EntryListInfo....", "\n" );
         return;
      }


      PrintString( indent + tab, "Entry Id : ",  value.getEntryID( ).toString( ), "\n" );
        

      PrintString( indent + tab, "Short Description :", new String( value.getDescription( ) ), "\n" );

      PrintNewLine( );
   }



   public static void PrintEntryListInfoList( String indent, String header, EntryListInfo[] value )
   {
        
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null EntryListInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintEntryListInfo( indent, "EntryListInfo " + i + " : ", value[i] );
      }

      PrintNewLine( );
   }



   public static void PrintArithOpAssignInfo( String indent, String header, ArithOpAssignInfo value )
   {
      PrintHeader( indent, header, "\n" );


      if( value == null )
      {
         PrintHeader( indent + tab,  " Null EntryListInfo list", "\n" );
         return;
      }

      switch( ( int ) value.getOperation( ) )
      {
         case 1      :
            PrintHeader( indent + tab, "Operation: ADD", "\n" );
            break;

         case 2 :
            PrintHeader( indent + tab, "Operation: SUBTRACT", "\n" );
            break;

         case 3 :
            PrintHeader( indent + tab, "Operation: MULTIPLY", "\n" );
            break;

         case 4   :
            PrintHeader( indent + tab, "Operation: DIVIDE", "\n" );
            break;

         case 5   :
            PrintHeader( indent + tab, "Operation: MODULO", "\n" );
            break;

         case 6   :
            PrintHeader( indent + tab, "Operation: NEGATE (unary minus)", "\n" );
            break;

         default                   :
            PrintLong( indent + tab, " Operation: Undefined -  ", value.getOperation( ), "\n" );
            break;
      }

      PrintAssignInfo( indent + tab, "LeftOperand :", value.getOperandLeft( ) );       

      PrintAssignInfo( indent + tab, "RightOperand :", value.getOperandRight( ) );

      PrintNewLine( );
   }


   public static void PrintArithmeticOperationInfo( String indent, String header, ArithmeticOperationInfo  value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null ArithmeticOperationInfo....", "\n" );
         return;
      }
           
      int operation = value.getOperation( );

      PrintInt( indent + tab, "Operation: ", operation, "\n" );

      PrintArithmeticOrRelationalOperand( indent + tab, "Left Operand: ", value.getLeftOperand( ) );

      PrintArithmeticOrRelationalOperand( indent + tab, "Right Operand: ", value.getRightOperand( ) );        

      PrintNewLine( );
   }

   public static void PrintQueryInfo( String indent, String header, QueryInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Query Info....", "\n" );
         return;
      }

      PrintLong( indent + tab, "FieldID: ", value.getFieldID( ).getValue( ), "\n" );

      PrintLong( indent + tab, "Match Mode: ", value.getMatchMode( ), "\n" );

      PrintString( indent + tab, "Schema ID: ", value.getSchemaID( ).toString( ), "\n" );

      PrintString( indent + tab, "Server Name: ", value.getServerName( ).toString( ), "\n" );
               
      PrintQualifierInfo( indent + tab, "Qualifier Info: ", value.getQualifierInfo( ) );
   }

   public static void PrintArithmeticOrRelationalOperand( String indent, String header, ArithmeticOrRelationalOperand value )
   {
      OperandType opType = value.getType( );        

      int operation = opType.toInt( );
      Object objVal = value.getValue( );


      if( opType == OperandType.FIELDID )
      {
         PrintHeader( indent + tab, "Type: FIELDID", "\n" );
         FieldID fieldId = ( FieldID ) objVal;
         PrintLong( indent + tab, "FieldId : ", fieldId.getValue( ), "\n" );

      }
      else if( opType == OperandType.VALUE )
      {
         PrintHeader( indent + tab, "Type: VALUE", "\n" );
         Value val = ( Value ) objVal;
         PrintValue( indent + tab, "Value: ", val );
      }
      else if( opType == OperandType.ARITHMETIC_OP )
      {
         PrintHeader( indent + tab, "Type: ARITHMETIC_OP", "\n" );
         ArithmeticOperationInfo arInfo = ( ArithmeticOperationInfo ) objVal;
         PrintArithmeticOperationInfo( indent + tab, "ArithmeticOperationInfo: ", arInfo );
      }
      else if( opType == OperandType.STATUS_HISTORY )
      {
         PrintHeader( indent + tab, "Type: STATUS_HISTORY", "\n" );
         StatusHistoryValue stHistoryVal = ( StatusHistoryValue ) objVal;
         PrintStatusHistoryValue( indent + tab, "StatusHistoryValue ", stHistoryVal );
      }
      else if( opType == OperandType.VALUE_SET )
      {
         PrintHeader( indent + tab, "Type: VALUE_SET", "\n" );
         PrintValueList( indent + tab, "Value List: ", ( Value[] )value.getValue( ) );
      }
      else if( opType == OperandType.FIELDID_TRANSACTION )
      {
         PrintHeader( indent + tab, "Type: FIELDID_TRANSACTION", "\n" );
         FieldID fieldIdTransaction = ( FieldID ) objVal;
         PrintLong( indent + tab, "FieldId : ", fieldIdTransaction.getValue( ), "\n" );
      }
      else if( opType == OperandType.FIELDID_DB )
      {
         PrintHeader( indent + tab, "Type: FIELDID_DB", "\n" );
         FieldID fieldIdDB = ( FieldID ) objVal;
         PrintLong( indent + tab, "FieldId : ", fieldIdDB.getValue( ), "\n" );
      }
      else if( opType == OperandType.LOCAL_VARIABLE )
      {
         PrintHeader( indent + tab, "Type: LOCAL_VARIABLE", "\n" );
         Integer variable = ( Integer ) value.getValue( );
         PrintHeader( indent + tab, "Local Variable Number: " + variable, "\n" );
      }
      else if( opType == OperandType.QUERY_INFO )
      {
         PrintHeader( indent + tab, "Type: QUERY_INFO", "\n" );
         QueryInfo qInfo = ( QueryInfo ) value.getValue( );
         PrintQueryInfo( indent + tab, " QueryInfo: ", qInfo );
      }
      else if( opType == OperandType.FIELDID_CURRENT )
      {
         PrintHeader( indent + tab, "Type: FIELDID_CURRENT", "\n" );
         FieldID fieldIdCurrent = ( FieldID ) objVal;
         PrintLong( indent + tab, "FieldId : ", fieldIdCurrent.getValue( ), "\n" );
      }
      else
      {   
         PrintInt( indent + tab, "Type : Invalid Operation - ", operation, "\n" );
      }                
   }
         

   public static void PrintRelationalOperationInfo( String indent, String header, RelationalOperationInfo value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null RelationalOperationInfo", "\n" );
         return;
      }

      PrintInt( indent + tab, "Operation Code :", value.getOperation( ), "\n" );
        
      PrintArithmeticOrRelationalOperand( indent + tab, "Left Operand : ", value.getLeftOperand( ) );
      PrintArithmeticOrRelationalOperand( indent + tab, "Right Operand : ", value.getRightOperand( ) );

      PrintNewLine( );
   }


   public static void PrintQualifierOperationCode( String indent, String header, int operationCode )
   {
      switch( operationCode )
      {
         case QualifierInfo.AR_COND_OP_NONE   :
            PrintString( indent + tab + header + " : <Operation code none>" + "\n" );
            break;

         case QualifierInfo.AR_COND_OP_AND    :
            PrintString( indent + tab + header + " : < AND Operation (" + QualifierInfo.AR_COND_OP_AND + ") >"  + "\n" );
            break;

         case QualifierInfo.AR_COND_OP_OR     :
            PrintString( indent + tab + header + " : < OR Operation (" + QualifierInfo.AR_COND_OP_OR + ") >"  + "\n" );
            break;
         
         case QualifierInfo.AR_COND_OP_NOT    :
            PrintString( indent + tab + header + " : < NOT Operation (" + QualifierInfo.AR_COND_OP_NOT + ") >"  + "\n" );
            break;

         case QualifierInfo.AR_COND_OP_REL_OP :
            PrintString( indent + tab + header + " : < RELATIONAL Operation (" + QualifierInfo.AR_COND_OP_REL_OP + ") >"  + "\n" );
            break;

         case QualifierInfo.AR_COND_OP_FROM_FIELD :
            PrintString( indent + tab + header + " : < FROMFIELD Operation (" + QualifierInfo.AR_COND_OP_FROM_FIELD + ") >"  + "\n" );
            break;            
         default  :
            PrintString( indent + tab + "Invalid Operation code..." + operationCode + "\n" );
            break;             
      }
   }

   public static void PrintQualifierInfo( String indent, String header, QualifierInfo value)
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null QualifierInfo", "\n" );
         return;
      }
      PrintQualifierOperationCode( indent + tab, "Operation Code : ", value.getOperation( ) );
      switch( value.getOperation( ) )
      {
         case QualifierInfo.AR_COND_OP_NONE   :
            PrintString( indent + tab + " No operation mentioned..." + "\n" );
            break;

         case QualifierInfo.AR_COND_OP_AND    :
         case QualifierInfo.AR_COND_OP_OR     :
            PrintQualifierInfo( indent + tab, "Left Operand: ", value.getLeftOperand( ) );
            PrintQualifierInfo( indent + tab, "Right Operand: ", value.getRightOperand( ) );
            break;

         case QualifierInfo.AR_COND_OP_NOT    :
            PrintQualifierInfo( indent + tab, "Right Operand: ", value.getNotOperand( ) );
            break;

         case QualifierInfo.AR_COND_OP_REL_OP :
            PrintRelationalOperationInfo( indent + tab, "Relational Operation Info: ", value.getRelationalOperationInfo( ) );
            break;
                
         case QualifierInfo.AR_COND_OP_FROM_FIELD :
            QualifierFromFieldInfo fromfid = value.getFromFieldInfo();
            PrintString(indent + tab, "From Field: ", fromfid.toString(), "\n");
            break;

         default  :
            PrintString( indent + tab + "Invalid Operation code..." + "\n" );
            break;             
      }
           
      PrintNewLine( );       
   }

   public static void PrintPropInfo( String indent, String header, PropInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null PropInfo", "\n" );
         return;
      }
      PrintInt(  indent + tab, "Property Tag : ", value.getPropertyTag( ), "\n" );
                   
      PrintValue( indent + tab, "Property Value : ", value.getPropertyValue( ) );

      PrintNewLine( );
   }

   public static void PrintPropInfoList( String indent, String header, PropInfo[] value )
   {
         
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null PropInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintPropInfo( indent + tab, "PropInfo: ", value[i] );
      }

      PrintNewLine( );
   }



   public static void PrintDisplayInstanceInfo( String indent, String header, DisplayInstanceInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null DisplayInstance Info", "\n" );
         return;
      }

      PrintLong( indent + tab, "Internal ID : ", value.getVUIId( ).getValue( ), "\n" );
        
      PrintPropInfoList( indent + tab, "Properties", value.getVUIProperties( ) );

      PrintNewLine( );

   }


   public static void PrintDisplayInstanceInfoList( String indent, String header, DisplayInstanceInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null DisplayInstanceInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintDisplayInstanceInfo( indent + tab, "DisplayInstanceInfo: ", value[i] );
      }

      PrintNewLine( );

   }

   public static void PrintDisplayInstanceList( String indent, String header, DisplayInstanceList value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null DisplayInstance Info", "\n" );
         return;
      }

      if( value.getCommonProperties( ) != null )
      {
         PrintPropInfoList( indent + tab, "Common Properties : ", value.getCommonProperties( ) );
      }
      else
      {
         PrintHeader( indent + tab, "No Common properties", "\n" );
      }
               
      PrintDisplayInstanceInfoList( indent + tab, "DisplayInstances Properties list: ", value.getDisplayInstances( ) ); 

      PrintNewLine( );
   }


   public static void PrintDisplayInstanceListList( String indent, String header, DisplayInstanceList[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null DisplayInstanceList list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintDisplayInstanceList( indent + tab, "DisplayInstanceList: ", value[i] );
      }

      PrintNewLine( );
   }


   public static void PrintAssignFieldInfo( String indent, String header, AssignFieldInfo value )
   {        
      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null assign Field Info value ...", "\n" );
         return; 
      }

      PrintString(  indent + tab, "Server: ", value.getServer( ), "\n" );        

      PrintString( indent + tab, "Schema: ", value.getSchema( ).toString( ), "\n" );

      PrintLong( indent + tab, "Tag : ", value.getTag( ), "\n" );

      //PrintLong( indent + tab, "FieldID : ", value.getFieldId( ), "\n" ) ;    

      PrintQualifierInfo( indent + tab, "QualifierInfo: ", value.getQualifier( ) );

      PrintLong( indent + tab, "No Match Option : ", value.getNoMatchOption( ), "\n" );

      PrintLong( indent + tab, "Multi Match Option : ", value.getMultiMatchOption( ), "\n" );

      PrintStatusHistoryValue( indent + tab, "Status History: ", value.getStatHistory( ) );

      PrintNewLine( );
   }

   public static void PrintStatusHistoryValue( String indent, String header, StatusHistoryValue value )
   {
      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Status History value ...", "\n" );
         return; 
      }

      PrintBoolean( indent + tab, "Time : ", value.isTime( ), "\n" ); 
                
      PrintInt( indent + tab, "Value : ", value.getEnumValue( ), "\n" );
        
      PrintNewLine( );        
   } 


   public static void PrintAssignSQLInfo( String indent, String header, AssignSQLInfo value )
   {
      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null AssignSQLInfo value...", "\n" );
         return;
      }

      PrintString( indent + tab, "Server: ", value.getServer( ), "\n" );
               
          
      if( value.getSqlCommand( ) == null)
      {
         PrintHeader( indent + tab, "SQL Command: NULL", "\n" );
      }
      else
      {
         PrintString( indent + tab, "SQL Command: ", value.getSqlCommand( ), "\n" );
      }

      PrintLong( indent + tab, "Value Index: ", value.getValueIndex( ), "\n" );

      PrintLong( indent + tab, "No Match Option : ", value.getNoMatchOption( ), "\n" );

      PrintLong( indent + tab, "Multi Match Option : ", value.getMultiMatchOption( ), "\n" );

      PrintNewLine( ); 
   }


   public static void PrintAssignInfo( String indent, String header, AssignInfo value )
   {

      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null AssignInfo value...", "\n" );
         return;
      }

      PrintLong( indent + tab, "Assign Type : ", value.getAssignType( ), "\n" );

      PrintArithOpAssignInfo( indent + tab, "AssignInfo :", value.getArithOp( ) );

      PrintAssignFieldInfo( indent + tab, "AssignFieldInfo :", value.getField( ) );

      PrintFunctionAssignInfo( indent + tab, "Function Assign Info :", value.getFunction( ) );

      PrintAssignSQLInfo( indent + tab, "Assign SQL Info :", value.getSql( ) );

      PrintString( indent + tab, "Process :", value.getProcess( ), "\n" );

      PrintDDEInfo( indent + tab, "DDE Info :", value.getDde( ) );

      PrintValue( indent + tab, "Value :", value.getValue( ) );

      PrintNewLine( );
   }

   public static void PrintAssignInfoList( String indent, String header, AssignInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null AssignInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintAssignInfo( indent + tab, "AssignInfoInfo: ", value[i] );
      }

      PrintNewLine( );
   }

   public static void PrintFieldAssignInfo( String indent, String header, FieldAssignInfo value )
   {
      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null AssignSQLInfo value...", "\n" );
         return;
      }
       
      PrintLong( indent + tab, "Field Id : ", value.getFieldId( ).getValue( ), "\n" );

      PrintAssignInfo( indent + tab, " AssignInfo : ", value.getAssignment( ) );

      PrintNewLine( );
   }




   public static void PrintFieldAssignInfoList( String indent, String header, FieldAssignInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null FieldAssign list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintFieldAssignInfo( indent + tab, "FieldAssignInfo: ", value[i] );
      }

      PrintNewLine( );  
   }



   public static void PrintFunctionAssignInfo( String indent, String header, FunctionAssignInfo value )
   {

      PrintHeader( indent, header, "\n" );
               
               
      if( value == null )
      {
         PrintHeader( indent + tab,  "Null FunctionAssignInfo....", "\n" );
         return;
      }

      PrintLong( indent + tab,  "Function Code : ", value.getFunctionCode( ), "\n" );
             
      PrintLong( indent + tab, "Number of items : ", value.getNumItems( ), "\n" );

      PrintAssignInfoList(  indent + tab, "Parameters List :", value.getParameterList( ) );

      PrintNewLine( );
   }

   public static void PrintNotifyActionInfo( String indent, String header, NotifyActionInfo value )
   {
      PrintHeader( indent, header, "\n" );
                       
      if( value == null )
      {
         PrintHeader( indent + tab,  "Null NotifyActionInfo....", "\n" );
         return;
      }       

      PrintLong( indent + tab, "Notify Mechanism: ", value.getNotifyMechanism( ), "\n" );
               
      PrintLong( indent + tab, "Notify Priority: ", value.getNotifyPriority( ), "\n" );

      PrintLong( indent + tab, "Notify Mechanism X Ref: ", value.getNotifyMechanismXRef( ).getValue( ), "\n" );
             
      PrintString( indent + tab, "User: ", value.getUser( ), "\n" );

      PrintString( indent + tab, "Notify Text: ", value.getNotifyText( ), "\n" );

      PrintString( indent + tab, "Subject Text: ", value.getSubjectText( ), "\n" );

      PrintLong( indent + tab, "FieldIdListType: ", value.getFieldIdListType( ), "\n" );

      PrintInternalIDList( indent + tab, "Field ID List: ", value.getFieldIdList( ) );
         
      PrintNewLine( );
   }


   public static void PrintFilterActionInfoList( String indent, String header, FilterActionInfo[] actionList )
   {
      PrintHeader( indent, header, "\n" );
               
      if( actionList == null )
      {
         PrintHeader( indent + tab,  " Null FilterActionInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of actions: ", actionList.length, "\n" ); 
        
      for( int i = 0; i < actionList.length; i++ )
      {
         PrintFilterActionInfo( indent + tab, "FilterActionInfo " + i + " : ", actionList[i] );
      }

      PrintNewLine( );  
   }

   public static void PrintFilterActionInfo( String indent, String header, FilterActionInfo value )
   {
      PrintHeader( indent, header, "\n" );
                       
      if( value == null )
      {
         PrintHeader( indent + tab,  "Null FilterActionInfo....", "\n" );
         return;
      }
               
      PrintLong( indent + tab, "Action : ", value.getAction( ), "\n" );

      PrintString( indent + tab, "Log file : ", value.getLogFile( ), "\n" );

      PrintString( indent + tab, "Process : ", value.getProcess( ), "\n" );

      PrintFieldAssignInfoList( indent + tab, "Fields list : ", value.getFieldList( ) );

      PrintGotoActionInfo( indent + tab, "Goto Action : ", value.getGotoAction( ) );

      PrintFilterStatusInfo( indent + tab, "Status Info: ", value.getMessage( ) );

      PrintNotifyActionInfo( indent + tab, "Notify: ", value.getNotify( ) );

      PrintPushFieldsInfoList( indent + tab, "PushFields list: ", value.getPushFieldsList( ) );

      PrintSQLInfo( indent + tab, "SQL Command: ", value.getSqlCommand( ) );
               
      PrintCallGuideInfo( indent + tab, "Call guide Info: ", value.getCallGuide( ) ); 

      PrintNewLine( );
   }


   public static void PrintFilterStatusInfo( String indent, String header, FilterStatusInfo value )
   {
      PrintHeader( indent, header, "\n" );
                       
      if( value == null )
      {
         PrintHeader( indent + tab,  "Null FilterStatusInfo....", "\n" );
         return;
      }

      PrintLong( indent + tab, "   Message type : ", value.getMessageType( ), "\n" );

      PrintLong( indent + tab, "   Message number : ", value.getMessageNum( ), "\n" );             
               
      PrintString( indent + tab, "   Message Text : ", value.getMessageText( ), "\n" ); 

      PrintNewLine( );
   }


   public static void PrintPushFieldsInfo( String indent, String header,  PushFieldsInfo value )
   {
      PrintHeader( indent, header, "\n" );
                       
      if( value == null )
      {
         PrintHeader( indent + tab, "Null PushFieldsInfo....", "\n" );
         return;
      }

      PrintAssignFieldInfo( indent + tab, "Assign Field Info: ", value.getField( ) );

      PrintAssignInfo( indent + tab, "Assign Info: ", value.getAssign( ) );

      PrintNewLine( );
   }


   public static void PrintPushFieldsInfoList( String indent, String header, PushFieldsInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null PushFieldsInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintPushFieldsInfo( indent + tab, "PushFieldsInfo: ", value[i] );
      }

      PrintNewLine( );  
   }

   public static void PrintSQLInfo( String indent, String header, SQLInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null SQL Info", "\n" );
         return;
      }

      if( value.getServer( ) != null )
      {
         PrintString( indent + tab, " Server: ", value.getServer( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Server: <NULL> ", "\n" );
      }  

      if( value.getCommand( ) != null )
      {
         PrintString( indent + tab, "SQL Command: ", value.getCommand( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "SQL Command: NULL", "\n" );
      }

      PrintNewLine( );
   }
          

   public static void PrintGotoActionInfo( String indent, String header, GotoActionInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null GotoActionInfo.....", "\n" );
         return;
      }

      PrintLong( indent + tab, "Tag: ", value.getTag( ), "\n" );
      PrintLong( indent + tab, "FieldID or Value : ", value.getFieldIdOrValue( ), "\n" );
               
      PrintNewLine( );
   }  

   public static void PrintMacroParmInfo( String indent, String header, MacroParmInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null MacroParmInfo.....", "\n" );
         return;
      }        

      PrintString( indent + tab, "Name: ", value.getName( ).toString( ), "\n" );
      PrintString( indent + tab, "Value: ", value.getValue( ), "\n" );

      PrintNewLine( );
   }

   public static void PrintMacroParmInfoList( String indent, String header, MacroParmInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null MacroParmInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintMacroParmInfo( indent + tab, "PushMacroParmInfo: ", value[i] );
      }

      PrintNewLine( );     
   }

   public static void PrintActiveLinkMacroInfo( String indent, String header, ActiveLinkMacroInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null GotoActionInfo.....", "\n" );
         return;
      }

      PrintString(  indent + tab, "Macro name: ", value.getMacroName( ).toString( ), "\n" );

      PrintString(  indent + tab, "Macro text: ", value.getMacroText( ), "\n" );

      PrintMacroParmInfoList( indent + tab, "Macro Param List :", value.getMacroParms( ) );

      PrintNewLine( ); 
   }


   public static void PrintMessageInfo( String indent, String header, MessageInfo value)
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null GotoActionInfo.....", "\n" );
         return;
      }

      PrintLong( indent + tab, "Message type : ", value.getMessageType( ), "\n" );

      PrintLong( indent + tab,  "Message number : ", value.getMessageNum( ), "\n" );

      if( value.getMessageText( ) != null)
      {
         PrintString( indent + tab, "Message: ", value.getMessageText( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Message: <NULL>", "\n" );
      }
        
      PrintBoolean( indent + tab, "Use Prompting Pane : ", value.getUsePromptingPane( ), "\n" );

      PrintNewLine( );
   }


   public static void PrintFieldCharacteristicsInfo( String indent, String header, FieldCharacteristicsInfo value)
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null FieldCharacteristics Info.....", "\n" );
         return;
      }
               
      PrintLong( indent + tab, "Field Id: ", value.getFieldId( ).getValue( ), "\n" );

      PrintLong( indent + tab, "Reset Focus:", value.getFocus( ), "\n" );

      PrintLong( indent + tab, "Access option:", value.getAccessOption( ), "\n" );

      if( value.getCharMenu( ) == null )
      {
         PrintHeader( indent + tab, "Char menu: NULL", "\n" );
      }
      else
      {
         PrintString( indent + tab, "Char menu: ", value.getCharMenu( ), "\n" );
      }

      PrintPropInfoList( indent + tab, "Properties :", value.getProps( ) );

      PrintNewLine( );
   }


   public static void PrintDDEInfo( String indent, String header, DDEInfo  value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null DDE Info.....", "\n" );
         return;
      }

      if( value.getServiceName( ) != null )
      {
         PrintString( indent + tab, "Service name:", value.getServiceName( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Service name: < NULL >", "\n" );
      }

      if( value.getTopic( ) != null )
      {
         PrintString( indent + tab, "Topic:", value.getTopic( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Topic: < NULL >", "\n" );
      }

      PrintLong( indent + tab, "Action: ", value.getAction( ), "\n" );

      if( value.getPathToProgram( ) != null )
      {
         PrintString( indent + tab, "Path to Program:", value.getPathToProgram( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Path to Program:< NULL >", "\n" );
      }

      if( value.getCommand( ) != null )
      {
         PrintString( indent + tab, "Command: ", value.getCommand( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Command: <NULL> ", "\n" );
      }

      if( value.getItem( ) != null )
      {
         PrintString( indent + tab, "Item:", value.getItem( ), "\n" );
      }
      else
      {
         PrintHeader( indent + tab, "Item:", "\n" );
      }

      PrintNewLine( );
   }


   public static void PrintAutomationInfo( String indent, String header, AutomationInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null Automation Info.....", "\n" );
         return;
      }

      PrintString( indent + tab, "Auto Server name:", value.getAutoServerName( ), "\n" );
               
      PrintBoolean( indent + tab, "Automation Server Showing flag :", value.getIsVisible( ), "\n" );

      PrintString( indent + tab, "Class Id:", value.getClsId( ), "\n" );

      PrintString( indent + tab, "Automation Action: ", value.getAction( ), "\n" );

      PrintCOMMethodInfoList( indent + tab, "Com methods list: ", value.getMethodList( ) );

      PrintNewLine( );
   }

        
   public static void PrintCOMValueInfo( String indent, String header, COMValueInfo value )
   {

      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null COMValueInfo.....", "\n" );
         return;
      }

      if( value.getFieldId( ) != null )
      {
         PrintLong( indent + tab, "FieldId: ", value.getFieldId( ).getValue( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "FieldId: ", "< null >", "\n" );
      }

      if( value.getTransId( ) != null )
      {
         PrintLong( indent + tab, "TransientId: ", value.getTransId( ).getValue( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "TransientId: ", "< null >", "\n" );
      }
        
      PrintLong( indent + tab, "Value Type: ", value.getValueType( ), "\n" );

      PrintString( indent + tab, "ValueId: ", value.getValueIId( ), "\n" );


      PrintValue( indent + tab, "value: ", value.getValue( ) );

      PrintNewLine( );
   }
        
   public static void PrintCOMMethodInfoList( String indent, String header, COMMethodInfo[] value) 
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null COMMethodInfo List....", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items : ", value.length, "\n" );        

      for( int i = 0; i < value.length; i++ )
      {
         PrintCOMMethodInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( );
   }        
        
   public static void PrintCOMMethodInfo( String indent, String header, COMMethodInfo value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null COMMethodInfo Info....", "\n" );
         return;
      }

      PrintString( indent+ tab, "Method Name: ", value.getMethodName( ), "\n" );

      PrintString( indent + tab, "Method Interface Id: ", value.getMethodIId( ), "\n" );

      PrintLong( indent + tab, "Method Type: ", value.getMethodType( ), "\n" );

      PrintCOMValueInfo( indent + tab, "Method:", value.getMethodValue( ) );

      PrintCOMMethodParmInfoList( indent + tab, " Parameter List: \n",  value.getParameterList( ) );

      PrintNewLine( );
   }
        
        
   public static void PrintCOMMethodParmInfoList( String indent, String header, COMMethodParmInfo[] value )
   {
         
      PrintHeader( indent, header, "\n" );        

      if( value == null )
      {
         PrintHeader( indent + tab, " Null COMMethodParmInfo List", "\n" );  
         return;
      }
      PrintInt( indent +tab,  "Number of Items : ", value.length, "\n" ); 
      for( int i = 0; i < value.length; i++ )
      {
         PrintCOMMethodParmInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( );
   }

        
        
   public static void PrintCOMMethodParmInfo( String indent, String header, COMMethodParmInfo value ) 
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null COMMethodParmInfo", "\n" );  
         return;
      }

      PrintString( indent + tab, "Parameter Name: ", value.getParmName( ), "\n" );

      PrintLong( indent + tab, "Parameter Type: ", value.getParmType( ), "\n" );

      PrintCOMValueInfo( indent + tab, "Parameter: ", value.getParmValue( ) );
   }




   public static void PrintOpenDialogInfo( String indent, String header, OpenDialogInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null OpenDlg Info", "\n" );  
         return;
      }

      PrintString( indent + tab, "Server Name: ", value.getServerName( ).toString( ), "\n" );

      PrintString( indent + tab, "Schema Name: ", value.getSchemaName( ).toString( ), "\n" );

      PrintString( indent + tab, "Vui Label: ", value.getVuiLabel( ).toString( ), "\n" );

      PrintBoolean( indent + tab, "Close Box Showing flag : ", value.getCloseBox( ), "\n" );

      PrintFieldAssignInfoList( indent + tab, "Input Value Fields : ", value.getInputValueFieldPairs( ) );
      PrintFieldAssignInfoList( indent + tab, "Output Value Fields : ", value.getOutputValueFieldPairs( ) );

      PrintInt( indent + tab, "Window Mode: ", value.getWindowMode(), "\n");
      PrintString( indent + tab, "Target Location: ", value.getTargetLocation(), "\n");
      PrintQualifierInfo( indent + tab, "Query: ", value.getQuery());
      PrintBoolean( indent + tab, "No Match Continue: ", value.getNoMatchContinue(), "\n");
      PrintBoolean( indent + tab, "Suppress Empty List: ", value.getSuppressEmptyLst(), "\n");
      PrintMessageInfo( indent + tab, "Message: ", value.getMsg());
      PrintLong( indent + tab, "Polling Interval: ", value.getPollinginterval(), "\n");
      PrintString( indent + tab, "Report String: ", value.getReportString(), "\n");
      PrintSortInfoList( indent + tab, "Sort Order List: ", value.getSortOrderList());

      PrintNewLine( );
   }

         
   public static void PrintCallGuideInfo( String indent, String header, CallGuideInfo value )
   { 
      FieldID fid;
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null CallGuide Info", "\n" );  
         return;
      }

      PrintString( indent + tab, "Server Name: ", value.getServerName( ).toString( ), "\n" );
      PrintString( indent + tab, "Guide Name: ", value.getGuideName( ).toString( ), "\n" );
        
      PrintInt( indent + tab,"Guide Mode: ", value.getGuideMode( ), "\n" );
      fid = value.getGuideTableId( );
      PrintLong( indent + tab, "Table Field: ", fid.getValue( ), "\n" );

      PrintNewLine( );
   }



   public static void PrintExitGuideInfo( String indent, String header, ExitGuideInfo value)
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ExitGuide Info", "\n" );  
         return;
      }

      PrintBoolean( indent + tab, "Close All Windows : ", value.getCloseAll( ), "\n" );

      PrintNewLine( );
   }


   public static void PrintGotoGuideLabelInfo( String indent, String header, GotoGuideLabelInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null GotoGuideLabel Info", "\n" );  
         return;
      }

      PrintString( indent + tab, "Label: ", value.getLabel( ), "\n" );
      PrintNewLine( );
   }

        
   public static void PrintWaitInfo( String indent, String header, WaitInfo value)
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null WaitInfo....", "\n" );  
         return;
      }

      PrintString( indent + tab, "Continue Button Title: ", value.getContinueButtonTitle( ), "\n" );
          
      PrintNewLine( ); 

   }


   public static void PrintCloseWindowInfo( String indent, String header, CloseWindowInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null Close Window Info....", "\n" );  
         return;
      }

      PrintBoolean( indent + tab, "Close All: ", value.getCloseAll( ), "\n" );
                
      PrintNewLine( );
   }


   public static void PrintCommitChangesInfo( String indent, String header, CommitChangesInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null CommitChanges Info....", "\n" );  
         return;
      }

      PrintString( indent + tab, "Schema Name: ", value.getSchemaName( ).toString( ), "\n" );
                
      PrintNewLine( );
   }


   public static void PrintActiveLinkActionInfo(  String indent, String header, ActiveLinkActionInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ActiveLinkAction Info", "\n" );  
         return;
      }

      PrintLong( indent + tab, "Action : ", value.getAction( ), "\n" );

      PrintAutomationInfo( indent + tab, "Automation Info: ", value.getAutomation( ) ); 
        
      PrintCallGuideInfo( indent + tab, "Call guide Info: ", value.getCallGuide( ) ); 
         
      PrintFieldCharacteristicsInfo( indent + tab, "Field Characteristics: ", value.getCharacteristics( ) ); 

      PrintCloseWindowInfo( indent + tab, "Close Window Info: ", value.getCloseWnd( ) ); 
               
      PrintOpenDialogInfo( indent + tab, "Open Dialog/Window Info: ", value.getOpenDlg( ) ); 

      PrintCommitChangesInfo( indent + tab, "Commit Changes Info: ", value.getCommitChanges( ) ); 

      PrintDDEInfo( indent + tab, "DDE Info: ", value.getDde( ) ); 

      PrintExitGuideInfo( indent + tab, "Exit Guide Info: ", value.getExitGuide( ) ); 

      PrintGotoActionInfo( indent + tab, "Goto Action Info: ", value.getGotoAction( ) ); 

      PrintActiveLinkMacroInfo( indent + tab, "Active Link Macro Info: ", value.getMacro( ) ); 

      PrintMessageInfo( indent + tab, "Message Info: ", value.getMessage( ) ); 

      PrintString( indent + tab, "Process: ", value.getProcess( ), "\n" ); 

      PrintPushFieldsInfoList( indent + tab, "Push Fields List Info: ", value.getPushFieldsList( ) ); 

      PrintSQLInfo( indent + tab, "SQL Command: ", value.getSqlCommand( ) ); 

      PrintWaitInfo( indent + tab, "Wait Info: ", value.getWaitAction( ) ); 

      PrintNewLine( ); 
   }



   public static void PrintActiveLinkActionInfoList(  String indent, String header, ActiveLinkActionInfo[] value, boolean flag )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null ActiveLinkActionInfo list..", "\n" );
         return;
      }

      if( flag )
      {
         PrintInt( indent + tab, "Active Link Action List items: ", value.length, "\n" );
      }
      else
      {
         PrintInt( indent + tab, "Active Link Else List items: ", value.length, "\n" );
      }

      for( int i = 0; i < value.length; i++ )
      {
         PrintActiveLinkActionInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }


   public static void PrintActiveLinkList(  String indent, String header, ActiveLink[] activeLinkList )
   {
      PrintHeader( indent, header, "\n" );

      if( activeLinkList == null )
      {
         PrintHeader( indent + tab, "Null ActiveLink list..", "\n" );
         return;
      }

      PrintInt( indent + tab,  "Number of Items : ", activeLinkList.length, "\n" ); 

      for( int i = 0; i < activeLinkList.length; i++ )
         PrintActiveLink( indent + tab, "ActiveLink Info:", activeLinkList[i] );

      PrintNewLine( ); 
   }

   public static void PrintWorkflowConnectInfo( String indent, String header, WorkflowConnectInfo workflow )
   {
      PrintHeader( indent, header, "\n" );

      if( workflow == null )
      {
         PrintHeader( indent + tab, " Null WorkflowConnectInfo...", "\n" );  
         return;
      }

      PrintLong( indent + tab, "Workflow Type:", workflow.getType( ) , "\n" );

      PrintNameIDList( indent + tab, "Schemas List:", workflow.getSchemaList( ) );
        
      PrintNewLine( ); 
   }
           
   public static void PrintActiveLink(  String indent, String header, ActiveLink activeLink )
   {
      PrintHeader( indent, header, "\n" );

      if( activeLink == null || activeLink.isPresent() == false)
      {
         PrintHeader( indent + tab, "Null ActiveLink...", "\n" );
         return;
      }
         
      if( activeLink.getName( ) != null )
      {
         PrintString( indent + tab, "Name: ", activeLink.getName( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "Name: <null>", "", "\n" );
         return;
      }

      PrintLong( indent + tab, "Execution order: ", activeLink.getOrder( ), "\n" );
               
      // Print Workflow information
         PrintWorkflowConnectInfo( indent + tab, "Work flow information:", activeLink.getWorkflowConnect( ) );

      // Print Group list
         PrintInternalIDList( indent + tab, "Group List: ", activeLink.getGroupList( ) );

      PrintLong( indent + tab, "Execute bitmask: ", activeLink.getExecuteMask( ), "\n" );

      PrintLong( indent + tab, "Control Field: ", activeLink.getControlField( ), "\n" );

      PrintLong( indent + tab, "Cocus Field: ", activeLink.getFocusField( ), "\n" );

      PrintLong( indent + tab, "Enable flag: ", activeLink.getEnable( ), "\n" );

      // Print Qualifier
         PrintQualifierInfo( indent + tab, "", activeLink.getQualifier( ) );

      // Print Active Link action list
         PrintActiveLinkActionInfoList( indent + tab, "", activeLink.getActionList( ), true );

      // Print Active Link else action list
         PrintActiveLinkActionInfoList( indent + tab, "", activeLink.getElseList( ), false );

      if( activeLink.getHelpText( ) != null )
      {
         PrintString( indent + tab, "Help Text: ", activeLink.getHelpText( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "HelpText: <null>" + "\n" );
      }
        
      if( activeLink.getLastUpdateTime( ) != null )
      {
         PrintString( indent + tab + "Last Update Time:" +  activeLink.getLastUpdateTime( ).getValue( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Update Time: <null>" + "\n" );
      }

      if( activeLink.getOwner( ) != null )
      {
         PrintString( indent + tab, "Owner: ", activeLink.getOwner( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Owner: null" + "\n" );
      }

      if( activeLink.getLastChangedBy( ) != null )
      {
         PrintString( indent + tab + "Last Changed: " + activeLink.getLastChangedBy().toString( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Changed: <null>"  + "\n" );
      }

      if( activeLink.getDiary( ) != null )
      {
         PrintDiaryString( indent + tab, "Change Diary: ", activeLink.getDiary( ) );
      }
      else
      {
         PrintString( indent + tab + "Change Diary: null " + "\n" );
      }
               

      PrintPropInfoList( indent + tab, "Properties List: ", activeLink.getObjPropList( ) );

      PrintNewLine( ); 
   }

   public static void PrintPermissionInfo( String indent, String header, PermissionInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null Permission Info...", "\n" );  
         return;
      }

      PrintLong( indent + tab, "Group id:", value.getGroupID( ).getValue( ) , "\n" );

      PrintLong( indent + tab, "Permission:", value.getPermissionValue( ) , "\n" );

      PrintNewLine( ); 
   }



   public static void PrintPermissionInfoList( String indent, String header, PermissionInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab, "Null PermissionInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintPermissionInfo( indent + tab, null, value[i] );
      }
      PrintNewLine( ); 
   }





   public static void PrintGroupInfo( String indent, String header, GroupInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null GroupInfo....", "\n" );  
         return;
      }

      PrintLong( indent + tab, "Group ID: ", value.getGroupID( ).getValue( ), "\n" );    

      PrintInt( indent + tab, "Group Type: ", value.getGroupType( ), "\n" ); 

      PrintAccessNameIDList( indent+ tab, "Group name(s): ", value.getGroupName( ) );

      PrintNewLine( ); 
   }





   public static void PrintGroupInfoList( String indent, String header, GroupInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null GroupInfo List..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintGroupInfo( indent + tab, null, value[i] );
      }
      PrintNewLine( ); 
   }


   public static void PrintUserLicenseInfo( String indent, String header, UserLicenseInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null UserLicenseInfo.....", "\n" );  
         return;
      }

      PrintInt( indent + tab, "License Tag: ", value.getLicenseTag( ), "\n" );

      PrintInt( indent + tab, "License Type: ", value.getLicenseType( ), "\n" );

      PrintInt( indent + tab, "Current License Type: ", value.getCurrentLicenseType( ), "\n" );
               
      PrintLong( indent + tab, "License Pool: ", value.getLicensePool().getValue( ), "\n" );
                     
      PrintNewLine( ); 
   }



   public static void PrintUserLicenseInfoList( String indent, String header, UserLicenseInfo[]  value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null UserLicenseInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintUserLicenseInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }


   public static void PrintUserInfo( String indent, String header, UserInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null UserInfo....", "\n" );  
         return;
      }

      PrintString( indent + tab, "User name: ", value.getUserName( ).toString( ), "\n" );

      PrintUserLicenseInfoList( indent + tab, "license List: ", value.getLicenseInfo( ) );

      PrintTimestamp( indent + tab, "Last Access Time: ", value.getLastAccessTime( ) );

      PrintString( indent + tab, "Email Address: ", value.getEmailAddress( ), "\n" );

      PrintInt( indent + tab, "Default notify mechanism: ", value.getDefaultNotifyMechanism( ), "\n" );

      PrintTimestamp( indent + tab, "Connection Time: ", value.getConnectionTime( ) );

      PrintNewLine( ); 
   }



   public static void PrintUserInfoList( String indent, String header, UserInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null UserInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintUserInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }



   public static void PrintIntegerLimitInfo( String indent, String header, IntegerLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null IntegerLimitInfo.....", "\n" );  
         return;
      }

      PrintLong( indent + tab, "High Range: ", value.getHighRange( ), "\n" );
      PrintLong( indent + tab, "Low Range : ", value.getLowRange( ), "\n" );

      PrintNewLine( ); 
   }



   public static void PrintRealLimitInfo( String indent, String header, RealLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null RealLimits Info", "\n" );  
         return;
      }

      PrintHeader( indent + tab, "High Range: " + value.getHighRange( ), "\n" );
      PrintHeader( indent + tab, "Low  Range: " + value.getLowRange( ), "\n" );

      PrintInt( indent + tab, "Precision: ", value.getPrecision( ), "\n" );
      PrintNewLine( ); 
   }



   public static void PrintCharLimitInfo( String indent, String header, CharLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null Char Limit Info", "\n" );  
         return;
      }

      PrintInt( indent + tab,"Maximum length: ", value.getMaxLength( ), "\n" );

      PrintInt( indent + tab,"Menu style: ", value.getMenuStyle( ), "\n" );

      PrintInt( indent + tab,"QBE match operation: ", value.getQBEMatch( ), "\n" );

      PrintInt( indent + tab,"FullText Options:", value.getFullTextOption( ), "\n" );

      PrintString( indent + tab,"Character menu:", value.getCharMenu( ).toString( ), "\n" );

      PrintString( indent + tab,"Pattern:", value.getPattern( ), "\n" );

      PrintNewLine( ); 
   }

   public static void PrintDiaryLimitInfo( String indent, String header, DiaryLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null Diary Limit Info....", "\n" );  
         return;
      }

      PrintInt( indent + tab,"FullText Options:", value.getFullTextOption( ), "\n" );

      PrintNewLine( ); 
   }

   public static void PrintAttachmentLimitInfo( String indent, String header, AttachmentLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null AttachmentLimitInfo....", "\n" );  
         return;
      }

      PrintLong( indent + tab,"Maximum Size: ", value.getMaxSize( ), "\n" );

      PrintInt( indent + tab,"Attachment Type: ", value.getAttachType( ), "\n" );

      PrintNewLine( ); 
   }


   public static void PrintTableLimitInfo( String indent, String header, TableLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null TableLimitInfo...", "\n" );  
         return;
      }

      PrintString( indent + tab, "Schema: ", value.getSchema( ).toString( ), "\n" );

      PrintString( indent + tab, "Server: ", value.getServer( ).toString( ), "\n" );

      PrintQualifierInfo( indent + tab, "Qualifier: ", value.getQualifier( ) );

      PrintInt( indent + tab, "numColumns: ", value.getColumnCount( ), "\n" );

      PrintInt( indent + tab, "MaxRetrieve: ", value.getMaxRetrieve( ), "\n" );

      PrintNewLine( ); 
   }


   public static void PrintColumnLimitInfo( String indent, String header, ColumnLimitInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ColumnLimitInfo....", "\n" );  
         return;
      }

      PrintInt( indent + tab, "Column Length: ", value.getColumnLength( ), "\n" );

      PrintLong( indent + tab, "Parent (Field ID ): ", value.getParent( ).getValue( ), "\n" );

      PrintLong( indent + tab, "Data Field: ", value.getDataField( ).getValue( ), "\n" );

      PrintNewLine( ); 
   }


   public static void PrintDecimalLimitInfo( String indent, String header, DecimalLimitInfo value  )
   {        
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null DecimalLimitInfo...", "\n" );  
         return;
      }

      PrintHeader( indent + tab, "Low Range: " + value.getLowRange( ), "\n" );

      PrintHeader( indent + tab, "High Range: " + value.getHighRange( ), "\n" );

      PrintInt( indent + tab, "Precision: ", value.getPrecision( ), "\n" );

      PrintNewLine( ); 
   }


        
   public static void PrintCharMenuQueryInfo( String indent, String header, CharMenuQueryInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null CharMenuQueryInfo....", "\n" );  
         return;
      }

      PrintString( indent + tab, "Schema name: ", value.getSchema( ).toString( ), "\n" );

      PrintString( indent + tab, "Server name: ", value.getServer( ).toString( ), "\n" );

      PrintString( indent + tab, "Label Field Id: ", "", "");
      FieldID[] labelField = value.getLabelField();
      for (int i = 0; i < labelField.length; i ++)
      {
         PrintString(labelField[i].toString());
         PrintString(" ");
      }
      PrintString("\n");

      PrintLong( indent + tab, "Value Field Id: ", value.getValueField( ).getValue( ), "\n" );

      PrintBoolean( indent + tab, "Sort on Label: ", value.getSortOnLabel( ), "\n" );

      PrintQualifierInfo( indent + tab, "Qualifier: ", value.getQualification( ) );

      PrintNewLine( );
   }


   public static void PrintCharMenuSQLInfo( String indent, String header, CharMenuSQLInfo value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null CharMenuSQLInfo....", "\n" );  
         return;
      }

      PrintString( indent + tab, "Server name: ", value.getServer( ).toString( ), "\n" );

      PrintString( indent + tab, "Label Index: ", "", "");
      int[] LabelIndex = value.getLabelIndex();
      for (int i = 0; i < LabelIndex.length; i ++)
      {
         if (LabelIndex[i] != 0)
         {
            DriverPrintInt(LabelIndex[i]);
            PrintString(" ");
         }            
      }
      PrintString("\n");

      PrintInt( indent + tab, "Value Index: ", value.getValueIndex( ), "\n" );

      PrintString( indent + tab, "SQL Command: ", value.getSQLCommand( ), "\n" );
          
      PrintNewLine( );
   }
           
   public static void PrintCharMenuDDInfo( String indent, String header, CharMenuDDInfo value )
   {
      PrintHeader( indent, header, "\n" );
      if( value == null )
      {
         PrintHeader( indent + tab, " Null CharMenuDDInfo....", "\n" );  
         return;
      }

      PrintString( indent + tab, "Server name: ", value.getServer( ).toString( ), "\n" );
      PrintInt( indent + tab, "Name Type: ", value.getNameType( ), "\n" );
      PrintInt( indent + tab, "Value Format: ", value.getValueFormat( ), "\n" );

      int structType = value.getStructType( );
      PrintInt( indent + tab, "Struct Type: ", structType, "\n" );        
      switch (structType)
      {
         case Constants.AR_CHAR_MENU_DD_NONE:
               break;
         case Constants.AR_CHAR_MENU_DD_FORM:
               PrintInt(indent + tab, "Schema Type: ", ((CharMenuDDFormInfo)value).getSchemaType( ), "\n" );
               PrintBoolean(indent + tab, "Include Hidden: ", ((CharMenuDDFormInfo)value).getIncludeHidden( ), "\n" );
               break;
         case Constants.AR_CHAR_MENU_DD_FIELD:
               PrintInt(indent + tab, "Field Type: ", ((CharMenuDDFieldInfo)value).getFieldType( ), "\n" );
               PrintString( indent + tab, "Schema name: ", ((CharMenuDDFieldInfo)value).getSchema().toString(), "\n");
               break;
         default:
               PrintString( indent + tab + "Invalid struct type : " + structType + "\n" );
               break;
      } 
      PrintNewLine( );
   }

   public static void PrintCharMenuItemInfo( String indent, String header, CharMenuItemInfo value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Char Menu list Info..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Type: ", value.getType( ), "\n" );
           
      PrintString( indent + tab, "Label: ", value.getLabel( ).toString( ), "\n" );

      switch( value.getType( ) )
      {
         case 1: String menuItem = ( String ) value.getContents( );
                  PrintString( indent + tab, "Menu Item: ", menuItem, "\n" );
                  break;

         case 2: 
                  CharMenuInfo childMenu = ( CharMenuInfo ) value.getContents( );
                  switch( childMenu.getMenuType( ) )
                  {
                     case Constants.AR_CHAR_MENU_LIST: 
                           PrintCharMenuListInfo( indent + tab, null, ( CharMenuListInfo ) childMenu );     
                           break;

                     case Constants.AR_CHAR_MENU_QUERY: 
                           PrintCharMenuQueryInfo( indent + tab, null, ( CharMenuQueryInfo ) childMenu );
                           break;

                     case Constants.AR_CHAR_MENU_FILE: 
                           PrintCharMenuFileInfo( indent + tab, null, ( CharMenuFileInfo ) childMenu );
                           break;

                     case Constants.AR_CHAR_MENU_SQL: 
                           PrintCharMenuSQLInfo( indent + tab, null, ( CharMenuSQLInfo ) childMenu );
                           break;

                     case Constants.AR_CHAR_MENU_DATA_DICTIONARY:
                           PrintCharMenuDDInfo( indent + tab, null, (CharMenuDDInfo) childMenu);
                           break;
                                  
                     default: 
                           PrintString( indent + tab + "Invalid child menu type : " + childMenu.getMenuType( ) + "\n" );
                           break;
                  }
                  break;

         default : PrintString( indent + tab + "Invalid Menu Type : " + value.getType( ) + "\n" );
                     break;
      }           
      PrintNewLine( );
   }


   public static void PrintCharMenuInfo( String indent, String header, CharMenuInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null CharMenuInfo..", "\n" );
         return;
      }
                
      int menuType = value.getMenuType();
      PrintInt( indent + tab, "Menu Type: ", menuType, "\n" );

      switch( menuType)
      {

         case Constants.AR_CHAR_MENU_LIST: 
               PrintCharMenuListInfo( indent + tab, null, ( CharMenuListInfo ) value );
               break;

         case Constants.AR_CHAR_MENU_QUERY: 
               PrintCharMenuQueryInfo( indent + tab, null, ( CharMenuQueryInfo ) value );
               break;

         case Constants.AR_CHAR_MENU_FILE: 
               PrintCharMenuFileInfo( indent + tab, null, ( CharMenuFileInfo ) value );
               break;

         case Constants.AR_CHAR_MENU_SQL: 
               PrintCharMenuSQLInfo( indent + tab, null, ( CharMenuSQLInfo ) value );
               break;

         case Constants.AR_CHAR_MENU_DATA_DICTIONARY:
               PrintCharMenuDDInfo( indent + tab, null, ( CharMenuDDInfo ) value );
               break;

         default: 
               PrintString( indent + tab + "Invalid child menu type : " + menuType + "\n" );
               break;
      }
      PrintNewLine( );        
   }

   public static void PrintCharMenuItemInfoList( String indent, String header, CharMenuItemInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null CharMenuItemInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintCharMenuItemInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( );         
   }

   public static void PrintCharMenuListInfo(String indent, String header, CharMenuListInfo value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Char Menu list Info..", "\n" );
         return;
      }
      PrintCharMenuItemInfoList( indent + tab, "Char Menu List : ", value.getItems( ) );

      PrintNewLine( );
   }

   public static void PrintCharMenuFileInfo(String indent, String header, CharMenuFileInfo value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Char Menu File Info..", "\n" );
         return;
      }
               
      PrintInt( indent + tab, "File Location: ", value.getLocation( ), "\n" );

      if( value.getFileName( ) != null )
      {
         PrintString( indent + tab, "File Name: ", value.getFileName( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "File Name: ", "Null", "\n" );
      }

      PrintNewLine( );
   }

   public static void PrintMenu( String indent, String header, Menu menu )
   {
      if( menu == null )
      {
         PrintString( indent + header + ": Null Menu\n" );
         return;
      }

      if( menu.getName( ) != null )
      {
         PrintString( indent + tab + "Menu name : " + menu.getName( ).toString( ) + "\n" );
      }

      PrintString( indent + tab + "Refresh Code: " + menu.getRefreshCode( ) + "\n" );

      PrintCharMenuInfo( indent + tab, "Menu Information: ", menu.getMenuDefinition( ) );

      if( menu.getHelpText( ) != null )
      {
         PrintString( indent + tab, "Help Text: ", menu.getHelpText( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Help Text: <null>" + "\n" );
      }

      if( menu.getOwner( ) != null )
      {
         PrintString( indent + tab, "Owner: ", menu.getOwner( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Owner: null" + "\n" );
      }

      if( menu.getLastChangedBy( ) != null )
      {
         PrintString( indent + tab + "Last Changed: " + menu.getLastChangedBy().toString( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Changed: <null>"  + "\n" );
      }
      PrintString( indent + tab + "Last Update Time:" +  menu.getLastUpdateTime( ).getValue( ) + "\n" );

      if( menu.getDiary( ) != null )
      {
         PrintDiaryString( indent + tab, "Change Diary: ", menu.getDiary( )  );
      }
      else
      {
         PrintString( indent + tab + "Change Diary: null " + "\n" );
      }
               
      PrintPropInfoList( indent + tab, "Properties: ", menu.getProperties( ) );

      PrintNewLine( );
   }

   public static void PrintMenuList( String indent, String header, Menu[] menuList )
   {
      PrintHeader( indent, header, "\n" );

      if( menuList == null )
      {
         PrintHeader( indent + tab, "Null Menu list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", menuList.length, "\n" );      

      for( int i = 0; i < menuList.length; i++ )
      {
         PrintMenu( indent + tab, null, menuList[i] );
      }

      PrintNewLine( );         
   }

   public static void PrintServerInfo( String indent, String header, ServerInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null Server Info....", "\n" );  
         return;
      }
               
      PrintInt( indent + tab, "Operation: ", value.getOperation( ), "\n" );

      PrintValue( indent + tab, "Value: ", value.getValue( ) );

      PrintNewLine( );
   }


   public static void PrintServerInfoList( String indent, String header, ServerInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null ServerInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintServerInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }

        
   public static void PrintProcessResult( String indent, String header, ProcessResult result )
   {
      PrintHeader( indent, header, "\n" );

      if( result == null )
      {
         PrintHeader( indent + tab, " Process Result is null....", "\n" );  
         return;
      }
               
      PrintInt( indent + tab, "Operation Status: ", result.getStatus( ), "\n" );

      PrintString( indent + tab, "Process Output: ", result.getOutput( ), "\n" );

      PrintNewLine( );
   }



   public static void PrintFullTextInfo( String indent, String header, FullTextInfo value )
   {
      PrintHeader( indent, header, "\n" );

      PrintInt( indent + tab, "Text Info Type: ", value.getInfoType( ), "\n" );
      PrintValueList( indent + tab, "Value : ", value.getValue( ) );
             
      PrintNewLine( );
   }



   public static void PrintFullTextInfoList( String indent, String header, FullTextInfo[] value )
   {

      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null FullTextInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintFullTextInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }


   public static void PrintFieldMappingInfo( String indent, String header, FieldMappingInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null FieldMappingInfo.....", "\n" );  
         return;
      }

      switch( value.getFieldType( ) )
      {
         case 0       :  PrintHeader( indent + tab, "Field Type : NONE", "\n" );
                           break;
         case 1       :  PrintHeader( indent + tab, "Field Type : REGULAR", "\n" );
                           break;
         case 2       :  PrintHeader( indent + tab, "Field Type : JOIN", "\n" );
                           JoinMappingInfo joinMap = (JoinMappingInfo) value;
                           FieldID id = joinMap.getFieldID( );
                           PrintInt( indent + tab, "Schema Index : ", joinMap.getIndex( ), "\n");
                           PrintLong( indent + tab, "Field ID     : ", id.getValue( ), "\n" );
                           break;
         case 3       :  PrintHeader( indent + tab, "Field Type : VIEW", "\n" );
                           ViewMappingInfo viewMap = (ViewMappingInfo) value;
                           NameID viewFieldName = viewMap.getFieldName( );
                           PrintString( indent + tab, "Field Name : ", viewFieldName.toString( ), "\n" );
                           break;
         case 4       :  PrintHeader( indent + tab, "Field Type : VENDOR", "\n" );
                           VendorMappingInfo vendorMap = (VendorMappingInfo) value;
                           NameID vendorFieldName = vendorMap.getFieldName( );
                           PrintString( indent + tab, "Field Name : ", vendorFieldName.toString( ), "\n" );
                           break;
         default: PrintInt( indent + tab, " Field Type: bad type - ", value.getFieldType( ), "\n" );
                     break;
      }

      PrintNewLine( );
   }


   public static void PrintFieldMappingInfoList( String indent, String header, FieldMappingInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Field MappingInfo list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintFieldMappingInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }

   public static void PrintContainerType( String indent, String header, ContainerType value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ContainerType....", "\n" );  
         return;
      }
      PrintInt( indent + tab, "Container Type: ", value.toInt( ), "\n" );     

      PrintNewLine( );
   }


   public static void PrintContainerKey( String indent, String header, ContainerKey value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ContainerKey....", "\n" );  
         return;
      }
      PrintString( indent + tab, "Name: ", value.toString( ), "\n" );     

      PrintNewLine( );
   }

   public static void PrintContainer( String indent, String header, Container value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null Container....", "\n" );  
         return;
      }

      if( value.getName( ) != null )
      {
         PrintString( indent + tab, "Container Name: ", value.getName( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Container Name: <null>" + "\n" );
      }

      if( value.getLabel( ) != null )
      {
         PrintString( indent + tab, "Label: ", new String( value.getLabel( ) ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Container Label:<null> " + "\n" );

      }
            
      if( value.getDescription( ) != null )
      {
         PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Container Description:<null> " + "\n" );
      }

      PrintPermissionInfoList( indent, "Permission List:", value.getPermissions( ) );
             
      PrintInternalIDList( indent, "Sub Admin Group List: ", value.getAdminGroupList( ) );

      PrintBoolean( indent + tab, "Remove Flag: ", value.getRemoveFlag( ), "\n" );

      PrintContainerOwnerList( indent + tab, "Container Owner: ", value.getContainerOwner( ) );

      PrintContainerType( "", "", value.getType( ) );

      if( value.getHelpText( ) != null )
      {
         PrintString( indent + tab, "Help Text: ", value.getHelpText( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "HelpText: <null>" + "\n" );
      }

      if( value.getOwner( ) != null )
      {
         PrintString( indent + tab, "Owner: ", value.getOwner( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Owner: null" + "\n" );
      }

      if( value.getLastChangedBy( ) != null )
      {
         PrintString( indent + tab + "Last Changed: " + value.getLastChangedBy().toString( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Changed: <null>"  + "\n" );
      }
      PrintString( indent + tab + "Last Update Time:" +  value.getLastUpdateTime( ).getValue( ) + "\n" );

      if( value.getDiary( ) != null )
      {
         PrintDiaryString( indent + tab, "Change Diary: ", value.getDiary( ) );
      }
      else
      {
         PrintString( indent + tab + "Change Diary: null " + "\n" );
      }
               

      PrintPropInfoList( indent + tab, "Properties List: ", value.getProperties( ) );

      PrintReferenceBaseList( indent + tab, "Reference Base List: ", value.getReferences( ) );

      PrintNewLine( );
   }

   public static void PrintContainerList( String indent, String header, Container[] containerList )
   {
      PrintHeader( indent, header, "\n" );

      if( containerList == null )
      {
         PrintHeader( indent + tab, "No Containers...", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Containers: ", containerList.length, "\n" );      

      for( int i = 0; i < containerList.length; i++ )
      {
         PrintContainer( indent + tab, "Container " + i + ":", containerList[i] );
      }

      PrintNewLine( ); 
   }



   public static void PrintContainerOwner( String indent, String header, ContainerOwner value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ContainerOwner....", "\n" );  
         return;
      }

      PrintInt( indent + tab, "Owner Type: ", value.getType( ), "\n" );

      PrintString( indent + tab, "Owner Name: ", value.getName( ).toString( ), "\n" );
             
      PrintNewLine( );
   }


   public static void PrintContainerOwnerList( String indent, String header, ContainerOwner[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ContainerOwner[]....", "\n" );  
         return;
      }

      for( int i = 0; i < value.length; i++ )
      {
         PrintContainerOwner( indent + tab, "Container Owner" + i + ":", value[i] );
      }

      PrintNewLine( );
   }


   public static void PrintReferenceBase( String indent, String header, ReferenceBase value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null ReferenceBase....", "\n" );  
         return;
      }     
        
      if( value.getDataType( ) == ReferenceBase.SYSTEM_REFERENCE )
      {
         PrintReferenceInfo( indent, "Reference Info:", ( ReferenceInfo )value );
      }
      else if( value.getDataType( ) == ReferenceBase.EXTERNAL_REFERENCE )
      {
         PrintExternalReferenceInfo( indent, "External Reference Info:", ( ExternalReferenceInfo )value );
      }
      else
      {
         PrintString( indent + "Unknown Reference Info ( " + value.getDataType( ) + " )" + "\n" );
      }
               
      PrintNewLine( );
   }

   public static void PrintReferenceBaseList( String indent, String header, ReferenceBase[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Reference Base list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintReferenceBase( indent + tab, null, value[i] );
      }

      PrintNewLine( );  
   }

   public static void PrintReferenceType( String indent, String header, ReferenceType value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ReferenceType....", "\n" );  
         return;
      }

      switch( value.toInt( ) )
      {
         case 0       :  PrintHeader( indent + tab, "Type: NONE", "\n" );
                           break;

         case 1       :  PrintHeader( indent + tab, "Type: ALL", "\n" );
                           break;

         case 2       :  PrintHeader( indent + tab, "Type: SCHEMA", "\n" );
                           break;

         case 3       :  PrintHeader( indent + tab, "Type: FILTER", "\n" );
                           break;

         case 4       :  PrintHeader( indent + tab, "Type: ESCALATION", "\n" );
                           break;

         case 5       :  PrintHeader( indent + tab, "Type: ACTIVELINK", "\n" );
                           break;
            
         case 6       :  PrintHeader( indent + tab, "Type: CONTAINER", "\n" );
                           break;

         case 7       :  PrintHeader( indent + tab, "Type: CHAR_MENU", "\n" );
                           break;

         case 32788   :  PrintHeader( indent + tab, "Type: APPLICATION_HAS_EXT_HELP", "\n" );
                           break;

         case 32787   :  PrintHeader( indent + tab, "Type: DISTMAPPING_DATA", "\n" );
                           break;

         case 32786   :  PrintHeader( indent + tab, "Type: GROUP_DATA", "\n" );
                           break;

         case 32785   :  PrintHeader( indent + tab, "Type: PACKINGLIST_PACK", "\n" );
                           break;

         case 32784   :  PrintHeader( indent + tab, "Type: PACKINGLIST_APP", "\n" );
                           break;

         case 32783   :  PrintHeader( indent + tab, "Type: PACKINGLIST_GUIDE", "\n" );
                           break;
                                  
         case 32782   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_FILE_NAME", "\n" );
                           break;

         case 32781   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_INDEX_FILE", "\n" );
                           break;

         case 32780   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_INDEX_EXT", "\n" );
                           break;

         case 32779   :  PrintHeader( indent + tab, "Type: APPLICATION_DISABLE_BEGIN_TASK", "\n" );
                           break;

         case 32778   :  PrintHeader( indent + tab, "Type: APPLICATION_FORM_VUI", "\n" );
                           break;

         case 32777   :  PrintHeader( indent + tab, "Type: APPLICATION_PRIMARY_FORM", "\n" ) ;
                           break;

         case 32776   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_FILE", "\n" );
                           break;
        
         case 32775   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_EXT", "\n" );
                           break;
         
         case 32774   :  PrintHeader( indent + tab, "Type: NULL_STRING", "\n" );
                           break;

         case 32773   :  PrintHeader( indent + tab, "Type: ABOUT_BOX_FORM", "\n" );
                           break;

         case 32772   :  PrintHeader( indent + tab, "Type: ABOUT_BOX_IMAGE", "\n" );
                           break;

         case 32771   :  PrintHeader( indent + tab, "Type: APPLICATION_FORMS", "\n" );
                           break;

         case 32770   :  PrintHeader( indent + tab, "Type: MAXIMIZE_FORMS", "\n" );
                           break;

         case 32768   :  PrintHeader( indent + tab, "Type: ICON", "\n" );
                           break;

         case 32769   :  PrintHeader( indent + tab, "Type: SMALL_ICON", "\n" );
                           break;


         default: PrintInt( indent + tab, " Type: bad referencetype - ", value.toInt( ), "\n" );
                     break;
       	     
   }       
   }

   public static void PrintReferenceInfo( String indent, String header, ReferenceInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, " Null ReferenceInfo....", "\n" );  
         return;
      }

      PrintString( indent + tab, "Name: ", value.getName( ).toString( ), "\n" );

      PrintString( indent + tab, "Label: ", new String( value.getLabel( ) ), "\n" );

      PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );

      PrintInt( indent + tab, "Data Type: ", value.getDataType( ), "\n" );
             
      PrintReferenceType( indent + tab, "Reference Type : ",value.getReferenceType( ) );

      PrintNewLine( );
   }



   public static void PrintExternalReferenceInfo( String indent, String header, ExternalReferenceInfo value )
   {

      PrintHeader( indent, header, "\n" );


      if( value == null )
      {
         PrintHeader( indent + tab, " Null ExternalReferenceInfo....", "\n" );  
         return;
      }

      PrintInternalIDList( indent, "Admin Group List: ", value.getAdminGroupList( ) );

      PrintValue( indent, "Value: ", value.getValue( ) );

      PrintString( indent + tab, "Label: ", new String( value.getLabel( ) ), "\n" );

      PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );

      PrintInt( indent + tab, "Data Type: ", value.getDataType( ), "\n" );
             
      PrintReferenceType( indent + tab, "Reference Type : ",value.getReferenceType( ) );

      PrintNewLine( );
   }



   public static void PrintReferenceInfoList( String indent, String header, ReferenceInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null Reference list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );      

      for( int i = 0; i < value.length; i++ )
      {
         PrintReferenceInfo( indent + tab, null, value[i] );
      }

      PrintNewLine( ); 
   }

           

   public static void PrintReturnCode( String indent, int returnCode )
   {
      PrintHeader( indent + tab, "ReturnCode:  ", "\n" );

      switch( returnCode )
      {
         case 0        :
               PrintHeader(indent + tab, "OK", "\n" );
               break;

         case 1    :
               PrintHeader( indent + tab, "WARNING", "\n" );
               break;

         case 2      :
               PrintHeader( indent + tab, "ERROR", "\n" ) ;
               break;

         case 3      :
               PrintHeader( indent + tab, "FATAL", "\n" );
               break;

         case 4 :
               PrintHeader( indent + tab, "BAD STATUS", "\n" );
               break;

         default                   :
               PrintInt( indent + tab, "<unknown return> : ", returnCode, "\n");
               break;
      }
   }

   public static void PrintVUIID( String indent, String header, FieldID id )
   {

      if( id != null )
      {
         PrintLong( indent, "VUI ID: ", id.getValue( ), "\n" );
      }
      else
      {
         PrintString( indent + "VUI ID: <null>" + "\n" );    
      }
   }

   public static void PrintView( String indent, String header, View view )
   {
      PrintHeader( indent, header, "\n" );

      if( view == null )
      {
         PrintHeader( indent + tab, "Null View..", "\n" );
         return;
      }
      if( view.getName( ) != null )
      {
         PrintString( indent + tab, "View name: ", view.getName( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "View name: <null>" + "\n" );
      }
               
      if (view.getLocale() != null)
         PrintString( indent + tab, "Locale: ", view.getLocale( ), "\n" );
      else
         PrintString( indent + tab + "Locale: <null>" + "\n" );
                   
      PrintLong( indent + tab, "Vui-type: ", view.getVUIType(), "\n" );        

      PrintPropInfoList( indent + tab, "Display Properties List: ", view.getDisplayProperties( ) );  
             
      if( view.getHelpText( ) != null )
      {
         PrintString( indent + tab, "Help Text: ", view.getHelpText( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Help Text: <null>" + "\n" );
      }
      if( view.getLastUpdateTime( ) == null )
      {
         PrintString( indent + tab + "Last Update Time: <null>" + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Update Time:" +  view.getLastUpdateTime( ).getValue( ) + "\n" );
      }
      if( view.getOwner( ) != null )
      {
         PrintString( indent + tab, "Owner: ", view.getOwner( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Owner: null" + "\n" );
      }

      if( view.getLastChangedBy( ) != null )
      {
         PrintString( indent + tab + "Last Changed: " + view.getLastChangedBy().toString( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Changed: <null>"  + "\n" );
      }

      if( view.getDiary( ) != null )
      {
         PrintDiaryString( indent + tab, "Change Diary: ", view.getDiary( ) );
      }
      else
      {
         PrintString( indent + tab + "Change Diary: null " + "\n" );
      }  
               
      PrintNewLine( );      

   }

   public static void PrintViewList( String indent, String header, View[] viewList )
   {
      PrintHeader( indent, header, "\n" );

      if( viewList == null )
      {
         PrintHeader( indent + tab, "Null View list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Views: ", viewList.length, "\n" );      

      for( int i = 0; i < viewList.length; i++ )
      {
         PrintView( indent + tab, "View (" + i + ") :", viewList[i] );
      }

      PrintNewLine( ); 
   }

   public static void PrintFilter(  String indent, String header, Filter filter )
   {
      PrintHeader( indent, header, "\n" );

      if( filter == null )
      {
         PrintHeader( indent + tab, "Null Filter...", "\n" );
         return;
      }
         
      if( filter.getName( ) != null )
      {
         PrintString( indent + tab, "Name: ", filter.getName( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "Name: <null>", "", "\n" );
      }

      PrintLong( indent + tab, "Order: ", filter.getOrder( ), "\n" );
               
      // Print Workflow information
         PrintWorkflowConnectInfo( indent + tab, "Work flow information:", filter.getWorkflowConnect( ) );


      PrintLong( indent + tab, "Operation bit bitmask: ", filter.getOpSet( ), "\n" );

      PrintLong( indent + tab, "Enable flag: ", filter.getEnable( ), "\n" );

      // Print Qualifier
         PrintQualifierInfo( indent + tab, "", filter.getQualifier( ) );

      // Print Active Link action list
         PrintFilterActionInfoList( indent + tab, "Filter Action List:", filter.getActionList( ) );

      // Print Active Link else action list
         PrintFilterActionInfoList( indent + tab, "Filter Action else list:", filter.getElseList( ) );

      if( filter.getHelpText( ) != null )
      {
         PrintString( indent + tab, "Help Text: ", filter.getHelpText( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "HelpText: <null>" + "\n" );
      }
        
      if( filter.getLastUpdateTime( ) != null )
      {
         PrintString( indent + tab + "Last Update Time:" +  filter.getLastUpdateTime( ).getValue( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Update Time: <null>" + "\n" );
      }

      if( filter.getOwner( ) != null )
      {
         PrintString( indent + tab, "Owner: ", filter.getOwner( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Owner: null" + "\n" );
      }

      if( filter.getLastChangedBy( ) != null )
      {
         PrintString( indent + tab + "Last Changed: " + filter.getLastChangedBy().toString( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Changed: <null>"  + "\n" );
      }

      if( filter.getDiary( ) != null )
      {
         PrintDiaryString( indent + tab, "Change Diary: ", filter.getDiary( ) );
      }
      else
      {
         PrintString( indent + tab + "Change Diary: null " + "\n" );
      }
               

      PrintPropInfoList( indent + tab, "Properties List: ", filter.getObjPropList( ) );

      PrintNewLine( ); 
   }

   public static void PrintFilterList( String indent, String header, Filter[] filterList )
   {
      PrintHeader( indent, header, "\n" );

      if( filterList == null )
      {
         PrintHeader( indent + tab, "Null Filter list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Filters: ", filterList.length, "\n" );      

      for( int i = 0; i < filterList.length; i++ )
      {
         PrintFilter( indent + tab, "Filter " + i + " :", filterList[i] );
      }

      PrintNewLine( ); 
   }

   public static void PrintEscalation(  String indent, String header, Escalation escalation )
   {
      PrintHeader( indent, header, "\n" );

      if( escalation == null )
      {
         PrintHeader( indent + tab, "Null Escalation...", "\n" );
         return;
      }
         
      if( escalation.getName( ) != null )
      {
         PrintString( indent + tab, "Name: ", escalation.getName( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "Name: <null>", "", "\n" );
      }

      PrintEscalationTmInfo( indent + tab, "Escalation Time Information: ", escalation.getEscalationTm( ) );
               
      // Print Workflow information
         PrintWorkflowConnectInfo( indent + tab, "Work flow information:", escalation.getWorkflowConnect( ) );

      PrintLong( indent + tab, "Enable flag: ", escalation.getEnable( ), "\n" );

      // Print Qualifier
         PrintQualifierInfo( indent + tab, "", escalation.getQualifier( ) );

      // Print action list
         PrintFilterActionInfoList( indent + tab, "Filter Action List:", escalation.getActionList( ) );

      // Print Active Link else action list
         PrintFilterActionInfoList( indent + tab, "Filter Action else list:", escalation.getElseList( ) );

      if( escalation.getHelpText( ) != null )
      {
         PrintString( indent + tab, "Help Text: ", escalation.getHelpText( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "HelpText: <null>" + "\n" );
      }
        
      if( escalation.getLastUpdateTime( ) != null )
      {
         PrintString( indent + tab + "Last Update Time:" +  escalation.getLastUpdateTime( ).getValue( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Update Time: <null>" + "\n" );
      }

      if( escalation.getOwner( ) != null )
      {
         PrintString( indent + tab, "Owner: ", escalation.getOwner( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab + "Owner: null" + "\n" );
      }

      if( escalation.getLastChangedBy( ) != null )
      {
         PrintString( indent + tab + "Last Changed: " + escalation.getLastChangedBy().toString( ) + "\n" );
      }
      else
      {
         PrintString( indent + tab + "Last Changed: <null>"  + "\n" );
      }

      if( escalation.getDiary( ) != null )
      {
         PrintDiaryString( indent + tab, "Change Diary: ", escalation.getDiary( ) );
      }
      else
      {
         PrintString( indent + tab + "Change Diary: null " + "\n" );
      }
               

      PrintPropInfoList( indent + tab, "Properties List: ", escalation.getObjPropList( ) );

      PrintNewLine( ); 
   }

   public static void PrintEscalationList( String indent, String header, Escalation[] escalationList )
   {
      PrintHeader( indent, header, "\n" );

      if( escalationList == null )
      {
         PrintHeader( indent + tab, "Null Escalation list..", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of Escalations: ", escalationList.length, "\n" );      

      for( int i = 0; i < escalationList.length; i++ )
      {
         PrintEscalation( indent + tab, "Escalation " + i + " :", escalationList[i] );
      }

      PrintNewLine( ); 
   }


   public static void PrintDayInfo( String indent, String header, DayInfo dateInfo )
   {
      PrintHeader( indent, header, "\n" );

      if( dateInfo == null )
      {
         PrintHeader( indent + tab, " Null DayInfo....", "\n" );  
         return;
      }

      PrintLong( indent + tab, "Hour Mask: ", dateInfo.getHourmask( ), "\n" );

      PrintLong( indent + tab, "Minutes: ", dateInfo.getMinute( ), "\n" );

      PrintLong( indent + tab, "Month day: ", dateInfo.getMonthday( ), "\n" );

      PrintLong( indent + tab, "Week day: ", dateInfo.getWeekday( ), "\n" );

      PrintNewLine( );
   }

   public static void PrintEscalationTmInfo( String indent, String header, EscalationTmInfo timeInfo )
   {
      PrintHeader( indent, header, "\n" );

      if( timeInfo == null )
      {
         PrintHeader( indent + tab, " Null EscalationTmInfo....", "\n" );  
         return;
      }

      if( timeInfo.getEscalationTmType( ) == Constants.AR_ESCALATION_TYPE_INTERVAL )
      {
         PrintLong( indent + tab, "Time Interval: ", timeInfo.getInterval( ), "\n" );
      }
      else if( timeInfo.getEscalationTmType( ) == Constants.AR_ESCALATION_TYPE_TIMEMARK )
      {
         PrintDayInfo( indent + tab, "Date Information:", timeInfo.getDate( ) );
      }
      else
      {
         PrintLong( indent + tab, "Wrong Time type: ", timeInfo.getEscalationTmType( ), "\n" );
      }

      PrintNewLine( );
   }


   public static void PrintSQLResult( String indent, String header, SQLResult result )
   {
      PrintHeader( indent, header, "\n" );

      if( result == null )
      {
         PrintHeader( indent + tab, "  SQLResult.... <null>", "\n" );  
         return;
      }
   PrintInt( indent + tab, "Number of Items: ", result.getTotalNumberOfMatches(), "\n" );
      Value valueListList[][] = result.getContents();
   for(int i = 0; i < valueListList.length; i++)
         PrintValueList( indent + tab, "ValueList " + i +": ", valueListList[i] );
      PrintNewLine( );
   }
   public static void PrintStatisticsResultInfo( String indent, String header, StatisticsResultInfo result )
   {
      PrintHeader( indent, header, "\n" );

      if( result == null )
      {
         PrintHeader( indent + tab, " Null StatisticsResultInfo....", "\n" );  
         return;
      }

               
      PrintNewLine( );
   }

   public static void PrintStatisticsResultInfoList( String indent, String header, StatisticsResultInfo[] list )
   {
      PrintHeader( indent, header, "\n" );

      if( list == null )
      {
         PrintHeader( indent + tab, " Null StatisticsResultInfo List....", "\n" );  
         return;
      }

      PrintInt( indent + tab, "Number of Items: ", list.length, "\n" );             

      for( int i = 0; i < list.length; i++ )
      {
         PrintStatisticsResultInfo( indent + tab, "StatisticsResultInfo " + i + " :", list[i] );
      }

      PrintNewLine( );
   }
   public static void PrintEntryList( String indent, String header, Entry[] entryList )
   {
      PrintHeader( indent, header, "\n" );

      if( entryList == null )
      {
         PrintHeader( indent + tab, " Null Entry List....", "\n" );  
         return;
      }

      PrintInt( indent + tab, "Number of Entries: ", entryList.length, "\n" ); 

      for( int i = 0; i < entryList.length;i++ ) 
      {
         if( entryList[i].isPresent( ) )
         {
               EntryID entryId = entryList[i].getKey().getEntryID();
               PrintEntryItemList( indent + tab, "Entry Items of entry Id " + entryId + " : ", 
                                 entryList[i].getEntryItems( ) );
         }
         else
         {
               PrintString( indent + tab, "Entry Id ", entryList[i].getEntryID().toString( ) + "  is not present", "\n" );
         }
         }
   }
   public static void PrintDiaryString( String indent, String header, String diaryString )
   {
      try{
      PrintHeader( indent, header, "\n" );

      if( diaryString == null )
      {
         PrintHeader( indent + tab, " Null DiaryString....", "\n" );  
         return;
      }

      Diary diary = new Diary( diaryString );
      DiaryInfo[] diaryList = diary.decode( JavaDriver.context );

      if( diaryList != null )
      {
         for( int i = 0; i < diaryList.length; i++ )
         {
               PrintHeader( indent, "Diary Item " + i + " :", "\n" );
               if( diaryList[i].getUser( ) != null )
               {
                  PrintString( indent + tab, "User: ", diaryList[i].getUser( ).toString( ), "\n" );
               }
               else
               {
                  PrintString( indent + tab, "Null User Name ID", "  ", "\n" );
               }
               PrintString( indent + tab, "Diary String: ", diaryList[i].getDiaryInfo( ), "\n" );
               PrintTimestamp( indent + tab, "Time stamp: ", diaryList[i].getTimestamp( ) );
               PrintNewLine( );
         }
      }

      PrintNewLine( );
      }
         
      catch( ARException e )
      {
         e.describe( );
      }   
   }

   public static void PrintSupportFileKey( String indent, String header, SupportFileKey key )
   {
      PrintHeader( indent, header, "\n" );

      if( key == null )
      {
         PrintHeader( indent + tab, " Null SupportFileKey...", "\n" );  
         return;
      }

      PrintLong( indent + tab, "File Type:", key.getFileType( ) , "\n" );

         NameID	name = key.getName();
         if( name != null )
         {
               PrintString( indent + tab, "Name ID: ", name.toString( ), "\n" );
         }
         else{
               PrintString( indent + tab, "Name ID: ", "null", "\n" );
         }

         PrintInternalID ( indent + tab, "Field ID: ", key.getFieldId());

         PrintInternalID ( indent + tab, "File ID: ", key.getFieldId());

      PrintNewLine( ); 
   }
           

   public static void PrintSupportFile(  String indent, String header, SupportFile supportFile )
   {
      PrintHeader( indent, header, "\n" );

      if( supportFile == null )
      {
         PrintHeader( indent + tab, "Null supportFile...", "\n" );
         return;
      }
         
      // Print SupportFileKey information
         PrintSupportFileKey( indent + tab, "Support File Key:", supportFile.getKey( ) );

      if( supportFile.getFilePath( ) != null )
      {
         PrintString( indent + tab, "FilePath: ", supportFile.getFilePath( ).toString( ), "\n" );
      }
      else
      {
         PrintString( indent + tab, "FilePath: <null>", "", "\n" );
      }

      PrintNewLine( ); 
   }


   public static void PrintSupportFileList(  String indent, String header, SupportFile[] SupportFileList )
   {
      PrintHeader( indent, header, "\n" );

      if( SupportFileList == null )
      {
         PrintHeader( indent + tab, "Null SupportFile list..", "\n" );
         return;
      }

      PrintInt( indent +tab,  "Number of Items : ", SupportFileList.length, "\n" ); 

      for( int i = 0; i < SupportFileList.length; i++ )
      {
         PrintSupportFile( indent + tab, "SupportFile Info:", SupportFileList[i] );
      }

      PrintNewLine( ); 
   }


   public static void PrintEntryID( String indent, String header,  EntryID value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null EntryID ", "\n" );
         return;
      }
              
               
      PrintString( indent + tab, "Entry ID: ", value.toString( ), "\n" );
               
      PrintNewLine( );
   }

   static void PrintSchema( String indent, String header, Schema schema )
   {
         PrintHeader( indent, header, "\n" );

         if( schema == null )
         {
               PrintHeader( indent + tab, "Schema is not present....", "\n" );
               return;
         }

         PrintString( "schema name is: " + schema.getName().toString( ) + "\n" );

         PermissionInfo[] permissionList = schema.getPermissions( );
         PrintPermissionInfoList( "", "Permission List: ", permissionList );

         InternalID[] admingrp = schema.getAdminGrpList( );
         PrintInternalIDList( "", "Sub Admin Group List :", admingrp );

         EntryListFieldInfo[] entrylist = schema.getEntryListFieldInfo();
         PrintEntryListFieldInfoList( "", "Entry List Field List: ", entrylist );

         SortInfo[] sort = schema.getSortInfo();
         PrintSortInfoList( "", "Sort List :", sort );

         IndexInfo[] index = schema.getIndexInfo();
         PrintIndexInfoList( "", "Index List : ", index );

         PrintString( "Help text: " + schema.getHelpText( )  + "\n" ); 

         PrintString( "Last update time: " + schema.getLastUpdateTime( ).getValue( )  + "\n" );

         AccessNameID owner = schema.getOwner();
         PrintString( "Owner: " + owner.toString( ) + "\n" );

         PrintString( "last changed by: " + schema.getLastChangedBy().toString() + "\n" );

         PropInfo[] props = schema.getProperties();
         PrintPropInfoList( "", "Prop List : ", props );
   }

   public static void PrintSchemaAliases(String indent, SchemaAliasInfo[] aliases)
   {
      PrintHeader(indent, "Schema Aliases:", "\n" );
               
      if (aliases == null )
      {
         PrintHeader(indent + tab,  " Null NameID/Alias list", "\n" );
         return;
      }
               
      PrintInt(indent + tab, "Number of Aliases: ", aliases.length, "\n" ); 
      for (int i = 0; i < aliases.length; i++ )
      {
         if (aliases[i] != null )
         {
               PrintString(indent + tab, "Name ID: ", aliases[i].getSchemaKey().toString( ), "\n" );
               PrintString(indent + tab, "Alias  : ", aliases[i].getAlias().toString( ), "\n" );
         }
         else{
               PrintString(indent + tab, "Name ID: ", "null", "\n" );
               PrintString(indent + tab, "Alias  : ", "null", "\n" );
         }
      }
      PrintNewLine( );
   }

   static void PrintFieldLimitInfo(String indent, String header, FieldLimitInfo limit)
   {
      PrintHeader(indent, header, "\n");
      if (limit == null)
      {
         PrintHeader(indent + tab, "Null Filed Limit info....", "\n");
         return;
      }
      PrintInt(indent + tab, "Limit Type: ", limit.getDataType(), "\n");
      switch(limit.getDataType())
      {
         case Constants.AR_DATA_TYPE_ENUM:
         EnumLimitInfo enumLimit = (EnumLimitInfo)limit;
         PrintNameIDList(indent, header, enumLimit.getEnumLimit());
         break;
         default:
         break;
      }
   }

   static void PrintField( String indent, String header, Field field )
   {
      PrintHeader( indent, header, "\n" );

      if( field == null )
      {
         PrintHeader( indent + tab, "Null Field....", "\n" );
         return;
      }
         // Print all the information
      NameID fieldName = field.getName( );
      PrintString( indent + tab, "Field Name: ", fieldName.toString( ), "\n" );
                             
      FieldMappingInfo mapInfo = field.getFieldMap( );
      PrintFieldMappingInfo( indent + tab, "FieldMapping:", mapInfo );

      DataType type = field.getDataType( );
      PrintDataType( tab, "DataType:", type );

      PrintInt( indent + tab, "Field Option: ", field.getFieldOption( ), "\n" );
                 
      PrintInt( indent + tab, "Field Create Mode: ", field.getCreateMode( ), "\n" );

      PrintValue( indent + tab, "Default Value: ", field.getDefaultValue( ) );

      PrintPermissionInfoList( indent + tab, "Permission List: ", field.getPermissions( ) );

      PrintFieldLimitInfo( indent + tab, "Field Limit Info: ", field.getFieldLimit());
                              
      PrintDisplayInstanceList( indent + tab, "Display Instance List: ", field.getDisplayInstance( ) );                                                     

      PrintString( indent + tab, "Help Text: ", field.getHelpText( ), "\n" );
                             
      PrintTimestamp( indent + tab, "Last changed: ", field.getLastUpdateTime( ) );

      PrintString( indent + tab, "Owner: ", field.getOwner( ).toString( ), "\n" );

      PrintString( indent + tab, "Diary: ", field.getDiary( ), "\n" );
   }

   static void PrintFieldList( String indent, String header, Field[] fieldList)
   {
      PrintHeader( indent, header, "\n" );
               
      if( fieldList == null )
      {
         PrintHeader( indent + tab,  " Null FieldAssign list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of field: ", fieldList.length, "\n" ); 
        
      for( int i = 0; i < fieldList.length; i++ )
      {
         PrintField( indent + tab, "Field Info: ", fieldList[i] );
      }
      PrintNewLine( );  
   }

   static void PrintCompoundSchemaInfo(String indent, String header,CompoundSchemaInfo schema)
   {
      PrintHeader(indent, header, "");
      if (schema == null)
      {
         PrintHeader(indent + tab, "CompoundSchemaInfo is NULL....", "\n");
         return;
      }
      switch (schema.getType() )
      {
         case Constants.AR_SCHEMA_NONE :
         PrintHeader( indent + tab, "None", "\n" );
         break;
         case Constants.AR_SCHEMA_REGULAR :
         PrintHeader( indent + tab, "REGULAR", "\n" );
         break;
         case Constants.AR_SCHEMA_DIALOG :
         PrintHeader( indent + tab, "DIALOG", "\n" );
         break;
         case Constants.AR_SCHEMA_JOIN :
         PrintHeader( indent + tab, "JOIN", "\n" );
         JoinSchemaInfo joinSchema = (JoinSchemaInfo)schema;
         PrintString( indent + tab, "  Join member A: ", joinSchema.getMemberA().toString(), "\n");
         PrintString( indent + tab, "  Join member B: ", joinSchema.getMemberB().toString(), "\n");
         PrintQualifierInfo( indent + tab, "  Join qualification", joinSchema.getJoinQualification() );
         PrintInt( indent + tab, "  Join option : ", joinSchema.getJoinOption(), "\n" );
         break;
         case Constants.AR_SCHEMA_VIEW :
         ViewSchemaInfo viewSchema = (ViewSchemaInfo)schema;
         PrintHeader( indent + tab, "VIEW" ,"");
         PrintString( indent + tab, "  View table name: ", (new String(viewSchema.getTableName() )).trim(), "");
         break;
         case Constants.AR_SCHEMA_VENDOR :
         VendorSchemaInfo vendorSchema = (VendorSchemaInfo)schema;
         PrintHeader( indent + tab, "VENDOR", "\n");
         PrintString( indent + tab, "  Vendor name: ", vendorSchema.getVendorName().toString(), "\n");
         PrintString( indent + tab, "  Vendor table name:", new String( vendorSchema.getTableName() ), "\n");
         break;
         default             :
         PrintInt( indent + tab, "  undefined schemaType: ", schema.getType(), "\n");
         break;
      }
   }

   static void PrintCompoundSchemaInfoList(String indent, String header, CompoundSchemaInfo[] schema)
   {
      PrintHeader(indent, header, "\n");
      if (schema == null)
      {
         PrintHeader(indent + tab, "CompoundSchemaInfo is NULL....", "\n");
         return;
      }
      PrintInt( indent + tab, "Number of schemas: ", schema.length, "\n" ); 
      for( int i = 0; i < schema.length; i++ )
      {
         PrintCompoundSchemaInfo( indent + tab, null, schema[i] );
      }
      }


   static void PrintAlertMessageInfo(String indent, String header, AlertMessageInfo message)
   {
      PrintHeader(indent, header, "\n");
      if (message == null)
      {
         PrintHeader(indent + tab, " NULL Message....", "\n");
         return;
      }
      PrintTimestamp( indent + tab, "Timestamp: ", message.getTimestamp() );
      PrintInt( indent + tab, "sourceType: ", message.getSourceType(), "\n" ); 
      PrintInt( indent + tab, "priority: ", message.getPriority() , "\n" );
      PrintString( indent + tab, "  alertText: ", message.getAlertText(), "\n");
      PrintString( indent + tab, "  sourceTag: ", message.getSourceTag(),"\n");
      PrintString( indent + tab, "  serverName: ", message.getServerName(), "\n");
      PrintString( indent + tab, "  formName : ", message.getFormName(), "\n");
      PrintString( indent + tab, "  objectId : ", message.getObjectId(), "\n");
      PrintNewLine( );
   }
   static void PrintExtFieldCandidatesInfo(String indent, ExtFieldCandidatesInfo result)
   {
      if (result == null)
      {
         PrintHeader(indent + tab, " NULL result....", "\n");
         return;
      }
      PrintFieldMappingInfo( indent + tab, "FieldMapping:", result.getFieldMappingInfo() );
      PrintFieldLimitInfo( indent + tab, "Field Limit Info: ", result.getFieldLimitInfo());
      PrintDataType( tab, "DataType:", result.getDataType() );
   }

   static void PrintExtFieldCandidatesInfoList(String indent, String header, ExtFieldCandidatesInfo[] result)
   {
      PrintHeader(indent, header, "\n");
      if (result == null)
      {
         PrintHeader(indent + tab, " NULL result....", "\n");
         return;
      }
      PrintInt( indent + tab, "Number of Candidates: ", result.length, "\n" ); 
      for( int i = 0; i < result.length; i++ )
      {
         PrintExtFieldCandidatesInfo( indent + tab, result[i] );
      }
      PrintNewLine( ); 
   }

   public static void PrintLicenseNameID( String indent, String header,  LicenseNameID value )
   {
      //   PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseNameID ", "\n" );
         return;
      }
               
      PrintString( indent + tab, header, value.toString( ), "\n" );
   }

   public static void PrintLicenseNameIDList( String indent, String header,  LicenseNameID[] value )
   {
      // PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseNameID list", "\n" );
         return;
      }
              
               
      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintString( indent + tab, header, value[i].toString( ), "\n" );
      }
      PrintNewLine( );
   }

   public static void PrintLicenseKeyID( String indent, String header,  LicenseKeyID value )
   {
      // PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseKeyID ", "\n" );
         return;
      }

      PrintString( indent + tab, header, value.toString( ), "\n" );
   }

   public static void PrintLicensKeyIDList( String indent, String header,  LicenseKeyID[] value )
   {
      //   PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseKeyID list", "\n" );
         return;
      }
              
               
      PrintInt( indent + tab, header, value.length, "\n" );
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintString( indent + tab, "License Key ID: ", value[i].toString( ), "\n" );
      }
      PrintNewLine( );
   }

   public static void PrintLicenseValidInfo( String indent, String header, LicenseValidInfo value )
   {
      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null LicenseValidInfo value...", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number Of Licenses: ", value.getNumLicenses(), "\n");
      PrintBoolean( indent + tab, "Is Demo: ", value.getIsDemo(), "\n");
      PrintInt( indent + tab, "Expire Date: month: ", value.getExpireDate().getMonth(), "\n");
      PrintInt( indent + tab, "               day: ", value.getExpireDate().getDay(), "\n");
      PrintInt( indent + tab, "              year: ", value.getExpireDate().getYear(), "\n"); 
      PrintString( indent + tab, "Token List: ", value.getTokenList( ), "\n" );

      PrintNewLine( ); 
   }
           
   public static void PrintLicenseValidList( String indent, String header, LicenseValidInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseValidInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintLicenseValidInfo( indent + tab, "", value[i] );
      }

      PrintNewLine( );
   }
           
   public static void PrintLicenseInfo( String indent, String header, LicenseInfo value )
   {
      PrintHeader( indent, header, "\n" ); 

      if( value == null )
      {
         PrintHeader( indent + tab, "Null LicenseInfo value...", "\n" );
         return;
      }
               
      PrintLicenseNameID( indent, "License Type: ", value.getlicType( ));
      PrintLicenseKeyID ( indent, "License Key: ", value.getlicKey( ));
      PrintLicenseNameID( indent, "License Sub Type: ", value.getlicSubtype( ) );
      PrintInt( indent + tab, "Expire Date: month: ", value.getExpireDate().getMonth(), "\n");
      PrintInt( indent + tab, "               day: ", value.getExpireDate().getDay(), "\n");
      PrintInt( indent + tab, "              year: ", value.getExpireDate().getYear(), "\n"); 
      PrintInt( indent + tab, "Issued Date: month: ", value.getIssuedDate().getMonth(), "\n");
      PrintInt( indent + tab, "               day: ", value.getIssuedDate().getDay(), "\n");
      PrintInt( indent + tab, "              year: ", value.getIssuedDate().getYear(), "\n"); 
      PrintString( indent + tab, "Site Name: ", value.getSiteName( ), "\n" );
      PrintString( indent + tab, "Host ID: ", value.getHostId( ), "\n" );
      PrintInt( indent + tab, "Number Of Licenses: ", value.getNumLicenses(), "\n");        
      PrintString( indent + tab, "Token List: ", value.getTokenList( ), "\n" );        
      PrintString( indent + tab, "Comment: ", value.getComment( ), "\n" );
      PrintNewLine( ); 
   }
           
   public static void PrintLicenseInfoList( String indent, String header, LicenseInfo[] value )
   {
      PrintHeader( indent, header, "\n" );
               
      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseValidInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" ); 
        
      for( int i = 0; i < value.length; i++ )
      {
         PrintLicenseInfo( indent + tab, "", value[i] );
      }

      PrintNewLine( );
   }

}