import OutputWriter.*;
import java.io.*;
import com.remedy.arsys.api.*;

public class InputReader
{
   static BufferedReader      in = new BufferedReader( new InputStreamReader( System.in ) );
   static PrintWriter    outFile = null;
   static String   commentPrefix = "#";
   static boolean  recordPrompt  = false;

       
   public static void RecordInput( )
   {
      try
      {
         String  fileName = GetString( "File name of record file ():", "" );

         if( fileName == null || fileName.length( ) == 0 )
         {
            PrintErrorMessage( "No output file name..." );            
         }
         else
         {
            if( outFile != null )
            {
               outFile.close( );
               outFile = null;
            }
            outFile = new PrintWriter( new FileOutputStream( new File( fileName ) ) );     
         }
      }
      catch( IOException e ){
         PrintErrorMessage( "Problem in opening the file...\n" );
      }
   }

   public static void StopRecordingInput( )
   {
      if( outFile != null )
      {
         outFile.close( );
         outFile = null;
      }
   }

   public static void SetRecordingPrompt( )
   {
      recordPrompt = true;
   }

   public static void StopRecordingPrompt( )
   {
      recordPrompt = false;
   }

   public static void RecordInputString( String input )
   throws IOException{      
      
      if( outFile != null  && input != null )
      {           
         outFile.println( input );
         outFile.flush( );
      } 
   }  

   public static void RecordPrompt( String prompt )
   throws IOException{      
      
      if( recordPrompt &&  outFile != null  && prompt != null )
      {           
         outFile.println( commentPrefix + prompt );
         outFile.flush( );
      } 
   }  
        
   public static void PrintHeader( String prompt )
   throws IOException{               

      System.out.println( prompt );
      RecordPrompt( prompt );
   }

   public static void PrintPrompt( String prompt  )
   throws IOException{

      System.out.print( prompt );
      RecordPrompt( prompt );
   }

   public static void PrintPromptWithNewline( String prompt  )
   throws IOException{

      System.out.println( prompt );
      RecordPrompt( prompt );
   }

   public static void PrintErrorMessage( String message  )
   {
      System.out.println( message );
   }

   public static String GetInputLine( )
   throws IOException{

      String input = null;

      boolean comment = false;
      do{
         comment = false;
         input = in.readLine( );

         if( input.startsWith( commentPrefix ) )
         {
               comment = true;
         }

      }while( comment );       

      return input;
   }

   public static boolean GetBoolean( String prompt, boolean defaultVal)
   throws IOException{      
    
      PrintPrompt( prompt );

      boolean         val = defaultVal;
      String  recordInput = "";
      String        input = GetInputLine( );  

      if( input.length( ) != 0 )
      {
         if( input.equals( "t" ) || input.equals( "true" ) || input.equals( "T" ) )
         {
            val =  true;
            recordInput = "true";
         }
         else
         {
            val = false;
            recordInput = "false";
         }
      }
           
      RecordInputString( recordInput );

      return val;
   }  


   public static int GetInt(int defaultVal)
   throws IOException {

      String s = GetInputLine();
      int value = defaultVal;

      if (s.length() != 0)
      {
         Integer val = new Integer(s);
         value = val.intValue();
      }

      RecordInputString(s);
      return value;
   }

   public static int GetInt(String prompt, int defaultVal) 
   throws IOException{      

      PrintPrompt( prompt );

      return GetInt(defaultVal);
   }  

   public static long GetLong( String prompt, long defaultVal )
   throws IOException{       

      PrintPrompt( prompt );

      long value = defaultVal;
      String   s = GetInputLine( );

      if( s.length( ) != 0 )
      {
         Long val = new Long( s );
         value =  val.longValue( );
      }

      // Record the input string
      RecordInputString( s );

      return value;   
   }  


   public static float GetFloat(String prompt, float defaultVal)
   throws IOException{      

      PrintPrompt( prompt );

      float value = defaultVal;
      String    s = GetInputLine( );

      if( s.length( ) != 0 )
      {
         Float val = new Float( s );

         value = val.floatValue( );
      } 

      RecordInputString( s );

      return value;
   }  

   public static char GetChar( String prompt, char defaultVal )
   throws IOException{      

      PrintPrompt( prompt );

      char value = defaultVal;
      String   s = GetInputLine( );

      if( s.length( ) != 0 )
      {
         value =  s.charAt( 0 );
      }

      // Record the input
      RecordInputString( s );

      return value; 
   }  



   public static String GetString(String prompt, String defaultVal)
   throws IOException{      

      PrintPrompt( prompt );

      String value = null;
      String     s = GetInputLine( );     

      if( s.length( ) == 0 )
      {            
         RecordInputString( "" );
      }
      else
      {
         RecordInputString( s );
         value = s;
      }
      return value;
   }  


   public static ARServerUser GetARServerUser( String header )
   throws IOException{

      PrintHeader( header );

      ARServerUser userInfo = new ARServerUser( );
           
      String  authentication = GetString( "   Authentication () : ", "" );
      userInfo.setAuthentication( authentication );

      AccessNameID name = GetAccessNameID(  "   User name () : " );
      userInfo.setUser( name );

      AccessNameID  password = GetAccessNameID( "   Password () : " );
      userInfo.setPassword( password );

      String language = GetString( "   Language () : ", "" );
      userInfo.setLanguage( language );
           
      String  server = GetString( "   Server () : ", "" ); 
      userInfo.setServer( server );  
           
      return userInfo;
   }


   public static Timestamp GetTimestamp( String prompt, Timestamp defaultTime )
   throws IOException{  

      PrintPrompt( prompt + "(" + defaultTime.getValue( ) + "): " );

      Timestamp time = new Timestamp( defaultTime.getValue( ) );
      String s = GetInputLine( );               

      if( s.length( ) != 0 )
      {
         Long val = new Long( s );
         time.setValue( val.longValue( ) );
      }

      // Record Input line
      RecordInputString( s );

      return time;
   }

   public static SchemaListCriteria GetSchemaListCriteria( )
   throws IOException{ 
           
      SchemaType type = GetSchemaType( );

      NameID name = null;

      if( (type != null ) && ( type.equals( SchemaType.UPLINK ) || type.equals( SchemaType.DOWNLINK ) ) )
      {
         String id = GetString( "Enter the name ():", "" );
         name = new NameID( id );
      }

      boolean    hidden = GetBoolean( "Include hidden schemas (T):", true );

      Timestamp  ts = GetTimestamp( "Get all changed since", new Timestamp( 0 ) );
           
      PrintPrompt( "Required field ids on schema: \n" );
      FieldID[] fids = GetFieldIDList();
           
      return  new SchemaListCriteria( type, hidden, ts, name , fids);
           
   }

   public static SchemaAliasesCriteria GetSchemaAliasesCriteria( )
   throws IOException{ 
           
      SchemaType type = GetSchemaType( );

      NameID name = null;

      if( (type != null ) && ( type.equals( SchemaType.UPLINK ) || type.equals( SchemaType.DOWNLINK ) ) )
      {
         String id = GetString( "Enter the name (): ", "" );
         name = new NameID( id );
      }

      boolean    hidden = GetBoolean( "Include hidden schemas (T): ", true );

      Timestamp  ts = GetTimestamp( "Get all changed since: ", new Timestamp( 0 ) );        

      PrintPrompt( "Required field ids on schema: \n" );
      FieldID[] fids = GetFieldIDList();
           
      NameID vuiLabel = null;        
      if( !GetBoolean( "Null Vui Label (F): ", false ) )
      { 
         vuiLabel = new NameID( GetString( "Enter the Vui label: ", "" ));
      }

      return new SchemaAliasesCriteria( type, hidden, ts, name, fids, vuiLabel );
   }

   public static DataType GetDataType( )
   throws IOException{

      PrintPromptWithNewline( "Datatype Null/Key/Int/Real/Char/Diary/Enum/Time/Bitmask/Byte/Decimal" );

      int type = GetInt( "    attach/join/trim/control/table/column/ulong/coords/view/display (0 - 11, 30-34, 40-43) (2): ", 2 );

      switch( type )
      {
         case 0  : return DataType.NULL;
         case 1  : return DataType.KEYWORD;
         case 2  : return DataType.INTEGER;
         case 3  : return DataType.REAL;
         case 4  : return DataType.CHAR;          
         case 5  : return DataType.DIARY;
         case 6  : return DataType.ENUM;
         case 7  : return DataType.TIME;
         case 8  : return DataType.BITMASK;
         case 9  : return DataType.BYTES;
         case 10 : return DataType.DECIMAL;
         case 11 : return DataType.ATTACHMENT;
         case 30 : return DataType.JOIN;
         case 31 : return DataType.TRIM;
         case 32 : return DataType.CONTROL;
         case 33 : return DataType.TABLE;
         case 34 : return DataType.COLUMN;
         case 40 : return DataType.ULONG;
         case 41 : return DataType.COORDS;
         case 42 : return DataType.VIEW;
         case 43 : return DataType.DISPLAY;
         default : return DataType.NULL;
      }
   }


   public static SchemaType GetSchemaType( )
   throws IOException{ 

      int type = GetInt( "Type of schema (all, regular, join, view, uplink, downlink, dialog, all_with_data) (0-7)(0):", 0 );

      switch( type )
      {
         case 0: return SchemaType.ALL;
         case 1: return SchemaType.REGULAR;   
         case 2: return SchemaType.JOIN;
         case 3: return SchemaType.VIEW; 
         case 4: return SchemaType.UPLINK;
         case 5: return SchemaType.DOWNLINK;   
         case 6: return SchemaType.DIALOG;
         case 7: return SchemaType.ALL_WITH_DATA; 
         default: return null;
      }
   }


   public static EntryCriteria GetEntryCriteria( )
   throws IOException{

      EntryCriteria criteria = new EntryCriteria( );

      EntryListFieldInfo[] fieldsList = GetEntryListFieldInfoList( );

      criteria.setEntryListFieldInfo( fieldsList );

      return criteria;
   }


   public static EntryListCriteria GetEntryListCriteria( )
   throws IOException{

      EntryListCriteria listCriteria = new EntryListCriteria( );

      NameID schemaName = GetNameID( "Schema: ", true);
      listCriteria.setSchemaID( schemaName );

      QualifierInfo qualifier = GetQualifierInfo( );
      listCriteria.setQualifier( qualifier );
           
      SortInfo[] sortOrder = GetSortInfoList( );
      listCriteria.setSortInfos( sortOrder );

      long firstRetrieve = GetLong("First Retrieve (0): ", 0);
      listCriteria.setFirstRetrieve( firstRetrieve );
           
      int limit = GetInt( "Maximum number of entries to retrieve (500):", 500 );
      listCriteria.setMaxLimit( limit );

      return listCriteria;
   }

   public static EntryID[] GetEntryIDList( )
   throws IOException{ 

      int numEntries = GetInt( "   Number of entry ids(0): ", 0 );
       
      EntryID[] idList = null;

      if( numEntries != 0 )
      {
         idList = new EntryID[ numEntries ];

         String s;
         for( int i = 0; i < numEntries; i++ )
         {
            s = GetString( "   Entry Id " + i + ": ", "" );
            idList[i] = new EntryID( s );                     
         }
      }
      return idList;        
   }

   public static InternalID[] GetInternalIDList( )
   throws IOException{ 

      int   i;      
      int   numItems;
      InternalID[]  idList = null;
           
      numItems = GetInt( "  Number of ids( 0 ): ", 0 );
                 
      if( numItems != 0 )
      {            
         idList = new InternalID[ numItems ];                                
         for( i = 0; i < numItems; i++ )
         {          
            idList[i] = new InternalID( GetLong( "    Id  " + i  + " ( 1 ): ", 1 ) );
         }
      }

      return idList;
   }


   public static NameID GetNameID()
   throws IOException {

      String name = GetString("Name", "");

      return new NameID(name);
   }
       

   public static NameID[] GetNameIDList( )
   throws IOException{
    
      NameID[]   nameList = null;

      int numItems = GetInt("   Number of names (0): ", 0);
      if( numItems != 0)
      {     
         nameList = new NameID[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {               
            nameList[i] = new NameID( GetString( "Name " + "(" + i + "): ", "" ) );
         }
      }

      return nameList;
   }

   public static AccessNameID GetAccessNameID()
   throws IOException {

      String name = GetString("Name", "");

      return new AccessNameID(name);
   }

   public static AccessNameID GetAccessNameID(String prompt)
   throws IOException {
      String name = GetString(prompt, "");

      return new AccessNameID(name);
   }

   public static AccessNameID GetAccessNameID( String prompt, boolean nullable )
   throws IOException{

      if (!nullable)
         return GetAccessNameID(prompt);

      String name = GetString( prompt, "" );

      return new AccessNameID( name );               
   }
       

   public static AccessNameID[] GetAccessNameIDList( )
   throws IOException{
    
      AccessNameID[]   nameList = null;

      int numItems = GetInt("   Number of access names (0): ", 0);
      if( numItems != 0)
      {     
         nameList = new AccessNameID[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {               
            nameList[i] = new AccessNameID( GetString( "Name " + "(" + i + ")", "" ) );
         }
      }

      return nameList;
   }

   public static FilterStatusInfo GetFilterStatusInfo( )
   throws IOException{

      PrintHeader( "Filter Status Info:" );  

      long messageType   = GetLong( "   Note, Warning, or Error (0, 1, 2) (2) : ",2 );
      long messageNumber = GetLong( "   Message number (0): ", 0 );
      String messageText   = GetString( "   Message Text( ):  ", "" );
          
      return new FilterStatusInfo( messageType, messageNumber, messageText );
   }


   public static MessageInfo GetMessageInfo( )
   throws IOException{

      PrintHeader( "Message Info:" );

      long messageType   = GetLong( "   Note, Warning, or Error (0, 1, 2) (2) : ",2 );

      long messageNumber = GetLong( "   Message number (0): ", 0 );

      String messageText   = GetString( "   Message Text( ):  ", "" );

      boolean usePane       = GetBoolean( "   Use Prompting Pane? (T): ", true );
          
      return new MessageInfo( messageType, messageNumber, messageText, usePane );
   }


   public static EntryKey GetEntryKey( )
   throws IOException{

      PrintHeader( "Entry Key:" ); 
        
      NameID schemaName = GetNameID( "Schema Name: ", true);
      String entryId = GetString( "EntryID: ", "" );
       
      return new EntryKey( schemaName, new EntryID( entryId ) );
   }

   public static CoordinateInfo[] GetCoordinateInfoList( )
   throws IOException{

      CoordinateInfo[] coordinates = null;

      int  numberOfItems = GetInt( "Number of Items in the List (0): ", 0 );
      if( numberOfItems != 0 )
      {
         coordinates = new CoordinateInfo[ numberOfItems ];

         int   i;
         long  x;
         long  y;

         for( i = 0; i < numberOfItems; i++ )
         {
            x = GetLong("x (" + i + "): ",  0 );                  
            y = GetLong("y (" + i + "): ",  0 );
                    
            coordinates[i] = new CoordinateInfo( x, y );
         }
      }
           
      return coordinates;   
   }

   public static ByteListInfo GetByteListInfo( )
   throws IOException{

      byte[]   byteArray = null;

      int type = GetInt( "Byte List Type (0): ", 0 );

      int numberOfBytes = GetInt( "Number of Items in the List (0): ", 0 );
      if( numberOfBytes != 0 )
      {
         byteArray = new byte[ numberOfBytes ];
               
         for( int i = 0; i < numberOfBytes; i++ )
         {  
            byteArray[ i ] =  ( byte )GetChar( "Byte (" + i + "): ",  '0' );               
         }
      }
           
      return new ByteListInfo( type, byteArray );       
   }

   public static ByteListInfo[] GetByteListInfoList( )
   throws IOException{

      ByteListInfo[]  byteList = null;

      int   numberOfValues = GetInt("   Number of items (0): ", 0 );

      if( numberOfValues != 0 )  
      {
         byteList = new ByteListInfo[ numberOfValues ];

         for( int i = 0; i < numberOfValues; i++ )
         {
            byteList[i] = GetByteListInfo( );            
         }
      }

      return byteList;          
   }
   public static AttachmentInfo GetAttachmentInfo( )
   throws IOException{

      String name =  GetString( "Attachment Name: ", "" );
      String cname = null;

      int choice = GetInt( "Choose:\n" +
                     "   1 - prompt for filename,\n" +
                     "   2 - prompt for string\n" +
                     "   default (1): ", 1 );

      if( ( choice < 1 ) || ( choice > 4 ) )
      {
         PrintErrorMessage( "   ERROR: choice outside range 1-4; defaulting to prompt for filename(1)" );
         choice = 1;
      }

      switch( choice ) 
      {
         case 1:   
            cname = GetString("Enter filename: ", "");           
            break;
    
         case 2: 
            cname = GetString( "Enter string: ", "" );
            break;

         default: 
            cname = GetString("Enter filename: ", "");           
            break;
      }

      long orgSize = GetLong( "Orginal Size (0) ", 0 );
      long cmpSize = GetLong( "Compressed size ( 0 )", 0 );

      return new AttachmentInfo( name, orgSize, cmpSize, cname);
   }

   public static Value GetValue( )
   throws IOException{
                  
      PrintPromptWithNewline( "Datatype Null/Key/Int/Real/Char/Diary/Enum/Time/Bitmask/Byte/" );

      PrintPromptWithNewline( "Decimal/attach/join/trim/control/ulong/coords" );

      int dataType = GetInt( "(0 - 11, 30-32, 40-41) (0): ", 0 );
        
      Value val = GetValue( dataType );
           
      return val;
   }

   public static Value GetValue( int dataType )
   throws IOException{               
        
      Value val = null;
      switch( dataType )
      {
         case 0 :  // _DATA_TYPE_NULL 
            val =  new Value( );
            break;

         case 1:   // _DATA_TYPE_KEYWORD :              
            int keycode = GetInt("Keyword Code (0): ", 0);

            switch( keycode )
            {
               case 0 :
                  val = new Value( Keyword.AR_KEYWORD_DEFAULT );
                  break;

               case 1 :
                  val = new Value( Keyword.AR_KEYWORD_USER );
                  break;

               case 2 :
                  val = new Value( Keyword.AR_KEYWORD_TIMESTAMP );
                  break;

               case 3 :
                  val = new Value( Keyword.AR_KEYWORD_TIME_ONLY );
                  break;

               case 4 :
                  val = new Value( Keyword.AR_KEYWORD_DATE_ONLY );
                  break;

               case 5 :
                  val = new Value( Keyword.AR_KEYWORD_SCHEMA );
                  break;

               case 6 :
                  val = new Value( Keyword.AR_KEYWORD_SERVER );
                  break;

               case 7 :
                  val = new Value( Keyword.AR_KEYWORD_WEEKDAY );
                  break;

               case 8 :
                  val = new Value( Keyword.AR_KEYWORD_GROUPS );
                  break;

               case 9 :
                  val = new Value( Keyword.AR_KEYWORD_OPERATION  );
                  break;

               case 10 :
                  val = new Value( Keyword.AR_KEYWORD_HARDWARE );
                  break;

               case 11 :
                  val = new Value( Keyword.AR_KEYWORD_OS );
                  break;

               case 12 :
                  val = new Value( Keyword.AR_KEYWORD_DATABASE );
                  break;

               case 13 :
                  val = new Value( Keyword.AR_KEYWORD_LASTID );
                  break;

               case 14 :
                  val = new Value( Keyword.AR_KEYWORD_LASTCOUNT );
                  break;

               case 15 :
                  val = new Value( Keyword.AR_KEYWORD_VERSION );
                  break;

               default : val = new Value( Keyword.AR_KEYWORD_VERSION );
                  break;
            }
      
            break;          
         case 2:  // _DATA_TYPE_INTEGER 
            int intVal = GetInt( "Integer Value (0): ", 0 );
            val =  new Value( intVal );       
            break;

         case 3:
            double doubleVal = (double) GetFloat("Real Value (0.0): ", (float)0.0 );
            val = new Value( doubleVal );
            break;

         case 4  :
            String name = GetString( "Char Value (): ", "" );
            val = new Value( name );
            break;

         case 5  :
            String dairyValue = GetString( "Diary Value (): ", "" );
            val = new Value( new Diary( dairyValue ) );
            break;

         case 6:
            long enumVal = GetLong( "Enum Value( 0 ): ", 0 );
            val =  new Value( DataType.ENUM, enumVal );
            break;

         case 7:
            Timestamp timeStamp = GetTimestamp("Time Value( 0 ):", new Timestamp( 0 ) );
            val = new Value( timeStamp );
            break;

         case 8:
            long maskVal = GetLong("Bitmask Value (0): ", 0);
            val = new Value( DataType.BITMASK, maskVal );
            break;

         case 9 :
            ByteListInfo byteList = GetByteListInfo(  );
            val = new Value( byteList );
            break;

         case 10 :
            String decimalString = GetString("Decimal Value (0.0):", "" );
            Double decimalValue = new Double( decimalString );
            val = new Value(  decimalValue.doubleValue( ) );
            break;

         case 11  :
            AttachmentInfo attach = GetAttachmentInfo( );                
            val = new Value( attach );
            break;

         case 40 :
            long ulongVal = GetLong( "Ulong Value (0): ", 0 ); 
            val = new Value( DataType.ULONG, ulongVal );
            break;

         case 41  :
            CoordinateInfo[] coords = GetCoordinateInfoList( );                
            val =  new Value( coords );
            break;
      }
           
      return val;
   }

   static public Value[] GetValueList( )
   throws IOException{

      Value[] valueList = null;

      int   numberOfValues = GetInt("   Number of values (0): ", 0 );

      if( numberOfValues != 0 )  
      {
         valueList = new Value[ numberOfValues ];
         for( int i = 0; i < numberOfValues; i++ )
         {
            valueList[i] = GetValue( );            
         }
      }

      return valueList;
   }

   public static EntryItem[] GetEntryItemList( )
   throws IOException{

      EntryItem[] entryList = null;

      int numItems = GetInt( "  Number of Field/value pairs (0): ", 0 );
      if(numItems != 0 )
      {
         entryList = new EntryItem[ numItems ];   
         for( int i = 0; i < numItems; i++ )
         {
            entryList[i] = GetEntryItem( );
         }
      }
          
      return entryList;
   }

   static public EntryItem GetEntryItem( )
   throws IOException{

      long  id = GetLong( "Field id (0): ", 0 );
      FieldID fieldId = new FieldID( id );

      Value val = GetValue( );

      return new EntryItem( fieldId, val );
   }   

   static public EntryListFieldInfo GetEntryListFieldInfo( )
   throws IOException{

      PrintHeader( "   Entry list field Info" );

      long  id = GetLong( "      Field id (0): ", 0 );
      FieldID fieldId = new FieldID( id );

      int columnWidth = GetInt( "      Column width (20): ", 20 );

      String separator = GetString( "      Separator(  ): ", "  " );

      return new EntryListFieldInfo( fieldId, columnWidth, separator );
   }


   public static EntryListFieldInfo[] GetEntryListFieldInfoList( )
   throws IOException{
      EntryListFieldInfo[] entryListFieldList = null;

      int numItems = GetInt("Number of list fields (0): ", 0);
      if(numItems != 0 )
      {
         entryListFieldList = new EntryListFieldInfo[ numItems ];   
         for( int i = 0; i < numItems; i++ )
         {
            entryListFieldList[i] = GetEntryListFieldInfo( );
         }
      }
          
      return entryListFieldList;
   }

   public static ViewKey GetViewKey( )
   throws IOException{

      // Get the Schema Name
      NameID schemaName = GetNameID( "Schema Name: ", true );

      // Get the VUI id
      FieldID vuiId = GetVUIID();

      return new ViewKey( schemaName, vuiId );
   }

   public static ViewListCriteria GetViewListCriteria( )
   throws IOException{

      NameID schemaName = GetNameID( "Schema Name", true );
           
      Timestamp timeModifiedAfter = GetTimestamp( "Get All changed since (0) ", new Timestamp( 0 ) );

      return new ViewListCriteria( schemaName, timeModifiedAfter );
   } 

   public static FieldID GetVUIID( )
   throws IOException
      {
      if( GetBoolean( "Null VUI ID( f ): ", false ) )
      {
         return null;
      }      
      long  id = GetLong( "VUI id (1): ", 1 );
      return new FieldID( id );
   }

   public static FieldID GetFieldID(String prompt, long defaultVal)
   throws IOException {
      long id = GetLong(prompt, defaultVal);
      return new FieldID(id);
   }

   public static FieldID GetFieldID( )
   throws IOException
   {
      if( GetBoolean( "Null FieldID( f ): ", false ) )
      {
         return null;
      }
      long  id = GetLong( "      Field id (0): ", 0 );
      return new FieldID( id );
   }

   public static FieldID[] GetFieldIDList( )
   throws IOException{     

      FieldID[]  fieldIdList = null;

      int numItems = GetInt( "   Number of field IDs (0): ", 0 );

      if( numItems != 0 )
      {
         fieldIdList = new FieldID[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            fieldIdList[i] =  GetFieldID( );
         }
      }

      return fieldIdList;
   }


   public static RelationalOperationInfo GetRelationalOperationInfo( )
   throws IOException{

      int operation =  GetInt( "Relational op code - EQ, GT, GE, LT, LE, NE, LIKE, IN (1 - 8): ", 0 );

      PrintHeader( "Left operand - " );
      ArithmeticOrRelationalOperand leftOperand = GetArithmeticOrRelationalOperand( ); 

      PrintHeader( "Right operand - " );
      ArithmeticOrRelationalOperand rightOperand = GetArithmeticOrRelationalOperand( ); 
           
      return new RelationalOperationInfo( operation, leftOperand, rightOperand );
   }


   public static QualifierInfo GetQualifierInfo( )
   throws IOException{

      PrintHeader( "Qualifier Info: " );

      int operation = GetInt( "None, And, Or, Not, Relop or FromField (0, 1, 2, 3, 4, 5) (0): ", 0 );

      IARQualifierOperand opLeft = null;
      IARQualifierOperand opRight = null;
         
      QualifierInfo qInfo = null;

      switch( operation )
      {
         case QualifierInfo.AR_COND_OP_NONE   :
            // nothing to load if no qualifier
            break;

         case QualifierInfo.AR_COND_OP_AND    :
            PrintHeader( "LeftOperand" );
            opLeft = GetQualifierInfo( );

            PrintHeader( "RightOperand" );
            opRight = GetQualifierInfo( );
            qInfo = new QualifierInfo( QualifierInfo.AR_COND_OP_AND, ( QualifierInfo )opLeft, ( QualifierInfo )opRight );
            break;

         case QualifierInfo.AR_COND_OP_OR     :
            PrintHeader( "LeftOperand" );
            opLeft = GetQualifierInfo( );

            PrintHeader( "RightOperand" );
            opRight = GetQualifierInfo( );
            qInfo = new QualifierInfo( QualifierInfo.AR_COND_OP_OR, ( QualifierInfo )opLeft, ( QualifierInfo )opRight );
            break;
     
         case QualifierInfo.AR_COND_OP_NOT    :
            opLeft = GetQualifierInfo( );
            qInfo = new QualifierInfo( QualifierInfo.AR_COND_OP_NOT, ( QualifierInfo )opLeft, null );
            break;

         case QualifierInfo.AR_COND_OP_REL_OP :
            RelationalOperationInfo rOpInfo = GetRelationalOperationInfo( );
            qInfo = new QualifierInfo( rOpInfo );
            break;

         case QualifierInfo.AR_COND_OP_FROM_FIELD:
            FieldID fid = GetFieldID();
            QualifierFromFieldInfo fromFidInfo = new QualifierFromFieldInfo(fid);
            qInfo = new QualifierInfo(fromFidInfo);
            break;

         default  :
            break;
      }               
      return qInfo;    
   }

      
   public static QueryInfo GetQueryInfo( )
   throws IOException{

      NameID schema = GetNameID( "Schema: ", true );

      ServerNameID server =  new ServerNameID( GetString( "Server: ", "" ) );

      QualifierInfo qualifier = GetQualifierInfo( );

      FieldID fieldId = GetFieldID( );

      int multiMatchCode =  GetInt( "Multi-Match code (error, first, set) (1, 2, 3) (1): ", 1 ); 

      return new QueryInfo( schema, server, qualifier, fieldId, multiMatchCode );
        
   }

   public static DiaryInfo GetDiaryInfo()
   throws IOException{
   AccessNameID user = new AccessNameID(GetString("   User: ", ""));
   Timestamp timestamp = new Timestamp(GetLong("   TimeStamp: ", 0));
   String diaryItemString = GetString("   Diary String: ", "");
         
   return new DiaryInfo(user, diaryItemString, timestamp);     
   }
          
   public static DiaryInfo[] GetDiaryInfoList()
   throws IOException{
   DiaryInfo[] list = null;
         
   int numItems = GetInt("Number of Diary (0): ",0);   
   if(numItems != 0)
   {
      list = new DiaryInfo[numItems];
      for(int i = 0; i < numItems; i++)
         list[i] = GetDiaryInfo();
   }
   return list;
   }
          
   public static StatusHistoryInfo GetStatusHistoryInfo()
   throws IOException{
      AccessNameID user = new AccessNameID(GetString("   User: ", ""));
      Timestamp timestamp = new Timestamp(GetLong("   TimeStamp: ", 0)); 
            
      return new StatusHistoryInfo(user, timestamp);     
   }
          
   public static StatusHistoryInfo[] GetStatusHistoryInfoList()
   throws IOException{
   StatusHistoryInfo[] list = null;
         
   int numItems = GetInt("Number of Status History (0): ",0);  
   if(numItems != 0)
   {
      list = new StatusHistoryInfo[numItems];
      for(int i = 0; i < numItems; i++)
         list[i] = GetStatusHistoryInfo();
   }
   return list;
   }
          
   public static StatusHistoryValue GetStatusHistoryValue( )
   throws IOException{

      int index =  GetInt( "Enumerated value index (0): ", 0 );
      int userOrTime = GetInt( "User or Time field (1 or 2) (2): ", 2 );  
     
      boolean type = true;

      if( userOrTime ==  2 )
      {
         type = false;
      }

      return new StatusHistoryValue( type, index );
   }


   public static ArithmeticOrRelationalOperand GetArithmeticOrRelationalOperand( )
   throws IOException{

      OperandType opType = null;        

      int operation =  GetInt( "Fld,Value,Arith,Stat-Hist,Val-Set,Fld-tran,Fld-DB,L-Var,Query,Current\n  (1-5,50-53,99): ", 1 );
      switch( operation )
      {
         case 1: opType = OperandType.FIELDID;
            break;

         case 2: opType = OperandType.VALUE;
            break;

         case 3: opType = OperandType.ARITHMETIC_OP;
            break;

         case 4: opType = OperandType.STATUS_HISTORY;
            break;

         case 5: opType = OperandType.VALUE_SET;
            break;

         case 50: opType = OperandType.FIELDID_TRANSACTION;
            break;

         case 51: opType = OperandType.FIELDID_DB;
            break;

         case 52: opType = OperandType.LOCAL_VARIABLE;
            break;

         case 53: opType = OperandType.QUERY_INFO;
            break;

         case 99: opType = OperandType.FIELDID_CURRENT;
            break;
               
         default: PrintErrorMessage( "Invalid operation.." );                     
            break;
      }    
               
      ArithmeticOrRelationalOperand arithOrRlOperand = null;

      switch( operation )
      {
         case 1:
         case 50: 
         case 51:
         case 99: 
            FieldID fldId = GetFieldID( );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( opType, fldId );
            break;

         case 2:  
            Value val = GetValue( );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( val );
            break;

         case 3:
            ArithmeticOperationInfo aropInfo = GetArithmeticOperationInfo( );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( aropInfo );                    
            break;

         case 4:  
            StatusHistoryValue stHistoryVal = GetStatusHistoryValue( );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( stHistoryVal );                     
            break;

         case 5 : 
            Value[] valList = GetValueList( );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( valList );                    
            break;

         case 52: 
            int variable = GetInt( "Local Variable number (0 to 10) (0): ", 0 );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( variable );
            break;

         case 53: 
            QueryInfo qInfo = GetQueryInfo( );
            arithOrRlOperand =  new ArithmeticOrRelationalOperand( qInfo );
            break;
               
         default: 
            PrintErrorMessage( "Invalid operation.." );
            break;
      } 

      return arithOrRlOperand;               

   }

   public static ArithmeticOperationInfo GetArithmeticOperationInfo( )
   throws IOException{ 

      ArithmeticOrRelationalOperand  leftOperand = null;
      ArithmeticOrRelationalOperand  rightOperand = null;      

      int operation =  GetInt("Arithmetic op code -- +, -, *, /, %, unary - (1 - 6): ", 0);

      if( operation != 6 ) // 6 for unary negation
      {
         PrintHeader( "Left Operand - " );
         leftOperand = GetArithmeticOrRelationalOperand( );
      }

      PrintHeader( "Right Operand - " );

      rightOperand = GetArithmeticOrRelationalOperand( );
    
      return new ArithmeticOperationInfo( operation, leftOperand, rightOperand );
   }



   public static SortInfo GetSortInfo( )
   throws IOException{

      PrintHeader( "   Sort list entry" );

      InternalID id = new InternalID( GetLong( "      Internal id of field to sort on (0): ", 0 ) );
      int  order =  GetInt( "      Ascending or Descending (1 or 2) (1): ", 1 );     

      return new SortInfo( id, order );  
   }

   public static SortInfo[] GetSortInfoList( )
   throws IOException{  

      SortInfo[]   sortInfoList = null;
      int numItems = GetInt( "Number of sort fields (0): ", 0 );
      if( numItems != 0 )
      {
         sortInfoList = new SortInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            sortInfoList[i] = GetSortInfo( );            
         }
      }
            
      return sortInfoList;
   }

   public static IndexInfo GetIndexInfo( )
   throws IOException{

      long id;
      InternalID[] fieldIds;

      PrintHeader( "   Index list entry" );

      int numFields = GetInt( "      Number of fields in index (1): ", 1 );

      fieldIds = new InternalID[ numFields ];
      for( int i = 0; i < numFields; i++ )
      {
         id = GetLong( "      Internal id of field to index on (0): ", 0 );
         fieldIds[i] = new InternalID( id );            
      }
           
      boolean unique = GetBoolean("      Unique index (F): ", false );        

      NameID nameId = GetNameID( "Name", true);

      return new IndexInfo( fieldIds, unique, nameId );
   }



   public static IndexInfo[] GetIndexInfoList( )
   throws IOException{  

      IndexInfo[]  indexList = null;
              
      int numItems = GetInt( "Number of indexes (0): ", 0 );

      if( numItems != 0 )
      {
         indexList = new IndexInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {   
            PrintHeader( "Enter the information for index " + i + ":" );  
            indexList[i] = GetIndexInfo( );
         }
      }

      return indexList;
   }
       

   public static PropInfo GetPropInfo( )
   throws IOException{       

      int tag = GetInt( "Prop Tag - ( 0 ): ", 0 );
           
      Value val = GetValue( );
           
      return new PropInfo( tag, val );        
   }

   public static PropInfo[]  GetPropInfoList( )
   throws IOException{

      PropInfo[]   propList = null;

      int numItems = GetInt( "Number of Properties (0): ", 0 );

      if( numItems != 0 )   
      {
         propList = new PropInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            propList[i] = GetPropInfo( );
         }
      }

      return propList;
   }
    

   public static DisplayInstanceInfo GetDisplayInstanceInfo( )
   throws IOException{

      InternalID id = new InternalID( GetLong( "Enter the VUI id ( 0 ): ", 0 ) );              

      PropInfo[] propList = GetPropInfoList( );

      return new DisplayInstanceInfo( id, propList );
   }
     
      
   public static DisplayInstanceList GetDisplayInstanceList( )
   throws IOException{    

      DisplayInstanceInfo[] dispInstanceInfoList = null;

      PrintHeader( "Getting the Common Properties for this field" );

      PropInfo[] propList =  GetPropInfoList( );

      int numItems = GetInt( "Number of display Instances (0): ", 0 );

      if( numItems != 0 )
      {
         dispInstanceInfoList = new DisplayInstanceInfo[ numItems ];
         for( int  i = 0; i <  numItems; i++ )
         {
            dispInstanceInfoList[i] = GetDisplayInstanceInfo( );
         }
      }
          
      return new DisplayInstanceList( propList, dispInstanceInfoList );
   }

   public static FieldMappingInfo GetFieldMappingInfo( )
   throws IOException{
           
      int fieldType = GetInt( "Field Type (0): ", 0 );
      switch( fieldType )
      {
         case Constants.AR_FIELD_NONE    :
         case Constants.AR_FIELD_REGULAR :
            return null;

         case Constants.AR_FIELD_JOIN    :
            return null;
         case Constants.AR_FIELD_VIEW    :
            return new ViewMappingInfo(GetNameID("Field Name: "));
         case Constants.AR_FIELD_VENDOR  :
            return new VendorMappingInfo(GetNameID("Field Name: "));
         default:
            return null;
      }
   }

   public static FieldLimitInfo GetFieldLimitInfo()
   throws IOException{
           
      PrintHeader( "Field Limits" );
           
      if ( GetBoolean( "Set to No Limits? (F): ", false ) )
         return null;
           
      int dataType = GetInt("dataType? (0): ",0);
      switch( dataType )
      {
         case Constants.AR_DATA_TYPE_INTEGER :
            return GetIntegerLimitInfo();
                   
         case Constants.AR_DATA_TYPE_REAL :
            return GetRealLimitInfo();
                   
         case Constants.AR_DATA_TYPE_CHAR :
            return GetCharLimitInfo();
                   
         case Constants.AR_DATA_TYPE_ENUM:
            return GetEnumInfo();
                   
         case Constants.AR_DATA_TYPE_ATTACH :
            return GetAttachmentLimitInfo();
                   
         case Constants.AR_DATA_TYPE_DECIMAL :
            return GetDecimalLimitInfo();
                   
         case Constants.AR_DATA_TYPE_TABLE :
            return GetTableLimitInfo();
                   
         case Constants.AR_DATA_TYPE_COLUMN :
            return GetColumnLimitInfo();
                   
         case Constants.AR_DATA_TYPE_VIEW :
            return GetViewLimits();
                   
         case Constants.AR_DATA_TYPE_DISPLAY :
            return GetDisplayLimits();
               
         default:
            System.out.println("There are no limits for this field");
            return null;
      }
   }

   public static AssignFieldInfo GetAssignFieldInfo( )
   throws IOException{

      long fieldId = 0;
      StatusHistoryValue statusHistory = null;

      String serverName = GetString( "Server name (): ", "" );
      String schemaName = GetString( "Schema name (): ", "" );

      int tag = GetInt( "Field or status history (1 or 4) (1): ", 1 );

      if( tag == 1 )
      {
         fieldId = GetLong("Field id (0): ", 0 );
      }
      else if( tag == 4 )
      {
         statusHistory = GetStatusHistoryValue( );
      }
            
      QualifierInfo qualifierInfo = GetQualifierInfo( );

      long noMatchOption = GetInt( "No match action -- error, null, no action, submit (1-4) (2): ", 2 );
      long multiMatchOption = GetInt(
      "Multi match action -- error, null, first, picklist, mod all, no action, submit (1-7) (4): ",
      4);

      return  new AssignFieldInfo( serverName, schemaName, qualifierInfo, tag, 
                                    fieldId, statusHistory, noMatchOption,
                                    multiMatchOption );
   }

   public static DDEInfo GetDDEInfo( )
   throws IOException{

      PrintHeader( "   Active Link DDE Info:" );

      String serviceName = GetString( "      Service name (): ", "" );

      String topic = GetString( "      Topic (): ", "" );

      long action = GetLong( "      Action (execute, poke, request) (1-3) (1): ", 1 );

      String pathToProgram = GetString( "      Path To Program (): ", "" );
           
      String command = null;
      if( action != 3)
      {
         command = GetString( "      Command (): ", "" );
      }
      else
      {
         command = null;
      }

      String item = null;
      if( GetBoolean( "      Set an item string? (F): ", false ) )
      {
         item = GetString( "      Item text (): ", "" );
      }
      else
      {
         item = null;
      }

      return new DDEInfo( serviceName, topic, item, action, pathToProgram, command );
   }
   public static AutomationInfo GetAutomationInfo( )
   throws IOException{

      PrintHeader( "   Active Link Automation Info:" );

      String serverName = GetString( "      Auto Server name (): ", "" );
      boolean   isVisible = GetBoolean( "      Showing Automation Server? (T): ", true );

      String classId = GetString( "      Class  Id (): ", "" );
      String action =  GetString( "      Automation Action (): ", "" );
      COMMethodInfo[]  comMethodList = GetCOMMethodInfoList( );

      return new AutomationInfo( serverName, classId, action, isVisible, comMethodList );        
   }


   public static COMMethodInfo GetCOMMethodInfo( ) 
   throws IOException{

      String name = GetString( "      Method Name (): ", "" );

      String methodId = GetString( "      Method Interface Id (): ", "" );

      long methodType = GetInt( "      COM Method Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);

      COMValueInfo value = GetCOMValueInfo( );

      COMMethodParmInfo[ ] paramList = GetCOMMethodParmInfoList( ); 
    
      return new COMMethodInfo( name, methodId, methodType, value, paramList );
   }

   public static COMMethodInfo[] GetCOMMethodInfoList( )
   throws IOException{

      COMMethodInfo[] methodList = null;
    
      int numItems = GetInt( "      Number of Methods (1): ", 1 );
     
      if( numItems != 0 )
      {
         methodList = new COMMethodInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            methodList[i] = GetCOMMethodInfo( );
         }
      }
    
      return methodList;
   }


   public static COMValueInfo GetCOMValueInfo( )
   throws IOException{

      long transId  = GetLong( "      Transient Id (1): ", 1 );

      String valueId = GetString( "      Value IId (used for method only)(): ", "" );
                   
      int valueType = GetInt( "      COM [Method( null -0, fieldId - 1)/Parm( null -0, value - 2)] Type (0): ", 0 );

      long     fieldId = 0;
      Value    val = null;

      switch( valueType ) 
      {
         case 1: 
            fieldId = GetLong( "      FieldId (1): ", 1L );
            break;
    
         case 2:
            val = GetValue( );
            break;

         default:  break;
      }
          
      return new COMValueInfo( valueId, transId, valueType, fieldId, val );
   }

    
   public static COMMethodParmInfo GetCOMMethodParmInfo( )
   throws IOException{

      String name = GetString( "      Parameter Name (): ", "" );

      long parmType = GetLong( "      COM Parameter Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);

      COMValueInfo val = GetCOMValueInfo( );
           
      return new COMMethodParmInfo( name, parmType, val ); 
   }
   public static COMMethodParmInfo[] GetCOMMethodParmInfoList( )
   throws IOException{

      COMMethodParmInfo[]  parmList = null;
    
      int numItems = GetInt( "      Number of Parameters (0): ", 0 );
      if( numItems != 0 )
      {
         parmList = new COMMethodParmInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         { 
            parmList[i] = GetCOMMethodParmInfo( ); 
         }
      }

      return parmList;
   }
    
   public static FieldAssignInfo GetFieldAssignInfo( )
   throws IOException{

      long fieldId = GetLong( "Field id: ", 0 );
      AssignInfo asnInfo = GetAssignInfo( );

      FieldAssignInfo fldAsnInfo =  new FieldAssignInfo( );
           
      fldAsnInfo.setFieldId( new InternalID( fieldId ) );

      fldAsnInfo.setAssignment( asnInfo );

      return fldAsnInfo;
   }

   public static ArithOpAssignInfo GetArithOpAssignInfo( )
   throws IOException{

      AssignInfo leftOperand = null;
      AssignInfo rightOperand = null;
        
      int operation =  GetInt("Arithmetic op code -- +, -, *, /, %, unary - (1 - 6): ", 0);
      if( operation != 6 )
      {
         PrintHeader( "Left Operand - " );

         leftOperand = GetAssignInfo( );
      }

      PrintHeader( "Right Operand - " );

      rightOperand = GetAssignInfo( );

      ArithOpAssignInfo asnInfo = new ArithOpAssignInfo( );

      asnInfo.setOperation( (long) operation );
      asnInfo.setOperandLeft( leftOperand );
      asnInfo.setOperandRight( rightOperand );

      return asnInfo;
   }

   public static FunctionAssignInfo GetFunctionAssignInfo( )
   throws IOException{

      FunctionAssignInfo fnAssignInfo = new FunctionAssignInfo( );
           
      int functionCode =  GetInt( "Function code -- (1 - 26): ", 0 );

      fnAssignInfo.setFunctionCode( (long) functionCode );

      int numItems = GetInt( "Number of parameters (0): ", 0 );
       
      if( numItems != 0 )
      {
         AssignInfo[]  paramList = new AssignInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            PrintHeader( "Parameter[" + i + "] - " );
            paramList[i] = GetAssignInfo( );
         }    
              
         fnAssignInfo.setParameterList( paramList );
      }

      return fnAssignInfo;
   }


   public static AssignSQLInfo GetAssignSQLInfo( )
   throws IOException{


      String server = GetString( "Server name (): ", "" );

      String command = GetString( "SQL command (): ", "" );

      int valueIndex = GetInt( "Index of returned value to select (1): ", 1 );

      int noMatchOption = GetInt( "No match action -- error, null (1, 2) (2): ",2 );

      int multiMatchOption = GetInt( "Multi match action -- error, null, first, picklist (1, 2, 3, 4) (4): ", 4 );

      return new AssignSQLInfo( server, command, valueIndex, noMatchOption, multiMatchOption );
   }
       

   public static AssignFilterApiInfo GetAssignFilterApiInfo( )
   throws IOException{

      String server = GetString( "Service name (): ", "" );

      int valueIndex = GetInt( "Number of imput assignments (0): ", 0 );

   /* xxxuli */
   /* loop */
   /*    get assign structs */

   /*  int valueIndex = GetInt( "Index of returned value to select (1): ", 1 ); 

      return new AssignFilterApiInfo( server, command, valueIndex, noMatchOption, multiMatchOption );*/
      return new AssignFilterApiInfo();
   }
       
   public static AssignInfo GetAssignInfo( )
   throws IOException{

      AssignInfo asnInfo = new AssignInfo( );

      int type =  GetInt("Assign type:  None, Value, Field, Process, Arith, Function, DDE, SQL(0 - 7): ", 0);

      asnInfo.setAssignType( type );

      switch( type )
      {
         case AssignInfo.AR_ASSIGN_TYPE_VALUE   :
            Value val = GetValue( );
            asnInfo.setValue( val );

            break;

         case AssignInfo.AR_ASSIGN_TYPE_FIELD   :
            AssignFieldInfo fldInfo = GetAssignFieldInfo( );
            asnInfo.setField( fldInfo );

            break;

         case AssignInfo.AR_ASSIGN_TYPE_PROCESS :
            String process = GetString( "Process to run (): ", "" );
            asnInfo.setProcess( process );

            break;

         case AssignInfo.AR_ASSIGN_TYPE_ARITH   :
            ArithOpAssignInfo arAsnInfo = GetArithOpAssignInfo( );
            asnInfo.setArithOp( arAsnInfo );
            break;

         case AssignInfo.AR_ASSIGN_TYPE_FUNCTION:
            FunctionAssignInfo fnInfo = GetFunctionAssignInfo( );
            asnInfo.setFunction( fnInfo );
            break;

         case AssignInfo.AR_ASSIGN_TYPE_DDE     :
            DDEInfo  ddeInfo = GetDDEInfo( );
            asnInfo.setDde( ddeInfo ); 
            break;

         case AssignInfo.AR_ASSIGN_TYPE_SQL     :
            AssignSQLInfo sqlInfo = GetAssignSQLInfo( );
            asnInfo.setSql( sqlInfo );
            break;

         case AssignInfo.AR_ASSIGN_TYPE_FILTER_API:
            AssignFilterApiInfo filterApiInfo = GetAssignFilterApiInfo( );
            asnInfo.setFilterApi( filterApiInfo );
            break;

         default                     :
            break;
      }

      return asnInfo;
   }
           
      
   public static FieldAssignInfo[] GetFieldAssignInfoList( )
   throws IOException{

      int numItems = GetInt( "   Number of field/assign pairs (0): ", 0 );
    
      FieldAssignInfo[] fldAssignInfoList = null;

      if( numItems != 0 )
      {
         fldAssignInfoList = new FieldAssignInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            fldAssignInfoList[i] = GetFieldAssignInfo( );
         }
      }     

      return fldAssignInfoList;
   }


   public static OpenDialogInfo GetOpenDialogInfo( )
   throws IOException{

      PrintHeader( "   Active Link Open Dialog Info:" );

      OpenDialogInfo openDlg = new OpenDialogInfo( );

      String serverName =  GetString( "Server Name ():", "" );
      openDlg.setServerName( new ServerNameID( serverName ) );

      NameID schemaName =  GetNameID( "Schema Name ():", true );
      openDlg.setSchemaName( schemaName );

      NameID vuiLabel   =  GetNameID( "Vui Label ():", true );
      openDlg.setVuiLabel( vuiLabel );

      boolean   closeBox   = GetBoolean( "Close Box? (T): ", true );
      openDlg.setCloseBox( closeBox );

      FieldAssignInfo[] inputFields  = GetFieldAssignInfoList( );
      openDlg.setInputValueFieldPairs( inputFields );

      FieldAssignInfo[] outputFields = GetFieldAssignInfoList( );
      openDlg.setOutputValueFieldPairs( outputFields );

      int mode = GetInt( "Window Mode (0 - 8) ( 1 ):", 1 );
      openDlg.setWindowMode( mode );

      String targetLocation = GetString( "Target Location ():", "");
      openDlg.setTargetLocation(targetLocation);

      QualifierInfo  query = GetQualifierInfo( );
      openDlg.setQuery( query );

      boolean noMatchContinue = GetBoolean( "No Match Continue flag (F):", false );
      openDlg.setNoMatchContinue( noMatchContinue );
          
      boolean suppressEmptyLst = GetBoolean( "Suppress Empty List flag (F):", false );
      openDlg.setSuppressEmptyLst(suppressEmptyLst);

      MessageInfo msg = GetMessageInfo( );
      openDlg.setMsg( msg );

      long interval = GetLong( "Polling interval (0):", 0 );
      openDlg.setPollinginterval( interval );
          
      String reportString = GetString( "Report String ():", "" );
      openDlg.setReportString( reportString );

      SortInfo[] sortOrderList = GetSortInfoList( );
      openDlg.setSortOrderList( sortOrderList );

      return openDlg;
   }


   public static CallGuideInfo GetCallGuideInfo( )
   throws IOException{

      PrintHeader( "   Active Link Call Guide Info:" );

      String name = GetString( "      Server Name: " , "" );

      String guideName =  GetString( "      Guide Name: ", "" );

      int guideMode = GetInt( "      Guide Mode: (0): ", 0 );

      FieldID guideTableId = new FieldID( GetLong( "      Guide Table Id (0): ", 0 ) );

      return new CallGuideInfo( name, guideName, guideMode, guideTableId );
   }


   public static GotoGuideLabelInfo GetGotoGuideLabelInfo( )
   throws IOException{

      PrintHeader( "   Active Link Goto Guide Label Info:" );

      String label = GetString( "      Label (): ", "" );  

      return new GotoGuideLabelInfo( label );
   }

   public static PushFieldsInfo[] GetPushFieldsInfoList( )
   throws IOException{

      int numItems = GetInt( "   Number of field/assign pairs (0): ", 0 );

      PushFieldsInfo[] fieldList = null;

      if( numItems != 0 )
      {
         fieldList = new PushFieldsInfo[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {
            fieldList[ i ] = new PushFieldsInfo( );

            fieldList[i].setField( GetAssignFieldInfo( ) );
            fieldList[i].setAssign( GetAssignInfo( ) );           
         }
      }  
        
      return fieldList;
   }


   public static NotifyActionInfo GetNotifyActionInfo( )
   throws IOException{

      NotifyActionInfo info = new NotifyActionInfo( );

      PrintHeader( "Filter Action Notify:" );

      int notifyMechanism = GetInt( "   Notifier, Email, Default, other, or XRef (1, 2, 3, 4-98, 99): ", 0);
      info.setNotifyMechanism( (long) notifyMechanism );
            
      if( notifyMechanism == 99 )
      {
         InternalID  ref = new InternalID( GetLong("   Cross-reference field id: ", 0 ) );
         info.setNotifyMechanismXRef( ref );
      }

      String user =  GetString( "   User name: ", "" );
      info.setUser( user );
           
      String text = GetString( "   Notify text (): ", "" );
      info.setNotifyText( text );

      int notifyPriority = GetInt( "   Notify priority (1 to 10) (1): ", 1 );
      info.setNotifyPriority( notifyPriority );

      String subject = GetString( "   Notify subject (): ", "" );
      info.setSubjectText( subject );

      int fieldIdListType = GetInt("   None, All, specific list, or changed (0, 1, 2, 3) (0): ", 0 );
      info.setFieldIdListType( fieldIdListType );
            
      if( fieldIdListType == 2 )
      {
         InternalID[] idList = GetInternalIDList( );
         info.setFieldIdList( idList );
      }

      return info;
   }


   public static SQLInfo GetSQLInfo( )
   throws IOException{

      PrintHeader( "Action Direct SQL:" );

      String server = GetString( "      Server (): ", "" );

      String command = GetString( "      SQL command (): ", "" );

      return new SQLInfo( server, command );
   }


   public static  GotoActionInfo GetGotoActionInfo( )
   throws IOException{

      PrintHeader( "   Goto Action Info:" );

      long fieldIdOrValue;

      int tag = GetInt( "      Field, Value (1-2): ", 1);

      if( tag == 1 )
      { 
         fieldIdOrValue = GetLong( "      FieldId: ", 0 );
      }
      else
      {
         fieldIdOrValue = GetLong( "      Execution Order: ", 0 );
      }
            
      return new GotoActionInfo( tag, fieldIdOrValue );
           
   }

   public static StatusInfo GetStatusInfo( )
   throws IOException{

      PrintHeader( "Status Info:" );

      int messageType = GetInt( "   Note, Warning, or Error (0, 1, 2) (2) : ",2 );
      long messageNum = GetLong( "   Message number (0): ", 0 );
      String text = GetString( "   Message text (): ", "" );
      String appendedText = GetString( "Appended Text():", "" );

      return new StatusInfo( messageType, messageNum, text, appendedText );
   }

   public static WorkflowObjectListCriteria GetWorkflowObjectListCriteria(boolean retrieveByNames)
   throws IOException
   {
      String schemaName = null;
      long changedSince = 0;

      if (retrieveByNames)
      {
         // Get the names to be retrived
         NameID[] nameList = InputReader.GetNameIDList();
         if( GetBoolean( "For a specific schema? (F):", false ) )
            schemaName = GetString( "Schema Name:", "" );
         changedSince = GetLong( "Get all changed since (0):", 0 );            
         return new WorkflowObjectListCriteria(nameList, schemaName, changedSince);
      }
      else
      {
         if( GetBoolean( "For a specific schema? (F):", false ) )
            schemaName = GetString( "Schema Name:", "" );

         changedSince = GetLong( "Get all changed since (0):", 0 );
                
         return new WorkflowObjectListCriteria( schemaName, changedSince );
      }
   }  
    
   public static ActiveLinkMacroInfo GetActiveLinkMacroInfo( )
   throws IOException{  

      PrintHeader( "   Active Link Macro Info:" );

      String macroName = GetString( "      Macro name: ", "" );

      String text = GetString( "      Macro text(): ", "" );

      MacroParmInfo[] list = null;

      int numItems = GetInt( "      Number of macro parms (0): ", 0 );

      if( numItems != 0 )
      {
         list = new MacroParmInfo[ numItems ];

         String name = null;
         String val  = null;
         for( int i = 0; i < numItems; i++ )
         {
            name =  GetString("         Parm Name (): ", "" );
            val  =  GetString("         Parm Value (): ", "" );

            list[i] = new MacroParmInfo( name, val );
         }
      }

      return new ActiveLinkMacroInfo( macroName, text, list ); 
   }




   public static FieldCharacteristicsInfo GetFieldCharacteristicsInfo( )
   throws IOException{

      PrintHeader( "   Active Link Field Characteristics:" );

      long fieldId = GetLong( "      Field Id (0): ", 0 );
           
      String menu = null;
      if( GetBoolean( "      Change menu? (F): ", false ) )
      {
         menu = GetString( "      Char menu (): ", "" );
      }

      PropInfo[] propList = null;
      if( GetBoolean( "      Change display Properties? (F): ", false ) )
      {
         propList = GetPropInfoList( );
      }

      long focus = 0; // unchanged
      if( GetBoolean( "      Change focus to this field? (F): ", false ) )
      {
         focus = 1;
      }

      int accessOption = GetInt( "      Access option (unchanged, read-only, read/write, disable) (0-3) (0): ", 0 );

      return new FieldCharacteristicsInfo( fieldId, menu, propList, focus, accessOption );
   }


   public static CommitChangesInfo GetCommitChangesInfo( )
   throws IOException{

      PrintHeader( "   Active Link Commit Changes Info :" );

      String schemaName = GetString( "      Schema Name (): ", "" );  

      return new CommitChangesInfo( schemaName );         
   }


   public static CloseWindowInfo GetCloseWindowInfo( )
   throws IOException{

      PrintHeader( "   Active Link Close Window Info :" );

      boolean closeAll = GetBoolean( "Close All flag (F): ", false );  

      return new CloseWindowInfo( closeAll );         
   }


   public static WaitInfo GetWaitInfo( )
   throws IOException {

      PrintHeader( "   Active Link Wait Info:" );

      String title = GetString("      Continue Button Title (): ", "Continue" );

      return new WaitInfo( title );
   } 


      
   public static ExitGuideInfo GetExitGuideInfo( )
   throws IOException{

      PrintHeader( "   Active Link Exit Guide Info:" );

      boolean closeAll = GetBoolean( "      Close All? (T): ", true );  
       
      return new ExitGuideInfo( closeAll );
   }


   public static PermissionInfo GetPermissionInfo( boolean fieldFlag )
   throws IOException{

      PrintHeader( "   Permission Info:" );

      int groupId = GetInt("      Group id (3): ", 0);

      int permissions = 0;

      if( fieldFlag )
      {
         permissions = GetInt( "      None, View, or Change (0, 1, 2): ", 0 );
      }
      else
      {
         permissions = GetInt("      None, Visible, or Hidden(0, 1, 2): ", 0 );
      }

      return new PermissionInfo( new InternalID( groupId ), permissions );
   }

   public static PermissionInfo[] GetPermissionInfoList( boolean fieldFlag )
   throws IOException{

      PrintHeader( "Permission List:" );

      int numItems = GetInt( "   Number of permission defns (0): ", 0 );

      PermissionInfo[] list = null;
    
      if( numItems != 0 )
      {
         list = new PermissionInfo[ numItems ];
    
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetPermissionInfo( fieldFlag );            
         }
      }
      return list;
   }


   public static DiaryLimitInfo GetDiaryLimitInfo()
   throws IOException{

      int fullTextOptions = GetInt( "   FullText Options(0): ", 0 );

      return new DiaryLimitInfo( fullTextOptions );
   }

   public static AttachmentLimitInfo GetAttachmentLimitInfo( )
   throws IOException{

      int maxSize = GetInt( "   maxSize(0): ", 0 );
      int    type = GetInt( "   attachment Type(1)", 1 );
    
      return new AttachmentLimitInfo( maxSize, type );
   }


   public static TableLimitInfo GetTableLimitInfo( )
   throws IOException{

      NameID schema =  GetNameID( "schema name", true );

      ServerNameID server =  new ServerNameID( GetString( "   server name : ", "" ) );

      QualifierInfo qualifier = GetQualifierInfo( );

      int maxRetrieve = GetInt( "  Max rows to retrieve (10): ", 10 );
      int numColumns  = GetInt( "  Number of Columns(0)", 0 );

      return new TableLimitInfo( numColumns, qualifier, maxRetrieve, schema, server ); 
   }

   public static DecimalLimitInfo GetDecimalLimitInfo( )
   throws IOException{

      String low = GetString( "   Decimal range low (0.0): ", "0.0" );
      String high = GetString( "   Decimal range high (5000.0): ", "5000.0" );
      int precision = GetInt( "   Precision (0): ", 0 );

      return new DecimalLimitInfo( low, high, precision );
   }


   public static ColumnLimitInfo GetColumnLimitInfo( )
   throws IOException{

      long parent = GetLong( "   Parent Table field Id : ", 0 );
      long dataField = GetLong( "   Data field Id : ", 0 );
      int dataSource= GetInt("   Data Source: ", 0);
      int colLength = GetInt( "   Length to display(10) : ", 10 );
    
      return new ColumnLimitInfo( new FieldID( parent ), new FieldID( dataField ), 
                                 dataSource, colLength );
   }

   public static CharLimitInfo GetCharLimitInfo( )
   throws IOException{   

      int maxLength = GetInt( "   Maximum length (128): ", 128 );
      int menuStyle = GetInt( "   Menu style - Append or Overwrite (1 or 2) (1): ", 1 );
      int qbe = GetInt( "   Match operation - Anywhere, Leading match, or Equal (1 - 3) (1): ", 1 );

      NameID charMenu = GetNameID( "Character menu", true );

      String pattern = GetString( "   Pattern (): ", "" );

      int option = GetInt( "   FullText Options(0): ", 0 );

      return new CharLimitInfo( maxLength, menuStyle, qbe, charMenu, pattern, option );
   }
       
   public static EnumLimitInfo GetEnumInfo()
   throws IOException
   {
   return new EnumLimitInfo(GetNameIDList());
   }    

   public static ViewLimits GetViewLimits( )
   throws IOException{   
           
      int maxLength = GetInt( "   Maximum length (128): ", 128 );

      return new ViewLimits(maxLength);
   }
       
   public static DisplayLimits GetDisplayLimits( )
   throws IOException{   
           
      int maxLength = GetInt( "   Maximum length (128): ", 128 );

      return new DisplayLimits(maxLength);
   }

   public static CharMenuInfo GetCharMenuInfo( )
   throws IOException{

      PrintHeader( "Char Menu Info:" );

      int menuType = GetInt( "    Menu type - None, List, Query, File, SQL, SS, DD (0 - 6) ( 1 ) :", 1 );

      CharMenuInfo menuInfo = null;

      switch( menuType )
      {
         case Constants.AR_CHAR_MENU_LIST:               
            menuInfo = ( CharMenuInfo )GetCharMenuListInfo( );
            break;
    
         case Constants.AR_CHAR_MENU_QUERY:
            menuInfo = ( CharMenuInfo )GetCharMenuQueryInfo( );
            break;
               
         case Constants.AR_CHAR_MENU_FILE:
            menuInfo = ( CharMenuInfo )GetCharMenuFileInfo( );
            break;

         case Constants.AR_CHAR_MENU_SQL:
            menuInfo = ( CharMenuInfo )GetCharMenuSQLInfo( );
            break;

         case Constants.AR_CHAR_MENU_SS:
            menuInfo = ( CharMenuInfo )GetCharMenuSSInfo( );
            break;
                   
         case Constants.AR_CHAR_MENU_DATA_DICTIONARY:
            menuInfo = (CharMenuInfo) GetCharMenuDDInfo();
            break;

         default :              
            break;
      }

      return menuInfo;
   }


   public static CharMenuItemInfo GetCharMenuItemInfo( )
   throws IOException{

      PrintHeader( "Char Menu Item Info:" );

      CharMenuItemInfo charMenuItem = null;

      NameID menuLabel = null;

      int menuType = GetInt( "    Menu type - Value Or Menu (1, 2) (1):", 1 );
           
      if( menuType != 0 )
      {
         menuLabel = GetNameID( "Menu Label", true );
      }

      switch( menuType )
      {
         case 1 :
            String menuItem = GetString( "    Char menu text(): ", "" );
            charMenuItem = new CharMenuItemInfo( menuLabel, menuItem );
            break;

         case 2:               
            CharMenuInfo menuInfo = GetCharMenuInfo( );
            charMenuItem = new CharMenuItemInfo( menuLabel, menuInfo );
            break;
    
         default :              
            break;
      }

      return charMenuItem;
   }

   public static CharMenuQueryInfo GetCharMenuQueryInfo( )
   throws IOException
   {
      PrintHeader( "Char Menu Query Info:" );

      NameID schema = GetNameID( "      Schema Name (): ", true );

      ServerNameID server =  new ServerNameID( GetString( "      Server (): ", "" ) );

      QualifierInfo qualifier = GetQualifierInfo( );

      FieldID[] labelField = new FieldID[Constants.AR_MAX_LEVELS_DYNAMIC_MENU];
      for (int i = 0; i < labelField.length; i++)
      {
         String prompt = "      Id of the label field " + (i+1) + " (0): ";      
         labelField[i] = new FieldID( GetLong(prompt, 0 ) );
      }
           
      FieldID valueField = new FieldID( GetLong("      Id of the value field (0): ", 0 ) );
      
      boolean sortOnLabel = GetBoolean( "      Sort the label field (T): ", true );

      return new CharMenuQueryInfo( schema, server, qualifier, labelField, valueField, sortOnLabel ); 
   }

   public static CharMenuFileInfo GetCharMenuFileInfo( )
   throws IOException{

      PrintHeader( "Char Menu FILE INFO:" );

      int type = GetInt( "      location type(2):", 2 );
      String name = GetString( "      File Name():", "" );

      return new CharMenuFileInfo( type, name );
   }

   public static CharMenuSQLInfo GetCharMenuSQLInfo( )
   throws IOException
   {
      PrintHeader( "Char Menu SQL INFO:" );

      ServerNameID server =  new ServerNameID( GetString( "      Server (): ", "" ) );

      String command = GetString( "      SQL command (): ", "" );

      int[] labelIndex = new int[Constants.AR_MAX_LEVELS_DYNAMIC_MENU];
      for (int i = 0; i < labelIndex.length; i++)
      {
         String prompt = "      Id of the label index " + (i+1) + " (0): ";       
         labelIndex[i] = GetInt(prompt, 0);
      }
      
      int  valueIndex = GetInt( "      Id of the value index (0): ", 0);

      return new CharMenuSQLInfo( server, command, labelIndex, valueIndex );
   }
   
   public static CharMenuSSInfo GetCharMenuSSInfo( )
   throws IOException{

      PrintHeader( "Char Menu SS INFO:" );
      EntryItem[] keywordList = null;
      EntryItem[] parameterList = null;
            
      ServerNameID server =  new ServerNameID( GetString( "      Server (): ", "" ) );

      NameID menuName = GetNameID( "      Menu Name (): ", true );

      int  numberOfKeywords = GetInt( "Number of Keywords (0): ", 0);
      if( numberOfKeywords != 0 )
      {
         keywordList = GetEntryItemList();
      }
      int  numberOfParameters = GetInt( "Number of Parameters (0): ", 0);
      if( numberOfParameters != 0 )
      {
         parameterList = GetEntryItemList();
      }
      return new CharMenuSSInfo( server, menuName, keywordList, parameterList);
   }

   public static CharMenuDDInfo GetCharMenuDDInfo( )
   throws IOException{
      PrintHeader( "Char Menu DD INFO:" );
            
      CharMenuDDInfo ddMenuInfo = null;
      ServerNameID server =  new ServerNameID( GetString( "      Server (): ", "" ) );
      int  nameType = GetInt( "      Name Type (0 - 2)(0): ", 0 );
      int  valueFormat = GetInt( "      Value Format (0 - 11)(1): ", 1);
      int  structType = GetInt("      Struct Type (0 - 2)(1): ", 1);      
      switch (structType)
      {
         case Constants.AR_CHAR_MENU_DD_NONE:
            break;
         case Constants.AR_CHAR_MENU_DD_FORM:
            int schemaType = GetInt("      Schema Type (0 - 5)(1): ", 1);
            boolean includeHidden = GetBoolean("      Include Hidden (T): ", true);
            ddMenuInfo = new CharMenuDDFormInfo(server, nameType, valueFormat, schemaType, includeHidden);
            break;
         case Constants.AR_CHAR_MENU_DD_FIELD:
            int fieldType = GetInt("      Field Type (0 - 4)(1): ", 1);
            NameID schema = new NameID( GetString( "      Schema (): ", "" ) );
            ddMenuInfo = new CharMenuDDFieldInfo(server, nameType, valueFormat, fieldType, schema);
            break;
         default:
            break;
      }
      return ddMenuInfo;
   }
      
   public static MenuKey GetMenuKey( )
   throws IOException{

      String name = GetString( "Menu Name():", "" );
      return new MenuKey( name );
   }

   public static StructItemInfo GetStructItemInfo( )
   throws IOException{

      int type = GetInt( "   Schema(full,defn,view,mail),Filter,ActLink,<7-obsolete>,CharMenu,\n" +
                        "     Escalation,Dist Map, Schema(min view), Container, Dist Pool,\n"     +
                        "     VUI (1 - 6, 8 - 14): ", 0 );

      NameID name = GetNameID( "   Structure name (): ", true );
           
      NameID selectedElements[] = null;
      if (type == StructItemInfo.VUI || type == StructItemInfo.SCHEMA_MAIL)
      {
         OutputWriter.PrintString("   VUIs to select:\n");
         selectedElements = GetNameIDList();
      }
           
      return new StructItemInfo( type, name, selectedElements );
   }


   public static CharMenuListInfo  GetCharMenuListInfo( )
   throws IOException{

      int numItems = GetInt( "   Number of char menu items (0): ", 0 );
      CharMenuItemInfo[] list = null;
      if( numItems != 0 )
      {
         list = new CharMenuItemInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetCharMenuItemInfo( );           
         }
      }
           
      return new CharMenuListInfo( list );
   }


   public static StructItemInfo[] GetStructItemInfoList( )
   throws IOException{

      PrintHeader( "Struct ItemInfo List:" );

      int numItems = GetInt( "   Number of structure items (0): ", 0 );

      StructItemInfo[] list = null;

      if( numItems != 0 )
      {
         list = new StructItemInfo[numItems];
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetStructItemInfo( );
         }
      }

      return list;
   }

   public static ServerInfo GetServerInfo( )
   throws IOException{

      PrintHeader( "Server info list entry" );

      int operation = GetInt( "Operation (1-121) (1):", 1);
      Value val = GetValue( );

      return new ServerInfo( operation, val );
   }

   public static ServerInfo[] GetServerInfoList( )
   throws IOException{

      int numItems = GetInt( "   Number of server info operations (0): ", 0 );

      ServerInfo[] list = null;

      if( numItems != 0 ) 
      {
         list = new ServerInfo[numItems];
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetServerInfo( );            
         }
      }
      
      return list;
   }


   public static FullTextInfo GetFullTextInfo( )
   throws IOException{

      PrintHeader( "FullText info list entry:" );

      int infoType = GetInt( "InfoType (1-6) (1): ", 1 );

      Value val = null;
      Value[] valList = null;
      FullTextInfo fullText = null;

      switch( infoType )
      {
         case 1:
            val = GetValue( );
            fullText = new FullTextInfo( infoType, val );                
            break;

         case 2 : //_FULLTEXTINFO_STOPWORD:
            valList = GetValueList( );
            fullText = new FullTextInfo( infoType, valList ); 
            break;

         case 3: //_FULLTEXTINFO_REINDEX:
            val = GetValue( );
            fullText = new FullTextInfo( infoType, val ); 
            break;

         case 4: // _FULLTEXTINFO_CASE_SENSITIVE_SRCH:
            val = GetValue( );
            fullText = new FullTextInfo( infoType, val ); 
            break;

         case 5: //_FULLTEXTINFO_STATE:
            val = GetValue( );
            fullText = new FullTextInfo( infoType, val ); 
            break;

         case 6: //_FULLTEXTINFO_FTS_MATCH_OP:
            val = GetValue( );
            fullText = new FullTextInfo( infoType, val ); 
            break;
      }

      return fullText; 
   }
   public static FullTextInfo[] GetFullTextInfoList( )
   throws IOException{

      int numItems = GetInt("   Number of fulltext info types (0): ", 0);

      FullTextInfo[] list = null;

      if( numItems != 0 )
      {
         list = new FullTextInfo[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetFullTextInfo( );
         }
      }  

      return list;
   }

   public static ReferenceType[] GetReferenceTypeList( )
   throws IOException{

      int numItems = GetInt( "   Number of reference types (0): ", 0 );
           
      ReferenceType[] list = null;

      if( numItems != 0 )
      {
         list = new ReferenceType[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetReferenceType( );
         }
      }
      return list;
   }

   public static ReferenceInfo GetReferenceInfo( )
   throws IOException{

      String label = GetString( "   Reference label (): ", "" );

      String description = GetString( "   Reference description (): ", "" );

      ReferenceType refType = GetReferenceType( );

      NameID name = GetNameID( "Reference name", true );

      return new ReferenceInfo( label, description, refType, name );
   }

   public static RealLimitInfo GetRealLimitInfo( )
   throws IOException{

      float rangeLow = GetFloat("   Real range low (0): ", (float) 0);
      float rangeHigh = GetFloat("   Real range high (5000): ", (float) 5000);
      int   precision = GetInt("   Precision (-1 is no precision) (-1): ", -1);
           
      return new RealLimitInfo( rangeLow, rangeHigh, precision );
   }


   public static IntegerLimitInfo GetIntegerLimitInfo( )
   throws IOException{

      long rangeLow = GetLong( "Integer range low (0): ", 0 );
      long rangeHigh = GetLong( "Integer range high (5000): ", 5000 );
           
      return new IntegerLimitInfo( rangeLow, rangeHigh );
   }

   public static FieldListCriteria GetFieldListCriteria( )
   throws IOException{

      NameID name = GetNameID( "Schema Name: ", true );

      Timestamp changedTime = GetTimestamp( "Get all changed since: ", new Timestamp( 0 ) );

      int type = GetInt( "Type of Fields to retrieve (1): ", 1 );

      return new FieldListCriteria( name, changedTime, type );

   }
   public static MenuListCriteria GetMenuListCriteria( )
   throws IOException{

      Timestamp changedTime = GetTimestamp( "Get all changed since (0): ", new Timestamp( 0 ) );

      return new MenuListCriteria( changedTime );

   }

   public static ActiveLinkKey GetActiveLinkKey( )
   throws IOException{
      NameID name = GetNameID( "Active Link name:", true);       
      return new ActiveLinkKey( name );
   }

   public static ActiveLinkActionInfo GetActiveLinkActionInfo( )
   throws IOException{

      PrintHeader( "Active Link Action Info:" );

      ActiveLinkActionInfo action = new ActiveLinkActionInfo( );

      int type= GetInt( " Macro, Fields, Process, Message, Field Characteristics, DDE, Push, SQL, Automation, Open Dialog, Commit Changes, Close Window, Call Guide, Exit Guide, Goto Guide, Wait, Goto Action(1-17): ", 1 );

      switch( type )
      {
         case 1  :
            ActiveLinkMacroInfo activeLinkMacro = GetActiveLinkMacroInfo( );
            action.setMacro( activeLinkMacro );
            break;

         case 2  :
            FieldAssignInfo[] fieldList = GetFieldAssignInfoList( );
            action.setFieldList( fieldList );
            break;

         case 3 :
            String process = GetString( "   Command string (): ", "" );
            action.setProcess( process );
            break;

         case 4 :
            MessageInfo message = GetMessageInfo( );
            action.setMessage( message );
            break;

         case 5 :
            FieldCharacteristicsInfo field = GetFieldCharacteristicsInfo( );
            action.setCharacteristics( field );
            break;

         case 6     :
            DDEInfo  dde = GetDDEInfo( );
            action.setDde( dde );
            break;

         case 7  :
            PushFieldsInfo[] push = GetPushFieldsInfoList( );
            action.setPushFieldsList( push );
            break;

         case 8  :
            SQLInfo sql = GetSQLInfo( );
            action.setSqlCommand( sql );
            break;

         case 9  :
            AutomationInfo auto = GetAutomationInfo( );
            action.setAutomation( auto );
            break;

         case 10  :
            OpenDialogInfo openDlg = GetOpenDialogInfo( );
            action.setOpenDlg( openDlg );
            break;

         case 11  :
            CommitChangesInfo commit = GetCommitChangesInfo( );
            action.setCommitChanges( commit );
            break;

         case 12 :
            CloseWindowInfo closeWnd = GetCloseWindowInfo( );
            action.setCloseWnd( closeWnd);
            break;

         case 13 :
            CallGuideInfo callGuide = GetCallGuideInfo( );
            action.setCallGuide( callGuide );
            break;

         case 14 :
            ExitGuideInfo exitGuide = GetExitGuideInfo( );  
            action.setExitGuide( exitGuide );    
            break;

         case 15 :
            GotoGuideLabelInfo guideLabel = GetGotoGuideLabelInfo( );
            action.setGotoGuide( guideLabel );
            break;

         case 16 :
            WaitInfo wait = GetWaitInfo( );
            action.setWaitAction( wait );
            break;

         case 17 :
            GotoActionInfo gotoAction = GetGotoActionInfo( );
            action.setGotoAction( gotoAction );
            break;
         
         default:
            break;
      }

      return action;

   }

   public static ActiveLinkActionInfo[] GetActiveLinkActionInfoList( boolean actionFlag )
   throws IOException{

      int numItems = 0;

      if( actionFlag )
      {
         numItems = GetInt("Number of actions for the active link (1): ",1);
      }
      else
      {
         numItems = GetInt("Number of elses for the active link (0): ", 0);
      }

      ActiveLinkActionInfo[] list = null;

      if( numItems != 0 )
      {
         list = new ActiveLinkActionInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetActiveLinkActionInfo( );
         }
      }
          
      return list;
   }



   public static ContainerKey GetContainerKey( )
   throws IOException{

      NameID name = GetNameID( "Container Name", true );
           
      return new ContainerKey( name );
   }
    
   public static ContainerOwner GetContainerOwner( )
   throws IOException{

      int type = GetInt( "Container owner type (unowned, all, owned) (0-2) (0): ", 0 );
     
      if( type == 0 || type == 1 )
      {
         return new ContainerOwner( type );
      }
      else
      {
         NameID ownerName =  GetNameID( );
         return new ContainerOwner( type, ownerName );
      }
   }

   public static ContainerOwner[] GetContainerOwnerList( )
   throws IOException{

      int numItems =  GetInt( "Number of container owners (0): ", 0 );

      ContainerOwner[] list = null;
      if( numItems != 0 )
      {
         list = new ContainerOwner[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetContainerOwner( );
         }
      }
      return list;
   }

   public static ContainerType GetContainerType( )
   throws IOException{

      int type =  GetInt( "Container type All, Application, Guide, PackingList(0,1,2,3)(0): ", 0 );
           
      switch( type )
      {
         case 0 : return ContainerType.ALL;
         case 1 : return ContainerType.APPLICATION;
         case 2 : return ContainerType.GUIDE;
         case 3 : return ContainerType.PACKINGLIST;
         default : return null;
      }        
   }
   public static ContainerType[] GetContainerTypeList( )
   throws IOException{

      int numItems =  GetInt( "Number of container types (0): ", 0 );

      ContainerType[] list = null;
      if( numItems != 0 )
      {
         list = new ContainerType[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetContainerType( );
         }
      }
          
      return list;
   }

   public static ReferenceType GetReferenceType( )
   throws IOException{

      PrintPromptWithNewline( "Reference Type( ABOUT_BOX_FORM, ABOUT_BOX_IMAGE,ACTIVELINK," );
           
      PrintPromptWithNewline( "ALL, DISABLE_BEGIN_TASK, FORM_VUI, FORMS, HAS_EXT_HELP,  " ); 
      PrintPromptWithNewline( "HELP_EXT, HELP_FILE, HELP_FILE_NAME, HELP_INDEX_EXT, HELP_INDEX_FILE, " ); 
      PrintPromptWithNewline( "PRIMARY_FORM, CHAR_MENU, CONTAINER, DISTMAPPING_DATA, ESCALATION, " ); 
      PrintPromptWithNewline( "FILTER, GROUP_DATA, ICON, MAXIMIZE_FORMS, NONE, NULL_STRING," ); 
      PrintPromptWithNewline( "PACKINGLIST_APP, PACKINGLIST_GUIDE, PACKINGLIST_PACK, SCHMEA, " ); 
      int type = GetInt( "SMALL_ICON( 0, 28) (22/NONE): ", 27 );  

      switch( type )
      {
         case  0: return ReferenceType.ABOUT_BOX_FORM;
         case  1: return ReferenceType.ABOUT_BOX_IMAGE;
         case  2: return ReferenceType.ACTIVELINK;
         case  3: return ReferenceType.ALL;
         case  4: return ReferenceType.APPLICATION_DISABLE_BEGIN_TASK;
         case  5: return ReferenceType.APPLICATION_FORM_VUI;
         case  6: return ReferenceType.APPLICATION_FORMS;
         case  7: return ReferenceType.APPLICATION_HAS_EXT_HELP;
         case  8: return ReferenceType.APPLICATION_HELP_EXT;
         case  9: return ReferenceType.APPLICATION_HELP_FILE;
         case 10: return ReferenceType.APPLICATION_HELP_FILE_NAME;
         case 11: return ReferenceType.APPLICATION_HELP_INDEX_EXT;
         case 12: return ReferenceType.APPLICATION_HELP_INDEX_FILE;
         case 13: return ReferenceType.APPLICATION_PRIMARY_FORM;
         case 14: return ReferenceType.CHAR_MENU;
         case 15: return ReferenceType.CONTAINER;
         case 16: return ReferenceType.DISTMAPPING_DATA;
         case 17: return ReferenceType.ESCALATION;
         case 18: return ReferenceType.FILTER;
         case 19: return ReferenceType.GROUP_DATA;
         case 20: return ReferenceType.ICON;
         case 21: return ReferenceType.MAXIMIZE_FORMS;
         case 22: return ReferenceType.NONE;
         case 23: return ReferenceType.NULL_STRING;
         case 24: return ReferenceType.PACKINGLIST_APP;
         case 25: return ReferenceType.PACKINGLIST_GUIDE;
         case 26: return ReferenceType.PACKINGLIST_PACK;
         case 27: return ReferenceType.SCHEMA;
         case 28: return ReferenceType.SMALL_ICON;
    
         default : return null;
      }                    

   }

   public static ReferenceBase GetReferenceBase( )
   throws IOException{

      String label = GetString( "Reference Label ():", "" );
           
      String desc = GetString( "Reference Description ():", "" );

      ReferenceType type = GetReferenceType( );

      int dataType = GetInt( "References Data Type AR, EXTERNAL (0, 1) (0):", 0 );

      if( dataType == 0 ) // System reference
      {
         NameID name = GetNameID( "AR reference name", true );

         return new ReferenceInfo( label, desc, type, name );   
      }
      else  // External reference
      {
         InternalID[] idList = GetInternalIDList( );
         PrintHeader( "External Reference Value :" );
         Value val = GetValue( );

         return new ExternalReferenceInfo( label, desc, type, idList, val );    
      }                       
   }

   public static ReferenceBase[] GetReferenceBaseList( )
   throws IOException{

      PrintHeader( "RefernceBase List:" );

      int numItems = GetInt( "   Number of References (0): ", 0 );

      ReferenceBase[] list = null;

      if( numItems != 0 )
      {
         list = new ReferenceBase[numItems];

         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetReferenceBase( );
         }
      }

      return list;
   }

   public static NameID GetNameID(String prompt)
   throws IOException {
      String name = GetString(prompt, "");

      return new NameID(name);
   }

   public static NameID GetNameID( String prompt, boolean nullable )
   throws IOException{

      if (!nullable)
         return GetNameID(prompt);

      String name = GetString( prompt, "" );

      return new NameID( name );               
   }

   public static WorkflowConnectInfo GetWorkflowConnectInfo( )
   throws IOException{

      int type = GetInt( "Workflow Type (1):", 1 );
          
      NameID[] schemas = null;

      int  numberOfSchemas = GetInt( "Number of schemas (1):", 1 );            
      if( numberOfSchemas != 0 )
      {        
         schemas = new NameID[ numberOfSchemas ];
             
         for( int i = 0; i < numberOfSchemas; i++ )
         {
            schemas[ i] = GetNameID( "Schema Name " + ( i + 1 ) + ":", true );
         }
      }
               
      WorkflowConnectInfo workflow = new WorkflowConnectInfo( );

      workflow.setType( type );
      workflow.setSchemaList( schemas );

      return workflow;
   }

   public static FilterActionInfo[] GetFilterActionInfoList( boolean actionFlag )
   throws IOException{

      int numItems = 0;

      if( actionFlag )
      {
         numItems = GetInt( "Number of actions for the filter (1): ", 1 );
      }
      else
      {
         numItems = GetInt( "Number of elses for the filter (0): ", 0 );
      }

      FilterActionInfo[] list = null;

      if( numItems != 0 )
      {
         list = new FilterActionInfo[ numItems ];
         for( int i = 0; i < numItems; i++ )
         {
            list[i] = GetFilterActionInfo( );
         }
      }
          
      return list;
   }


   public static FilterActionInfo GetFilterActionInfo( )
   throws IOException{

      PrintHeader( "Filter Action Info:" );

      FilterActionInfo filterAction = new FilterActionInfo( );

      int action= GetInt( "  Notify, Message, Log, Fields, Process, Push, SQL, Goto Action, CallGuide (1-9):", 10 );

      switch( action )
      {
         case 1  :
            NotifyActionInfo notify = GetNotifyActionInfo( );
            filterAction.setNotify( notify );
            break;

         case 2  :
            FilterStatusInfo message = GetFilterStatusInfo( );
            filterAction.setMessage( message );
            break;

         case 3 :
            String file = GetString( "  Log File (): ", "" );
            filterAction.setLogFile( file );
            break;

         case 4 :
            FieldAssignInfo[] fields = GetFieldAssignInfoList( );
            filterAction.setFieldList( fields );
            break;

         case 5 :
            String process = GetString( "    Process:", "");
            filterAction.setProcess( process );
            break;

         case 6  :
            PushFieldsInfo[]  push = GetPushFieldsInfoList( );
            filterAction.setPushFieldsList( push );
            break;

         case 7  :
            SQLInfo sqlCommand = GetSQLInfo( );
            filterAction.setSqlCommand( sqlCommand );
            break;

         case 8  :
            GotoActionInfo gotoAction = GetGotoActionInfo( );
            filterAction.setGotoAction( gotoAction );
            break;

         case 9  :
            CallGuideInfo callGuide = GetCallGuideInfo( );
            filterAction.setCallGuide( callGuide );
            break;

         default:
            break;
      }
      return filterAction;
   }

   public static FilterKey GetFilterKey( )
   throws IOException{

      NameID name = GetNameID( "Filter name:", true);       
      return new FilterKey( name );
   }

   public static EscalationKey GetEscalationKey( )
   throws IOException{

      NameID name = GetNameID( "Escalation name:", true);       
      return new EscalationKey( name );
   }

   public static SchemaKey GetSchemaKey( )
   throws IOException{

      NameID name = GetNameID( "Schema name: ", true);       
      return new SchemaKey( name );
   }
   public static DayInfo GetDayInfo( )
   throws IOException{

      long minutes = GetLong( "Minutes (0):", 0 );
      long hourMask = GetLong( "HourMask (0):", 0 );
      long day = GetLong( "Day (0):", 0 );
      long weekDay = GetLong( "Week day (0):", 0 );

      return new DayInfo( day, weekDay, hourMask, minutes );
   }

   public static EscalationTmInfo GetEsclationTmInfo( )
   throws IOException{

      EscalationTmInfo timeInfo = new EscalationTmInfo( );

      int type = GetInt( "Escalation Time Format (1-interval /2) (1) :", 1 );
      timeInfo.setEscalationTmType( type );

      int emType = GetInt( "Want to set the Interval or Day/Week (1, 2) (1):", 1 );
       
      if( emType == 1 ) 
      {
         long interval = GetLong( "Escalation Interval (300):", 300 );  
         timeInfo.setInterval( interval );
      }
      else
      {
         DayInfo day = GetDayInfo( );
         timeInfo.setDate( day );  
      }

      return timeInfo;
   }



   public static VerifyUserCriteria GetVerifyUserCriteria( )
   throws IOException{

      VerifyUserCriteria criteria = new VerifyUserCriteria( );
          
      if( GetBoolean( "Want to retrieve all the properties? (F): ", false ) )
      {
         criteria.setRetrieveAll( true );
      }         
      else
      {

   /*         if( GetBoolean( "Want to Set ADMIN_FLAG? (F): ", false ) )
         {
               criteria.setPropertiesToRetrieve( criteria.getParameters( ) || VerifyUserCriteria.ADMIN_FLAG );   
         }
         if( GetBoolean( "Want to Set CUSTOM_FLAG? (F): ", false ) )
         {
               criteria.setPropertiesToRetrieve( criteria.getParameters( ) || VerifyUserCriteria.CUSTOM_FLAG );   
         }
         if( GetBoolean( "Want to Set SUBADMIN_FLAG? (F): ", false ) )
         {
               criteria.setPropertiesToRetrieve( criteria.getParameters( ) || VerifyUserCriteria.SUBADMIN_FLAG );   
         } */
      }

      return criteria;
   }

   public static SupportFileKey GetSupportFileKey( )
   throws IOException{

      SupportFileKey key = new SupportFileKey( );

      NameID name = GetNameID( "Name of associated object:", true );
      key.setName( name );
           
      long fileType = GetLong( "File type -- external report (1) (1):", 1 );
      key.setFileType( fileType );

      long fileID = GetLong( "Supporting ID for object (0):", 0 );
      key.setFileId( fileID );


      return key;
   }
    
   public static SupportFileListCriteria GetSupportFileListCriteria( )
   throws IOException{ 
           
      long fileType = GetLong( "Enter the file type (0):", 0 );

      String name = GetString( "Enter the name ():", "" );

      long  fieldId = GetLong("   Enter the field Id (0): ", 0 );

      long changedSince = GetLong( "Get all changed since (0):", 0 );

   return  new SupportFileListCriteria( fileType, name, fieldId, changedSince );
           
   }
       
   public static LocalizedRequestInfo GetLocalizedRequest()
   throws IOException
   {
      LocalizedRequestInfo req;
      InternalID internalID = new InternalID(0);
      int workflowIfElse = 0;
      int workflowAction = 0;
            
      NameID name = GetNameID("Message name: ");
      InputReader.PrintHeader("Message Type:");
      int messageType = GetInt("   System, Active Link, Filter, Active Link Help,\n" +
                              "   Form Help, Field Help, Container Desc., List Menu Defn,\n" +
                              "   External Report, Container Label, Application Help, \n" +
                              "   Application About, Application Help Index \n" +
                              "   (0 - 13) (0): ", 0);
      switch (messageType)
      {    
         case Constants.AR_LOCAL_TEXT_EXTERN_REPORT:
         case Constants.AR_LOCAL_TEXT_FIELD_HELP:
            internalID = new InternalID(GetInt("Internal ID (0): ", 0));
            break;
               
         case Constants.AR_LOCAL_TEXT_ACT_LINK_MESSAGE:
         case Constants.AR_LOCAL_TEXT_FILTER_MESSAGE:
            workflowIfElse = GetInt("If/Else (0): ", 0);
            workflowAction = GetInt("Action (0): ", 0);
            break;
               
         case Constants.AR_LOCAL_TEXT_SYSTEM_MESSAGE:
         case Constants.AR_LOCAL_TEXT_ACT_LINK_HELP:
         case Constants.AR_LOCAL_TEXT_FORM_HELP:
         case Constants.AR_LOCAL_TEXT_CONTAIN_DESC:
         case Constants.AR_LOCAL_TEXT_LIST_MENU_DEFN:
         default:
            break;
      }

      return new LocalizedRequestInfo(name, messageType, workflowIfElse, workflowAction, internalID);
   }

   public static LocalizedValueCriteria GetLocalizedValueCriteria( )
   throws IOException{ 
           
      LocalizedValueCriteria criteria = new LocalizedValueCriteria();
      criteria.setRetrieveAll(false);
           
      if (GetBoolean( "Get Localized Values? (T): ", true))
         criteria.setPropertiesToRetrieve(LocalizedValueCriteria.VALUE | criteria.getPropertiesToRetrieve());
           
      if (GetBoolean( "Get Timestamps? (T): ", true))
         criteria.setPropertiesToRetrieve(LocalizedValueCriteria.TIMESTAMP | criteria.getPropertiesToRetrieve());
                  
      return criteria;
   }

   public static CompoundSchemaInfo GetCompoundSchemaInfo( )
   throws IOException{
      int type = InputReader.GetInt("Schema Type (1): ", 1);
      if (type > Constants.AR_SCHEMA_VENDOR  || 
         type < Constants.AR_SCHEMA_REGULAR)
      {
         type = Constants.AR_SCHEMA_REGULAR;
      } 
      switch (type) {
      case Constants.AR_SCHEMA_REGULAR:
      case Constants.AR_SCHEMA_DIALOG:
	 return new CompoundSchemaInfo(type);
	 
      case Constants.AR_SCHEMA_JOIN :
         NameID memberA = GetNameID("   Join member A name : ", true);
         NameID memberB = GetNameID("   Join member B name : ", true);
	 QualifierInfo joinQual = GetQualifierInfo();
         int option = GetInt("   Join option(0): ", 0);
	 return new JoinSchemaInfo(memberA, memberB, joinQual, option);
	 
      case Constants.AR_SCHEMA_VIEW:
         String tableName = GetString("   View table name : ", "");
         NameID keyField = GetNameID("   Key Field : ", true);
	 return new ViewSchemaInfo(tableName, keyField);
	 
      case Constants.AR_SCHEMA_VENDOR:
         NameID vendorName = GetNameID("   Vendor name : ", true);
         String vtableName =  GetString("   Vendor table name : ", "");
	 return new VendorSchemaInfo(vendorName, vtableName);      
      }
      return null;
   }
       
   public static LicenseNameID GetLicenseNameID(String prompt)
   throws IOException {
      String name = GetString(prompt, "");

      return new LicenseNameID(name);
   }

   public static LicenseNameID[] GetLicenseNameIDList()
   throws IOException{
    
      LicenseNameID[]   nameList = null;

      int numItems = GetInt("Number of licenses to validate (1): ", 1);
      if( numItems != 0)
      {     
         nameList = new LicenseNameID[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {               
            nameList[i] = new LicenseNameID( GetString( "License Type " + "(" + i + ")", "" ) );
         }
      }

      return nameList;
   }
       
   public static AlertMessageCriteria GetAlertMessageCriteria( )
   throws IOException{ 
           
      AlertMessageCriteria criteria = new AlertMessageCriteria();
      criteria.setRetrieveAll(false);
           
      if (GetBoolean( "Get Timestamp? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.TIMESTAMP | criteria.getPropertiesToRetrieve());
           
      if (GetBoolean( "Get sourceType? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SOURCETYPE | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get priority? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.PRIORITY | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get alertText? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.ALERTTEXT | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get sourceTag? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SOURCETAG | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get serverName? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SERVERNAME | criteria.getPropertiesToRetrieve());
              
      if (GetBoolean( "Get formName? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.FORMNAME | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get objectId? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.OBJECTID | criteria.getPropertiesToRetrieve());
                  
      return criteria;
   }    
                
}