/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ViewCriteria;
import com.remedy.arsys.api.ViewKey;

public class View
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_context;
    private PropInfo[] m_dProps;
    private String m_locale = null;
    private int m_vuiType = 0;
    private ViewKey m_key;
    private static final int TOTAL_PARAMS = 8;
    private static final int NEW_PROPERTIES = 5;
    private static final int NEW_LOCALE = 6;
    private static final int NEW_VUI_TYPE = 7;

    View() {
        this.m_key = new ViewKey(null, null);
        this.m_changeFlags = new CriteriaFlags(8);
    }

    View(NameID nameID, long l) {
        this.m_key = new ViewKey(nameID, new FieldID(l));
        this.m_changeFlags = new CriteriaFlags(8);
    }

    View(NameID nameID, NameID nameID2, long l, PropInfo[] propInfoArray) {
        this.setName(nameID2);
        this.m_key.setSchemaName(nameID);
        this.m_key.setVUIId(new FieldID(l));
        this.m_dProps = propInfoArray;
        this.m_key = new ViewKey(null, null);
        this.m_changeFlags = new CriteriaFlags(8);
    }

    View(NameID nameID, NameID nameID2, long l, PropInfo[] propInfoArray, String string, int n) {
        this.setName(nameID2);
        this.m_key.setSchemaName(nameID);
        this.m_key.setVUIId(new FieldID(l));
        this.m_dProps = propInfoArray;
        this.m_key = new ViewKey(null, null);
        this.m_locale = string;
        this.m_vuiType = n;
        this.m_changeFlags = new CriteriaFlags(8);
    }

    public void activate() {
    }

    public void clear() {
    }

    public Object clone() throws CloneNotSupportedException {
        View view = null;
        view = (View)super.clone();
        view.m_key = (ViewKey)this.m_key.clone();
        int n = this.m_dProps.length;
        view.m_dProps = new PropInfo[n];
        int n2 = 0;
        while (n2 < n) {
            view.m_dProps[n2] = (PropInfo)this.m_dProps[n2].clone();
            ++n2;
        }
        view.m_locale = this.m_locale;
        view.m_vuiType = this.m_vuiType;
        return view;
    }

    public void create() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARCreateView(this.m_context, this);
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public PropInfo[] getDisplayProperties() {
        return this.m_dProps;
    }

    private long getInternalIDAsLong() {
        return this.getVUIId().toLong();
    }

    public ViewKey getKey() {
        return this.m_key;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public NameID getSchemaName() {
        return this.m_key.getSchemaName();
    }

    public FieldID getVUIId() {
        return this.m_key.getVUIId();
    }

    public int getVUIType() {
        return this.m_vuiType;
    }

    public void load() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        ViewCriteria viewCriteria = new ViewCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARGetView(this.m_context, this.m_key, viewCriteria, this);
            Object var5_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void load(ViewCriteria viewCriteria) throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARGetView(this.m_context, this.m_key, viewCriteria, this);
            Object var5_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void passivate() {
    }

    public void remove() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteView(this.m_context, this.getSchemaName(), this.getVUIId().toLong());
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_context = aRServerUser;
    }

    public void setDisplayProperties(PropInfo[] propInfoArray) {
        this.m_dProps = propInfoArray;
        this.m_changeFlags.setParameter(5L, true);
    }

    public void setKey(ViewKey viewKey) {
        this.setSchemaName(viewKey.getSchemaName());
        this.setVUIId(viewKey.getVUIId());
    }

    public void setLocale(String string) {
        this.m_locale = string;
        this.m_changeFlags.setParameter(6L, true);
    }

    void setLongVUIId(long l) {
        this.m_key.setVUIId(new FieldID(l));
    }

    public void setSchemaName(NameID nameID) {
        this.m_key.setSchemaName(nameID);
    }

    public void setVUIId(FieldID fieldID) {
        this.m_key.setVUIId(fieldID);
    }

    public void setVUIType(int n) {
        this.m_vuiType = n;
        this.m_changeFlags.setParameter(7L, true);
    }

    public void store() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARSetView(this.m_context, this, this.m_changeFlags.getParameters());
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void unsetContext() {
        this.m_context = null;
    }
}

