/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.AttachmentInfo;
import com.remedy.arsys.api.ByteListInfo;
import com.remedy.arsys.api.CoordinateInfo;
import com.remedy.arsys.api.DataType;
import com.remedy.arsys.api.Diary;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.Keyword;
import com.remedy.arsys.api.Timestamp;
import java.io.Serializable;
import java.math.BigDecimal;

public class Value
implements Cloneable,
Serializable {
    private DataType _dataType;
    private Object _value;

    public Value() {
        this._value = null;
        this._dataType = DataType.NULL;
    }

    public Value(double d) {
        this._value = new Double(d);
        this._dataType = DataType.REAL;
    }

    public Value(int n) {
        this._value = new Integer(n);
        this._dataType = DataType.INTEGER;
    }

    Value(int n, long l) {
        this._value = new Long(l);
        this._dataType = DataType.toDataType(n);
    }

    Value(int n, String string) {
        DataType dataType = DataType.toDataType(n);
        if (!(dataType.equals(DataType.DECIMAL) || dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY))) {
            throw new IllegalArgumentException("datatype should be decimal, view or display");
        }
        if (dataType.equals(DataType.DECIMAL)) {
            this._value = new BigDecimal(string);
        } else if (dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY)) {
            this._value = string;
        }
        this._dataType = DataType.toDataType(n);
    }

    public Value(long l) {
        this._value = new Long(l);
        this._dataType = DataType.ULONG;
    }

    public Value(AttachmentInfo attachmentInfo) {
        this._value = attachmentInfo;
        this._dataType = DataType.ATTACHMENT;
    }

    public Value(ByteListInfo byteListInfo) {
        this._value = byteListInfo;
        this._dataType = DataType.BYTES;
    }

    public Value(DataType dataType, long l) throws IllegalArgumentException {
        if (dataType != DataType.ENUM && dataType != DataType.ULONG && dataType != DataType.BITMASK) {
            throw new IllegalArgumentException("datatype should be enum,long or bitmask");
        }
        this._value = new Long(l);
        this._dataType = dataType;
    }

    public Value(Diary diary) {
        this._value = diary;
        this._dataType = DataType.DIARY;
    }

    public Value(FieldID fieldID) {
        this._value = new Long(fieldID.toLong());
        this._dataType = DataType.ULONG;
    }

    public Value(Keyword keyword) {
        this._value = keyword;
        this._dataType = DataType.KEYWORD;
    }

    public Value(Timestamp timestamp) {
        this._value = timestamp;
        this._dataType = DataType.TIME;
    }

    Value(Object object, DataType dataType) {
        this._value = object;
        this._dataType = dataType;
    }

    public Value(String string) {
        this._value = string;
        this._dataType = DataType.CHAR;
    }

    public Value(String string, DataType dataType) {
        if (dataType.equals(DataType.INTEGER)) {
            this._value = new Integer(string);
            this._dataType = DataType.INTEGER;
        } else if (dataType.equals(DataType.REAL)) {
            this._value = new Double(string);
            this._dataType = DataType.REAL;
        } else if (dataType.equals(DataType.CHAR)) {
            this._value = string;
            this._dataType = DataType.CHAR;
        } else if (dataType.equals(DataType.TIME)) {
            long l = new Long(string);
            this._value = new Timestamp(l);
            this._dataType = DataType.TIME;
        } else if (dataType.equals(DataType.BITMASK)) {
            this._value = new Long(string);
            this._dataType = DataType.BITMASK;
        } else if (dataType.equals(DataType.DECIMAL)) {
            this._value = new BigDecimal(string);
            this._dataType = DataType.DECIMAL;
        } else if (dataType.equals(DataType.ULONG)) {
            this._value = new Long(string);
            this._dataType = DataType.ULONG;
        } else if (dataType.equals(DataType.ENUM)) {
            this._value = new Long(string);
            this._dataType = DataType.ENUM;
        } else if (dataType.equals(DataType.VIEW)) {
            this._value = string;
            this._dataType = DataType.VIEW;
        } else if (dataType.equals(DataType.DISPLAY)) {
            this._value = string;
            this._dataType = DataType.DISPLAY;
        } else {
            if (dataType.equals(DataType.KEYWORD)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.DIARY)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.BYTES)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.ATTACHMENT)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.JOIN)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.TRIM)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.CONTROL)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.TABLE)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.COLUMN)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.PAGE)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.PAGE_HOLDER)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
            if (dataType.equals(DataType.COORDS)) {
                throw new IllegalArgumentException("datatype not supportd by this method");
            }
        }
    }

    public Value(BigDecimal bigDecimal) {
        this._value = bigDecimal;
        this._dataType = DataType.DECIMAL;
    }

    public Value(CoordinateInfo[] coordinateInfoArray) {
        this._value = coordinateInfoArray;
        this._dataType = DataType.COORDS;
    }

    public Object clone() throws CloneNotSupportedException {
        Value value = (Value)super.clone();
        switch (this.getDataType().toInt()) {
            case 1: {
                value.setValue((Keyword)this._value);
                break;
            }
            case 2: {
                value.setValue(new Integer(this.getIntValue()));
                break;
            }
            case 3: {
                value.setValue(new Double(this.getDoubleValue()));
                break;
            }
            case 4: {
                value.setValue((String)this._value);
                break;
            }
            case 5: {
                value.setValue(((Diary)this._value).clone());
                break;
            }
            case 6: {
                value.setValue(new Long(this.getLongValue()));
                break;
            }
            case 7: {
                value.setValue(((Timestamp)this._value).clone());
                break;
            }
            case 8: {
                value.setValue(new Long(this.getLongValue()));
                break;
            }
            case 9: {
                value.setValue(((ByteListInfo)this._value).clone());
                break;
            }
            case 10: {
                value.setValue(new BigDecimal(((BigDecimal)this._value).toString()));
                break;
            }
            case 11: {
                value.setValue(((AttachmentInfo)this._value).clone());
                break;
            }
            case 40: {
                value.setValue(new Long(this.getLongValue()));
                break;
            }
            case 41: {
                value.setValue(((CoordinateInfo)this._value).clone());
                break;
            }
            case 42: {
                value.setValue((String)this._value);
                break;
            }
            case 43: {
                value.setValue((String)this._value);
                break;
            }
            default: {
                value.setValue(null);
            }
        }
        return value;
    }

    public void describe() {
        System.out.println(this._value);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Value value = (Value)object;
        if (!this._dataType.equals(value.getDataType())) {
            return false;
        }
        switch (this._dataType.toInt()) {
            case 0: {
                return true;
            }
            case 1: {
                return ((Keyword)this._value).equals(value.getValue());
            }
            case 2: {
                return ((Integer)this._value).equals(value.getValue());
            }
            case 3: {
                return ((Double)this._value).equals(value.getValue());
            }
            case 4: {
                return ((String)this._value).equals(value.getValue());
            }
            case 5: {
                return ((Diary)this._value).equals(value.getValue());
            }
            case 7: {
                return ((Timestamp)this._value).equals(value.getValue());
            }
            case 6: 
            case 8: 
            case 40: {
                return ((Long)this._value).equals(value.getValue());
            }
            case 10: {
                return ((BigDecimal)this._value).compareTo(value.getValue()) == 0;
            }
            case 41: {
                return ((CoordinateInfo)this._value).equals(value.getValue());
            }
        }
        return this._value.equals(value.getValue());
    }

    public DataType getDataType() {
        return this._dataType;
    }

    String getDecimalStringValue() {
        return ((BigDecimal)this._value).toString();
    }

    String getDiaryValue() {
        return ((Diary)this._value).toString();
    }

    double getDoubleValue() {
        return (Double)this._value;
    }

    long getEnumValue() {
        return (Long)this._value;
    }

    int getIntValue() {
        return (Integer)this._value;
    }

    int getKeywordValue() {
        return ((Keyword)this._value).toInt();
    }

    long getLongValue() {
        return (Long)this._value;
    }

    long getTimestampValue() {
        return ((Timestamp)this._value).getValue();
    }

    int getType() {
        return this._dataType.toInt();
    }

    public Object getValue() {
        return this._value;
    }

    private void setDataType(DataType dataType) {
        this._dataType = dataType;
    }

    void setKeyword(int n) {
        this._dataType = DataType.KEYWORD;
        this._value = Keyword.toKeyword(n);
    }

    private void setValue(Object object) {
        this._value = object;
    }

    public String toString() {
        if (this._value == null) {
            return null;
        }
        return this._value.toString();
    }
}

