/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.IARObjectFactory;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.Schema;
import com.remedy.arsys.api.SchemaAliasInfo;
import com.remedy.arsys.api.SchemaAliasesCriteria;
import com.remedy.arsys.api.SchemaCriteria;
import com.remedy.arsys.api.SchemaKey;
import com.remedy.arsys.api.SchemaListCriteria;

public class SchemaFactory
implements IARObjectFactory {
    private static final SchemaFactory schemaFactory = new SchemaFactory();

    protected SchemaFactory() {
    }

    public static SchemaKey[] find(ARServerUser aRServerUser, SchemaListCriteria schemaListCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        SchemaKey[] schemaKeyArray = null;
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            schemaKeyArray = proxy.ARGetListSchema(aRServerUser, schemaListCriteria);
            Object var6_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
            throw throwable;
        }
        return schemaKeyArray;
    }

    public static SchemaAliasInfo[] findAliases(ARServerUser aRServerUser, SchemaAliasesCriteria schemaAliasesCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        SchemaAliasInfo[] schemaAliasInfoArray = null;
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            schemaAliasInfoArray = proxy.ARGetListSchemaWithAlias(aRServerUser, schemaAliasesCriteria);
            Object var6_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
            throw throwable;
        }
        return schemaAliasInfoArray;
    }

    public static Schema findByKey(ARServerUser aRServerUser, SchemaKey schemaKey, SchemaCriteria schemaCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (schemaCriteria == null) {
            schemaCriteria = new SchemaCriteria();
        }
        Schema schema = new Schema();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARGetSchema(aRServerUser, schemaKey, schemaCriteria, schema);
            Object var7_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
            throw throwable;
        }
        schema.setName(schemaKey);
        schema.resetChangeFlags();
        return schema;
    }

    public static Schema[] findObjects(ARServerUser aRServerUser, SchemaListCriteria schemaListCriteria, SchemaCriteria schemaCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (schemaCriteria == null) {
            schemaCriteria = new SchemaCriteria();
        }
        Schema[] schemaArray = null;
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            schemaArray = proxy.ARGetListSchemaObjects(aRServerUser, schemaListCriteria, schemaCriteria);
            Object var7_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
            throw throwable;
        }
        if (schemaArray == null) {
            return null;
        }
        int n = 0;
        while (n < schemaArray.length) {
            schemaArray[n].resetChangeFlags();
            ++n;
        }
        return schemaArray;
    }

    public static SchemaFactory getFactory() {
        return schemaFactory;
    }

    public Object newInstance() {
        Schema schema = new Schema();
        return schema;
    }

    public boolean releaseInstance(Object object) {
        return true;
    }
}

