/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.CompoundSchemaInfo;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.EntryListFieldInfo;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.IndexInfo;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.SchemaCriteria;
import com.remedy.arsys.api.SchemaKey;
import com.remedy.arsys.api.SortInfo;

public class Schema
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_context;
    private CompoundSchemaInfo m_compoundSchema;
    private EntryListFieldInfo[] m_getListFields = null;
    private InternalID[] m_adminGrpList;
    private SortInfo[] m_sortInfo;
    private IndexInfo[] m_indexInfo;
    private int m_deleteOption;
    private PropInfo[] m_props;
    private NameID m_defaultVUI;
    private static final int TOTAL_PARAMS = 12;
    private static final int NEW_COMPOUND_SCHEMA = 5;
    private static final int NEW_INTERNALID = 6;
    private static final int NEW_ENTRY_LIST_FIELD = 7;
    private static final int NEW_SORT_LIST = 8;
    private static final int NEW_INDEX_LIST = 9;
    private static final int NEW_PROPERTIES = 10;
    private static final int NEW_DEFAULTVIEW = 11;

    Schema() {
        this.m_compoundSchema = new CompoundSchemaInfo();
        this.m_compoundSchema.m_type = 1;
        this.m_changeFlags = new CriteriaFlags(12);
    }

    Schema(NameID nameID) {
        this.setName(nameID);
        this.m_compoundSchema = new CompoundSchemaInfo();
        this.m_compoundSchema.m_type = 1;
        this.m_changeFlags = new CriteriaFlags(12);
    }

    public void activate() {
    }

    public void clear() {
    }

    public Object clone() throws CloneNotSupportedException {
        Schema schema = null;
        schema = (Schema)super.clone();
        schema.m_compoundSchema = (CompoundSchemaInfo)this.m_compoundSchema.clone();
        schema.m_defaultVUI = (NameID)this.m_defaultVUI.clone();
        int n = this.m_getListFields.length;
        schema.m_getListFields = new EntryListFieldInfo[n];
        int n2 = 0;
        while (n2 < n) {
            schema.m_getListFields[n2] = (EntryListFieldInfo)this.m_getListFields[n2].clone();
            ++n2;
        }
        n = this.m_adminGrpList.length;
        schema.m_adminGrpList = new InternalID[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_adminGrpList[n2] = (InternalID)this.m_adminGrpList[n2].clone();
            ++n2;
        }
        n = this.m_sortInfo.length;
        schema.m_sortInfo = new SortInfo[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_sortInfo[n2] = (SortInfo)this.m_sortInfo[n2].clone();
            ++n2;
        }
        n = this.m_indexInfo.length;
        schema.m_indexInfo = new IndexInfo[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_indexInfo[n2] = (IndexInfo)this.m_indexInfo[n2].clone();
            ++n2;
        }
        n = this.m_props.length;
        schema.m_props = new PropInfo[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_props[n2] = (PropInfo)this.m_props[n2].clone();
            ++n2;
        }
        return schema;
    }

    public void create() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARCreateSchema(this.m_context, this);
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void deleteFields(FieldID[] fieldIDArray, int n) throws ARException {
        long[] lArray = new long[fieldIDArray.length];
        int n2 = 0;
        while (n2 < fieldIDArray.length) {
            lArray[n2] = fieldIDArray[n2].toLong();
            ++n2;
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteMultipleFields(this.m_context, this.getName(), lArray, this.m_deleteOption);
            Object var8_8 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
    }

    public InternalID[] getAdminGrpList() {
        return this.m_adminGrpList;
    }

    public CompoundSchemaInfo getCompoundSchema() {
        return this.m_compoundSchema;
    }

    public NameID getDefaultVUI() {
        return this.m_defaultVUI;
    }

    int getDeleteOption() {
        return this.m_deleteOption;
    }

    public EntryListFieldInfo[] getEntryListFieldInfo() {
        return this.m_getListFields;
    }

    public IndexInfo[] getIndexInfo() {
        return this.m_indexInfo;
    }

    public SchemaKey getKey() {
        return new SchemaKey(this.getName());
    }

    public PropInfo[] getProperties() {
        return this.m_props;
    }

    public int getSchemaType() {
        return this.m_compoundSchema.m_type;
    }

    public SortInfo[] getSortInfo() {
        return this.m_sortInfo;
    }

    public void load() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        SchemaCriteria schemaCriteria = new SchemaCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        SchemaKey schemaKey = new SchemaKey(this.getName());
        try {
            proxy.ARGetSchema(this.m_context, schemaKey, schemaCriteria, this);
            Object var6_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void load(SchemaCriteria schemaCriteria) throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        SchemaKey schemaKey = new SchemaKey(this.getName());
        try {
            proxy.ARGetSchema(this.m_context, schemaKey, schemaCriteria, this);
            Object var6_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void passivate() {
    }

    public void remove() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteSchema(this.m_context, this.getName(), this.m_deleteOption);
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
    }

    public void setAdminGrpList(InternalID[] internalIDArray) {
        this.m_adminGrpList = internalIDArray;
        this.m_changeFlags.setParameter(6L, true);
    }

    private void setCompoundSchema(CompoundSchemaInfo compoundSchemaInfo) {
        this.m_compoundSchema = compoundSchemaInfo;
        this.m_changeFlags.setParameter(5L, true);
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_context = aRServerUser;
    }

    public void setDefaultVUI(NameID nameID) {
        this.m_defaultVUI = nameID;
        this.m_changeFlags.setParameter(11L, true);
    }

    public void setDeleteOption(int n) {
        this.m_deleteOption = n;
    }

    public void setEntryListFieldInfo(EntryListFieldInfo[] entryListFieldInfoArray) {
        this.m_getListFields = entryListFieldInfoArray;
        this.m_changeFlags.setParameter(7L, true);
    }

    public void setIndexInfo(IndexInfo[] indexInfoArray) {
        this.m_indexInfo = indexInfoArray;
        this.m_changeFlags.setParameter(9L, true);
    }

    public void setKey(SchemaKey schemaKey) {
        this.setName(schemaKey);
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_props = propInfoArray;
        this.m_changeFlags.setParameter(10L, true);
    }

    private void setSchemaType(int n) {
        this.m_compoundSchema.m_type = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    public void setSchemaType(int n, CompoundSchemaInfo compoundSchemaInfo) {
        if (n != 1 && n != 0 && n != 4) {
            this.m_compoundSchema = compoundSchemaInfo;
        }
        this.m_compoundSchema.m_type = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    public void setSortInfo(SortInfo[] sortInfoArray) {
        this.m_sortInfo = sortInfoArray;
        this.m_changeFlags.setParameter(8L, true);
    }

    public void store() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARSetSchema(this.m_context, this, this.m_changeFlags.getParameters());
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void unsetContext() {
        this.m_context = null;
    }
}

