/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.CleanUpThread;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class ObjectPool {
    private long expirationTime = 5000L;
    private long cleanupThreadSleepTime = 5000L;
    private long lastCheckOut;
    private Hashtable locked = new Hashtable();
    private Hashtable unlocked = new Hashtable();
    private CleanUpThread cleaner;

    ObjectPool() {
        this.lastCheckOut = System.currentTimeMillis();
        this.cleaner = new CleanUpThread(this, this.expirationTime);
        this.cleaner.setDaemon(true);
        this.cleaner.start();
    }

    synchronized void checkIn(Object object) {
        if (object != null) {
            this.locked.remove(object);
            this.unlocked.put(object, new Long(System.currentTimeMillis()));
        }
    }

    synchronized Object checkOut() throws Exception {
        Object object;
        long l;
        this.lastCheckOut = l = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (this.validate(object)) {
                    this.unlocked.remove(object);
                    this.locked.put(object, new Long(l));
                    return object;
                }
                this.unlocked.remove(object);
                this.expire(object);
                object = null;
            }
        }
        object = this.create();
        this.locked.put(object, new Long(l));
        return object;
    }

    synchronized void cleanUp() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (l - (Long)this.unlocked.get(k) <= this.expirationTime) continue;
            this.unlocked.remove(k);
            this.expire(k);
            k = null;
        }
        System.gc();
    }

    abstract Object create() throws Exception;

    abstract void expire(Object var1);

    abstract boolean validate(Object var1);
}

