/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.AccessNameID;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.PermissionInfo;
import com.remedy.arsys.api.Timestamp;

public abstract class ObjectBase
implements Cloneable {
    private NameID m_name;
    private NameID m_newName;
    private PermissionInfo[] m_permissionList;
    private String m_helpText;
    private Timestamp m_lastUpdateTime;
    private AccessNameID m_owner;
    private AccessNameID m_lastChangedBy;
    private String m_diaryStr;
    protected CriteriaFlags m_changeFlags;
    static final int NEWNAME = 0;
    static final int PERMISSIONS = 1;
    static final int HELPTEXT = 2;
    static final int OWNER = 3;
    static final int DIARY = 4;

    protected ObjectBase() {
        this.m_name = new NameID();
        this.m_newName = new NameID();
        this.m_permissionList = new PermissionInfo[0];
        this.m_helpText = "";
        this.m_lastUpdateTime = new Timestamp();
        this.m_owner = new AccessNameID();
        this.m_lastChangedBy = new AccessNameID();
        this.m_diaryStr = "";
    }

    protected ObjectBase(String string, PermissionInfo[] permissionInfoArray, String string2, long l, String string3, String string4, String string5) {
        this.m_name = new NameID(string);
        this.m_permissionList = permissionInfoArray;
        this.m_helpText = string2;
        this.m_lastUpdateTime = new Timestamp(l);
        this.m_owner = new AccessNameID(string3);
        this.m_lastChangedBy = new AccessNameID(string4);
        this.m_diaryStr = string5;
    }

    public void clear() {
        this.m_name = null;
        this.m_newName = null;
        this.m_permissionList = null;
        this.m_helpText = null;
        this.m_lastUpdateTime = null;
        this.m_owner = null;
        this.m_lastChangedBy = null;
        this.m_diaryStr = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ObjectBase objectBase = (ObjectBase)super.clone();
        objectBase.m_name = (NameID)this.m_name.clone();
        objectBase.m_newName = (NameID)this.m_newName.clone();
        if (this.m_permissionList != null) {
            objectBase.m_permissionList = new PermissionInfo[this.m_permissionList.length];
            int n = 0;
            while (n < this.m_permissionList.length) {
                objectBase.m_permissionList[n] = (PermissionInfo)this.m_permissionList[n].clone();
                ++n;
            }
        }
        if (this.m_helpText != null) {
            objectBase.m_helpText = this.m_helpText;
        }
        objectBase.m_lastUpdateTime = (Timestamp)this.m_lastUpdateTime.clone();
        objectBase.m_owner = (AccessNameID)this.m_owner.clone();
        objectBase.m_lastChangedBy = (AccessNameID)this.m_lastChangedBy.clone();
        if (this.m_diaryStr != null) {
            objectBase.m_diaryStr = this.m_diaryStr;
        }
        return objectBase;
    }

    public String getDiary() {
        return this.m_diaryStr;
    }

    public String getHelpText() {
        return this.m_helpText;
    }

    public AccessNameID getLastChangedBy() {
        return this.m_lastChangedBy;
    }

    public Timestamp getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    public NameID getName() {
        return this.m_name;
    }

    public NameID getNewName() {
        return this.m_newName;
    }

    public AccessNameID getOwner() {
        return this.m_owner;
    }

    public PermissionInfo[] getPermissions() {
        return this.m_permissionList;
    }

    protected void resetChangeFlags() {
        this.m_changeFlags.setRetrieveAll(false);
    }

    public void setDiary(String string) {
        this.m_diaryStr = string;
        this.m_changeFlags.setParameter(4L, true);
    }

    public void setHelpText(String string) {
        this.m_helpText = string;
        this.m_changeFlags.setParameter(2L, true);
    }

    public void setLastChangedBy(AccessNameID accessNameID) {
        this.m_lastChangedBy = accessNameID;
    }

    void setLastChangedBy(String string) {
        this.m_lastChangedBy = new AccessNameID(string);
    }

    void setLastUpdateTime(long l) {
        this.m_lastUpdateTime = new Timestamp(l);
    }

    void setLastUpdateTime(Timestamp timestamp) {
        this.m_lastUpdateTime = timestamp;
    }

    public void setName(NameID nameID) {
        this.m_name = nameID;
    }

    private void setName(String string) {
        this.m_name = new NameID(string);
    }

    public void setNewName(NameID nameID) {
        this.m_newName = nameID;
        if (this.m_name != null && this.m_name.toString().equals("")) {
            this.m_name = nameID;
        }
        this.m_changeFlags.setParameter(0L, true);
    }

    public void setOwner(AccessNameID accessNameID) {
        this.m_owner = accessNameID;
        this.m_changeFlags.setParameter(3L, true);
    }

    void setOwner(String string) {
        this.m_owner = new AccessNameID(string);
    }

    public void setPermissions(PermissionInfo[] permissionInfoArray) {
        this.m_permissionList = permissionInfoArray;
        this.m_changeFlags.setParameter(1L, true);
    }
}

