/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ArithmeticOperationInfo;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.OperandType;
import com.remedy.arsys.api.QueryInfo;
import com.remedy.arsys.api.StatusHistoryValue;
import com.remedy.arsys.api.Value;

public class ArithmeticOrRelationalOperand
implements Cloneable {
    private OperandType m_operandType;
    private Object m_operand;

    public ArithmeticOrRelationalOperand(int n) {
        this.m_operandType = OperandType.LOCAL_VARIABLE;
        this.m_operand = new Integer(n);
    }

    ArithmeticOrRelationalOperand(int n, long l) {
        this.m_operandType = this.toOperandType(n);
        this.m_operand = new FieldID(l);
    }

    public ArithmeticOrRelationalOperand(ArithmeticOperationInfo arithmeticOperationInfo) {
        this.m_operandType = OperandType.ARITHMETIC_OP;
        this.m_operand = arithmeticOperationInfo;
    }

    public ArithmeticOrRelationalOperand(OperandType operandType, FieldID fieldID) {
        this.m_operandType = operandType;
        this.m_operand = fieldID;
    }

    public ArithmeticOrRelationalOperand(QueryInfo queryInfo) {
        this.m_operandType = OperandType.QUERY_INFO;
        this.m_operand = queryInfo;
    }

    public ArithmeticOrRelationalOperand(StatusHistoryValue statusHistoryValue) {
        this.m_operandType = OperandType.STATUS_HISTORY;
        this.m_operand = statusHistoryValue;
    }

    public ArithmeticOrRelationalOperand(Value value) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = value;
    }

    public ArithmeticOrRelationalOperand(Value[] valueArray) {
        this.m_operandType = OperandType.VALUE_SET;
        this.m_operand = valueArray;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = (ArithmeticOrRelationalOperand)super.clone();
        arithmeticOrRelationalOperand.m_operandType = (OperandType)this.m_operandType.clone();
        switch (this.getTypeInt()) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                arithmeticOrRelationalOperand.m_operand = new FieldID(((FieldID)this.m_operand).toLong());
                break;
            }
            case 2: {
                arithmeticOrRelationalOperand.m_operand = ((Value)this.m_operand).clone();
                break;
            }
            case 3: {
                arithmeticOrRelationalOperand.m_operand = ((ArithmeticOperationInfo)this.m_operand).clone();
                break;
            }
            case 4: {
                arithmeticOrRelationalOperand.m_operand = ((StatusHistoryValue)this.m_operand).clone();
                break;
            }
            case 5: {
                Value[] valueArray = (Value[])this.m_operand;
                int n = valueArray.length;
                Value[] valueArray2 = new Value[n];
                int n2 = 0;
                while (n2 < n) {
                    valueArray2[n2] = (Value)valueArray[n2].clone();
                    ++n2;
                }
                arithmeticOrRelationalOperand.m_operand = valueArray2;
                break;
            }
            case 52: {
                arithmeticOrRelationalOperand.m_operand = new Integer(this.getIntValue());
                break;
            }
            case 53: {
                arithmeticOrRelationalOperand.m_operand = ((QueryInfo)this.m_operand).clone();
                break;
            }
            default: {
                arithmeticOrRelationalOperand.m_operand = null;
            }
        }
        return arithmeticOrRelationalOperand;
    }

    long getFieldIDValue() {
        return ((FieldID)this.m_operand).toLong();
    }

    int getIntValue() {
        return (Integer)this.m_operand;
    }

    public OperandType getType() {
        return this.m_operandType;
    }

    int getTypeInt() {
        return this.m_operandType.toInt();
    }

    public Object getValue() {
        return this.m_operand;
    }

    OperandType toOperandType(int n) {
        switch (n) {
            case 1: {
                return OperandType.FIELDID;
            }
            case 2: {
                return OperandType.VALUE;
            }
            case 3: {
                return OperandType.ARITHMETIC_OP;
            }
            case 4: {
                return OperandType.STATUS_HISTORY;
            }
            case 5: {
                return OperandType.VALUE_SET;
            }
            case 50: {
                return OperandType.FIELDID_TRANSACTION;
            }
            case 51: {
                return OperandType.FIELDID_DB;
            }
            case 99: {
                return OperandType.FIELDID_CURRENT;
            }
            case 52: {
                return OperandType.LOCAL_VARIABLE;
            }
            case 53: {
                return OperandType.QUERY_INFO;
            }
        }
        return null;
    }
}

