/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ArithmeticOrRelationalOperand;

public class ArithmeticOperationInfo
implements Cloneable {
    private int m_operation;
    private ArithmeticOrRelationalOperand m_operandLeft;
    private ArithmeticOrRelationalOperand m_operandRight;
    public static final int AR_ARITH_OP_ADD = 1;
    public static final int AR_ARITH_OP_SUBTRACT = 2;
    public static final int AR_ARITH_OP_MULTIPLY = 3;
    public static final int AR_ARITH_OP_DIVIDE = 4;
    public static final int AR_ARITH_OP_MODULO = 5;
    public static final int AR_ARITH_OP_NEGATE = 6;

    public ArithmeticOperationInfo(int n, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2) throws IllegalArgumentException {
        if (!this.validate(n)) {
            throw new IllegalArgumentException("invalid operation in ArithmeticOperationInfo constructor");
        }
        this.m_operation = n;
        this.m_operandLeft = arithmeticOrRelationalOperand;
        this.m_operandRight = arithmeticOrRelationalOperand2;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)super.clone();
        arithmeticOperationInfo.m_operandLeft = (ArithmeticOrRelationalOperand)this.m_operandLeft.clone();
        arithmeticOperationInfo.m_operandRight = (ArithmeticOrRelationalOperand)this.m_operandRight.clone();
        return arithmeticOperationInfo;
    }

    public ArithmeticOrRelationalOperand getLeftOperand() {
        return this.m_operandLeft;
    }

    public int getOperation() {
        return this.m_operation;
    }

    public ArithmeticOrRelationalOperand getRightOperand() {
        return this.m_operandRight;
    }

    private boolean validate(int n) {
        return n >= 1 && n <= 6;
    }
}

