
/*  File:  arerrno.h  */

/* Codes for all the errors that can be returned from the AR Server */

/* error message catalog */
#define AR_CATALOG_FILENAME            "arsystem.cat"

/* set number in catalog for error msgs */
#define AR_ERROR_MSG_SET                            1

/* max error number that will be used by the AR system.  All "user" */
/*  errors should be above this value.                              */
#define AR_MAX_ERROR_NUMBER                      9999

/* no error */
#define AR_ERROR_NONE                               0

/* error message for "can't find msg" */
#define AR_ERROR_NO_MESSAGE                         1

/* messages for the server */
#define AR_NOTE_SIGNAL_RECEIVED                    20
#define AR_NOTE_FATAL_EXIT                         21
#define AR_ERROR_LOG_FILE_FAILURE                  22
#define AR_NOTE_LOG_FILE_RESUME                    23
#define AR_ERROR_FILTER_PROCESS_FAIL               24
#define AR_ERROR_FILTER_FIELDS_MATCH               25
#define AR_NOTE_NO_SERVER_LICENSE                  27
#define AR_ERROR_DEMO_LICENSE_EXPIRED              28
#define AR_NOTE_DEMO_LICENSE_EXPIRE                29
#define AR_ERROR_USER_LICENSE_LIMIT                30
#define AR_NOTE_NEW_USER_LICENSE                   31
#define AR_NOTE_TERM_RECEIVED                      32
#define AR_ERROR_EXEC_PROCESS_FAIL                 33
#define AR_ERROR_LOCK_FILE_OPEN                    34
#define AR_ERROR_DUPLICATE_SERVER                  35
#define AR_ERROR_WRONG_DB_VERSION                  36
#define AR_ERROR_DEBUG_FILE_ERROR                  37
#define AR_ERROR_FILTER_PROCESS_ERROR              38
#define AR_ERROR_FILTER_PROCESS_TIME               39
#define AR_WARN_BAD_RPC_ARGUMENT                   40
#define AR_WARN_BAD_CMD_LINE_ARGUMENT              41
#define AR_WARN_MULTI_NOT_LICENSED                 42
#define AR_ERROR_BAD_MENU_MATCH                    43
#define AR_ERROR_SCHEMA_LICENSE_LIMIT              44
#define AR_WARN_NOT_CONFIG_DAEMON                  45
#define AR_ERROR_ESCALATION_MESSAGE                46
#define AR_WARN_EMAIL_NOTIFY_TIMEOUT               47

#define AR_ERROR_ESCALATION_PROCESS_FAIL           AR_ERROR_FILTER_PROCESS_FAIL
#define AR_ERROR_ESCALATION_FIELDS_MATCH           AR_ERROR_FILTER_FIELDS_MATCH
#define AR_ERROR_ESCALATION_PROCESS_ERROR          AR_ERROR_FILTER_PROCESS_ERROR
#define AR_ERROR_ESCALATION_PROCESS_TIME           AR_ERROR_FILTER_PROCESS_TIME

/* internal errors */
#define AR_ERROR_MAX_RESPONSE_BAD                  48
#define AR_ERROR_BAD_RESPONSE_ID                   49

/* warning messages */
#define AR_WARN_ADMIN_ONLY_ACCESS                  50
#define AR_WARN_ID_NOT_IN_SCHEMA                   51
#define AR_WARN_CORE_SUPPORT_FIELD                 52
#define AR_WARN_PERM_REQUIRES_ADMIN                53
#define AR_WARN_NOTHING_TO_SET                     54
#define AR_WARN_ITEM_NOT_IMPORTED                  55
#define AR_WARN_NO_SUCH_ENTRY                      56
#define AR_WARN_NULL_IN_STAT_OP                    57
#define AR_WARN_NO_SUCH_USER                       59
#define AR_WARN_NO_READ_ACCESS                     60
#define AR_WARN_NO_READ_ACCESS_IND                 61
#define AR_WARN_NO_ACCESS_TO_ENTRY                 62
#define AR_WARN_ACCESS_CONTROL_SKIP                63
#define AR_WARN_LOG_FILE_ACCESS                    64
#define AR_WARN_MULTI_SCHEMA_FILTER                65
#define AR_WARN_MAX_ENTRIES_RETRIEVED              66
#define AR_WARN_MENU_FILE_OPEN                     67
#define AR_WARN_BAD_RPC_ENV_VARIABLE               68
#define AR_WARN_VIEW_CREATE_FAILED                 69
#define AR_WARN_MISSING_MENUS                      70
#define AR_WARN_ADMIN_ONLY_ACCESS_AL               71
#define AR_WARN_MAX_ENTRIES_SERVER                 72
#define AR_WARN_PENDING_SUB_MODE_CHNG              73
#define AR_WARN_DUPLICATE_INDEX                    74
#define AR_WARN_NO_FREE_FLOATING                   75
#define AR_NOTE_UPGRADE_TO_FLOATING                76
#define AR_WARN_NO_FREE_FLOATING_FULL              77
#define AR_NOTE_UPGRADE_TO_FLOAT_FULL              78
#define AR_WARN_SQL_DEL_COL_FAIL                   80
#define AR_WARN_DISTRIB_CORE_FIELD                 81
#define AR_WARN_LONG_OUT_OF_INDEX                  82
#define AR_WARN_LONG_OUT_OF_GET_LIST               83
#define AR_WARN_LONG_OUT_OF_SORT_LIST              84
#define AR_WARN_INDEX_IGNORED                      85

/* limits to support of features */
#define AR_WARN_NO_FLAT_FILE_INDEX                 86
#define AR_WARN_FLAT_FILE_DB_LIMIT                 87
#define AR_WARN_FLAT_FILE_NO_SQL                   88
#define AR_WARN_NO_FLAT_FILE_JOIN                  89

#define AR_WARN_MIN                                50
#define AR_WARN_MAX                                89

/* rpc errors */
#define AR_ERROR_CONNECT                           90
#define AR_ERROR_RPC_CALL                          91
#define AR_ERROR_RPC_TIMEOUT                       92
#define AR_ERROR_RPC_TIMEOUT_2                     93
#define AR_ERROR_RPC_TIMEOUT_3                     94

/* support and licensing errors */
#define AR_ERROR_RPC_INIT                          95
#define AR_WARN_CAP_UNSUP_BY_CLNT                  96
#define AR_ERROR_ONE_UNLIC_CONNECT                 97
#define AR_ERROR_NO_LONGER_SUPPORTED               98
#define AR_ERROR_DUP_REM_SERVER_ID                 99

/* parameter validation errors */
#define AR_ERROR_ENTRYID_EMPTY                    100
#define AR_ERROR_ENTRYID_TOO_LONG                 101
#define AR_ERROR_NAME_EMPTY                       102
#define AR_ERROR_NAME_TOO_LONG                    103
#define AR_ERROR_FIELD_VALUE_EMPTY                104
#define AR_ERROR_RESULT_LIST_NULL                 105
#define AR_ERROR_ENTRYID_LIST_EMPTY               106
#define AR_ERROR_STATS_LIST_EMPTY                 107
#define AR_ERROR_FIELD_DISPLAY_BAD                108
#define AR_ERROR_FILENAME_TOO_LONG                109
#define AR_ERROR_DATA_TYPE_BAD                    110
#define AR_ERROR_DEFAULT_VALUE_BAD                111
#define AR_ERROR_CHAR_MENU_EMPTY                  112
#define AR_ERROR_NAME_LIST_EMPTY                  113
#define AR_ERROR_NAME_LIST_ITEM                   114
#define AR_ERROR_OP_SET_BAD                       115
#define AR_ERROR_FILTER_ACTION_EMPTY              116
#define AR_ERROR_COMMAND_BAD                      117
#define AR_ERROR_FIELD_OPTION_BAD                 118
#define AR_ERROR_CREATE_MODE_BAD                  119
#define AR_ERROR_UNSUPP_DATATYPE                  120
#define AR_ERROR_ENTRYID_LIST_ITEM                121
#define AR_ERROR_SERVER_IREQ_EMPTY                122
#define AR_ERROR_SERVER_INFO_TAG_BAD              123
#define AR_ERROR_FIELD_VALUE_ITEM                 124
#define AR_ERROR_STATS_LIST_ITEM                  125
#define AR_ERROR_STATS_OP_BAD                     126
#define AR_ERROR_PERM_LIST_ITEM                   127
#define AR_ERROR_PERMISSIONS_BAD                  128
#define AR_ERROR_FIELD_LIMIT_BAD                  129
#define AR_ERROR_CHAR_MENU_ITEM                   130
#define AR_ERROR_CHAR_MENU_TYPE_BAD               131
#define AR_ERROR_STRUCT_ITEM_EMPTY                132
#define AR_ERROR_STRUCT_ITEM_BAD                  133
#define AR_ERROR_STRUCT_ITEM_ITEM                 134
#define AR_ERROR_FILTER_ACTION_BAD                135
#define AR_ERROR_NOTIFY_MECH_BAD                  136
#define AR_ERROR_MESSAGE_TYPE_BAD                 137
#define AR_ERROR_MESSAGE_NUM_BAD                  138
#define AR_ERROR_CORE_FIXED_OPTIONS               139
#define AR_ERROR_STATUS_REQ_DEFAULT               140
#define AR_ERROR_QUAL_NONE_NOT_TOP                141
#define AR_ERROR_QUAL_OPERATION_BAD               142
#define AR_ERROR_REL_OP_EMPTY                     143
#define AR_ERROR_REL_OP_BAD                       144
#define AR_ERROR_ARITH_OP_EMPTY                   145
#define AR_ERROR_ARITH_OP_BAD                     146
#define AR_ERROR_FVA_EMPTY                        147
#define AR_ERROR_FVA_TAG_BAD                      148
#define AR_ERROR_USER_MISSING                     149
#define AR_ERROR_SERVER_MISSING                   150
#define AR_ERROR_SCHEMA_MISSING                   151
#define AR_ERROR_SORT_LIST_ITEM                   152
#define AR_ERROR_SORT_OP_BAD                      153
#define AR_ERROR_MALLOC_CLIENT_FAIL               154
#define AR_ERROR_RETURN_BUFFER_BAD                155
#define AR_ERROR_INPUT_BUFFER_BAD                 156
#define AR_ERROR_FIELD_ID_CORE                    157
#define AR_ERROR_ENTID_DEF_TOO_LONG               158
#define AR_ERROR_DECOMPRESSION_FAILURE            160
#define AR_ERROR_INVALID_SESSION_ID               161
#define AR_ERROR_NOTIFY_TEXT_BAD                  162
#define AR_ERROR_NOTIFY_FIELD_ID_BAD              163
#define AR_ERROR_ITEMS_BUT_NULL_PTR               165
#define AR_ERROR_DEFAULT_TYPE_ERROR               166
#define AR_ERROR_LIMIT_TYPE_ERROR                 167
#define AR_ERROR_FILTER_SET_ERROR                 168
#define AR_ERROR_ORDER_BAD                        169
#define AR_ERROR_STAT_HIST_TAG_BAD                170
#define AR_ERROR_STAT_HIST_ENUM_BAD               171
#define AR_ERROR_SERVICE_NOT_STARTED              172
#define AR_ERROR_LANGUAGE_BAD                     173
#define AR_ERROR_DISP_BAD_FOR_TYPE                174
#define AR_ERROR_DISP_PARM_BAD                    175
#define AR_ERROR_DUPLICATE_ENUM_VAL               176
#define AR_ERROR_CHANGE_IN_VIEW_GRP               177
#define AR_ERROR_FIELD_ID_NULL                    178
#define AR_ERROR_PATTERN_BAD                      179
#define AR_ERROR_DEFAULT_VALUE_LONG               180
#define AR_ERROR_FIELD_ID_RESERVED                181
#define AR_ERROR_TOO_MANY_ACTIONS                 182
#define AR_ERROR_DUP_ID_IN_PERM_LIST              183
#define AR_ERROR_QUOTE_IN_ENTRYID                 184
#define AR_ERROR_SYSTEM_NO_DEFAULT                185
#define AR_ERROR_CHAR_MENU_SYSTEM                 186
#define AR_ERROR_EXEC_MASK_BAD                    187
#define AR_ERROR_EXEC_MASK_REQ_FIELD              188
#define AR_ERROR_ACTLINK_ACTION_EMPTY             189
#define AR_ERROR_ACTLINK_ACTION_BAD               190
#define AR_ERROR_ASSIGN_TYPE_BAD                  191
#define AR_ERROR_FIELD_ASSIGN_EMPTY               192
#define AR_ERROR_FIELD_ASSIGN_ITEM                193
#define AR_ERROR_FIELD_TAG_BAD                    194
#define AR_ERROR_FIELD_EMPTY                      195
#define AR_ERROR_NO_MACRO_NAME_TEXT               196
#define AR_ERROR_KEYWORD_BAD                      197
#define AR_ERROR_NO_DEFAULT_KEYWORD               198
#define AR_ERROR_MISSING_PARM_NAME                199
#define AR_ERROR_MACRO_VALUE_TOO_BIG              200
#define AR_ERROR_BAD_FIELD_TAG                    201
#define AR_ERROR_NOTIFY_NAME_BAD                  202
#define AR_ERROR_VALUE_LIST_EMPTY                 203
#define AR_ERROR_NOTIFY_PRIORITY_BAD              204
#define AR_ERROR_CHAR_MENU_CLASS_BAD              206
#define AR_ERROR_MENU_REFRESH_BAD                 207
#define AR_ERROR_MENU_FILE_LOC_BAD                208
#define AR_ERROR_MENU_FILENAME_BAD                209
#define AR_ERROR_INDEX_LEN_TOO_LONG               210
#define AR_ERROR_NUM_INDEX_FIELDS_BAD             211
#define AR_ERROR_DISPLAY_LIST_EMPTY               212
#define AR_ERROR_QUALIFIER_NULL                   213
#define AR_ERROR_FIELD_LIST_BAD                   214
#define AR_ERROR_FIELD_LIST_TOO_LONG              215
#define AR_ERROR_SERVER_INFO_EMPTY                216
#define AR_ERROR_SERVER_INFO_SET_BAD              217
#define AR_ERROR_SERVER_INFO_GET_BAD              218
#define AR_ERROR_SERVER_INFO_TYPE                 219
#define AR_ERROR_LOCAL_VAR_NUM_BAD                220
#define AR_ERROR_QUERY_VALUE_EMPTY                221
#define AR_ERROR_QUERY_VALUE_ITEM                 222
#define AR_ERROR_QUERY_VAL_MULTI_BAD              223
#define AR_ERROR_CANNOT_INDEX_LONG                224
#define AR_ERROR_ONLY_REF_CURRENT                 225
#define AR_ERROR_QUAL_NOT_GET_LIST                226
#define AR_ERROR_FIELD_FOCUS_BAD                  227
#define AR_ERROR_FIELD_ACCESS_BAD                 228
#define AR_ERROR_FUNCTION_EMPTY                   229
#define AR_ERROR_FUNCTION_BAD                     230
#define AR_ERROR_PARAM_LIST_EMPTY                 231
#define AR_ERROR_VALUE_SET_TYPE_DIFF              232
#define AR_ERROR_FUNCTION_PARMS_BAD               233
#define AR_ERROR_SET_PROC_TIME_BAD                234
#define AR_ERROR_USER_LIST_TYPE_BAD               235
#define AR_ERROR_SET_LIC_TIME_BAD                 236
#define AR_ERROR_DDE_NAME_BAD                     237
#define AR_ERROR_DDE_ITEM_BAD                     238
#define AR_ERROR_DDE_ACTION_BAD                   239
#define AR_ERROR_CANNOT_SORT_LONG                 240
#define AR_ERROR_CANNOT_GETLIST_LONG              241
#define AR_ERROR_QUAL_FILTER_ONLY                 242
#define AR_ERROR_DDE_EMPTY                        243
#define AR_ERROR_DDE_PATH_BAD                     244
#define AR_ERROR_MAX_DAEMONS_BAD                  245
#define AR_ERROR_FIRETM_TYPE_BAD                  246
#define AR_ERROR_INTERVAL_BAD                     247
#define AR_ERROR_DAY_BAD                          248
#define AR_ERROR_HOUR_BAD                         249
#define AR_ERROR_MINUTE_BAD                       250
#define AR_ERROR_ENABLE_BAD                       251
#define AR_ERROR_SUBADMIN_BAD                     252
#define AR_WARN_SUBADMIN_BAD                      253
#define AR_ERROR_SUBJECT_TEXT_BAD                 254
#define AR_ERROR_SUBMITTER_MODE_BAD               255
#define AR_ERROR_SERVER_STAT_TAG_BAD              256
#define AR_ERROR_DUP_DISPLAY_TAG                  257
#define AR_ERROR_DS_RPC_SOCKET_BAD                258
#define AR_ERROR_NO_MATCH_BAD                     259
#define AR_ERROR_MULTI_MATCH_BAD                  260
#define AR_ERROR_SQL_COMMAND_EMPTY                261
#define AR_ERROR_CANNOT_GROUP_LONG                262
#define AR_ERROR_SAVE_LOGIN_BAD                   263
#define AR_ERROR_MENU_SERVER_BAD                  264
#define AR_ERROR_EMPTY_COMSCHEMA                  265
#define AR_ERROR_BAD_JOIN_MEMBER                  266
#define AR_ERROR_BAD_JOIN_QUERY                   267
#define AR_ERROR_BAD_VIEW_SCHEMA                  268
#define AR_ERROR_BAD_SCHEMA_TYPE                  269
#define AR_ERROR_EMPTY_FIELDMAP                   270
#define AR_ERROR_BAD_JOIN_MAP_INDEX               271
#define AR_ERROR_BAD_VIEW_MAP_NAME                272
#define AR_ERROR_BAD_MAPPING_TYPE                 273
#define AR_ERROR_BAD_COMSCHEMA_CHANGE             274
#define AR_ERROR_INDEX_NOT_ALLOWED                275
#define AR_ERROR_SCHEMA_DEPENDED                  276
#define AR_ERROR_FIELD_DEPENDED                   277
#define AR_ERROR_FIELD_IN_JOIN_QUAL               278
#define AR_ERROR_CREATE_DELETE_JOIN               279
#define AR_ERROR_NO_SUPPORT_IN_FLAT               280
#define AR_ERROR_NO_MULTI_ACTLINK                 281
#define AR_ERROR_DEFAULT_VUI_EXISTS               282
#define AR_ERROR_NO_DATATYPE_ON_SERVER            283
#define AR_ERROR_ESCL_ACTION_EMPTY                284
#define AR_ERROR_NOT_ALLOWED_IN_QUAL              285
#define AR_ERROR_NO_DISPLAY_IN_QUERY              286
#define AR_ERROR_NO_STATUS_FIELD                  287
#define AR_ERROR_STATUS_HISTORY_EXISTS            288
#define AR_ERROR_NO_NESTED_OUTER_JOIN             289
#define AR_ERROR_NO_JOIN_ACCESS                   290
#define AR_ERROR_MESSAGE_TEXT_BAD                 291
#define AR_ERROR_BAD_EXISTANCE_ARRAY              292
#define AR_ERROR_BAD_FIELDLIST_COLUMN             293
#define AR_ERROR_TOO_MANY_ENTRY                   294
#define AR_ERROR_FILE_POINTER_BAD                 295
#define AR_ERROR_BAD_SUP_FILE_TYPE                296
#define AR_ERROR_RELEASE_TOO_RECENT               297
#define AR_ERROR_FILTER_MAX_TOTAL                 298
#define AR_ERROR_FILTER_MAX_STACK                 299

/* runtime errors */
#define AR_ERROR_MALLOC_FAILED                    300
#define AR_ERROR_FILE_WRITE                       301
#define AR_ERROR_NO_SUCH_ENTRY                    302
#define AR_ERROR_NO_SUCH_SCHEMA                   303
#define AR_ERROR_MUST_BE_ADMIN                    304
#define AR_ERROR_ID_TOO_LONG                      305
#define AR_ERROR_VALUE_OUT_OF_LIMIT               306
#define AR_ERROR_REQ_VALUE_MISSING                307
#define AR_ERROR_DUPLICATE_FIELD                  308
#define AR_ERROR_MODIFIED_SINCE_GET               309
#define AR_ERROR_WRONG_DATA_TYPE                  310
#define AR_ERROR_ID_NOT_IN_SCHEMA                 311
#define AR_ERROR_BAD_ARITH_OP                     312
#define AR_ERROR_BAD_REL_OP                       313
#define AR_ERROR_NO_SUCH_FIELD                    314
#define AR_ERROR_ENTRIES_NO_DELETE                315
#define AR_ERROR_TEMP_FILE_FAILURE                316
#define AR_ERROR_DUPLICATE_SCHEMA                 317
#define AR_ERROR_NO_SUCH_GROUP                    318
#define AR_ERROR_CORE_LENGTH                      319
#define AR_ERROR_NO_SUCH_CHAR_MENU                320
#define AR_ERROR_CHAR_MENU_TOO_DEEP               321
#define AR_ERROR_INVALID_HIERARCHY                322
#define AR_ERROR_NO_SUCH_FILTER                   323
#define AR_ERROR_NO_SUCH_ADMIN_EXT                324
#define AR_ERROR_DUPLICATE_FILTER                 325
#define AR_ERROR_REQ_VALUE_NULL                   326
#define AR_ERROR_STAT_OP_BAD_TYPE                 327
#define AR_ERROR_DUPLICATE_ADMIN_EXT              328
#define AR_ERROR_PASSWORD_MISMATCH                329
#define AR_ERROR_NO_WRITE_ACCESS                  330
#define AR_ERROR_NO_WRITE_ACCESS_IND              331
#define AR_ERROR_NO_WRITE_ACCESS_CRE              332
#define AR_ERROR_NO_ACCESS_TO_FIELD               333
#define AR_ERROR_BAD_AR_RESERV_DEFN               334
#define AR_ERROR_RESERV_FIELD_FORMAT              335
#define AR_ERROR_ID_IN_GROUP_LIST                 336
#define AR_ERROR_NO_LICENSE_DB_LIMIT              337
#define AR_ERROR_MERGE_DUPLICATE_ID               338
#define AR_ERROR_DIARY_FORMAT                     339
#define AR_ERROR_STAT_HIST_FORMAT                 340
#define AR_ERROR_CANNOT_RUN_PROCESS               341
#define AR_ERROR_DIRECTORY_OPEN_FAIL              342
#define AR_ERROR_BAD_FILTER_DEFN                  343
#define AR_ERROR_GROUP_TYPE_CONFLICT              344
#define AR_ERROR_DUPLICATE_ACTLINK                345
#define AR_ERROR_NO_SUCH_ACTLINK                  346
#define AR_ERROR_NO_ACCESS_TO_ACTLINK             347
#define AR_ERROR_GROUP_CACHE_EMPTY                348
#define AR_ERROR_DELETE_CORE_FIELD                349
#define AR_ERROR_DIVIDE_BY_0                      350
#define AR_ERROR_PASSWORD_IN_QUALIFY              351
#define AR_ERROR_GROUP_NOTIFY_LOOP                352
#define AR_ERROR_NO_ACCESS_TO_SCHEMA              353
#define AR_ERROR_NO_ACCESS_TO_ADMEXT              354
#define AR_ERROR_NO_ACCESS_TO_FILTER              355
#define AR_ERROR_DUPLICATE_CHAR_MENU              356
#define AR_ERROR_CHAR_MENU_TOO_LONG               357
#define AR_ERROR_MENU_FILE_ACCESS                 358
#define AR_ERROR_BAD_RPC_FOR_OP                   359
#define AR_ERROR_NO_UNQUAL_QUERY                  361
#define AR_ERROR_FLAT_FILE_DB_LIMIT               362
#define AR_ERROR_REQ_VALUE_BAD_DEF                363
#define AR_ERROR_DIARY_VALUE_NULL                 364
#define AR_ERROR_BAD_SPECIAL_RPC_OP               365
#define AR_ERROR_NO_SUCH_ESCALATION               366
#define AR_ERROR_DUPLICATE_ESCALATION             367
#define AR_ERROR_BAD_ESCALATION_DEFN              368
#define AR_ERROR_NO_ACCESS_TO_ESCALATION          369
#define AR_ERROR_NO_SCHEMAID                      370
#define AR_ERROR_SUBMITTER_LOCKED                 371
#define AR_ERROR_NOTIFICATION_ERROR               372
#define AR_ERROR_NO_ACCESS_TO_DIST_MAP            373
#define AR_ERROR_NO_SUCH_DIST_MAP                 374
#define AR_ERROR_DUPLICATE_DIST_MAP               375
#define AR_ERROR_DIST_NOT_MASTER                  376
#define AR_ERROR_MISSING_QUOTE_IN_DS              377
#define AR_ERROR_MUST_BE_DISTRIB                  378
#define AR_ERROR_IMPORT_DISTRIBUTED               379
#define AR_ERROR_FILTER_REF_NO_MATCH              380
#define AR_ERROR_FILTER_MULTI_MATCH               381
#define AR_ERROR_DUP_ON_UNIQUE_INDEX              382
#define AR_ERROR_FILE_MENU_TOO_LONG               383
#define AR_ERROR_INVALID_CHAR_IN_NAME             384
#define AR_ERROR_DUP_ID_IN_MULTIPLE               385
#define AR_ERROR_NESTED_EXCEPTION                 386
#define AR_ERROR_VIOLATE_INTEGRITY                387
#define AR_ERROR_NO_SUCH_VUI                      388
#define AR_ERROR_DUPLICATE_VUI                    389
#define AR_ERROR_DELETE_LAST_VUI                  390
#define AR_ERROR_CREATE_VUI                       391
#define AR_ERROR_DUPLICATE_DB_NAME                392
#define AR_ERROR_STATUS_HIS_IN_MENU               393
#define AR_ERROR_ADMIN_ONLY_MODE                  394
#define AR_ERROR_REMOTE_PROC_TIMEOUT              395
#define AR_ERROR_NO_SUCH_SUP_FILE                 396
#define AR_ERROR_GROUPLIST_LENGTH                 397
#define AR_ERROR_MALLOC_FAILED_FOR_CACHE          398
#define AR_ERROR_MALLOC_FAILED_FOR_SHARED_CACHE   399

/* definition file errors */
#define AR_ERROR_NOT_SCHEMA_DEFN                  400
#define AR_ERROR_WRONG_DEFINITION                 401
#define AR_ERROR_INCORRECT_FORMAT                 402
#define AR_ERROR_DEF_COUNT_MISMATCH               403
#define AR_ERROR_UNKNOWN_CORE_FIELD               404
#define AR_ERROR_BAD_CORE_DEFN                    405
#define AR_ERROR_MISSING_CORE_FIELD               406
#define AR_ERROR_DUPLICATE_FIELD_ID               407
#define AR_ERROR_ENUM_REQ_LIMITS                  408
#define AR_ERROR_NO_DEFN_IN_FILE                  409
#define AR_ERROR_NOT_FILTER_DEFN                  410
#define AR_ERROR_NOT_ADMIN_EXT_DEFN               411
#define AR_ERROR_BAD_IMPORT_FORMAT                412
#define AR_ERROR_NOT_ACTLINK_DEFN                 413
#define AR_ERROR_NOT_CHAR_MENU_DEFN               414
#define AR_ERROR_NOT_ESCALATION_DEFN              415
#define AR_ERROR_NOT_DIST_MAP_DEFN                416
#define AR_ERROR_RESERV_GROUP_LIST                417
#define AR_ERROR_INCORRECT_JOIN                   418
#define AR_ERROR_INCORRECT_VIEW                   419
#define AR_ERROR_INCORRECT_FIELD_TYPE             420
#define AR_ERROR_INCORRECT_FIELD_MAP              421
#define AR_ERROR_ESCL_ACTION_BAD                  422
#define AR_ERROR_NOT_CONTAINER_DEFN               423
#define AR_ERROR_PF_ONLY_REF_CURRENT              424

/* external file errors */
#define AR_WARN_REP_FILE_OPEN_FAIL                450
#define AR_WARN_REP_FILE_LOAD_FAIL                451

/* configuration file errors */
/* application license auditing message*/
#define AR_ERROR_MISSING_APPL_AUDIT_INFO          460

/* upgrade process errors */
#define AR_ERROR_TOO_FEW_UP_ARGS                  475
#define AR_ERROR_TOO_MANY_UP_ARGS                 476

/* flat-file database errors */
#define AR_ERROR_DB_OPEN_FAILED                   500
#define AR_ERROR_NOT_A_DB_FILE                    501
#define AR_ERROR_FILE_DB_FORMAT                   502
#define AR_ERROR_DB_WRITE                         503
#define AR_ERROR_NO_SCHEMA_DEFN                   504
#define AR_ERROR_SCHEMA_FILE_ERROR                505
#define AR_ERROR_DEFN_FILE_ERROR                  506
#define AR_ERROR_DB_FILE_ERROR                    507
#define AR_ERROR_FILTER_FILE_ERROR                508
#define AR_ERROR_ADMINEXT_FILE_ERROR              509
#define AR_ERROR_USER_FILE_ERROR                  510
#define AR_ERROR_GROUP_FILE_ERROR                 511
#define AR_ERROR_ACTLINK_FILE_ERROR               512
#define AR_ERROR_DB_RECORD_OVERFLOW               513
#define AR_ERROR_DB_STATHIST_INVALID              514
#define AR_ERROR_CHARMENU_FILE_ERROR              515
#define AR_ERROR_ESCALATION_FILE_ERROR            516
#define AR_ERROR_SUP_FILE_FILE_ERROR              517
#define AR_ERROR_SUP_FILE_ERROR                   518
#define AR_ERROR_ATTACH_FILE                      520
#define AR_ERROR_ATTACH_FILE_INDEX                521

/* SQL database errors */
#define AR_ERROR_SQL_OPEN_FAILED                  550
#define AR_ERROR_SQL_INIT                         551
#define AR_ERROR_SQL_OP_FAILURE                   552
#define AR_ERROR_SQL_OP_TOO_LARGE                 553
#define AR_ERROR_SQL_MISSING_CONTROL              554
#define AR_ERROR_SQL_MISSING_ENUM                 555
#define AR_ERROR_SQL_MISSING_DATA                 556
#define AR_ERROR_SQL_TOO_MUCH_DATA                557
#define AR_ERROR_SQL_MISSING_SCHEMA               558
#define AR_ERROR_SQL_CHAR_STRING_LEN              559
#define AR_ERROR_SQL_BAD_ACTION_IND               560
#define AR_ERROR_SQL_QUALIFY_LONG                 561
#define AR_ERROR_SQL_MISSING_HELP                 562
#define AR_ERROR_SQL_NO_MODULO_OP                 563
#define AR_ERROR_SQL_BAD_LIKE                     564
#define AR_ERROR_SQL_NO_COL_IN_CMD                565
#define AR_ERROR_SQL_DEADLOCK                     566
#define AR_ERROR_SQL_CONNECTION_FAILURE           567
#define AR_ERROR_SQL_OCI_HANDLE_UNAVAILABLE       568

#define AR_NOTE_SQL_DB_UNAVAILABLE                590
#define AR_NOTE_SQL_DB_STILL_UNAVAIL              591
#define AR_NOTE_SQL_DB_AVAILABLE                  592

/* messages with user/group cache proc */
#define AR_ERROR_DIRECTORY_FILE                   600
#define AR_ERROR_BAD_CMD_LINE_OPTION              601
#define AR_ERROR_OPERATION_CONFLICT               602
#define AR_ERROR_MUST_GIVE_ONE                    603
#define AR_ERROR_MUST_GIVE_OPERATION              604
#define AR_ERROR_CMD_OPTION_CONFLICT              605
#define AR_ERROR_CMD_OPTION_MISSING               607
#define AR_ERROR_VALUE_EXPECTED                   608
#define AR_ERROR_CRE_DEL_TAG                      609
#define AR_ERROR_SERVER_FILE_ERROR                610
#define AR_ERROR_NO_SUCH_USER                     612
#define AR_ERROR_GROUP_TYPE_BAD                   613
#define AR_ERROR_LICENSE_TYPE_BAD                 614
#define AR_ERROR_CASE_MISMATCH_USER               615

#define AR_ERROR_TWO_OPEN_WRITE_TAG               620
#define AR_ERROR_TAG_FILE_PROBLEM                 621
#define AR_ERROR_TAG_LIC_PROBLEM                  622 

/* messages for business time */
#define AR_WARN_HOLIDAY_DATE_BAD                  625
#define AR_WARN_WORKDAY_TIME_BAD                  626 
#define AR_WARN_TOO_MANY_HOLIDAY                  627 

#define AR_ERROR_2_HOLIDAY_SCHEMA                 635
#define AR_ERROR_NO_HOLIDAY_SCHEMA                636
#define AR_ERROR_NO_HOLIDAY_FOR_TAG               637
#define AR_ERROR_2_WORKDAY_SCHEMA                 638
#define AR_ERROR_NO_WORKDAY_SCHEMA                639
#define AR_ERROR_NO_WORKDAY_FOR_TAG               640
#define AR_ERROR_WORKDAY_NEVER_OPEN               641

/* messages for full text search */
#define AR_ERROR_FULLTEXT_BEGIN                   650
#define AR_ERROR_FULLTEXT_INFO_EMPTY              651
#define AR_ERROR_FULLTEXT_INFO_TYPE               652
#define AR_ERROR_FULLTEXT_INFO_VALUE              653
#define AR_ERROR_FULLTEXT_INFO_TAG_BAD            654
#define AR_ERROR_FULLTEXT_IREQ_EMPTY              655
#define AR_ERROR_FULLTEXT_INIT_FAILED             656
#define AR_ERROR_FULLTEXT_OP_FAILURE              657
#define AR_ERROR_FULLTEXT_DOCREAD_FAILURE         658
#define AR_ERROR_FULLTEXT_STOPWORD_FILE_OPEN      659
#define AR_ERROR_FULLTEXT_SET_STOPWORD_FAIL       660
#define AR_ERROR_FULLTEXT_MOVECOLDIRFAIL          661
#define AR_ERROR_FULLTEXT_OP_TOO_LARGE            662
#define AR_ERROR_FULLTEXT_WRONG_DATA_TYPE         663
#define AR_ERROR_FULLTEXT_WRONG_VERSION           664
#define AR_ERROR_FULLTEXT_NOT_LICENSED            665
#define AR_ERROR_FULLTEXT_STATEOFF                666
#define AR_ERROR_FULLTEXT_STATEON                 667
#define AR_ERROR_FULLTEXT_BADQUERY                668
#define AR_ERROR_FULLTEXT_INDEXDIR_EXISTS         669
#define AR_WARN_FT_FIELD_PENDING_INDXNG           670
#define AR_ERROR_FT_INDEXER_NOT_EXISTS            671
#define AR_ERROR_FT_CANT_INDX_STATUS_HISTORY      672
#define AR_WARN_FT_UNSUPPORTED_FTS_QUERY          673
#define AR_ERROR_FULLTEXT_UNQUALIFIED_QUERY       674
#define AR_ERROR_FULLTEXT_INFO_SET_BAD            675
#define AR_ERROR_FULLTEXT_END                     676

/*** The range 700 to 799 are reserved for NM daemon messages ***/

/* messages for multi-process control */
#define ARTC_NOTE_SIGNAL_RECEIVED                 800
#define ARTC_NOTE_FATAL_EXIT                      801
#define ARTC_NOTE_FAILURE_RELAUNCH                802
#define ARTC_NOTE_INHERIT_RELAUNCH                803
#define ARTC_NOTE_RELAUNCH                        804
#define ARTC_ERROR_LOCK_FILE_OPEN                 840
#define ARTC_ERROR_DUPLICATE_SERVER               841
#define ARTC_ERROR_MALLOC_FAILED                  842
#define ARTC_ERROR_FORK_PROCESS                   843
#define ARTC_ERROR_EXEC_PROCESS                   844
#define ARTC_ERROR_MULTI_FAILURE                  845
#define AR_ERROR_WAIT_FAILED                      847
#define AR_ERROR_NO_SERVERS_RUNNING               848

/* messages for FTS daemon */                                        
#define AR_ERROR_FT_LOCKF_EXISTS                  855
#define AR_ERROR_FT_LOCKF_NOT_EXISTS              856
#define AR_ERROR_FT_PEND_FILE_OPEN_FAIL           857
#define AR_ERROR_FT_PEND_FILE_WRITE_FAIL          858
#define AR_ERROR_FT_RECORD_NOT_EXISTS             859
#define AR_ERROR_FT_TRUNCATE_ERROR                860
#define AR_ERROR_FULLTEXT_PURGE_PEND_FAIL         861
#define AR_ERROR_FT_TOO_FEW_ARGS                  862
#define AR_ERROR_FT_TOO_MANY_ARGS                 863
#define AR_ERROR_FT_INVALID_ACTION                864
#define AR_ERROR_FT_TERM_SIGNAL                   865
#define AR_ERROR_FT_DUPLICATE_SERVER              866
#define AR_ERROR_FULLTEXT_FIELDID_REQD            867
#define AR_ERROR_FULLTEXT_TOOMANYFOROPT           868
#define AR_ERROR_FULLTEXT_TOOMANYFORRETRY         869
#define AR_ERROR_FULLTEXT_NAMESPECIFIED           870
#define AR_ERROR_FULLTEXT_IDSPECIFIED             871
#define AR_ERROR_FULLTEXT_SCHEMANAMEBAD           872
#define AR_ERROR_FULLTEXT_BADDEBUGOPT             873

/* messages for mail interface */
#define AR_NOTE_MAIL_SUBJECT_ERROR                950
#define AR_ERROR_MAIL_NO_SCHEMA                   951
#define AR_ERROR_NO_MAIL_BODY                     952
#define AR_ERROR_MAIL_BODY_FORMAT                 953
#define AR_ERROR_MAIL_BAD_CMD_LINE                954
#define AR_ERROR_MAIL_PARM_VALUE                  955
#define AR_ERROR_MAIL_CONFIG_FILE                 956
#define AR_ERROR_MAIL_NOT_REQ_SCHEMA              957
#define AR_ERROR_MAIL_NOT_REQ_SERVER              958
#define AR_ERROR_MAIL_NOT_A_SERVER                959

#define AR_NOTE_MAIL_SUBJECT_OK                   960
#define AR_NOTE_MAIL_SUCCESS                      961
#define AR_NOTE_MAIL_QUERY_SUCCESS                962
#define AR_NOTE_MAIL_QUERY_SUBJECT_OK             963
#define AR_ERROR_MAIL_MAPI_LOGON_FAIL             964
#define AR_ERROR_MAIL_MAPI_RESOLVE_FAIL           965
#define AR_ERROR_MAIL_MAPI_READ_FAIL              966
#define AR_ERROR_MAIL_MAPI_LOGOFF_FAIL            967
#define AR_ERROR_MAIL_MAPI_SEND_FAIL              968
#define AR_NOTE_MAIL_QUERY_RESPONSE               969
#define AR_NOTE_MAIL_QUERY_MATCHES                970
#define AR_WARN_MAIL_MATCHES_LIMIT                971
#define AR_WARN_MAIL_MATCHES_NONE                 972
#define AR_WARN_MAIL_NO_FIELDS_IN_QL              973

/* messages for shared cache */
#define AR_WARN_ATTACH_CACHE_ADDR                 990
#define AR_WARN_USE_NONSHARED_CACHE               991
#define AR_WARN_REMOVE_CACHE_SEG                  992
#define AR_WARN_CREATE_CACHE_SEG                  993
#define AR_WARN_REMOVE_CACHE_SEM                  994
#define AR_WARN_CREATE_CACHE_SEM                  995
#define AR_ERROR_SHARED_CACHE_LOCK                996
#define AR_ERROR_NO_SHARED_CACHE                  997
#define AR_ERROR_USER_LOCK_NOT_HELD               998

/* messages for distributed server */
#define ARDS_NOTE_SIGNAL_RECEIVED                3000
#define ARDS_NOTE_FATAL_EXIT                     3001
#define ARDS_NOTE_TIMEOUT                        3002
#define ARDS_NOTE_CANCELLED_ON_ERROR             3003
#define ARDS_NOTE_AR_SERVER_UNAVAILABLE          3004
#define ARDS_NOTE_AR_SERVER_AVAILABLE            3005

#define ARDS_ERROR_DIST_NOT_LICENSED             3100
#define ARDS_ERROR_LOCK_FILE_OPEN                3101
#define ARDS_ERROR_DUPLICATE_SERVER              3102
#define ARDS_ERROR_MALLOC_FAILED                 3103
#define ARDS_ERROR_SERVER_NOT_DISTRIB            3106
#define ARDS_ERROR_NO_MAPPING_SCHEMA             3107
#define ARDS_ERROR_2_MAPPING_SCHEMA              3108
#define ARDS_ERROR_NO_PENDING_SCHEMA             3109
#define ARDS_ERROR_2_PENDING_SCHEMA              3110
#define ARDS_ERROR_DIFF_FROM_SCHEMA              3111
#define ARDS_ERROR_DIFF_FROM_SERVER              3112
#define ARDS_ERROR_DIFF_TO_SCHEMA                3113
#define ARDS_ERROR_DIFF_TO_SERVER                3114
#define ARDS_ERROR_BAD_PENDING_TYPE              3115
#define ARDS_ERROR_NON_MASTER_TRANSFER           3116
#define ARDS_ERROR_NO_FROM_INFO                  3117
#define ARDS_ERROR_DISTRIB_FAIL                  3118
#define ARDS_ERROR_MAPPING_DISABLED              3119
#define ARDS_ERROR_BAD_PENDING_OTHER             3120
#define ARDS_ERROR_NEW_NEEDS_FROM_ID             3121
#define ARDS_ERROR_DISTRIB_ON_DELETE             3122
#define ARDS_ERROR_DS_ID_NOT_MAPPED              3123
#define ARDS_ERROR_OWNER_REQ_MASTER_TRG          3124
#define ARDS_ERROR_OWNER_REQ_FROM_SCHEMA         3125
#define ARDS_ERROR_OWNER_REQ_FROM_SERVER         3126
#define ARDS_ERROR_OWNER_REQ_MASTER_SRC          3127
#define ARDS_ERROR_2_DSOPOOL_SCHEMA              3128
#define ARDS_ERROR_NO_DSOPOOL_SCHEMA             3129

#define ARDS_ERROR_MASTER_FLAG_BAD               3194
#define ARDS_ERROR_MISSING_ENTRY_ID              3195
#define ARDS_ERROR_MISSING_SCHEMA                3196
#define ARDS_ERROR_MISSING_SERVER                3197
#define ARDS_ERROR_DS_PARM_VALUE                 3198
#define ARDS_ERROR_BAD_DS_CMD_LINE               3199

/* messages for application server */
#define ARAPP_NOTE_SIGNAL_RECEIVED               4500
#define ARAPP_NOTE_FATAL_EXIT                    4501
#define ARAPP_NOTE_CANCELLED_ON_ERROR            4502
#define ARAPP_NOTE_RELAUNCH                      4503
 
#define ARAPP_WARN_DUP_ROLE_FOUND                4510
#define ARAPP_WARN_NO_ADMIN_SCHEMA               4511
#define ARAPP_WARN_NO_NOTIFY_SCHEMA              4512
#define ARAPP_WARN_NO_FORM_SCHEMA                4513

#define ARAPP_ERROR_PASS_NOT_CONFIRMED           4549

#define ARAPP_ERROR_IMPORT_APPLICATION           4550
#define ARAPP_ERROR_MUST_BE_APPLIC               4551
#define ARAPP_ERROR_2_PENDING_SCHEMA             4552
#define ARAPP_ERROR_NO_PENDING_SCHEMA            4553
#define ARAPP_ERROR_APPLIC_FAIL                  4554
#define ARAPP_ERROR_CMD_NO_SCHEMA                4555
#define ARAPP_ERROR_CMD_BAD_SCHEMA               4556
#define ARAPP_ERROR_PARSE_TWO_SCHEMA             4557
#define ARAPP_ERROR_QUAL_LINE_BAD                4558
#define ARAPP_ERROR_ASSIGN_LINE_BAD              4559
#define ARAPP_ERROR_NO_DETAILS_SCHEMA            4560
#define ARAPP_ERROR_CMD_NO_FIELD                 4561
#define ARAPP_ERROR_CMD_BAD_FIELD                4562
#define ARAPP_ERROR_CMD_NO_ENTRY_ID              4563
#define ARAPP_ERROR_CMD_BAD_ENTRY_ID             4564
#define ARAPP_ERROR_NO_SIGNATURE_SCHEMA          4565
#define ARAPP_ERROR_NO_DETSIG_SCHEMA             4566

#define ARAPP_ERROR_APPROVAL_NOT_LICENSED        4577
#define ARAPP_ERROR_2_LICENSE_TAGS               4578
#define ARAPP_ERROR_NO_LICENSE_TAGS              4579
#define ARAPP_ERROR_SCHEMA_NOT_LIC               4580
#define ARAPP_ERROR_MALLOC_FAILED                4581
#define ARAPP_ERROR_DUPLICATE_SERVER             4582
#define ARAPP_ERROR_LOCK_FILE_OPEN               4583
#define ARAPP_ERROR_2_DETAILS_SCHEMA             4584
#define ARAPP_ERROR_2_SIG_LINE_SCHEMA            4585
#define ARAPP_ERROR_NO_SIG_LINE_SCHEMA           4586
#define ARAPP_ERROR_2_PROCESS_SCHEMA             4587
#define ARAPP_ERROR_NO_PROCESS_SCHEMA            4588
#define ARAPP_ERROR_CMD_MISSING_DATA             4589
#define ARAPP_ERROR_2_RULE_SCHEMA                4590
#define ARAPP_ERROR_NO_RULE_SCHEMA               4591
#define ARAPP_ERROR_2_ALTERNATE_SCHEMA           4592
#define ARAPP_ERROR_NO_ALTERNATE_SCHEMA          4593
#define ARAPP_ERROR_2_MORE_INFO_SCHEMA           4594
#define ARAPP_ERROR_NO_MORE_INFO_SCHEMA          4595
#define ARAPP_ERROR_2_PROC_ADMIN_SCHEMA          4596
#define ARAPP_ERROR_NO_PROC_ADMIN_SCHEMA         4597
#define ARAPP_ERROR_2_ROLE_SCHEMA                4598
#define ARAPP_ERROR_NO_ROLE_SCHEMA               4599
#define ARAPP_ERROR_DETAIL_IS_ACTIVE             4600
#define ARAPP_ERROR_MULTI_NEXT_ERROR             4601
#define ARAPP_ERROR_SERVER_NOT_APPLIC            4602
#define ARAPP_ERROR_BAD_AD_HOC_FIELD             4603
#define ARAPP_ERROR_SIG_NEEDS_SIG                4604
#define ARAPP_ERROR_SIG_SAME_PROC                4605
#define ARAPP_ERROR_TWO_PROCESSES                4606
#define ARAPP_ERROR_ONLY_ONE_BUT_TWO             4607
#define ARAPP_ERROR_MI_NEEDS_MI                  4608
#define ARAPP_ERROR_NO_SUCH_PROCESS              4609
#define ARAPP_ERROR_NO_SCHEMA_PROCESS            4610
#define ARAPP_ERROR_NO_DETAIL_JOIN               4611
#define ARAPP_ERROR_NO_DETAIL_SIG_JOIN           4612
#define ARAPP_ERROR_CFG_MISSING_DATA             4613
#define ARAPP_ERROR_NAME_TO_ID_MAP_FAIL          4614
#define ARAPP_ERROR_GET_DETSIG_FAIL              4615
#define ARAPP_ERROR_2_ADMIN_SCHEMA               4616
#define ARAPP_ERROR_2_NOTIFY_SCHEMA              4617
#define ARAPP_ERROR_2_FORM_SCHEMA                4618
 
#define ARAPP_ERROR_NO_FIELD_ESCAPED             4650
#define ARAPP_ERROR_NO_FIELD_SCHEMA              4651
#define ARAPP_ERROR_NO_FIELD_ENTRY_ID            4652
#define ARAPP_ERROR_NO_FIELD_NEXT_APP            4653
#define ARAPP_ERROR_NO_FIELD_PROCESS             4654
 
#define ARPR_WARN_DUP_CATEGORY_FOUND             4810
 
#define ARSUM_ERROR_MALLOC_FAILED                4820
#define ARSUM_ERROR_GROUP_MISSING                4821
 
#define ARAPS_ERROR_TWO_MATCHING_SCHEMA          4830
#define ARAPS_ERROR_NO_MATCHING_SCHEMA           4831
 
#define ARPR_ERROR_CMD_MISSING_DATA              4836
#define ARPR_ERROR_CAT_NEEDS_PARTS               4837
#define ARPR_ERROR_MALLOC_FAILED                 4838
#define ARPR_ERROR_PART_NO_PARENT                4839
#define ARPR_ERROR_NO_SUCH_CATEGORY              4840
#define ARPR_ERROR_CATALOG_FILE_ERROR            4841
#define ARPR_ERROR_PART_TYPE_BAD                 4842
#define ARPR_ERROR_PART_ROW_COUNT_BAD            4843
#define ARPR_ERROR_MAP_NEEDS_PURREQ              4844
#define ARPR_ERROR_2_LINE_MAP_SCHEMA             4845
#define ARPR_ERROR_SUPPLIER_NULL                 4846
#define ARPR_ERROR_MAPB_NEEDS_LINEITEM           4847
#define ARPR_ERROR_MAPBACK_NO_LINE               4848
#define ARPR_ERROR_MAPBACK_NO_ENTRY              4849
#define ARPR_ERROR_NO_PENDING_ID                 4850
#define ARPR_ERROR_LINE_MAP_FAILURE              4851
#define ARPR_ERROR_LINE_MAPBACK_FAILURE          4852
#define ARPR_ERROR_CMD_MISSING_DATA2             4853
#define ARPR_ERROR_CMD_MISSING_DATA3             4854
#define ARPR_ERROR_CMD_MISSING_DATA4             4855
#define ARPR_ERROR_NO_PR_LI_SCHEMA               4856
#define ARPR_ERROR_LINE_ITEM_BOUNDS_ERR          4857


/* shared access segment errors */
#define AR_WARN_CREATE_ACCESS_SEM                8020
#define AR_WARN_REMOVE_ACCESS_SEM                8021
#define AR_WARN_ACCESS_SEGMENT_LOCK              8022
#define AR_WARN_CREATE_ACCESS_CONTROL            8023
#define AR_WARN_ATTACH_ACCESS_CONTROL            8024
#define AR_WARN_CREATE_SHARED_ACCESS             8025
#define AR_WARN_ATTACH_SHARED_ACCESS             8026
#define AR_WARN_MIGRATE_SHARED_ACCESS            8027
#define AR_WARN_NO_SHARED_ACCESS                 8028

#define AR_ERROR_FILTER_ANY_MATCH                8029


/* Additional warning messages */
#define AR_WARN_UNSUP_FIELD_OR_WORKFLOW          8031
#define AR_WARN_CONT_OWN_NO_ADMIN_GRP            8032

#define AR_WARN_MIN_2                            8031
#define AR_WARN_MAX_2                            8200

/* Additional RPC error messages */
#define AR_ERROR_RPC_SOCKET_RANGE                8201
#define AR_ERROR_RPC_PORT_RANGE                  8202

/* more param validation errors */
#define AR_ERROR_BAD_LOC_TYPE                    8700
#define AR_ERROR_BAD_LOC_BUF_SIZE                8701
#define AR_ERROR_BAD_LOC_BUF_PTR                 8702
#define AR_ERROR_BAD_BLOB_SIZE                   8703
#define AR_ERROR_AUTO_EMPTY                      8704
#define AR_ERROR_COM_METHODLIST_EMPTY            8705
#define AR_ERROR_COM_VALUE_BAD                   8706
#define AR_ERROR_COM_NAME_BAD                    8707
#define AR_ERROR_COM_ID_BAD                      8708
#define AR_ERROR_COM_METHOD_BAD                  8709
#define AR_ERROR_COM_METHOD_NAME_BAD             8710
#define AR_ERROR_COM_METHOD_EMPTY                8711
#define AR_ERROR_COM_PARMLIST_EMPTY              8712
#define AR_ERROR_COM_PARM_EMPTY                  8713
#define AR_ERROR_COM_PARM_BAD                    8714
#define AR_ERROR_AUTO_STRING_BAD                 8715
#define AR_ERROR_AP_RPC_SOCKET_BAD               8716
#define AR_ERROR_AP_DEFN_CHECK_BAD               8717
#define AR_WARN_BAD_SIGNAL                       8718

#define AR_ERROR_OPENDLG_EMPTY                   8720
#define AR_ERROR_CALLGUIDE_EMPTY                 8721
#define AR_ERROR_GUIDENAME_MISSING               8722
#define AR_ERROR_GOTOLABEL_BAD                   8723 
#define AR_ERROR_BAD_GOTOACTION_TAG              8724
#define AR_ERROR_CONTTITLE_BAD                   8725

/* messages related to decimal data type */
#define AR_ERROR_BAD_DEC_VALUE                   8735
#define AR_ERROR_BAD_DEC_CALC                    8736

/* messages related to thread management */
#define AR_ERROR_CREATE_THREAD_FAILED            8740
#define AR_ERROR_CREATE_MUTEX_FAILED             8741
#define AR_ERROR_CREATE_SEM_FAILED               8742
#define AR_ERROR_LOCK_MUTEX_FAILED               8743
#define AR_ERROR_SEM_OP_FAILED                   8744
#define AR_ERROR_CREATE_QUEUE_FAILED             8745
#define AR_ERROR_CREATE_TLS_FAILED               8746
#define AR_ERROR_ACCESS_TLS_FAILED               8747
#define AR_ERROR_SEM_TIMEOUT                     8748

/* param validation errors for container */
#define AR_ERROR_CON_OWNER_ITEM                  8800
#define AR_ERROR_REF_VALUE_EMPTY                 8801
#define AR_ERROR_REF_LABEL_EMPTY                 8802
#define AR_ERROR_REF_DESCR_EMPTY                 8803
#define AR_ERROR_NO_SUCH_CONTAINER               8804
#define AR_ERROR_NO_ACCESS_TO_CONTAINER          8805
#define AR_ERROR_CONTAINER_MISSING               8806
#define AR_ERROR_CTR_OPEN_FAILED                 8807
#define AR_ERROR_NOT_A_CTR_FILE                  8808
#define AR_ERROR_BAD_CONTAINER_TYPE              8809
#define AR_ERROR_DUPLICATE_CONTAINER             8810
#define AR_ERROR_NO_OWNER_NAME                   8811
#define AR_ERROR_ILLEGAL_OWNER_TYPE              8812
#define AR_ERROR_CONTAINER_FILE_ERROR            8813
#define AR_ERROR_NO_CONTAINERID                  8814
#define AR_ERROR_NO_CONTAINER_DEFN               8815
#define AR_ERROR_BAD_REFERENCE_TYPE              8816
#define AR_ERROR_REF_VALUE_BAD                   8817
#define AR_ERROR_CONTAINER_UNSUP_BY_SVR          8818

/* more server errors & warnings */
#define AR_ERROR_GETLISTFIELDS_NOT_ALLOWED       8900 
#define AR_WARN_GETLISTFIELDS_IGNORED            8901
#define AR_ERROR_SORTLIST_NOT_ALLOWED            8902
#define AR_WARN_SORTLIST_IGNORED                 8903
#define AR_ERROR_FILTER_NOT_ALLOWED              8904
#define AR_ERROR_ESCALATION_NOT_ALLOWED          8905
#define AR_ERROR_CORE_FIELD_NOT_ALLOWED          8906
#define AR_ERROR_MUST_BE_DISPLAY_FIELD           8907
#define AR_ERROR_ILLEGAL_USER_OR_PWD             8908
#define AR_ERROR_NO_DIALOG_IN_JOIN               8909
#define AR_ERROR_FIELD_IN_TABLE_QUAL             8910
#define AR_WARN_FIELD_LIST_TRUNCATED             8911
#define AR_ERROR_GLEWF_UNSUP_BY_SVR              8912
#define AR_ERROR_SEMAPHORE                       8913
#define AR_NOTE_LOG_INFO                         8914
#define AR_WARN_WRITE_LOGFILE                    8915
#define AR_ERROR_UPDATE_NEXT_FIELD               8916
#define AR_ERROR_GET_NEXT_FIELD                  8917
#define AR_ERROR_UPDATE_NEXT_VUI                 8918
#define AR_ERROR_GET_NEXT_VUI                    8919
#define AR_ERROR_NO_SUCH_WORKFLOW                8920
#define AR_ERROR_NO_SCHEMALIST                   8921
#define AR_ERROR_CONNECT_TO_EXTAUTH              8922
#define AR_ERROR_BAD_CONN_TYPE                   8923
#define AR_ERROR_DUPLICATED_SCHEMA               8924
#define AR_ERROR_EA_RPC_SOCKET_BAD               8925
#define AR_NOTE_EA_MESSAGE                       8926
#define AR_ERROR_EA_MESSAGE                      8927
#define AR_ERROR_OPEN_APPL_AUDIT_LOG             8928
#define AR_ERROR_OPEN_APPL_VIOLATION_LOG         8929
#define AR_ERROR_OCCURRED_IN_SCHEMA              8930
#define AR_ERROR_NO_WRITE_LICENSE		 8932
 
/* Default messages when we cannot get text from the catalog */
#define AR_ERROR_DEF_OPEN_CATALOG    "Cannot open catalog; Message number = "
#define AR_ERROR_DEF_NO_MESSAGE      "Message not in catalog; Message number = "

