/*  File: main.h  */

#define COMMAND_EXIT                      -1
#define COMMAND_LOGIN                      0
#define COMMAND_GET_ENTRY                  1
#define COMMAND_SET_ENTRY                  2
#define COMMAND_CREATE_ENTRY               3
#define COMMAND_DELETE_ENTRY               4
#define COMMAND_GETLIST_ENTRY              5
#define COMMAND_GET_FILTER                 6
#define COMMAND_SET_FILTER                 7
#define COMMAND_CREATE_FILTER              8
#define COMMAND_DELETE_FILTER              9
#define COMMAND_GETLIST_FILTER            10
#define COMMAND_GETLIST_GROUP             11
#define COMMAND_GET_SCHEMA                12
#define COMMAND_SET_SCHEMA                13
#define COMMAND_CREATE_SCHEMA             14
#define COMMAND_DELETE_SCHEMA             15
#define COMMAND_GETLIST_SCHEMA            16
#define COMMAND_GET_SCH_FIELD             17
#define COMMAND_SET_SCH_FIELD             18
#define COMMAND_CREATE_SCH_FIELD          19
#define COMMAND_DELETE_SCH_FIELD          20
#define COMMAND_GETLIST_SCH_FIELD         21
#define COMMAND_GET_CHAR_MENU             22
#define COMMAND_SET_CHAR_MENU             23
#define COMMAND_CREATE_CHAR_MENU          24
#define COMMAND_DELETE_CHAR_MENU          25
#define COMMAND_GETLIST_CHAR_MENU         26
#define COMMAND_EXPORT                    27
#define COMMAND_IMPORT                    28
#define COMMAND_GET_SERVER_INFO           29
#define COMMAND_VERIFY_USER               30
#define COMMAND_EXECUTE                   31
#define COMMAND_OPEN_OUT                  32
#define COMMAND_CLOSE_OUT                 33
#define COMMAND_RECORD                    34
#define COMMAND_STOP_RECORD               35
#define COMMAND_GETLIST_SERVER            36
#define COMMAND_INITIALIZATION            37
#define COMMAND_TERMINATION               38
#define COMMAND_GET_ACTIVE_LINK           39
#define COMMAND_SET_ACTIVE_LINK           40
#define COMMAND_CREATE_ACTIVE_LINK        41
#define COMMAND_DELETE_ACTIVE_LINK        42
#define COMMAND_GETLIST_ACTIVE_LINK       43
#define COMMAND_MERGE_ENTRY               44
#define COMMAND_LOAD_AR_QUAL_STRUCT       45
#define COMMAND_EXPAND_CHAR_MENU          46
#define COMMAND_SET_SERVER_INFO           47
#define COMMAND_GETLIST_USER              48
#define COMMAND_GET_ESCALATION            49
#define COMMAND_SET_ESCALATION            50
#define COMMAND_CREATE_ESCALATION         51
#define COMMAND_DELETE_ESCALATION         52
#define COMMAND_GETLIST_ESCALATION        53
#define COMMAND_ENTRY_STATISTICS          54
#define COMMAND_SETFULLTEXT_INFO          55
#define COMMAND_GETFULLTEXT_INFO          56
#define COMMAND_GET_SERVER_STAT           57
#define COMMAND_GETLIST_SQL               58
#define COMMAND_DELETE_MULTI_FIELD        59
#define COMMAND_EXECUTE_PROCESS           60
#define COMMAND_GET_VUI                   61
#define COMMAND_SET_VUI                   62
#define COMMAND_CREATE_VUI                63
#define COMMAND_DELETE_VUI                64
#define COMMAND_GETLIST_VUI               65
#define COMMAND_SET_SERVER_PORT           66
#define COMMAND_GET_MULTIPLE_ENTRY        67
#define COMMAND_GET_SUPPORT_FILE          68
#define COMMAND_SET_SUPPORT_FILE          69
#define COMMAND_CREATE_SUPPORT_FILE       70
#define COMMAND_DELETE_SUPPORT_FILE       71
#define COMMAND_GETLIST_SUPPORT_FILE      72
#define COMMAND_LAUNCH_THREAD             73
#define COMMAND_LAUNCH_WAITING_THREAD     74
#define COMMAND_RELEASE_WAITING_THREADS   75
#define COMMAND_SLEEP_TIMER               76
#define COMMAND_RANDOM_SLEEP_TIMER        77
#define COMMAND_MILLISECOND_SLEEP_TIMER   78
#define COMMAND_BEGIN_LOOP                79
#define COMMAND_END_LOOP                  80
#define COMMAND_GETLIST_ENTRY_WITH_FIELDS 81
#define COMMAND_GETENTRY_BLOB             82
#define COMMAND_GET_CONTAINER             83
#define COMMAND_SET_CONTAINER             84
#define COMMAND_CREATE_CONTAINER          85
#define COMMAND_DELETE_CONTAINER          86
#define COMMAND_GETLIST_CONTAINER         87
#define COMMAND_GET_ERROR_MESSAGE         88
#define COMMAND_SET_LOGGING               89
#define COMMAND_CLOSE_NET_CONNECTIONS     90
#define COMMAND_SIGNAL                    91
#define COMMAND_VALIDATE_FORM_CACHE       92
#define COMMAND_GET_MULTIPLE_FIELDS       93

#define MAX_COMMAND                       93

typedef char CommandType[6];  /* buffer to hold a command */

#ifdef MAIN
CommandType commands[MAX_COMMAND + 1] =
   {
      /* COMMAND_LOGIN                     */ "log",
      /* COMMAND_GET_ENTRY                 */ "ge",
      /* COMMAND_SET_ENTRY                 */ "se",
      /* COMMAND_CREATE_ENTRY              */ "ce",
      /* COMMAND_DELETE_ENTRY              */ "de",
      /* COMMAND_GETLIST_ENTRY             */ "gle",
      /* COMMAND_GET_FILTER                */ "gf",
      /* COMMAND_SET_FILTER                */ "sf",
      /* COMMAND_CREATE_FILTER             */ "cf",
      /* COMMAND_DELETE_FILTER             */ "df",
      /* COMMAND_GETLIST_FILTER            */ "glf",
      /* COMMAND_GETLIST_GROUP             */ "glg",
      /* COMMAND_GET_SCHEMA                */ "gs",
      /* COMMAND_SET_SCHEMA                */ "ss",
      /* COMMAND_CREATE_SCHEMA             */ "cs",
      /* COMMAND_DELETE_SCHEMA             */ "ds",
      /* COMMAND_GETLIST_SCHEMA            */ "gls",
      /* COMMAND_GET_SCH_FIELD             */ "gsf",
      /* COMMAND_SET_SCH_FIELD             */ "ssf",
      /* COMMAND_CREATE_SCH_FIELD          */ "csf",
      /* COMMAND_DELETE_SCH_FIELD          */ "dsf",
      /* COMMAND_GETLIST_SCH_FIELD         */ "glsf",
      /* COMMAND_GET_CHAR_MENU             */ "gc",
      /* COMMAND_SET_CHAR_MENU             */ "sc",
      /* COMMAND_CREATE_CHAR_MENU          */ "cc",
      /* COMMAND_DELETE_CHAR_MENU          */ "dc",
      /* COMMAND_GETLIST_CHAR_MENU         */ "glc",
      /* COMMAND_EXPORT                    */ "exp",
      /* COMMAND_IMPORT                    */ "imp",
      /* COMMAND_GET_SERVER_INFO           */ "gsi",
      /* COMMAND_VERIFY_USER               */ "ver",
      /* COMMAND_EXECUTE                   */ "ex",
      /* COMMAND_OPEN_OUT                  */ "oout",
      /* COMMAND_CLOSE_OUT                 */ "cout",
      /* COMMAND_RECORD                    */ "rec",
      /* COMMAND_STOP_RECORD               */ "srec",
      /* COMMAND_GETLIST_SERVER            */ "svr",
      /* COMMAND_INITIALIZATION            */ "init",
      /* COMMAND_TERMINATION               */ "term",
      /* COMMAND_GET_ACTIVE_LINK           */ "gal",
      /* COMMAND_SET_ACTIVE_LINK           */ "sal",
      /* COMMAND_CREATE_ACTIVE_LINK        */ "cal",
      /* COMMAND_DELETE_ACTIVE_LINK        */ "dal",
      /* COMMAND_GETLIST_ACTIVE_LINK       */ "glal",
      /* COMMAND_MERGE_ENTRY               */ "me",
      /* COMMAND_LOAD_AR_QUAL_STRUCT       */ "lqs",
      /* COMMAND_EXPAND_CHAR_MENU          */ "ec",
      /* COMMAND_SET_SERVER_INFO           */ "ssi",
      /* COMMAND_GETLIST_USER              */ "glu",
      /* COMMAND_GET_ESCALATION            */ "ges",
      /* COMMAND_SET_ESCALATION            */ "ses",
      /* COMMAND_CREATE_ESCALATION         */ "ces",
      /* COMMAND_DELETE_ESCALATION         */ "des",
      /* COMMAND_GETLIST_ESCALATION        */ "gles",
      /* COMMAND_ENTRY_STATISTICS          */ "stat",
      /* COMMAND_SETFULLTEXT_INFO          */ "sft",
      /* COMMAND_GETFULLTEXT_INFO          */ "gft",
      /* COMMAND_GET_SERVER_STAT           */ "gss",
      /* COMMAND_GETLIST_SQL               */ "glsql",
      /* COMMAND_DELETE_MULTI_FIELD        */ "dmsf",
      /* COMMAND_EXECUTE_PROCESS           */ "proc",
      /* COMMAND_GET_VUI                   */ "gv",
      /* COMMAND_SET_VUI                   */ "sv",
      /* COMMAND_CREATE_VUI                */ "cv",
      /* COMMAND_DELETE_VUI                */ "dv",
      /* COMMAND_GETLIST_VUI               */ "glsv",
      /* COMMAND_SET_SERVER_PORT           */ "ssp",
      /* COMMAND_GET_MULTIPLE_ENTRY        */ "gme",
      /* COMMAND_GET_SUPPORT_FILE          */ "gfl",
      /* COMMAND_SET_SUPPORT_FILE          */ "sfl",
      /* COMMAND_CREATE_SUPPORT_FILE       */ "cfl",
      /* COMMAND_DELETE_SUPPORT_FILE       */ "dfl",
      /* COMMAND_GETLIST_SUPPORT_FILE      */ "glfl",
      /* COMMAND_LAUNCH_THREAD             */ "lt",
      /* COMMAND_LAUNCH_WAITING_THREAD     */ "lwt",
      /* COMMAND_RELEASE_WAITING_THREADS   */ "rwt",
      /* COMMAND_SLEEP_TIMER               */ "st",
      /* COMMAND_RANDOM_SLEEP_TIMER        */ "rst",
      /* COMMAND_MILLISECOND_SLEEP_TIMER   */ "msst",
      /* COMMAND_BEGIN_LOOP                */ "bl",
      /* COMMAND_END_LOOP                  */ "el",
      /* COMMAND_GETLIST_ENTRY_WITH_FIELDS */ "glewf",
      /* COMMAND_GETENTRY_ATTACH           */ "geb",
      /* COMMAND_GET_CONTAINER             */ "gco",
      /* COMMAND_SET_CONTAINER             */ "sco",
      /* COMMAND_CREATE_CONTAINER          */ "cco",
      /* COMMAND_DELETE_CONTAINER          */ "dco",
      /* COMMAND_GETLIST_CONTAINER         */ "glco",
      /* COMMAND_GET_ERROR_MESSAGE         */ "gem",
      /* COMMAND_SET_LOGGING               */ "slog",
      /* COMMAND_CLOSE_NET_CONNECTIONS     */ "cnc",
      /* COMMAND_SIGNAL                    */ "sig",
      /* COMMAND_VALIDATE_FORM_CACHE       */ "vfc",
      /* COMMAND_GET_MULTIPLE_FIELDS       */ "gmsf"
   };
#else
extern CommandType commands[MAX_COMMAND + 1];
#endif
