
/*  File:  nterrno.h  */

/* Codes for all the errors that can be returned from the Notify Server */

#define NT_CATALOG_FILENAME    "ntsystem.cat"/* filename of error catalog */

#define NT_ERROR_MSG_SET              1/* set number in catalog for error msgs*/

#define NT_ERROR_NONE                 0/* no error */

#define NT_ERROR_NO_MESSAGE           1/* error message for "can't find msg" */

#define NT_NOTE_S_SIGNAL_RECEIVED    20/* notes for the system */
#define NT_NOTE_C_SIGNAL_RECEIVED    21
#define NT_NOTE_FATAL_EXIT           22
#define NT_NOTE_FAILURE_RELAUNCH     23
#define NT_NOTE_INHERIT_RELAUNCH     24
#define NT_NOTE_RELAUNCH             25

#define NT_WARN_NONE_PENDING         50/* warnings for the system */
#define NT_WARN_NO_SUCH_USER         59

#define NT_ERROR_CONNECT             90/* rpc errors */
#define NT_ERROR_RPC_CALL            91
#define NT_ERROR_RPC_TIMEOUT         92
#define NT_ERROR_RPC_INIT            95

#define NT_ERROR_SERVER_HOST_BAD    100/* parameter validation errors */
#define NT_ERROR_USER_BAD           101
#define NT_ERROR_NOTIFY_TEXT_BAD    102
#define NT_ERROR_CLNT_SRVR_BAD      103
#define NT_ERROR_CLIENT_HOST_BAD    104
#define NT_ERROR_NO_SERVERS         105
#define NT_ERROR_COMM_LINK_FAILED   106
#define NT_ERROR_FILENAME_BAD       107
#define NT_ERROR_NOT_CODE_TEXT_BAD  108
#define NT_ERROR_NO_NOTIFY          109
#define NT_ERROR_CLNT_ADDR_BAD      110
#define NT_ERROR_PROTOCOL_BAD       111
#define NT_ERROR_CLIENT_COMM_BAD    112
#define NT_ERROR_RETURN_BUFFER_BAD  113
#define NT_ERROR_USER_LIST_NULL     114

#define NT_ERROR_MALLOC_FAILED      200
#define NT_ERROR_USER_VALIDATION    201
#define NT_ERROR_SERVER_CONNECT     202
#define NT_ERROR_WRITE_FAILED       203
#define NT_ERROR_NO_USER_ON_CLIENT  204
#define NT_ERROR_NO_REGISTRATION    205
#define NT_ERROR_DIRECTORY_OPEN     206
#define NT_ERROR_MALLOC_CLNT_FAILED 207
#define NT_ERROR_AR_INITIALIZE      208
#define NT_ERROR_LOG_FILE_OPEN      209
#define NT_ERROR_LOG_FILE_WRITE     210
#define NT_ERROR_LOCK_FILE_OPEN     211
#define NT_ERROR_DUPLICATE_SERVER   212
#define NT_ERROR_DUPLICATE_CLIENT   213
#define NT_ERROR_SOCKET             214
#define NT_ERROR_SOCKET_TIMEOUT     215
#define NT_ERROR_NO_HOST_ADDRESS    216
#define NT_ERROR_NOCONTACT          217
#define NT_ERROR_LISTEN             218
#define NT_ERROR_NOTREGISTERED      219
#define NT_ERROR_NOTIFICATION       220
#define NT_ERROR_SHARED_ACCESS      221
#define NT_ERROR_BAD_FILE           222
#define NT_ERROR_NTC_INITIALIZE     223
#define NT_ERROR_LOGU_FILE          224
#define NT_ERROR_U2F_FILE           225
#define NT_ERROR_PIDSTATUS_FILE     226
#define NT_ERROR_LOCK_FILE          227
#define NT_ERROR_REMOVE_SHM         228
#define NT_ERROR_SHM_ID             229
#define NT_ERROR_ATTACH_SHM         230
#define NT_ERROR_REMOVE_SEM         231
#define NT_ERROR_MEM_SPACE          232
#define NT_ERROR_MULTI_FAILURE      233
#define NT_ERROR_FORK_PROCESS       234
#define NT_ERROR_EXEC_PROCESS       235
#define NT_ERROR_SEMAPHORE          236
#define NT_ERROR_NOT_INITIALIZED    237

/* Default messages when cannot get text from catalog */
#define NT_ERROR_DEF_OPEN_CATALOG  "Cannot open catalog; Message number = "
#define NT_ERROR_DEF_NO_MESSAGE    "Message not in catalog; Message number = "
