
/*  File:  arstruct.h  */

#ifndef AR_STRUCT_DEFINED
#define AR_STRUCT_DEFINED

#define AR_CORE_VERSION            2L /* version number of core definition */
#define AR_EXPORT_VERSION          5L /* version number of export definition */

#define AR_ENTRY_ID_SEPARATOR      '|'/* join schema entry id separator */

#define AR_CORE_ENTRY_ID           1L /* field-ids of the core fields */
#define AR_CORE_SUBMITTER          2L
#define AR_CORE_CREATE_DATE        3L
#define AR_CORE_ASSIGNED_TO        4L
#define AR_CORE_LAST_MODIFIED_BY   5L
#define AR_CORE_MODIFIED_DATE      6L
#define AR_CORE_STATUS             7L
#define AR_CORE_SHORT_DESCRIPTION  8L
#define AR_CORE_STATUS_HISTORY    15L

#define AR_CORE_DESCRIPTION        9L /* field-ids of obsoleted core fields */
#define AR_CORE_DISPOSITION       10L /* Any existing definitions can       */
#define AR_CORE_RELATED_TO        11L /* remain and will be fully supported.*/
#define AR_CORE_NOTIFY_METHOD     12L /* Any change to the fields will      */
#define AR_CORE_SUBMIT_SEVERITY   13L /* retain the restrictions when these */
#define AR_CORE_ASSIGN_PRIORITY   14L /* were core fields.  They can be     */
                                      /* deleted if desired, but not created*/

#define AR_NUM_CORE_FIELDS         9

#define AR_MAX_CORE_FIELD_ID             99L
#define AR_MAX_RESERVED_FIELD_ID  536870911L  /* 0x1fffffff */

#define AR_RESERV_WEIGHT          99  /* Reserved display only field - weight */

#define AR_RESERV_USER_NAME      101L /* field-ids of the user/group fields */
#define AR_RESERV_PASSWORD       102L
#define AR_RESERV_EMAIL          103L /* these ids are reserved for defining */
#define AR_RESERV_GROUP_LIST     104L /*  users and groups within the AR     */
#define AR_RESERV_GROUP_NAME     105L /*  system                             */
#define AR_RESERV_GROUP_ID       106L
#define AR_RESERV_GROUP_TYPE     107L
#define AR_RESERV_USER_NOTIFY    108L
#define AR_RESERV_LICENSE_TYPE   109L
#define AR_RESERV_LIC_FULL_TEXT  110L
#define AR_RESERV_LIC_RESERVED1  111L
#define AR_RESERV_ASSIGNED_GROUP 112L
#define AR_RESERV_LIC_ASSET      113L
#define AR_RESERV_LIC_CHANGE     114L
                                      /* reserved for Distributed Server */
/* Generic Fields */
#define AR_RESERV_CHANGE_DIARY            180L
#define AR_RESERV_HELP                    181L
#define AR_RESERV_OPROP                   182L

/* Mapping Schema */
#define ARDS_RESERV_DISTRIB_FROM_SCHEMA   200L
#define ARDS_RESERV_DISTRIB_FROM_SERVER   201L
#define ARDS_RESERV_DISTRIB_TO_SCHEMA     202L
#define ARDS_RESERV_DISTRIB_TO_SERVER     203L
#define ARDS_RESERV_DISTRIB_UPDATE_CODE   204L
#define ARDS_RESERV_DISTRIB_TRANS_MODE    205L
#define ARDS_RESERV_DISTRIB_MAP_TYPE      206L
#define ARDS_RESERV_DISTRIB_MAPPING       207L
#define ARDS_RESERV_DISTRIB_RTN_MAP_TYPE  208L
#define ARDS_RESERV_DISTRIB_RTN_MAPPING   209L
#define ARDS_RESERV_DISTRIB_DEFAULT_MAP   210L
#define ARDS_RESERV_DISTRIB_DUP_ACTION    211L
#define ARDS_RESERV_DISTRIB_RETRY_TIME    212L

/* Pending Schema */
#define ARDS_RESERV_DISTRIB_SOURCE_ID     250L
#define ARDS_RESERV_DISTRIB_PENDING_TYPE  251L
#define ARDS_RESERV_DISTRIB_PENDING_OTHER 252L
#define ARDS_RESERV_DISTRIB_POOL          253L

/* Pool Schema */
#define ARDS_RESERV_DISTRIB_TCOUNT        275L
#define ARDS_RESERV_DISTRIB_CONNECT       276L
#define ARDS_RESERV_DISTRIB_DEFAULT       277L
#define ARDS_RESERV_DISTRIB_OPROP         278L

/* User Schema Extensions */
#define ARDS_RESERV_DISTRIB_TO_MAPPING    300L
#define ARDS_RESERV_DISTRIB_TRANS_STATE   301L
#define ARDS_RESERV_DISTRIB_UPDATE_STATE  302L
#define ARDS_RESERV_DISTRIB_MASTER_FLAG   303L
#define ARDS_RESERV_DISTRIB_CUR_SCHEMA    304L
#define ARDS_RESERV_DISTRIB_CUR_SERVER    305L
#define ARDS_RESERV_DISTRIB_FROM_MAPPING  306L
#define ARDS_RESERV_DISTRIB_FROM_ENTRYID  307L
#define ARDS_RESERV_DISTRIB_TO_ENTRYID    308L
#define ARDS_RESERV_DISTRIB_MAP_HISTORY   309L
#define ARDS_RESERV_DISTRIB_FROM_SCHEMA_2 310L
#define ARDS_RESERV_DISTRIB_FROM_SERVER_2 311L
#define ARDS_RESERV_DISTRIB_TO_SCHEMA_2   312L
#define ARDS_RESERV_DISTRIB_TO_SERVER_2   313L
#define ARDS_RESERV_DISTRIB_UPDATE_CODE_2 314L
#define ARDS_RESERV_DISTRIB_TRANS_MODE_2  315L
#define ARDS_RESERV_DISTRIB_DUP_ACTION_2  316L
#define ARDS_RESERV_DISTRIB_RETRY_TIME_2  317L

/* Reserved fields for Remedy client menu items */
#define AR_RESERVE_MENU_MODIFYALL         401L
#define AR_RESERVE_MENU_DELETE            402L
#define AR_RESERVE_MENU_PREFERENCES       403L
#define AR_RESERVE_MENU_MENU              404L
#define AR_RESERVE_MENU_TOOLBAR           405L
#define AR_RESERVE_MENU_APPLY             406L
#define AR_RESERVE_MENU_POLLING           407L

/* Reserved fields for Application support */
#define ARAPP_RESERV_APPLIC_CATEGORY      AR_CORE_SHORT_DESCRIPTION
#define ARAPP_RESERV_APPLIC_COMMAND       501L
#define ARAPP_RESERV_APPLIC_SCHEMA        502L
#define ARAPP_RESERV_APPLIC_ENTRY_ID      503L
#define ARAPP_RESERV_APPLIC_TAG           504L
#define ARAPP_RESERV_APPLIC_FIELD_1       505L
#define ARAPP_RESERV_APPLIC_FIELD_2       506L
#define ARAPP_RESERV_APPLIC_FIELD_3       507L
#define ARAPP_RESERV_APPLIC_OTHER_SHORT   508L
#define ARAPP_RESERV_APPLIC_OTHER_LONG    509L
                                      /* reserved for Business Time support */
                                      /* Holiday */
#define AR_RESERV_HOLIDAY_LIST            600L
                                      /* Workday */
#define AR_RESERV_WORKDAY_OPEN_SUN        620L
#define AR_RESERV_WORKDAY_OPEN_MON        621L
#define AR_RESERV_WORKDAY_OPEN_TUES       622L
#define AR_RESERV_WORKDAY_OPEN_WED        623L
#define AR_RESERV_WORKDAY_OPEN_THURS      624L
#define AR_RESERV_WORKDAY_OPEN_FRI        625L
#define AR_RESERV_WORKDAY_OPEN_SAT        626L
#define AR_RESERV_WORKDAY_CLOSE_SUN       630L
#define AR_RESERV_WORKDAY_CLOSE_MON       631L
#define AR_RESERV_WORKDAY_CLOSE_TUES      632L
#define AR_RESERV_WORKDAY_CLOSE_WED       633L
#define AR_RESERV_WORKDAY_CLOSE_THURS     634L
#define AR_RESERV_WORKDAY_CLOSE_FRI       635L
#define AR_RESERV_WORKDAY_CLOSE_SAT       636L

#define AR_GROUP_ID_PUBLIC            0L /* group-ids of the 'key' groups */
#define AR_GROUP_ID_ADMINISTRATOR     1L
#define AR_GROUP_ID_CUSTOMIZE         2L
#define AR_GROUP_ID_SUBMITTER         3L
#define AR_GROUP_ID_ASSIGNEE          4L
#define AR_GROUP_ID_SUB_ADMINISTRATOR 5L
#define AR_GROUP_ID_FLASH_ADMIN       6L
#define AR_GROUP_ID_ASSIGNEE_GROUP    7L

/* Constants used for items in values returned from the server */

#define AR_DEFN_DIARY_SEP        '\03'     /* diary items separator */
#define AR_DEFN_DIARY_COMMA      '\04'     /* char between date/user/text */
                                           /*  within a diary item        */
#define AR_DEFN_STAT_HIST_SEP    '\03'     /* status history items separator */
#define AR_DEFN_STAT_HIST_COMMA  '\04'     /* char between user and time in a */
                                           /*  status history item            */


#define AR_DEFN_LABEL_SIZE     20 /* length of the label portion of lines   */
                                  /*   in the export definition format file */
#define AR_MAX_DEFN_LINE_SIZE 325 /* maximum length of a line in a defn file */
                                  /*   (excl "\n\0" at end of each line)     */

#define AR_NOTIFICATION_VUI      "ARNotification"
                                  /* VUI name used to identify the view to */
                                  /*  use for order of fields in an email  */
                                  /*  or other style notification          */

/* Constants holding label definitions for the fields in a definition file */

#define AR_DEFN_FILE_ALL_FIELDS    '*'     /* character to indicate ALL fields*/
#define AR_DEFN_FILE_CHNG_FIELDS   '@'     /* character to indicate CHNG field*/
#define AR_DEFN_FILE_COMMENT       '#'     /* character introducing a comment */
#define AR_DEFN_FILE_SEPARATOR     '\\'    /* character used to separate two */
                                           /*  or more values on one line    */
#define AR_DEFN_GROUP_ID_SEPARATOR ';'     /* character used to separate two */
                                           /*  or more group ids in a list   */
#define AR_DEFN_KEYWORD_PARM_TAG   '$'     /* character surrounding keywords */
                                           /*  and parameters in values      */
#define AR_DEFN_ATTACH_SEPARATOR   ';'     /* character used to separate     */
                                           /*  attributes of a stringified   */
                                           /*  attachment value              */

   /* There are some characters that can occur in labels and/or character */
   /* strings that conflict with the formatting characters that allow the */
   /* definition and processing of records.  When these characters are    */
   /* encountered, they are translated into a control character when the  */
   /* data is stored in the DB and then back into the "real" character on */
   /* retrieval.  The "EMBEDDED" definitions define these mappings.       */
#define AR_DEFN_EMBEDDED_RETURN  '\01'     /* character substituting for '\n' */
                                           /*  (record separator) in the DB   */
#define AR_DEFN_EMBEDDED_SEP     '\02'     /* character substituting for an */
                                           /*  embedded separator in the DB */
#define AR_DEFN_ALT_EMBEDDED_SEP '\04'     /* character subs for embedded     */
                                           /*  char if has meaning other than */
                                           /*  a mapping for something        */
#define AR_DEFN_CONT_CHAR          '&'     /* line continuation character */

#define AR_DEFN_STRUCT_ACTIVE_LINK      "begin active link\n"
#define AR_DEFN_STRUCT_ADMIN_EXT        "begin admin ext\n"
#define AR_DEFN_STRUCT_CHAR_MENU        "begin char menu\n"
#define AR_DEFN_STRUCT_CONTAINER        "begin container\n"
#define AR_DEFN_STRUCT_DIST_MAPPING     "begin distributed mapping\n"
#define AR_DEFN_STRUCT_FILTER           "begin filter\n"
#define AR_DEFN_STRUCT_ESCALATION       "begin escalation\n"
#define AR_DEFN_STRUCT_GROUP            "begin group\n"
#define AR_DEFN_STRUCT_SCHEMA           "begin schema\n"
#define AR_DEFN_STRUCT_DIST_POOL        "begin distributed pool\n"

#define AR_DEFN_END_STRUCT              "end\n"

#define AR_DEFN_CLAUSE_FIELD            "field {\n"
#define AR_DEFN_CLAUSE_REFERENCE        "reference {\n"
#define AR_DEFN_CLAUSE_VUI              "vui  {\n"
#define AR_DEFN_END_CLAUSE              "}\n"
#define AR_DEFN_CLAUSE_ACTION           "   action {\n"
#define AR_DEFN_END_ACTION              "   }\n"
#define AR_DEFN_CLAUSE_ELSE             "   else {\n"
#define AR_DEFN_END_ELSE                "   }\n"
#define AR_DEFN_CLAUSE_FILE             "   support file {\n"
#define AR_DEFN_END_FILE                "   }\n"

/* above definitions without newline */
#define AR_DEFN_STRUCT_ACTIVE_LINK_NO_NL  "begin active link"
#define AR_DEFN_STRUCT_ADMIN_EXT_NO_NL    "begin admin ext"
#define AR_DEFN_STRUCT_CHAR_MENU_NO_NL    "begin char menu"
#define AR_DEFN_STRUCT_CONTAINER_NO_NL    "begin container"
#define AR_DEFN_STRUCT_DIST_MAPPING_NO_NL "begin distributed mapping"
#define AR_DEFN_STRUCT_FILTER_NO_NL       "begin filter"
#define AR_DEFN_STRUCT_ESCALATION_NO_NL   "begin escalation"
#define AR_DEFN_STRUCT_GROUP_NO_NL        "begin group"
#define AR_DEFN_STRUCT_SCHEMA_NO_NL       "begin schema"
#define AR_DEFN_STRUCT_DIST_POOL_NO_NL    "begin distributed pool"

#define AR_DEFN_END_STRUCT_NO_NL          "end"

#define AR_DEFN_CLAUSE_FIELD_NO_NL      "field {"
#define AR_DEFN_CLAUSE_REFERENCE_NO_NL  "reference {"
#define AR_DEFN_CLAUSE_VUI_NO_NL        "vui  {"
#define AR_DEFN_CLAUSE_VUI_NO_NL_ALT    "vui {"
#define AR_DEFN_END_CLAUSE_NO_NL        "}"
#define AR_DEFN_CLAUSE_ACTION_NO_NL     "   action {"
#define AR_DEFN_END_ACTION_NO_NL        "   }"
#define AR_DEFN_CLAUSE_ELSE_NO_NL       "   else {"
#define AR_DEFN_END_ELSE_NO_NL          "   }"
#define AR_DEFN_CLAUSE_FILE_NO_NL       "   support file {"
#define AR_DEFN_END_FILE_NO_NL          "   }"

#define AR_DEFN_LABEL_ACCESS_OPTION     "      access-opt  : "
#define AR_DEFN_LABEL_ACTLINK_FIELD     "   actlink-field  : "
#define AR_DEFN_LABEL_ACTLINK_FOCUS     "   actlink-focus  : "
#define AR_DEFN_LABEL_ACTLINK_CONTROL   "   actlink-control: "
#define AR_DEFN_LABEL_ACTLINK_MASK      "   actlink-mask   : "
#define AR_DEFN_LABEL_ACTLINK_QRY       "   actlink-query  : "
#define AR_DEFN_LABEL_ACTLINK_ORD       "   actlink-order  : "
#define AR_DEFN_LABEL_AD_COMMAND        "   command        : "
#define AR_DEFN_LABEL_CALLGUIDE         " call guide :"
#define AR_DEFN_LABEL_CHANGE_DIARY      "   change-diary   : "
#define AR_DEFN_LABEL_CHAR_MENU         "   char-menu      : "
#define AR_DEFN_LABEL_ENCR_CHAR_MENU    " encrypt-char-menu: "
#define AR_DEFN_LABEL_CHAR_MENU_2       "      char-menu   : "
#define AR_DEFN_LABEL_CLOSE_WND         "      close-wnd   : "
#define AR_DEFN_LABEL_COMMAND           "      command     : "
#define AR_DEFN_LABEL_ENCR_COMMAND      "    encrypt-cmd   : "
#define AR_DEFN_LABEL_COMMIT_CHANGES    "    commit_changes: "
#define AR_DEFN_LABEL_CONTENT           "      content     : "
#define AR_DEFN_LABEL_CONTAINER_SUBADM  "   container-admin: "
#define AR_DEFN_LABEL_CORE_VERS         "   core-version   : "
#define AR_DEFN_LABEL_CREATE_MODE       "   create-mode    : "
#define AR_DEFN_LABEL_DATA_TYPE         "   datatype       : "
#define AR_DEFN_LABEL_DDE_ACTION        "      dde-action  : "
#define AR_DEFN_LABEL_DDE_COMMAND       "      dde-command : "
#define AR_DEFN_LABEL_DDE_FILE          "      dde-file    : "
#define AR_DEFN_LABEL_DDE_ITEM          "      dde-item    : "
#define AR_DEFN_LABEL_DDE_SERVICE       "      dde-service : "
#define AR_DEFN_LABEL_DDE_TOPIC         "      dde-topic   : "
#define AR_DEFN_LABEL_AUTO_SERVER       "      auto-server : "
#define AR_DEFN_LABEL_AUTO_CLSID        "      auto-clsId  : "
#define AR_DEFN_LABEL_AUTO_ACTION       "      auto-action : "
#define AR_DEFN_LABEL_AUTO_VISIBLE      "      auto-visible: "
#define AR_DEFN_LABEL_AUTO_COM          "      auto-COM    : "
#define AR_DEFN_LABEL_DIRECT_SQL        "      direct-sql  : "
#define AR_DEFN_LABEL_ENCR_AL_SQL       "      encrypt-sql : "
#define AR_DEFN_LABEL_DEFAULT           "   default        : "
#define AR_DEFN_LABEL_DESCRIPTION       "   description    : "
#define AR_DEFN_LABEL_DISPLAY           "   display        : "
#define AR_DEFN_LABEL_DISPLAY_2         "      display     : "
#define AR_DEFN_LABEL_DISPLAY_PROPLIST  "   display-prop   : "
#define AR_DEFN_LABEL_DISPLAY_INSTANCE  " display-instance : "
#define AR_DEFN_LABEL_DUP_ACTION        "   dup-action     : "
#define AR_DEFN_LABEL_ENABLE            "   enable         : "
#define AR_DEFN_LABEL_ENUM_VALUE        "   enum-value     : "
#define AR_DEFN_LABEL_TBLFLD_SCHEMA     "tablefield-schema : "
#define AR_DEFN_LABEL_TBLFLD_SERVER     "tablefield-server : "
#define AR_DEFN_LABEL_TBLFLD_QUERY      "tablefield-query  : "
#define AR_DEFN_LABEL_TBLFLD_NUMCOLS    "tablefield-numcols: "
#define AR_DEFN_LABEL_TBLFLD_MAXRET     "tablefield-maxret : "
#define AR_DEFN_LABEL_COLFLD_PARENT     "colfield-parent   : "
#define AR_DEFN_LABEL_COLFLD_DATAFIELD  "colfield-datafield: "
#define AR_DEFN_LABEL_COLFLD_DATATYPE   "colfield-datatype : "
#define AR_DEFN_LABEL_COLFLD_COLLENGTH  "colfield-collength: "
#define AR_DEFN_LABEL_ESCALATION_HOUR   "   escl-hourmask  : "
#define AR_DEFN_LABEL_ESCALATION_INT    "   escl-interval  : "
#define AR_DEFN_LABEL_ESCALATION_MIN    "   escl-minute    : "
#define AR_DEFN_LABEL_ESCALATION_MON    "   escl-monthday  : "
#define AR_DEFN_LABEL_ESCALATION_QRY    "   escl-query     : "
#define AR_DEFN_LABEL_ESCALATION_TMTYPE "   escl-tmType    : "
#define AR_DEFN_LABEL_ESCALATION_WEEK   "   escl-weekday   : "
#define AR_DEFN_LABEL_EXPORT_VERS       "   export-version : "

#define AR_DEFN_LABEL_EXT_FIELD         "      extfield    : "
#define AR_DEFN_LABEL_FIELD_TYPE        "   fieldtype      : "
#define AR_DEFN_LABEL_FILE_TYPE         "      file-type   : "
#define AR_DEFN_LABEL_FILTER_OP         "   filter-op      : "
#define AR_DEFN_LABEL_FILTER_ORD        "   filter-order   : "
#define AR_DEFN_LABEL_FILTER_QRY        "   filter-query   : "
#define AR_DEFN_LABEL_FOCUS             "      focus       : "
#define AR_DEFN_LABEL_FROM_SCHEMA       "   from-schema    : "
#define AR_DEFN_LABEL_FROM_SERVER       "   from-server    : "
#define AR_DEFN_LABEL_FULLTEXTOPTNS     "   fulltext-optns : "
#define AR_DEFN_LABEL_GET_LIST_FLDS     "   get-list-flds  : "
#define AR_DEFN_LABEL_HELP              "   help-text      : "
#define AR_DEFN_LABEL_ID                "   id             : "
#define AR_DEFN_LABEL_ID_2              "      id          : "
#define AR_DEFN_LABEL_INDEX             "   index          : "
#define AR_DEFN_LABEL_JOIN_OPTION       "      join-option : "
#define AR_DEFN_LABEL_JOIN_PRIMARY      "      primary     : "
#define AR_DEFN_LABEL_JOIN_QRY          "      join-query  : "
#define AR_DEFN_LABEL_JOIN_SECONDARY    "      secondary   : "
#define AR_DEFN_LABEL_LABEL             "   label          : "
#define AR_DEFN_LABEL_LAST_CHANGED      "   last-changed   : "
#define AR_DEFN_LABEL_LOG_FILE          "      log-file    : "
#define AR_DEFN_LABEL_MACRO_NAME        "      macro-name  : "
#define AR_DEFN_LABEL_MACRO_PARMS       "      macro-parms : "
#define AR_DEFN_LABEL_MACRO_TEXT        "      macro-text  : "
#define AR_DEFN_LABEL_MAP_FIELDID       "      mapfield    : "
#define AR_DEFN_LABEL_MAP_SCHEMA        "      mapschema   : "
#define AR_DEFN_LABEL_MAP_TYPE          "   map-type       : "
#define AR_DEFN_LABEL_MAPPING           "   mapping        : "
#define AR_DEFN_LABEL_MAX_LENGTH        "   maxlength      : "
#define AR_DEFN_LABEL_MAXSIZE           "   maxsize        : "
#define AR_DEFN_LABEL_ATTACH_TYPE       "   attachtype     : "
#define AR_DEFN_LABEL_MENU_STYLE        "   menu-style     : "
#define AR_DEFN_LABEL_MSG_NUM           "      message-num : "
#define AR_DEFN_LABEL_MSG_TEXT          "      message-text: "
#define AR_DEFN_LABEL_MSG_TYPE          "      message-type: "
#define AR_DEFN_LABEL_MSG_PANE          "      message-pane: "
#define AR_DEFN_LABEL_NAME              "   name           : "
#define AR_DEFN_LABEL_NOT_FIELDS        "      notify-field: "
#define AR_DEFN_LABEL_NOT_MECH          "      notify-mech : "
#define AR_DEFN_LABEL_NOT_PRIORITY      "      notify-pri  : "
#define AR_DEFN_LABEL_NOT_SUBJECT       "      notify-subj : "
#define AR_DEFN_LABEL_NOT_TEXT          "      notify-text : "
#define AR_DEFN_LABEL_NOT_USER          "      notify-user : "
#define AR_DEFN_LABEL_NOT_XREF          "      notify-xref : "
#define AR_DEFN_LABEL_NUM_FIELDS        "   num-fields     : "
#define AR_DEFN_LABEL_NUM_REFERENCES    "   num-references : "
#define AR_DEFN_LABEL_NUM_VUIS          "   num-vuis       : "
#define AR_DEFN_LABEL_OBJECT            "   object         : "
#define AR_DEFN_LABEL_OBJECT_PROP       "   object-prop    : "

#define AR_DEFN_LABEL_OPEN_DLG          "   open-dialog    : "
#define AR_DEFN_LABEL_OPEN_DLG_SERVER   "      open-server : "
#define AR_DEFN_LABEL_OPEN_DLG_SCHEMA   "      open-schema : "
#define AR_DEFN_LABEL_OPEN_DLG_VUI      "      open-vui    : "
#define AR_DEFN_LABEL_OPEN_DLG_BOX      "      open-close  : "
#define AR_DEFN_LABEL_OPEN_DLG_INPUT    "      open-input  : "
#define AR_DEFN_LABEL_OPEN_DLG_OUTPUT   "      open-output : "

#define AR_DEFN_LABEL_CALLGUIDE_SERVER  "      call-server : "
#define AR_DEFN_LABEL_CALLGUIDE_GUIDE   "      call-guide  : "
#define AR_DEFN_LABEL_CALLGUIDE_MODE    "      call-mode   : "

#define AR_DEFN_LABEL_EXITGUIDE         "      exit guide  : "
#define AR_DEFN_LABEL_GOTOGUIDE         "      goto guide  : "
#define AR_DEFN_LABEL_WAIT              "      wait        : "
#define AR_DEFN_LABEL_GOTOACTION        "      goto action : "

#define AR_DEFN_LABEL_OPTION            "   option         : "
#define AR_DEFN_LABEL_OWNER             "   owner          : "
#define AR_DEFN_LABEL_CONTAINER_OWNER_NAME "   owning-obj-name: "
#define AR_DEFN_LABEL_CONTAINER_OWNER_TYPE "   owning-obj-type: "
#define AR_DEFN_LABEL_PATTERN           "   pattern        : "
#define AR_DEFN_LABEL_PERMISSION        "   permission     : "
#define AR_DEFN_LABEL_PRECISION         "   precision      : "
#define AR_DEFN_LABEL_REFERENCE_GROUPS  "   ref-groups     : "
#define AR_DEFN_LABEL_QBE_MATCH_OP      "   qbe-match-op   : "
#define AR_DEFN_LABEL_PUSH_FIELD        "      push-field  : "
#define AR_DEFN_LABEL_ENCR_FIELDP       "encrypt-push-field: "
#define AR_DEFN_LABEL_RANGE_HIGH        "   range-high     : "
#define AR_DEFN_LABEL_RANGE_LOW         "   range-low      : "
#define AR_DEFN_LABEL_REFRESH_CODE      "   refresh-code   : "
#define AR_DEFN_LABEL_RETRY_TIME        "   retry-time     : "
#define AR_DEFN_LABEL_RTN_MAP_TYPE      "   rtn-map-type   : "
#define AR_DEFN_LABEL_RTN_MAPPING       "   rtn-mapping    : "
#define AR_DEFN_LABEL_WK_CONN_TYPE      "   wk-conn-type   : "
#define AR_DEFN_LABEL_NEXT_FIELD_ID     "   next-field-id  : "
#define AR_DEFN_LABEL_SCHEMA_NAME       "   schema-name    : "
#define AR_DEFN_LABEL_SCHEMA_TYPE       "   schema-type    : "
#define AR_DEFN_LABEL_SCHEMA_SUBADM     "   schema-admin   : "
#define AR_DEFN_LABEL_SET_FIELD         "      set-field   : "
#define AR_DEFN_LABEL_ENCR_SET_FIELD    " encrypt-set-field: "
#define AR_DEFN_LABEL_SORT_LIST         "   sort-list      : "
#define AR_DEFN_LABEL_TIMESTAMP         "   timestamp      : "
#define AR_DEFN_LABEL_TIMESTAMP_2       "      timestamp   : "
#define AR_DEFN_LABEL_TO_SCHEMA         "   to-schema      : "
#define AR_DEFN_LABEL_TO_SERVER         "   to-server      : "
#define AR_DEFN_LABEL_TRANSFER_MODE     "   transfer-mode  : "
#define AR_DEFN_LABEL_TYPE              "   type           : "
#define AR_DEFN_LABEL_UPDATE_CODE       "   update-code    : "
#define AR_DEFN_LABEL_VIEW_KEYFIELD     "      key-field   : "
#define AR_DEFN_LABEL_VIEW_NAME         "      ext-table   : "
#define AR_DEFN_LABEL_VIEW_QRY          "      view-query  : "
#define AR_DEFN_LABEL_VALUE             "   value          : "
#define AR_DEFN_LABEL_DISTRIB_TCOUNT    "   thread-count   : "
#define AR_DEFN_LABEL_DISTRIB_CONNECT   "   connection     : "


/* Constants used for processing the directory files */
#define AR_DIR_LABEL_ACTLINK_DIR         "Active-Link-Dir:"
#define AR_DIR_LABEL_ACTLINK_SHELL       "Active-Link-Shell:"
#define AR_DIR_LABEL_ADMIN_ONLY          "Admin-Only-Mode:"
#define AR_DIR_LABEL_AS_SPEC_PORT        "Admin-Specific-Port:"
#define AR_DIR_LABEL_ALLOW_GUEST         "Allow-Guest-Users:"
#define AR_DIR_LABEL_UNQUAL_QUERIES      "Allow-Unqual-Queries:"
#define AR_DIR_LABEL_API_LOG_FILE        "API-Log-File:"
#define AR_DIR_LABEL_APPLICATION_AUDIT   "Application-Audit-Info:"
#define AR_DIR_LABEL_APPLICATION_ENABLE  "Application-Enable:"
#define AR_DIR_LABEL_APPLICATION_TAG     "Application-Tag:"
#define AR_DIR_LABEL_AP_DEFN_CHECK_INT   "Approval-Defn-Check-Interval:"
#define AR_DIR_LABEL_APPROVAL_LOG_FILE   "Approval-Log-File:"
#define AR_DIR_LABEL_APPROVAL_NOTIFY     "Approval-Notify:"
#define AR_DIR_LABEL_AP_RPC_SOCKET       "Approval-RPC-Socket:"
#define AR_DIR_LABEL_AP_SPEC_PORT        "Approval-Specific-Port:"
#define AR_DIR_LABEL_AP_WEB_DOC_DIR      "Approval-Web-Doc-Dir:"
#define AR_DIR_LABEL_CACHE_LOG_FILE      "Cache-Log-File:"
#define AR_DIR_LABEL_CANCEL_QUERY        "Cancel-Query-Option:"
#define AR_DIR_LABEL_FTCASESEARCH        "Case-Insensitive-Search:"
#define AR_DIR_LABEL_NO_CHANGED_CHECK    "Changed-By-Another-Check:"
#define AR_DIR_LABEL_CLUSTERED_INDEX     "Clustered-Index:"
#define AR_DIR_LABEL_FTCOLLECTION        "Collection-directory:"
#define AR_DIR_LABEL_CREATE_DSO_POOLS    "Create-DSO-Pool-Form:"
#define AR_DIR_LABEL_XREF_PASSWD         "Crossref-Blank-Password:"
#define AR_DIR_LABEL_DB_DIR              "Dbhome-directory:"
#define AR_DIR_LABEL_DB_MAX_TEXT_SIZE    "Db-Max-Text-Size:"
#define AR_DIR_LABEL_DB_NAME             "Db-name:"
#define AR_DIR_LABEL_DB_PASSWORD         "Db-password:"
#define AR_DIR_LABEL_DB_USER             "Db-user:"
#define AR_DIR_LABEL_DEBUG_MODE          "Debug-mode:"
#define AR_DIR_LABEL_USER_CACHE_UTILS    "Disable-User-Cache-Utilities:"
#define AR_DIR_LABEL_DEFAULT_ORDER_BY    "Default-Order-By:"
#define AR_DIR_LABEL_DELAYED_CACHE       "Disable-Shared-Cache-Delay:"
#define AR_DIR_LABEL_SHARED_MEM          "Disable-Shared-Memory:"
#define AR_DIR_LABEL_DISTRIB_LOG_FILE    "Distrib-Log-File:"
#define AR_DIR_LABEL_DS_RPC_SOCKET       "Distributed-RPC-Socket:"
#define AR_DIR_LABEL_DSO_HOST_NAME       "DSO-Host-Name:"
#define AR_DIR_LABEL_DSO_MERGE_STYLE     "DSO-Merge-DupId-Overwrite:"
#define AR_DIR_LABEL_DSO_PLACEHOLDER     "DSO-Placeholder-Mode:"
#define AR_DIR_LABEL_DSO_POLL_INTERVAL   "DSO-Polling-Interval:"
#define AR_DIR_LABEL_DSO_DEST_PORT       "DSO-private-dest-port:"
#define AR_DIR_LABEL_DSO_SOURCE_SERVER   "DSO-Source-Server:"
#define AR_DIR_LABEL_EMAIL_SYSTEM        "Email-Delivery-System:"
#define AR_DIR_LABEL_EMAIL_FROM          "Email-Notify-From:"
#define AR_DIR_LABEL_EMAIL_TIMEOUT       "Email-Timeout:"
#define AR_DIR_LABEL_SHARED_CACHE        "Enable-Shared-Cache:"
#define AR_DIR_LABEL_ENCR_AL_SQL         "Encrypt-AL-Direct-SQL:"
#define AR_DIR_LABEL_ESCALATION_DAEMON   "Escalation-Daemon:"
#define AR_DIR_LABEL_ESCALATION_LOG_FILE "Escalation-Log-File:"
#define AR_DIR_LABEL_ES_SPEC_PORT        "Escalation-Specific-Port:"
#define AR_DIR_LABEL_EA_RPC_SOCKET       "External-Authentication-RPC-Socket:"
#define AR_DIR_LABEL_EA_RPC_TIMEOUT      "External-Authentication-RPC-Timeout:"
#define AR_DIR_LABEL_EA_SYNC_TIMEOUT     "External-Authentication-Sync-Timeout:"
#define AR_DIR_LABEL_FS_SPEC_PORT        "Fast-Specific-Port:"
#define AR_DIR_LABEL_APPLICATION_FIELDID "Field-Id:"
#define AR_DIR_LABEL_FILT_MAX_STACK      "Filter-Max-Stack:"
#define AR_DIR_LABEL_FILT_MAX_TOTAL      "Filter-Max-Total:"
#define AR_DIR_LABEL_FILTER_LOG_FILE     "Filter-Log-File:"
#define AR_DIR_LABEL_FLASH_DAEMON        "Flashboards-Daemon:"
#define AR_DIR_LABEL_FLASH_SPEC_PORT     "Flashboards-Specific-Port:"
#define AR_DIR_LABEL_FTS_DEBUG           "FTS-Debug-mode:"
#define AR_DIR_LABEL_FTHOMEDIR           "FullText-home:"
#define AR_DIR_LABEL_FULL_LIC_TIMEOUT    "FullText-License-Timeout:"
#define AR_DIR_LABEL_FTSMATCHOP          "FullText-matchop:"
#define AR_DIR_LABEL_FTOPSSTATE          "FullText-state:"
#define AR_DIR_LABEL_FTSTHRESHOLDHIGH    "FullText-threshold-high:"
#define AR_DIR_LABEL_FTSTHRESHOLDLOW     "FullText-threshold-low:"
#define AR_DIR_LABEL_DATE_FORMAT         "GetListEntry-Server-Date-Format:"
#define AR_DIR_LABEL_INFORMIX_DBN        "Informix-DBServer-Name:"
#define AR_DIR_LABEL_INFORMIX_RELAY_MOD  "Informix-Relay-Module:"
#define AR_DIR_LABEL_INFORMIX_TBC        "Informix-TBConfig:"
#define AR_DIR_LABEL_INGRES_VNOD         "Ingres-Vnode-Name:"
#define AR_DIR_LABEL_USER_INFO_LISTS     "Internal-User-Info-Hash-Lists:"
#define AR_DIR_LABEL_USER_INST_TIMEOUT   "Internal-User-Instance-Timeout:"
#define AR_DIR_LABEL_LIC_TIMEOUT         "License-Timeout:"
#define AR_DIR_LABEL_LICENSE_TAG         "License-Tag:"
#define AR_DIR_LABEL_LS_SPEC_PORT        "List-Specific-Port:"
#define AR_DIR_LABEL_LOGFILE_APPEND      "Log-File-Append:"
#define AR_DIR_LABEL_EMAIL_NOTIFY_DIR    "MailNotifyDir:"
#define AR_DIR_LABEL_MAX_AUDIT_LOG_FILE_SIZE   "Max-Audit-Log-File-Size:"
#define AR_DIR_LABEL_MAX_ENTRIES         "Max-Entries-Per-Query:"
#define AR_DIR_LABEL_MAX_F_DAEMONS       "Max-Fast-Daemons:"
#define AR_DIR_LABEL_MAX_L_DAEMONS       "Max-List-Daemons:"
#define AR_DIR_LABEL_MAX_LOG_FILE_SIZE   "Max-Log-File-Size:"
#define AR_DIR_LABEL_EMAIL_LINE_LEN      "Max-Notify-Mail-Line-Len:"
#define AR_DIR_LABEL_MINIMUM_API_VERSION "Minimum-API-Version:"
#define AR_DIR_LABEL_NS_SPEC_PORT        "Notifier-Specific-Port:"
#define AR_DIR_LABEL_ORACLE_SID          "Oracle-SID:"
#define AR_DIR_LABEL_ORACLE_TWO_T        "Oracle-Two-Task:"
#define AR_DIR_LABEL_PR_CATALOG_DIR      "PurchReq-Catalog-Dir:"
#define AR_DIR_LABEL_PS_RPC_SOCKET       "Private-RPC-Socket:"
#define AR_DIR_LABEL_PS_SPEC_PORT        "Private-Specific-Port:"
#define AR_DIR_LABEL_READ_ONLY_TRAN_OFF  "Read-Only-Tran-Off:"
#define AR_DIR_LABEL_REGISTER_PORTMAPPER "Register-With-Portmapper:"
#define AR_DIR_LABEL_SAVE_LOGIN          "Save-Login:"
#define AR_DIR_LABEL_SCC_CMNT_CHECKIN    "SCC-Comment-Checkin:"
#define AR_DIR_LABEL_SCC_CMNT_CHECKOUT   "SCC-Comment-Checkout:"
#define AR_DIR_LABEL_SCC_ENABLED         "SCC-Enabled:"
#define AR_DIR_LABEL_SCC_INT_MODE        "SCC-Integration-Mode:"
#define AR_DIR_LABEL_SCC_PROVIDER_NAME   "SCC-Provider-Name:"
#define AR_DIR_LABEL_SCC_TARGET_DIR      "SCC-Target-Dir:"
#define AR_DIR_LABEL_SERVER_DIR          "Server-directory:"
#define AR_DIR_LABEL_SERVER_NAME         "Server-Name:"
#define AR_DIR_LABEL_SET_PROC_TIME       "Set-Process-Timeout:"
#define AR_DIR_LABEL_CACHE_SEG_SIZE      "Shared-Cache-Segment-Size:"
#define AR_DIR_LABEL_SQL_LOG_FILE        "SQL-Log-File:"
#define AR_DIR_LABEL_SUBMITTER_MODE      "Submitter-Mode:"
#define AR_DIR_LABEL_SUPPRESS_WARNINGS   "Suppress-warnings:"
#define AR_DIR_LABEL_SVR_SECURITY_CACHE  "Server-Security-Cache:"
#define AR_DIR_LABEL_SYBASE_CHARSET      "Sybase-Character-Set:"
#define AR_DIR_LABEL_SYBASE_SERV         "Sybase-Server-Name:"
#define AR_DIR_LABEL_TS_SPEC_PORT        "TCD-Specific-Port:"
#define AR_DIR_LABEL_THREAD_DEBUG_MODE   "Thread-Debug-mode:"
#define AR_DIR_LABEL_THREAD_LOG_FILE     "Thread-Log-File:"
#define AR_DIR_LABEL_USE_PASSWD          "Use-Password-File:"
#define AR_DIR_LABEL_USER_LOG_FILE       "User-Log-File:"

/* Constants holding definitions for the database structure clause extensions */
#define AR_DIR_LABEL_CLAUSE              "Clause:"
#define AR_DIR_LABEL_FIELD               "Field {"
#define AR_DIR_LABEL_ID                  "Id:"
#define AR_DIR_LABEL_INDEX               "Index {"
#define AR_DIR_LABEL_SCHEMA              "Schema:"
#define AR_DIR_LABEL_FORM                "Form:"
#define AR_DIR_LABEL_INDEX_UPPER         "Oracle-Upper-Index:"
#define AR_DIR_LABEL_INDEX_FUPPER        "Oracle-All-Upper-Index"
#define AR_DIR_LABEL_DEBUG_GROUPID       "Debug-GroupId:"


#define AR_TAG_TRUE               "T"
#define AR_TAG_FALSE              "F"

                           /* default value for AR_DIR_LABEL_FTSTHRESHOLDLOW */
#define AR_DEFAULT_THRESHOLDLOW  200
                           /* default value for AR_DIR_LABEL_FTSTHRESHOLDHIGH */
#define AR_DEFAULT_THRESHOLDHIGH 1000000


/* Constants holding definitions for the contents of a mail template/message */

#define AR_MAIL_LABEL_SCHEMA   "Schema:"
#define AR_MAIL_LABEL_SERVER   "Server:"
#define AR_MAIL_LABEL_LOGIN    "Login:"
#define AR_MAIL_LABEL_PASSWORD "Password:"
#define AR_MAIL_LABEL_ACTION   "Action:"
#define AR_MAIL_LABEL_FORMAT   "Format:"

#define AR_MAIL_ACTION_SUBMIT  "Submit"
#define AR_MAIL_ACTION_QUERY   "Query"

#define AR_MAIL_FORMAT_SHORT   "Short"
#define AR_MAIL_FORMAT_FULL    "Full"

#define AR_MAIL_BEGIN          "AR-Message-Begin"
#define AR_MAIL_END            "AR-Message-End"

#define AR_MAIL_ID_DELIMITER   '!'

#define AR_MAIL_MAX_LINE_SIZE  1024 /* max size of mail message lines */



#endif
