
/*  File: ntsextern.h  */

/* External declarations of the API for the Notification System Server */

#ifndef NTS_EXTERN_DEFINED
#define NTS_EXTERN_DEFINED

#ifndef C_VARIETIES_H
#define C_VARIETIES_H

/* external definition macros extracted from the c_variables.h include file  */
/* Builds the correct external reference for the type of compiler being used */

#if defined(__cplusplus)
    /* Definitions for C++ 2.0 and later */
#   define EXTERN_FUNCTION( rtn, args ) extern "C" { rtn args; }
#   define STRUCT_TAG( tag_name ) /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(c_plusplus)
    /* Definitions for C++ 1.2 */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name )  /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(__STDC__) || defined(_WIN32)
    /* Definitions for ANSI C and Win32 .c files */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT ...
#   define _VOID_ void

#else
    /* Definitions for Sun/K&R C */
#   define EXTERN_FUNCTION( rtn, args ) rtn()
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) enum_type
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT
#   define _VOID_

#endif

#endif

#endif

#endif

EXTERN_FUNCTION (int  NTRegisterServer, (char *, NTNameType, NTNameType,
                                         unsigned int, NTPortAddr,
                                         unsigned int, NTBoolean, 
                                         NTStatusList *));
EXTERN_FUNCTION (int  NTDeregisterServer, (char *, NTNameType, NTNameType,
                                           NTPortAddr *, NTStatusList *));
EXTERN_FUNCTION (int  NTNotificationServer, (char *, NTNameType, char *, int,
                                             char *, NTStatusList *));
EXTERN_FUNCTION (int  NTGetListUser, (char *, NTNameList *, NTStatusList *));
EXTERN_FUNCTION (int  NTGetListServer, (NTServerNameList *, NTStatusList *));
EXTERN_FUNCTION (int  NTInitializationServer, (NTStatusList *));
EXTERN_FUNCTION (int  NTSetServerPort, (NTNameType, int, NTStatusList *));
EXTERN_FUNCTION (int  NTTerminationServer, (NTStatusList *));
EXTERN_FUNCTION (char *NTGetTextForErrorMessage, (int));

#endif  /* ifndef NTS_EXTERN_DEFINED */
