/*  File:  globals.h  */

#ifdef _WIN32
#include <windows.h>
#else
#ifndef SINGLE_THREADED
#include <pthread.h>
#endif /* !SINGLE_THREADED */
#endif /* _WIN32 */

#define MAX_THREAD_HANDLES  32

#ifdef MAIN
#ifdef SINGLE_THREADED
void         *gTCBPtr;
#else
#ifdef _WIN32
unsigned long gTLSIndex;
#else
pthread_key_t gTLSKey;
#endif /* _WIN32 */
#endif /* SINGLE_THREADED */

#else
#ifdef SINGLE_THREADED
extern void         *gTCBPtr;
#else
#ifdef _WIN32
extern unsigned long gTLSIndex;
#else
extern pthread_key_t gTLSKey;
#endif /* _WIN32 */
#endif /* SINGLE_THREADED */
#endif /* MAIN */


typedef struct
{
   ARControlStruct  control;        /* control record */
   FILE            *inFile;         /* pointer to file to read commands from */
   FILE            *outFile;        /* pointer to file to generate output to */
   FILE            *recordFile;     /* pointer to file to record commands */
   char             buffer[1024];   /* general use temporary buffer */
   char             args[1024];     /* argument from the command line */
#ifndef SINGLE_THREADED
   unsigned int     numHandles;     /* number of thread handles in array */
#ifdef _WIN32
   HANDLE           threadHandles[MAX_THREAD_HANDLES]; /* thread handle array */
   HANDLE           launchWaitEvent;  /* event to notify parent thread */
   HANDLE           releaseWaitEvent; /* event to notify child thread */
#else
   pthread_t        threadHandles[MAX_THREAD_HANDLES]; /* thread handle array */
   pthread_mutex_t  launchWaitMutex;  /* mutex for parent notification */
   pthread_cond_t   launchWaitCond;   /* condition var for notification */ 
   pthread_mutex_t  releaseWaitMutex; /* mutex for child notification */
   pthread_cond_t   releaseWaitCond;  /* condition var for notification */
#endif /* _WIN32 */
#endif /* !SINGLE_THREADED */
}  ThreadControlBlock;

typedef struct
{
   FILE            *inFile;     /* pointer to the file to read commands from */
   FILE            *outFile;    /* pointer to file to generate output to */
#ifndef SINGLE_THREADED
   ARBoolean        waitFlag;   /* flag indicating if synchronization needed */
#ifdef _WIN32
   HANDLE           launchWaitEvent;  /* event to notify parent thread */
   HANDLE           releaseWaitEvent; /* event to notify child thread */
#else
   pthread_mutex_t *launchWaitMutexPtr;  /* mutex for parent notification */
   pthread_cond_t  *launchWaitCondPtr;   /* condition var for notification */
   pthread_mutex_t *releaseWaitMutexPtr; /* mutex for child notification */
   pthread_cond_t  *releaseWaitCondPtr;  /* condition var for notification */
#endif /* _WIN32 */
#endif /* !SINGLE_THREADED */
}  ThreadStartInfo;
